<?php
/**
* Default Post Format Template
*
* Used when "Classic" standard style is selected.
*
* @version 11.0
*/

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
  exit;
}

global $post;
global $nectar_options;

$use_excerpt = ( ! empty( $nectar_options['blog_auto_excerpt'] ) && $nectar_options['blog_auto_excerpt'] === '1' ) ? 'true' : 'false';

$date = get_the_date('d-F-Y');
$separate_date = explode('-', $date);
?>

<article id="post-<?php the_ID(); ?>" <?php post_class('swiper-slide'); ?>>

  <div class="inner-wrap animated">

    <div class="post-content">

      <div class="content-inner">

        <a class="entire-meta-link" href="<?php the_permalink(); ?>" aria-label="<?php the_title(); ?>"></a>

        <?php
          // Featured image.
          get_template_part( 'includes/partials/blog/styles/masonry-material/post-image' );

          echo '<div class="date-div">';
          echo '<div class="date-content">';
            echo '<div class="date-number">';
              echo ( $separate_date[0] );
            echo '</div>';
            echo '<div class="date-text">';
              echo '<div class="year">';
              echo ( $separate_date[2] );
              echo '</div>';
              echo '<div class="month">';
              echo '<strong>'.mb_convert_case( $separate_date[1], MB_CASE_TITLE, 'UTF-8' ).'</strong>';
              echo '</div>';
            echo '</div>';
          echo '</div>';
          echo '</div>';

          // Output categories.
          get_template_part( 'includes/partials/blog/styles/masonry-material/post-categories' );

        ?>

        <div class="article-content-wrap">

          <div class="post-header">
            <h3 class="title"><a href="<?php the_permalink(); ?>"> <?php the_title(); ?></a></h3>
          </div>

          <?php

            // Excerpt.
            echo '<div class="excerpt">';
              // echo nectar_excerpt( $excerpt_length );
            the_excerpt();
            echo '</div>';

            do_action('nectar_after_archive_post_item_content');

          ?>

          <div class="view-more">
            <a href="<?php the_permalink(); ?>"> Más detalle <i class="fa fa-angle-right"></i></a>
          </div>

        </div><!--article-content-wrap-->

      </div><!--content-inner-->

    </div><!--/post-content-->

  </div><!--/inner-wrap-->

</article>