<?php

add_action( 'wp_enqueue_scripts', 'salient_child_enqueue_styles', 100);

function salient_child_enqueue_styles() {

        $nectar_theme_version = nectar_get_theme_version();
        wp_enqueue_style( 'salient-child-style', get_stylesheet_directory_uri() . '/style.css', '', $nectar_theme_version );

    if ( is_rtl() ) {
        wp_enqueue_style(  'salient-rtl',  get_template_directory_uri(). '/rtl.css', array(), '1', 'screen' );
        }
}

function salient_redux_custom_fonts() {
    $fonts = array(
        'Custom Fonts' => array(
            'NeuePlak-Black' => 'NeuePlak-Black',
            'NeuePlak-CondBlack' => 'NeuePlak-CondBlack',
            'NeuePlak-Bold' => 'NeuePlak-Bold',
            'NeuePlak-Semibold' => 'NeuePlak-Semibold',
            'NeuePlak-Regular' => 'NeuePlak-Regular',
        )
    );
    return $fonts;
}
add_filter( "redux/salient_redux/field/typography/custom_fonts", "salient_redux_custom_fonts" );


//GravityForms
//
add_filter( 'gform_next_button', 'add_custom_css_classes', 10, 2 );
add_filter( 'gform_previous_button', 'add_custom_css_classes', 10, 2 );
add_filter( 'gform_submit_button', 'add_custom_css_classes', 10, 2 );
function add_custom_css_classes( $button, $form ) {
    $dom = new DOMDocument();
    $dom->loadHTML( '<?xml encoding="utf-8" ?>' . $button );
    $input = $dom->getElementsByTagName( 'input' )->item(0);
    $classes = $input->getAttribute( 'class' );
    $classes .= " nectar-button regular regular-button";
    $input->setAttribute( 'class', $classes );
    return $dom->saveHtml( $input );
}

add_action( 'wp_enqueue_scripts', 'ajax_request_script' );

function ajax_request_script() {

    wp_register_script( 'ajax-script', get_stylesheet_directory_uri(). '/script.js', array('jquery'), false, true );

    $script_data_array = array(
        'url' => admin_url( 'admin-ajax.php' ),
        'nonce' => wp_create_nonce( 'ajax_script_nonce' ),
    );
    wp_localize_script( 'ajax-script', 'ajax_client', $script_data_array );

    wp_enqueue_script( 'ajax-script' );
}


add_action( 'wp_ajax_loadcarrera', 'load_carrera' );
add_action( 'wp_ajax_nopriv_loadcarrera', 'load_carrera' );

function load_carrera() {

    if (isset($_POST['sede']) && $_POST['sede'] != '' && isset($_POST['modalidad'])) {

        $response = wp_remote_get( 'https://lp.ucontinental.edu.pe/amp/api/carrera/'.$_POST['modalidad'].'/'.$_POST['sede'].'?key=o88eOhgYKD' );
    }

    wp_send_json($response);

    wp_die();
}

define('LISTPORTFOLIO', [
    943 => 118,//'Administración',
    933 => 115,//'Administración y Finanzas',
    935 => 104,//'Administración y Gestión Publica',
    937 => 117,//'Administración y Marketing',
    939 => 114,//'Administración y Negocios Internacionales',
    //100 => 133,//'Administración: Marketing y Neg. Internac.',
    941 => 116,//'Administración y Recursos Humanos',
    966 => 122,//'Arquitectura',
    1069 => 103,//'Ciencias y Tecnologías de la Comunicación',
    945 => 124,//'Contabilidad',
    //100 => 121,//'Contabilidad y Auditoria',
    874 => 106,//'Derecho',
    948 => 107,//'Economía',
    951 => 111,//'Enfermería',
    995 => 130,//'Ingeniería Ambiental',
    968 => 119,//'Ingeniería Civil',
    982 => 123,//'Ingeniería de Minas',
    984 => 129,//'Ingeniería de Sistemas e Informatica',
    970 => 108,//'Ingeniería Eléctrica',
    //100 => 128,//'Ingeniería Electrónica',
    972 => 109,//'Ingeniería Empresarial',
    //100 => 105,//'Ingeniería en Agronegocios',
    398 => 126,//'Ingeniería Industrial',
    974 => 131,//'Ingeniería Mecánica',
    978 => 132,//'Ingeniería Mecatrónica',
    957 => 127,//'Tecnología Médica - Laboratorio Clínico y Anatomía Patológica',
    748 => 113,//'Medicina Humana',
    //100 => 134,//'Obstetricia',
    954 => 110,//'Odontología',
    992 => 125,//'Psicología',
    960 => 120,//'Tecnología Médica - Terapia Física y Rehabilitación',
    986 => 320,//'Administración y Negocios Digitales',
    988 => 315,//'Ciencias de la Computación',
    990 => 321,//'Educación con especialidad en innovación y aprendizaje digital',
]);


add_filter('gform_field_value_carrera', 'populate_affiliate_carrera');

function populate_affiliate_carrera(){
    $id = get_the_ID();
    $carrera = 100;
    if (isset(LISTPORTFOLIO[$id])) {
        $carrera = LISTPORTFOLIO[$id];
    }
    return $carrera;
}

add_filter( 'gform_pre_render_7', 'populate_modalidad' );
add_filter( 'gform_pre_validation_7', 'populate_modalidad' );
add_filter( 'gform_pre_submission_filter_7', 'populate_modalidad' );
add_filter( 'gform_admin_pre_render_7', 'populate_modalidad' );
function populate_modalidad( $form ) {
    $id = get_the_ID() ?? false;
    foreach ( $form['fields'] as &$field ) {

        if ( $field->type != 'select' || strpos( $field->cssClass, 'populate-modalidad' ) === false || !$id ) {
            continue;
        }

        $carrera = LISTPORTFOLIO[$id] ?? false;
        if (isset($carrera)) {
            $response = wp_remote_get( "https://lp.ucontinental.edu.pe/amp/api/modalidad/".$carrera."?key=o88eOhgYKD" );

            $choices = [];

            $makes = json_decode( wp_remote_retrieve_body( $response ) );
            foreach( $makes as $key => $make ) {
                $choices[] = array(
                    'text'       => $make,
                    'value'      => $key,
                    'isSelected' => false
                );
            }

            $field->placeholder = 'Selecciona la modalidad';
            $field->choices = $choices;
        }

    }
    return $form;
}

add_action( 'wp_ajax_loadsede', 'load_sede' );
add_action( 'wp_ajax_nopriv_loadsede', 'load_sede' );

function load_sede() {

    if (isset($_POST['carrera']) && $_POST['carrera'] != '' && isset($_POST['modalidad'])) {

        $response = wp_remote_get( 'https://lp.ucontinental.edu.pe/amp/api/sede/'.$_POST['modalidad'].'/'.$_POST['carrera'].'?key=o88eOhgYKD' );
    }
    wp_send_json($response);

    wp_die();
}

?>