<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


add_action( 'vc_load_default_templates_action','nectar_custom_studio_templates_for_vc' );


/**
 * Salient Studio templates.
 *
 * @since 1.0
 */
if( !function_exists('nectar_custom_studio_templates_for_vc') ) {

function nectar_custom_studio_templates_for_vc() {

$cat_display_names = array(
	'about' => esc_html__('About', 'salient-core'),
	'blog' => esc_html__('Blog', 'salient-core'),
	'cta' => esc_html__('Call To Action', 'salient-core'),
	'counters' => esc_html__('Counters', 'salient-core'),
	'general' => esc_html__('General', 'salient-core'),
	'icons' => esc_html__('Icons', 'salient-core'),
	'hero_section' => esc_html__('Hero Section', 'salient-core'),
	'google_map' => esc_html__('Map', 'salient-core'),
	'lottie' => esc_html__('Lottie', 'salient-core'),
	'portfolio' => esc_html__('Project', 'salient-core'),
	'pricing' => esc_html__('Pricing', 'salient-core'),
	'services' => esc_html__('Services', 'salient-core'),
	'team' => esc_html__('Team', 'salient-core'),
	'testimonials' => esc_html__('Testimonials', 'salient-core'),
	'shop' => esc_html__('Shop', 'salient-core'),
	'new' => esc_html__('New', 'salient-core')
);




$data = array();
$data['name'] = esc_html__( 'SaaS Dark Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-11-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/promo-header-dark.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#000000" animated_gradient_bg="true" animated_gradient_bg_color_1="#000775" animated_gradient_bg_speed="850" animated_gradient_bg_blending_mode="organic" scene_position="center" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" advanced_gradient_angle="15" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="clip-path" clip_path_animation_type="default" clip_path_animation_applies="row" clip_path_start_top_desktop="0" clip_path_start_bottom_desktop="0" clip_path_start_left_desktop="0" clip_path_start_right_desktop="0" clip_path_end_top_desktop="80px" clip_path_end_bottom_desktop="0" clip_path_end_left_desktop="30px" clip_path_end_right_desktop="30px" clip_path_end_top_phone="50px" clip_path_end_bottom_phone="24px" clip_path_end_left_phone="24px" clip_path_end_right_phone="24px" clip_path_start_roundness="0" clip_path_end_roundness="20px" clip_path_animation_addon="fade" video_mute="true" shape_type="straight_section" gradient_type="default" bg_image_animation_delay="100"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="-4" persist_movement_on_mobile="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][vc_row_inner equal_height="yes" content_placement="bottom" column_margin="custom" column_margin_custom="6vw" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="13%" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" top_padding_tablet="20%" top_padding_phone="25%" left_padding_phone="14%" constrain_group_6="yes" right_padding_phone="14%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner left_padding_tablet="10%" constrain_group_103="yes" right_padding_tablet="10%" left_padding_phone="0" right_padding_phone="0" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="center" phone_text_alignment="center" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="1" width="3/5" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_color="rgba(255,255,255,0.22)" column_border_style="solid" gradient_type="default" column_padding_type="advanced" delay="400"][nectar_highlighted_text scribble_color="#ffffff" style="scribble" scribble_shape="basic-underline" scribble_thickness="thin" scribble_speed="1.3s" scribble_easing="ease_in_out" custom_font_size="5vw" font_size_tablet="7vw" font_line_height="1.1" font_size_phone="8vw" delay="400"]
<h1><em><strong>Beautiful</strong></em> websites with less work</h1>
[/nectar_highlighted_text][divider line_type="No Line" custom_height="50" custom_height_tablet="30"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="default" button_color_hover="#3452ff" text_color="#ffffff" button_border_color="#3452ff" button_border_color_hover="#3452ff" button_border_thickness="1px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Explore Features" padding_top="1em" padding_bottom="1em" padding_left="2.3em" padding_right="2.3em" url="#features" margin_bottom="16" font_size_desktop="1.1vw" font_size_tablet="2vw" font_size_phone="16px"][/vc_column_inner][vc_column_inner left_padding_tablet="20%" constrain_group_103="yes" right_padding_tablet="20%" left_padding_phone="8%" constrain_group_105="yes" right_padding_phone="8%" top_margin_tablet="40" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="center" phone_text_alignment="center" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="2/5" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default" delay="500"][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Salient is a next-generation WordPress theme that brings professional design results to anyone, without any coding required." font_size="1.3vw" font_line_height="1.4" animation_delay="400" font_size_tablet="2vw" font_size_phone="16px"][/split_line_heading][divider line_type="No Line" custom_height="30"][nectar_circle_images images="https://source.unsplash.com/6HVQ78WZEXg,https://source.unsplash.com/w4NPe3L9_E8,https://source.unsplash.com/Ku_L_W-cyDs,https://source.unsplash.com/54YvnfwCMyg" sizing="40px" positioning="overlapping" stacking_order="ltr" alignment_desktop="left" alignment_tablet="middle" alignment_phone="middle" animation="none" image_size="nectar_small_square" image_loading="skip-lazy-load" alignment="left"][nectar_responsive_text]<strong>6k+ reviews</strong> (4.8 of 5)[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="7%" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" left_padding_tablet="17%" constrain_group_4="yes" right_padding_tablet="17%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="rgba(255,255,255,0.06)" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="20px" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="600"][image_with_animation image_url="https://themenectar.com/img/demo-media/promo/landing-toolbar.webp" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="center" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default"][image_with_animation image_url="https://themenectar.com/img/demo-media/promo/promo-landing-builder.webp" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="skip-lazy-load" max_width="none" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Staggered Impact Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'] . ', ' .$cat_display_names['general'];
$data['custom_class'] = 'general hero_section date-3-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/promo-staggered-text.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="10%" bottom_padding="10%" left_padding_desktop="18%" constrain_group_2="yes" right_padding_desktop="18%" left_padding_phone="10%" constrain_group_6="yes" right_padding_phone="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="horizontal" column_element_direction_tablet="horizontal" column_element_direction_phone="horizontal" column_element_alignment="center" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="ENCHANT" font_size="10vw" font_line_height="0.9" font_size_tablet="11vw" font_size_phone="13vw"][/split_line_heading][nectar_lottie trigger_type="play" mobile_func="default" loop="true" trigger_offset="0.00,100.00" frame_constraint="0.00,100.00" speed="0.7" width_desktop="8vw" width_tablet="10vw" width_phone="12vw" alignment="left" preserve_aspect_ratio="xMidYMid meet" json_url="https://assets5.lottiefiles.com/packages/lf20_9r65d17y.json"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="right" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="YOUR" font_size="10vw" font_line_height="0.9" animation_offset="100%" font_size_tablet="11vw" font_size_phone="13vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="30px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="none" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="AUDIENCE" font_size="10vw" font_line_height="0.9" animation_offset="100%" font_size_tablet="11vw" font_size_phone="13vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Split Gradient Columns', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['about'];
$data['custom_class'] = 'about date-3-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/design-split-gradient.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="padding-7-percent" column_padding_tablet="padding-10-percent" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#ffffff" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient="radial-gradient(circle at top right, rgb(251,189,16) 5%, rgba(193,202,215,255) 43%, rgb(192,202,218) 58%, rgb(51,97,255) 94%)" advanced_gradient_radial_position="top right" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="advanced" advanced_gradient_display_type="radial"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_color="#ffffff" line_reveal_by_space_text_effect="default" stagger_animation="true" mobile_disable_animation="true" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="DEEP SPACE EXPLORATION" font_size="4vw" font_line_height="1.1" font_size_tablet="7vw"][/split_line_heading][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" left_padding_desktop="25%" constrain_group_2="yes" right_padding_desktop="25%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][image_with_animation image_url="https://source.unsplash.com/HQPJEEjHqSE" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="custom" box_shadow="none" top_left_border_radius="200" top_right_border_radius="200" bottom_right_border_radius="200" bottom_left_border_radius="200" image_loading="default" max_width="100%" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][split_line_heading animation_type="line-reveal-by-space" font_style="p" text_color="#ffffff" line_reveal_by_space_text_effect="default" stagger_animation="true" mobile_disable_animation="true" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="Retention is key to successful business growth. Our platform gives your customers a better experience from start to finish in order for you to easily turn them into lifelong fans." font_size="1.1vw" font_line_height="1.7" animation_offset="96%" font_size_tablet="2.5vw" font_size_phone="16px"][/split_line_heading][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/IZgg5g_LsS4" background_image_position="center top" background_image_stacking="default" enable_bg_scale="true" background_image_loading="default" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][divider line_type="No Line" custom_height="40vh"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'SAAS Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-14-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-header.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="none" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" bottom_padding="5%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column top_padding_desktop="4vw" bottom_padding_desktop="6vw" left_padding_desktop="7vw" constrain_group_101="yes" right_padding_desktop="7vw" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.8" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="5%" right_padding_desktop="10%" top_padding_tablet="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default" delay="900"][nectar_highlighted_text scribble_color="#ffce59" style="scribble" scribble_shape="basic-underline" scribble_thickness="regular" scribble_speed="0s" scribble_easing="ease_in_out" disable_mobile_animation="true" custom_font_size="5vw" font_size_tablet="7vw" font_line_height="1.1em"]
<h1>Where marketing &amp; automation <em>intersect.</em></h1>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="3vw" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="horizontal" column_element_direction_tablet="horizontal" column_element_direction_phone="horizontal" column_element_alignment="center" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="1100" column_padding_type="default" animation_offset="100%"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="accent-color" text_color="#ffffff" button_border_thickness="0px" link_type="new_tab" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="inline" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Get started" padding_top="0.8em" padding_bottom="0.8em" padding_left="2.2em" padding_right="2.2em" margin_right="1em" font_size_desktop="1.1vw" url="https://themenectar.com/demo/resort" font_size_tablet="14"][nectar_cta btn_style="underline" heading_tag="span" button_color="default" text_color="#000000" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" display="inline" display_tablet="inherit" display_phone="inherit" icon_family="iconsmind" link_text="Explore features" padding_top="4" padding_bottom="4" font_size_desktop="1.1vw" icon_iconsmind="iconsmind-Leafs" url="#features" font_size_tablet="16"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column right_padding_desktop="7vw" top_padding_tablet="30" left_padding_tablet="7vw" constrain_group_103="yes" right_padding_tablet="7vw" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="relative" advanced_gradient_angle="180" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="advanced" advanced_gradient_display_type="linear" column_padding_type="advanced"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="20px" column_link_target="_self" overflow="hidden" advanced_gradient="radial-gradient(circle at bottom, rgb(43,198,255) 0%, rgb(47,86,255) 76%)" advanced_gradient_radial_position="bottom" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="mask-reveal" animation_mask_direction="left" animation_mask_shape="straight" mobile_disable_entrance_animation="true" animation_easing="easeInOutCubic" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="advanced" column_padding_type="default" advanced_gradient_display_type="radial"][nectar_animated_shape shape_color="#ffce59" width_desktop="77vw" width_tablet="154vw" animation="grow-in" animation_disable_mobile="true" animation_easing="easeInOutCubic" animation_movement_type="transform_y" position_desktop="absolute" top_position_desktop="0" left_position_desktop="0" translate_y_desktop="-50%" translate_x_desktop="-50%" zindex="-1" animation_delay="30"][image_with_animation image_url="https://themenectar.com/img/demo-media/saas/sass-guy.webp" image_size="full" animation_type="entrance" animation="slide-up" disable_mobile_animation="true" animation_easing="easeInOutCubic" animation_movement_type="transform_y" hover_animation="none" alignment="center" border_radius="none" box_shadow="none" image_loading="skip-lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_x="-35%" text_align="left" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" top_position_desktop="20%" left_position_desktop="-1%" left_position_tablet="14%" zindex="500" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="entrance_and_parallax" animation_movement_type="default" column_parallax_intensity="1.2" persist_movement_on_mobile="true" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default" delay="900"][image_with_animation image_url="https://themenectar.com/img/demo-media/saas/saas-sales.jpeg" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="15px" box_shadow="custom" box_shadow_method="default" image_loading="skip-lazy-load" max_width="custom" max_width_custom="18vw" custom_box_shadow="horizontal:50,vertical:60,blur:60,spread:-20,opacity:0.175" custom_sizes_attr="(min-width: 1000px) 18vw, 30vw" max_width_custom_tablet="30vw"][nectar_lottie trigger_type="play" mobile_func="remove" trigger_offset="0.00,100.00" frame_constraint="0.00,100.00" width_desktop="6vw" alignment="center" preserve_aspect_ratio="xMidYMid meet" position_desktop="absolute" top_position_desktop="6%" left_position_desktop="5%" mobile_disable_css_animation="true" preserveaspectratio="center" json_url="https://assets4.lottiefiles.com/packages/lf20_d1q2zqsv.json" trigger_delay="900"][/vc_column_inner][/vc_row_inner]
[vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_x="0%" text_align="left" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" top_position_desktop="70%" right_position_desktop="6%" right_position_tablet="4%" zindex="500" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="entrance_and_parallax" animation_movement_type="default" column_parallax_intensity="2" persist_movement_on_mobile="true" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="1100" column_padding_type="default" animation_offset="120%"][image_with_animation image_url="https://themenectar.com/img/demo-media/saas/saas-user-badge.jpeg" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="15px" box_shadow="custom" box_shadow_method="default" image_loading="skip-lazy-load" max_width="custom" max_width_custom="15vw" custom_sizes_attr="(min-width: 1000px) 15vw, 30vw" custom_box_shadow="horizontal:30,vertical:45,blur:50,spread:-20,opacity:0.175" max_width_custom_tablet="30vw"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Animated Gradient Footer', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['cta'];
$data['custom_class'] = 'general cta date-3-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2022-promo-footer.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#0a0a0a" animated_gradient_bg="true" animated_gradient_bg_color_1="#233caf" animated_gradient_bg_speed="850" animated_gradient_bg_blending_mode="linear" scene_position="center" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="1" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="13%" bottom_padding="11%" left_padding_desktop="20%" constrain_group_2="yes" right_padding_desktop="20%" top_padding_tablet="30%" bottom_padding_tablet="25%" left_padding_phone="12%" constrain_group_6="yes" right_padding_phone="12%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][nectar_highlighted_text scribble_color="#ffffff" style="scribble" scribble_shape="squiggle-underline-2" scribble_thickness="thin" scribble_speed="1.6s" scribble_easing="ease_in_out" custom_font_size="6vw" font_size_phone="8vw"]
<h1>Build a website that you are <strong><em>proud of</em></strong></h1>
[/nectar_highlighted_text][divider line_type="No Line" custom_height="5vw"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" text_color="#000000" button_color="white" button_color_hover="#f4f4f4" button_border_thickness="0px" link_type="new_tab" alignment="center" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Purchase Salient" padding_top="12" padding_bottom="12" padding_left="35" padding_right="35" url="#"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="2%" constrain_group_1="yes" bottom_padding="2%" left_padding_desktop="3%" constrain_group_2="yes" right_padding_desktop="3%" top_padding_phone="5%" constrain_group_5="yes" bottom_padding_phone="5%" left_padding_phone="5%" constrain_group_6="yes" right_padding_phone="5%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all" css=".vc_custom_1659042013149{border-top-width: 1px !important;border-top-color: rgba(255,255,255,0.2) !important;border-top-style: solid !important;}"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" offset="vc_col-xs-5"][nectar_responsive_text]<b>© </b>[nectar_current_year] Salient.[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="right" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" offset="vc_col-xs-7"][nectar_cta btn_style="underline" heading_tag="p" text_color="#ffffff" button_color="default" button_border_thickness="0px" link_type="regular" alignment="right" alignment_tablet="right" alignment_phone="right" constrain_group_4="yes" display="inline" display_tablet="inline-block" display_phone="inline-block" icon_family="none" link_text="Docs" padding_left="15" padding_right="15"][nectar_cta btn_style="underline" heading_tag="p" text_color="#ffffff" button_color="default" button_border_thickness="0px" link_type="regular" alignment="right" alignment_tablet="right" alignment_phone="right" display="inline" display_tablet="inline-block" display_phone="inline-block" icon_family="none" link_text="Help Center" padding_left="15"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Hand-Drawn Underline Intro Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-3-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-text-intro.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="12%" bottom_padding="5%" left_padding_desktop="27vw" constrain_group_2="yes" right_padding_desktop="27vw" bottom_padding_tablet="12%" left_padding_tablet="20vw" constrain_group_4="yes" right_padding_tablet="20vw" left_padding_phone="7vw" constrain_group_6="yes" right_padding_phone="7vw" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" advanced_gradient_angle="65" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="advanced" advanced_gradient_display_type="linear"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="7%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" animation_offset="90%"][nectar_animated_shape shape_color="#ffffff" width_desktop="15vw" animation="none" animation_easing="default" animation_movement_type="transform_y" animation_movement_intensity="0.6" animation_movement_persist_on_mobile="true" position_desktop="absolute" top_position_desktop="0" left_position_desktop="0" translate_y_desktop="-30%" translate_x_desktop="-50%" zindex="-1"][nectar_highlighted_text scribble_color="#318fff" style="scribble" scribble_shape="squiggle-underline" scribble_thickness="thick" scribble_speed="1.6s" scribble_easing="ease_in_out" custom_font_size="3vw" id="circle-highlight2" font_line_height="1.4" font_size_tablet="4vw" font_size_phone="5vw"]
<h2>The best customer relationship management platform for just about <em>everything.</em></h2>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Convert leads into customers and then turn those customers into loyal fans of your brand by leveraging next-generation automation and AI. Yes, it really can be automated, and no, you're not dreaming." font_size="1.2vw" max_width="90%" font_line_height="1.8" font_size_tablet="16px"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Clip Path Expanding Video', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-9-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-video.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" video_bg="use_video" video_external="https://www.youtube.com/watch?v=6oTurM7gESE" background_video_loading="lazy-load" scene_position="center" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="10" overflow="visible" advanced_gradient="linear-gradient(0deg, rgba(0,0,0,0.478) 0%, rgba(243,243,243,0) 48%)" shape_divider_position="top" bg_image_animation="clip-path" clip_path_animation_type="scroll" clip_path_animation_applies="row" clip_path_start_left_desktop="14%" clip_path_start_right_desktop="14%" clip_path_end_left_desktop="0%" clip_path_end_right_desktop="0%" clip_path_start_roundness="20px" clip_path_end_roundness="0px" animation_trigger_offset="0.00,100.00" animation_trigger_origin="top" trigger_offset="30.00,60.00" gradient_type="advanced" shape_type="straight_section" advanced_gradient_display_type="linear"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_video_player_self_hosted el_aspect_tablet="43" player_functionality="lightbox" play_button_style="follow_mouse" play_button_hide="yes" play_button_color="#0a0a0a" play_button_icon_color="#ffffff" border_radius="none" box_shadow="none" video_lightbox_url="https://vimeo.com/118023315" advanced_gradient_display_type="linear"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" text_align="left" min_width_desktop="100%" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" bottom_position_desktop="5vw" zindex="1000" overflow="visible" pointer_events="none"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text text_color="#ffffff" font_size_desktop="2vw" font_size_tablet="4vw"]
<h3>Automate your growth</h3>
[/nectar_responsive_text][nectar_responsive_text text_color="#ffffff" font_size_desktop="1.2vw" font_line_height="2.5" font_size_tablet="14"]3:45 duration[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'SAAS Trust-builder', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-12-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-above-testimonial.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" constrain_group_1="yes" bottom_padding="5%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="5%" left_padding_desktop="25vw" constrain_group_2="yes" right_padding_desktop="25vw" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_text_inline_images media_type="images" image_size="large" image_effect="circle_fade_in" image_effect_stagger="yes" right_margin_desktop="-6%" image_loading="skip-lazy-load" line_reveal_by_space_text_effect="" content_alignment="" font_style="h1" font_size="3vw" font_line_height="1.4" font_size_desktop="4vw" font_size_tablet="4vw" max_width="" font_size_phone="5vw"]
<h2>Trusted by over 4,000 clients worldwide ***</h2>
[/nectar_text_inline_images][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'SAAS Testimonial Slider', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['testimonials'];
$data['custom_class'] = 'testimonials date-8-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-testimonials.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" constrain_group_1="yes" bottom_padding="5%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][testimonial_slider style="multiple_visible" color="accent-color-dark" slider_controls="next_prev_arrows" flickity_border_radius="20px" enable_shadow="true" custom_width_desktop="40%" font_size_desktop="1.3vw" font_line_height="1.7" shadow="horizontal:22,vertical:20,blur:60,spread:0,opacity:0.575" custom_box_shadow="horizontal:40,vertical:60,blur:60,spread:-20,opacity:0.175" font_size_tablet="16"][testimonial star_rating="none" title="Testimonial" id="1659387611495-9" name="Aura Brooks" subtitle="Marketing Director, Owl Eyes" quote="We checked out Salient to see what all the hype was about and here we are a year later with a 30% increased bottom line! If you're looking for the latest and greatest, I can't recommend this CRM platform enough." tab_id="1659387611495-2"][testimonial star_rating="none" title="Testimonial" id="1659387611509-0" name="Eve Crawford" subtitle="CEO at ThemeNectar" quote="Our productivity has noticably gone up since implementing the platform. We are now able to dedicate more time on our products while having the peace of mind that our customer experience has improved." tab_id="1659387611510-3"][testimonial star_rating="none" title="Testimonial" id="1659387611517-0" name="Jack Graham" subtitle="Project Manager, Coffee Inc" quote="Salient has enhanced our user experience and allowed us to move faster than ever and our company is now positioned to scale. We've seen a rediculous growth of 80% in just a few months!" tab_id="1659387611517-5"][testimonial star_rating="none" title="Testimonial" id="1659387611525-8" name="Zak Reid" subtitle="CTO at Envato" quote="Simply put, Salient is an excellent tool to accelerate growth and save time. We've been very pleased with the results from implementing the platform into our company." tab_id="1659387611525-4"][/testimonial_slider][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Feature Split #1', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['lottie'];
$data['custom_class'] = 'general lottie date-11-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-lottie-1.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="none" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" bottom_padding="7%" left_padding_desktop="7%" constrain_group_2="yes" right_padding_desktop="7%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="relative" advanced_gradient_angle="180" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="advanced" advanced_gradient_display_type="linear" column_padding_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="60vh" top_padding_tablet="50vh" top_padding_phone="40vh" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/saas/saas-feature-bg.webp" background_image_position="center center" background_image_stacking="front" enable_bg_scale="true" background_image_loading="default" column_backdrop_filter="none" column_shadow="none" column_border_radius="20px" column_link_target="_self" overflow="visible" advanced_gradient_angle="312" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="minimum" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" bottom_position_desktop="30" left_position_desktop="30" zindex="500" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="hidden" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="mask-reveal" animation_mask_direction="left_bottom" animation_mask_shape="circle" animation_easing="easeInOutCubic" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default" animation_offset="95%"][nectar_lottie trigger_type="play" mobile_func="default" trigger_offset="0.00,100.00" frame_constraint="0.00,100.00" width_desktop="18vw" width_tablet="36vw" alignment="center" preserve_aspect_ratio="xMidYMid meet" css_animation="fade-in" preserveaspectratio="center" json_url="https://assets10.lottiefiles.com/packages/lf20_erb8mppf.json" trigger_delay="500"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column left_padding_desktop="7vw" column_element_direction_desktop="default" column_element_spacing="30px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="5%" top_padding_tablet="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_color="#000000" line_reveal_by_space_text_effect="default" stagger_animation="true" mobile_disable_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Create loyal customers that love your brand" font_size="3vw" font_line_height="1.3"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="14%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="easeInOutQuad" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text font_size_min="16px" font_size_desktop="1.1vw" font_line_height="1.8"]Retention is key to successful business growth. Our platform gives your customers a better experience from start to finish in order for you to easily turn them into lifelong fans.[/nectar_responsive_text][nectar_cta btn_style="underline" heading_tag="span" button_color="default" text_color="#ff6b3d" button_border_thickness="0px" link_type="new_tab" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Start your trial" padding_top="4" padding_bottom="4" url="#" font_size_desktop="1.1vw" font_size_tablet="16"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Feature Box', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['lottie'];
$data['custom_class'] = 'general lottie date-10-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2022-promo-features-3.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="20px" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#f0f2f6" scene_position="center" top_padding="4%" constrain_group_1="yes" bottom_padding="4%" left_padding_desktop="5%" constrain_group_2="yes" right_padding_desktop="5%" left_padding_phone="14px" constrain_group_6="yes" right_padding_phone="14px" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="10" overflow="visible" id="studio" advanced_gradient_angle="0" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="advanced" advanced_gradient_display_type="linear"][vc_column top_padding_desktop="7%" left_padding_desktop="18%" constrain_group_101="yes" right_padding_desktop="18%" top_padding_tablet="8vw" left_padding_phone="8vw" constrain_group_105="yes" right_padding_phone="8vw" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/promo/ecommerce-bg.jpeg" background_image_position="center center" background_image_stacking="default" background_image_loading="default" column_backdrop_filter="none" column_shadow="none" column_border_radius="20px" column_link_target="_self" column_position="default" overflow="hidden" advanced_gradient_angle="0" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="minimum" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="advanced" column_padding_type="advanced" advanced_gradient_display_type="linear"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="5%" left_padding_desktop="18%" constrain_group_2="yes" right_padding_desktop="18%" left_padding_tablet="10%" constrain_group_4="yes" right_padding_tablet="10%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="10px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text font_size_desktop="1.8vw" font_line_height="1.3" font_size_tablet="22px"]
<h3>Powerful WooCommerce Functionality</h3>
[/nectar_responsive_text][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]Unlock incredible store building potential with an AJAX off-canvas cart, product quickview, advanced reviews, premium gallery styles, collapsable product widget area, and much more.[/nectar_responsive_text][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="black" text_color="#ffffff" button_border_thickness="0px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="View All Features" margin_top="40" padding_top="12" padding_bottom="12" padding_left="35" padding_right="35"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_tablet="5%" constrain_group_4="yes" right_padding_tablet="5%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="advanced" advanced_gradient_display_type="linear" column_padding_type="advanced"][nectar_lottie trigger_type="play" mobile_func="default" trigger_offset="15.00,100.00" frame_constraint="0.00,100.00" width_desktop="14vw" alignment="center" preserve_aspect_ratio="xMidYMid meet" enable_shadow="true" position_desktop="absolute" top_position_desktop="50%" right_position_desktop="0" translate_y_desktop="-50%" translate_x_desktop="50%" json_url="https://assets7.lottiefiles.com/packages/lf20_thwjheep.json" zindex="10" custom_box_shadow="horizontal:0,vertical:25,blur:30,spread:0,opacity:0.2"][image_with_animation image_url="https://themenectar.com/img/demo-media/promo/ecommerce-robust-preview.jpeg" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="custom" box_shadow="none" top_left_border_radius="20px" top_right_border_radius="20px" image_loading="default" max_width="100%" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Feature Split #2', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-2-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-feature-3.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="none" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="column_reverse" column_direction_phone="column_reverse" scene_position="center" top_padding="7%" constrain_group_1="yes" bottom_padding="7%" left_padding_desktop="7%" constrain_group_2="yes" right_padding_desktop="7%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column right_padding_desktop="7vw" left_padding_tablet="7vw" right_padding_tablet="0" column_element_direction_desktop="default" column_element_spacing="30px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="5%" top_padding_tablet="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_color="#000000" line_reveal_by_space_text_effect="default" stagger_animation="true" mobile_disable_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="AI driven solutions for exceptional outcomes" font_size="3vw" font_line_height="1.3"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="10%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" mobile_disable_entrance_animation="true" animation_easing="easeInOutQuad" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][fancy-ul icon_type="standard_check" color="Accent-Color" alignment="left" spacing="10px" font_size_min="16px" font_size_desktop="1.1vw" font_line_height="1.6"]
<ul>
 	<li>AI-Powered marketing strategies</li>
 	<li>Live customer support chat widget</li>
 	<li>Automatic scaling campaign tools</li>
 	<li>Adaptive testing/reporting</li>
</ul>
[/fancy-ul][nectar_cta btn_style="underline" heading_tag="span" button_color="default" text_color="#ff6b3d" button_border_thickness="0px" link_type="new_tab" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="View A Demo" padding_top="4" padding_bottom="4" url="#" font_size_desktop="1.1vw" font_size_tablet="16"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="relative" overflow="hidden" advanced_gradient_angle="180" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="advanced" advanced_gradient_display_type="linear" column_padding_type="advanced"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#d3dbe1" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="20px" column_link_target="_self" overflow="hidden" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][nectar_animated_shape shape_color="rgba(0,0,0,0.11)" width_desktop="50vw" animation="grow-in" animation_disable_mobile="true" animation_easing="easeInOutCubic" animation_movement_type="transform_y" position_desktop="absolute" top_position_desktop="0" right_position_desktop="0" translate_y_desktop="-50%" translate_x_desktop="50%" zindex="-1" animation_offset="80%"][image_with_animation image_url="https://themenectar.com/img/demo-media/saas/saas-phone.webp" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" animation_movement_intensity=".7" animation_movement_persist_on_mobile="true" hover_animation="none" alignment="center" border_radius="none" box_shadow="custom" box_shadow_method="filter" image_loading="default" max_width="custom" max_width_custom="60%" custom_box_shadow="horizontal:30,vertical:60,blur:60,spread:-20,opacity:0.25" margin_bottom="-12%" margin_top="14%"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Large Gradient Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-10-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/yellow-gradient-landing.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="custom" column_margin_custom="8%" equal_height="yes" content_placement="bottom" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="8%" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" top_padding_tablet="15%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" advanced_gradient="radial-gradient(circle at top right, rgb(255,189,36) 4%, rgb(247,243,239) 81%)" advanced_gradient_radial_position="top right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="advanced" advanced_gradient_display_type="radial" shape_type=""][vc_column bottom_padding_desktop="8vw" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="center" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="padding-4-percent" column_padding_phone="padding-2-percent" column_padding_position="all" bottom_margin="4vw" bottom_margin_tablet="0" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" animation_offset="100%" offset="vc_col-xs-6"][nectar_responsive_text font_size_desktop="1.3vw" font_line_height="1.4" font_size_tablet="16px" font_size_phone="14px"]All that you need to create your own beautiful website.[/nectar_responsive_text][nectar_cta btn_style="underline" heading_tag="h6" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Take a tour" font_size_desktop="1.3vw" font_size_tablet="16px" font_size_phone="14px" margin_top="20"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="padding-4-percent" column_padding_phone="padding-2-percent" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="150" offset="vc_col-xs-6"][nectar_responsive_text font_size_desktop="1.3vw" font_line_height="1.4" font_size_tablet="16px" font_size_phone="14px"]Innovative design that makes people stop and stare.[/nectar_responsive_text][nectar_cta btn_style="underline" heading_tag="h6" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Sign up now" font_size_desktop="1.3vw" font_size_tablet="16px" font_size_phone="14px" margin_top="20"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_element_direction_desktop="default" column_element_spacing="5px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-bottom" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="salient" font_size="8vw" font_line_height="1" font_size_tablet="12vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-bottom" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="DESIGN" font_size="8vw" font_line_height="1" animation_delay="200" font_size_tablet="12vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_x="50%" text_align="left" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" top_position_desktop="45%" right_position_desktop="0" top_position_tablet="40%" right_position_tablet="7%" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/HVrda0rOHqk" background_image_position="center center" background_image_stacking="default" enable_bg_scale="true" background_image_loading="default" column_backdrop_filter="none" column_shadow="custom" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="grow-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" mask_enable="true" mask_size="custom" mask_scale="70" mask_alignment_desktop="center-center" column_padding_type="default" gradient_type="default" custom_box_shadow="horizontal:0,vertical:30,blur:40,spread:0,opacity:0.45"][nectar_icon icon_family="fontawesome" icon_style="default" icon_color_type="color_scheme" icon_color="white" icon_padding="20px" zindex="10" pointer_events="all" position_desktop="absolute" top_position_desktop="50%" left_position_desktop="50%" translate_y_desktop="-50%" translate_x_desktop="-50%" icon_fontawesome="fa fa-play" icon_size="20"]
[image_with_animation image_url="https://themenectar.com/img/demo-media/spinners/play-video-dark.png" image_size="full" animation_type="looped" loop_animation="rotate" animation_movement_type="transform_y" hover_animation="none" alignment="" img_link_target="lightbox" border_radius="none" image_loading="default" max_width="custom" position_desktop="relative" max_width_custom="8vw" img_link="https://www.youtube.com/watch?v=6oTurM7gESE" zindex="1000" max_width_custom_tablet="15vw"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner top_margin="-4vw" top_margin_tablet="-7vw" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#f7f3ef" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" mask_enable="true" mask_shape="circle-rect" mask_size="cover" mask_alignment_desktop="center-top" column_padding_type="advanced" gradient_type="default"][image_with_animation image_url="https://themenectar.com/img/demo-media/saas/sunglasses-guy.webp" image_size="full" animation_type="entrance" animation="slide-up" animation_easing="default" animation_movement_type="transform_y" hover_animation="none" alignment="center" border_radius="none" box_shadow="none" image_loading="default" max_width="125%" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column bottom_padding_desktop="8vw" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default" offset="vc_hidden-sm vc_hidden-xs"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text font_size_desktop="3vw" font_line_height="1.3"]
<h3>98%</h3>
[/nectar_responsive_text][nectar_responsive_text font_size_desktop="1.3vw" font_line_height="1"]
<h6>Customer</h6>
[/nectar_responsive_text][nectar_responsive_text font_size_desktop="1.3vw" font_line_height="1"]
<h6>Satisfaction</h6>
[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Feature Split #3', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['lottie'];
$data['custom_class'] = 'general lottie date-10-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-lottie-2.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" bottom_padding="7%" left_padding_desktop="7%" constrain_group_2="yes" right_padding_desktop="7%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="relative" advanced_gradient_angle="180" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="advanced" advanced_gradient_display_type="linear" column_padding_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="60vh" top_padding_tablet="50vh" top_padding_phone="40vh" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/HVrda0rOHqk" background_image_position="center center" background_image_stacking="front" enable_bg_scale="true" background_image_loading="default" column_backdrop_filter="none" column_shadow="none" column_border_radius="20px" column_link_target="_self" overflow="visible" advanced_gradient_angle="312" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="minimum" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" bottom_position_desktop="30" right_position_desktop="30" zindex="500" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="hidden" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="mask-reveal" animation_mask_direction="right_bottom" animation_mask_shape="circle" animation_easing="easeInOutCubic" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default" animation_offset="95%"][nectar_lottie trigger_type="play" mobile_func="default" trigger_offset="0.00,100.00" frame_constraint="0.00,100.00" width_desktop="18vw" width_tablet="36vw" alignment="center" preserve_aspect_ratio="xMidYMid meet" css_animation="fade-in" preserveaspectratio="center" json_url="https://assets4.lottiefiles.com/packages/lf20_yvkok161.json" trigger_delay="500"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column left_padding_desktop="7vw" column_element_direction_desktop="default" column_element_spacing="30px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="5%" top_padding_tablet="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_color="#000000" line_reveal_by_space_text_effect="default" stagger_animation="true" mobile_disable_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Seriously improve your lead conversion rate" font_size="3vw" font_line_height="1.3"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="10%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" mobile_disable_entrance_animation="true" animation_easing="easeOutQuad" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][fancy-ul icon_type="standard_check" color="Accent-Color" alignment="left" spacing="10px" font_size_min="16px" font_size_desktop="1.1vw" font_line_height="1.6"]
<ul>
 	<li>Intuitive customer analytics</li>
 	<li>Advertisement conversion events</li>
 	<li>Automation of sales/marketing</li>
</ul>
[/fancy-ul][nectar_cta btn_style="underline" heading_tag="span" button_color="default" text_color="#ff6b3d" button_border_thickness="0px" link_type="new_tab" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Start your trial" padding_top="4" padding_bottom="4" url="https://themenectar.com/salient" font_size_desktop="1.1vw" font_size_tablet="16"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Hand-drawn text underline', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-10-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-pricing-text.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" left_padding_desktop="7%" constrain_group_2="yes" right_padding_desktop="7%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" padding_type="default" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="3%" left_padding_desktop="24%" constrain_group_2="yes" right_padding_desktop="24%" left_padding_phone="5%" constrain_group_6="yes" right_padding_phone="5%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][nectar_highlighted_text scribble_color="#ffce59" style="scribble" scribble_shape="squiggle-underline-2" scribble_thickness="thick" scribble_speed="1.1s" scribble_easing="ease_in_out" custom_font_size="4vw"]
<h2>Tailored pricing plans <em>designed</em> for you</h2>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Toggle Pricing Tables', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['pricing']. ', ' . $cat_display_names['lottie'];
$data['custom_class'] = 'pricing lottie date-9-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-pricing.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" left_padding_desktop="7%" constrain_group_2="yes" right_padding_desktop="7%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" padding_type="default" gradient_type="default"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_y="-44px" translate_x="170px" rotate_desktop="350" text_align="left" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" left_position_desktop="50%" overflow="visible" pointer_events="none"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default" offset="vc_hidden-xs"][nectar_badge display_tag="italic" badge_style="default" bg_color_type="custom" text_color="#000000" padding="none" border_radius="20px" display="block" text="Save 25%"][nectar_lottie trigger_type="play" mobile_func="default" trigger_offset="8.00,100.00" frame_constraint="0.00,100.00" speed="0.9" width_desktop="40px" alignment="left" preserve_aspect_ratio="xMidYMid meet" preserveaspectratio="center" json_url="https://assets2.lottiefiles.com/packages/lf20_ddvwtafj.json"][/vc_column_inner][/vc_row_inner][tabbed_section style="toggle_button" tab_change_animation="none" tab_color="Accent-Color" vs_content_animation="fade" vs_link_animation="opacity" vs_navigation_alignment="left" vs_navigation_width_2="25%" vs_navigation_func="default" vs_navigation_width="regular" vs_navigation_spacing="15px" vs_navigation_mobile_display="visible" vs_tab_spacing="5%" animation=""][tab icon_family="none" title="Pay Monthly" id="1659385701588-4" tab_id="1659385701589-2"][vc_row_inner equal_height="yes" column_margin="40px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="40" constrain_group_100="yes" bottom_padding_desktop="40" left_padding_desktop="40" constrain_group_101="yes" right_padding_desktop="40" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ff6b3d" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#ffffff" column_shadow="custom" column_border_radius="15px" column_link_target="_self" zindex="100" overflow="hidden" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" padding_type="advanced" column_padding_type="advanced" column_shadow_custom="" custom_box_shadow="horizontal:40,vertical:60,blur:60,spread:-20,opacity:0.175"][nectar_lottie trigger_type="play" mobile_func="default" loop="true" trigger_offset="0.00,100.00" frame_constraint="0.00,100.00" speed="0.2" width_desktop="150%" height_desktop="150%" alignment="center" preserve_aspect_ratio="xMidYMid meet" position_desktop="absolute" top_position_desktop="0" left_position_desktop="0" translate_y_desktop="-50%" translate_x_desktop="25%" preserveaspectratio="none" json_url="https://assets1.lottiefiles.com/packages/lf20_w4NUp4.json" zindex="-1"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color_type="color_scheme" icon_color="white" icon_padding="0px" pointer_events="all" icon_iconsmind="iconsmind-Plant"][nectar_responsive_text font_style="h4" content_alignment="default" mobile_content_alignment="inherit" font_size="5vw" font_line_height="1" font_size_desktop="2vw" font_size_tablet="3vw" font_size_phone="16"]Basic[/nectar_responsive_text][nectar_responsive_text font_style="h3" content_alignment="default" mobile_content_alignment="inherit" font_size="5vw" font_line_height="1" font_size_desktop="4vw" font_size_tablet="7vw"]Free[/nectar_responsive_text][divider line_type="No Line" custom_height="15"][fancy-ul icon_type="standard_dot" alignment="left" spacing="10px" font_size_min="16px" font_size_desktop="1.1vw"]</p>
<ul>
<li>Live chat widget</li>
<li>Email marketing</li>
<li>Custom Forms</li>
<li>Traffic analytics</li>
</ul>
<p>[/fancy-ul][divider line_type="No Line" custom_height="90"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="white" text_color="#000000" button_border_thickness="0px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" position_desktop="absolute" bottom_position_desktop="40" left_position_desktop="40" right_position_desktop="40" padding_top="0.8em" padding_bottom="0.8em" padding_left="40" padding_right="40" link_text="Get Started"][/vc_column_inner][vc_column_inner top_padding_desktop="40" constrain_group_100="yes" bottom_padding_desktop="40" left_padding_desktop="40" constrain_group_101="yes" right_padding_desktop="40" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#000000" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color_type="color_scheme" icon_color="black" icon_padding="0px" pointer_events="all" icon_iconsmind="iconsmind-Leafs"][nectar_responsive_text font_style="h4" content_alignment="default" mobile_content_alignment="inherit" font_size="5vw" font_line_height="1" font_size_desktop="2vw" font_size_tablet="3vw" font_size_phone="16px"]Premium[/nectar_responsive_text][nectar_price_typography before_text_scale="0.4" after_text_scale="0.4" font_style="h3" price_text="29" before_text="$" after_text="/ month" font_size_desktop="4vw" font_size_tablet="7vw" font_line_height="1.5"][divider line_type="No Line" custom_height="15"][fancy-ul icon_type="standard_dot" alignment="left" spacing="10px" font_size_min="16px" font_size_desktop="1.1vw"]</p>
<ul>
<li>Everything in basic</li>
<li>Marketing automation</li>
<li>Advanced chatbot</li>
<li>Campaign management</li>
<li>Collaboration tools</li>
</ul>
<p>[/fancy-ul][divider line_type="No Line" custom_height="90"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="accent-color" text_color="#ffffff" button_border_thickness="0px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" position_desktop="absolute" bottom_position_desktop="40" left_position_desktop="40" right_position_desktop="40" padding_top="0.8em" padding_bottom="0.8em" padding_left="40" padding_right="40" link_text="Get Started"][/vc_column_inner][vc_column_inner top_padding_desktop="40" constrain_group_100="yes" bottom_padding_desktop="40" left_padding_desktop="40" constrain_group_101="yes" right_padding_desktop="40" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color_type="color_scheme" icon_color="black" icon_padding="0px" pointer_events="all" icon_iconsmind="iconsmind-Flowerpot"][nectar_responsive_text font_style="h4" content_alignment="default" mobile_content_alignment="inherit" font_size="5vw" font_line_height="1" font_size_desktop="2vw" font_size_tablet="3vw" font_size_phone="16px"]Platinum[/nectar_responsive_text][nectar_price_typography before_text_scale="0.4" after_text_scale="0.4" font_style="h3" price_text="59" before_text="$" after_text="/ month" font_size_desktop="4vw" font_size_tablet="7vw" font_line_height="1.5"][divider line_type="No Line" custom_height="15"][fancy-ul icon_type="standard_dot" alignment="left" spacing="10px" font_size_min="16px" font_size_desktop="1.1vw"]</p>
<ul>
<li>Everything in premium</li>
<li>A/B testing sanbox</li>
<li>Custom permissions</li>
<li>Social media automation</li>
<li>Sales automation tools</li>
</ul>
<p>[/fancy-ul][divider line_type="No Line" custom_height="90"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="accent-color" text_color="#ffffff" button_border_thickness="0px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" position_desktop="absolute" bottom_position_desktop="40" left_position_desktop="40" right_position_desktop="40" padding_top="0.8em" padding_bottom="0.8em" padding_left="40" padding_right="40" link_text="Get Started"][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="none" title="Pay Yearly" id="1659385701727-9" tab_id="1659385701727-7"][vc_row_inner equal_height="yes" column_margin="40px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="40" constrain_group_100="yes" bottom_padding_desktop="40" left_padding_desktop="40" constrain_group_101="yes" right_padding_desktop="40" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ff6b3d" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#ffffff" column_shadow="custom" column_border_radius="15px" column_link_target="_self" zindex="100" overflow="hidden" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" padding_type="advanced" column_padding_type="advanced" column_shadow_custom="" custom_box_shadow="horizontal:40,vertical:60,blur:60,spread:-20,opacity:0.175"][nectar_lottie trigger_type="play" mobile_func="default" loop="true" trigger_offset="0.00,100.00" frame_constraint="0.00,100.00" speed="0.2" width_desktop="150%" height_desktop="150%" alignment="center" preserve_aspect_ratio="xMidYMid meet" position_desktop="absolute" top_position_desktop="0" left_position_desktop="0" translate_y_desktop="-50%" translate_x_desktop="25%" preserveaspectratio="none" json_url="https://assets1.lottiefiles.com/packages/lf20_w4NUp4.json" zindex="-1"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color_type="color_scheme" icon_color="white" icon_padding="0px" pointer_events="all" icon_iconsmind="iconsmind-Plant"][nectar_responsive_text font_style="h4" content_alignment="default" mobile_content_alignment="inherit" font_size="5vw" font_line_height="1" font_size_desktop="2vw" font_size_tablet="3vw" font_size_phone="16"]Basic[/nectar_responsive_text][nectar_responsive_text font_style="h3" content_alignment="default" mobile_content_alignment="inherit" font_size="5vw" font_line_height="1" font_size_desktop="4vw" font_size_tablet="7vw"]Free[/nectar_responsive_text][divider line_type="No Line" custom_height="15"][fancy-ul icon_type="standard_dot" alignment="left" spacing="10px" font_size_min="16px" font_size_desktop="1.1vw"]</p>
<ul>
<li>Live chat widget</li>
<li>Email marketing</li>
<li>Custom Forms</li>
<li>Traffic analytics</li>
</ul>
<p>[/fancy-ul][divider line_type="No Line" custom_height="90"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="white" text_color="#000000" button_border_thickness="0px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" position_desktop="absolute" bottom_position_desktop="40" left_position_desktop="40" right_position_desktop="40" padding_top="0.8em" padding_bottom="0.8em" padding_left="40" padding_right="40" link_text="Get Started"][/vc_column_inner][vc_column_inner top_padding_desktop="40" constrain_group_100="yes" bottom_padding_desktop="40" left_padding_desktop="40" constrain_group_101="yes" right_padding_desktop="40" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#000000" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color_type="color_scheme" icon_color="black" icon_padding="0px" pointer_events="all" icon_iconsmind="iconsmind-Leafs"][nectar_responsive_text font_style="h4" content_alignment="default" mobile_content_alignment="inherit" font_size="5vw" font_line_height="1" font_size_desktop="2vw" font_size_tablet="3vw" font_size_phone="16px"]Premium[/nectar_responsive_text][nectar_price_typography before_text_scale="0.4" after_text_scale="0.4" font_style="h3" price_text="250" before_text="$" after_text="/ year" font_size_desktop="4vw" font_size_tablet="7vw" font_line_height="1.5"][divider line_type="No Line" custom_height="15"][fancy-ul icon_type="standard_dot" alignment="left" spacing="10px" font_size_min="16px" font_size_desktop="1.1vw"]</p>
<ul>
<li>Everything in basic</li>
<li>Marketing automation</li>
<li>Advanced chatbot</li>
<li>Campaign management</li>
<li>Collaboration tools</li>
</ul>
<p>[/fancy-ul][divider line_type="No Line" custom_height="90"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="accent-color" text_color="#ffffff" button_border_thickness="0px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" position_desktop="absolute" bottom_position_desktop="40" left_position_desktop="40" right_position_desktop="40" padding_top="0.8em" padding_bottom="0.8em" padding_left="40" padding_right="40" link_text="Get Started"][/vc_column_inner][vc_column_inner top_padding_desktop="40" constrain_group_100="yes" bottom_padding_desktop="40" left_padding_desktop="40" constrain_group_101="yes" right_padding_desktop="40" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color_type="color_scheme" icon_color="black" icon_padding="0px" pointer_events="all" icon_iconsmind="iconsmind-Flowerpot"][nectar_responsive_text font_style="h4" content_alignment="default" mobile_content_alignment="inherit" font_size="5vw" font_line_height="1" font_size_desktop="2vw" font_size_tablet="3vw" font_size_phone="16px"]Platinum[/nectar_responsive_text][nectar_price_typography before_text_scale="0.4" after_text_scale="0.4" font_style="h3" price_text="500" before_text="$" after_text="/ year" font_size_desktop="4vw" font_size_tablet="7vw" font_line_height="1.5"][divider line_type="No Line" custom_height="15"][fancy-ul icon_type="standard_dot" alignment="left" spacing="10px" font_size_min="16px" font_size_desktop="1.1vw"]</p>
<ul>
<li>Everything in premium</li>
<li>A/B testing sanbox</li>
<li>Custom permissions</li>
<li>Social media automation</li>
<li>Sales automation tools</li>
</ul>
<p>[/fancy-ul][divider line_type="No Line" custom_height="90"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="accent-color" text_color="#ffffff" button_border_thickness="0px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" position_desktop="absolute" bottom_position_desktop="40" left_position_desktop="40" right_position_desktop="40" padding_top="0.8em" padding_bottom="0.8em" padding_left="40" padding_right="40" link_text="Get Started"][/vc_column_inner][/vc_row_inner][/tab][/tabbed_section][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Tilted Scrolling Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-8-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-strips.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#318fff" scene_position="center" top_padding="2%" constrain_group_1="yes" bottom_padding="2%" top_margin="5%" scale_desktop="1.02" rotate_desktop="2" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" advanced_gradient_angle="0" shape_divider_position="bottom" bg_image_animation="none" gradient_type="advanced" shape_type="" advanced_gradient_display_type="linear"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="transform_x" column_parallax_intensity="-2.5" persist_movement_on_mobile="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][nectar_scrolling_text scroll_direction="rtl" scroll_speed="slowest" text_color="#0a0a0a" style="default" text_repeat_number="5" text_repeat_divider="space" text_space_amount="medium" overflow="visible" background_image_animation="None" custom_font_size="5vw" custom_font_size_mobile="9vw"]
<h2>Grow your business</h2>
[/nectar_scrolling_text][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffce59" scene_position="center" top_padding="2%" constrain_group_1="yes" bottom_padding="2%" bottom_margin="5%" scale_desktop="1.02" rotate_desktop="358" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="20" overflow="hidden" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="transform_x" column_parallax_intensity="2.5" persist_movement_on_mobile="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][nectar_scrolling_text scroll_direction="ltr" scroll_speed="slowest" text_color="#0a0a0a" style="default" text_repeat_number="5" text_repeat_divider="space" text_space_amount="medium" overflow="visible" background_image_animation="None" custom_font_size="5vw" custom_font_size_mobile="9vw"]
<h2>Grow your business</h2>
[/nectar_scrolling_text][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Clip Path Connected Sections', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-7-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-faq-footer.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="8%" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="4%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_highlighted_text style="none" custom_font_size="3vw" font_size_tablet="6vw" font_line_height="1.2"]
<h1>Frequently asked questions</h1>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="custom" column_margin_custom="7vw" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#f8f8f8" scene_position="center" top_padding="3%" bottom_padding="12%" left_padding_desktop="7vw" constrain_group_2="yes" right_padding_desktop="7vw" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.8" gradient_direction="left_to_right" enable_shape_divider="true" shape_divider_color="#000000" shape_divider_position="bottom" shape_divider_height="99%" bg_image_animation="clip-path" clip_path_animation_type="scroll" clip_path_animation_applies="default" clip_path_start_bottom_desktop="0" clip_path_start_left_desktop="0" clip_path_start_right_desktop="0" clip_path_end_bottom_desktop="4%" clip_path_end_left_desktop="4%" clip_path_end_right_desktop="4%" clip_path_start_roundness="0" clip_path_end_roundness="20" animation_trigger_offset="32.00,50.00" animation_trigger_origin="bottom" shape_type="straight_section" gradient_type="default"][vc_column left_padding_desktop="2vw" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][toggles style="minimal_shadow" accordion="true" accordion_starting_functionality="default" border_radius="none"][toggle color="Accent-Color" heading_tag="h3" heading_tag_functionality="default" title="What does CRM mean?"][vc_column_text]CRM stands for Content Relationship Management. Using a CRM platform gives everyone involved in your business a way to manage customer interactions to increase growth.[/vc_column_text][/toggle][toggle color="Accent-Color" heading_tag="h3" heading_tag_functionality="default" title="Is it really free to start?"][vc_column_text]Yes! You can opt to stay within the free tier for as long as you want to. It's a great way to get a feel for the platform before deciding to upgrade to take advantage of the more advanced features.[/vc_column_text][/toggle][toggle color="Accent-Color" heading_tag="h3" heading_tag_functionality="default" title="Can I import data?"][vc_column_text]Yes! Getting your existing data in is easy. Simply export your existing customers to a .csv file and import them within a couple of clicks.[/vc_column_text][/toggle][/toggles][/vc_column][vc_column right_padding_desktop="2vw" top_margin_tablet="10%" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ff6b3d" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="hidden" advanced_gradient_radial_position="top right" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="advanced" advanced_gradient_display_type="radial"][nectar_animated_shape shape_color="#ffce59" width_desktop="65vw" animation="none" animation_easing="easeInOutCubic" animation_movement_type="transform_y" position_desktop="absolute" top_position_desktop="0" bottom_position_desktop="0" left_position_desktop="0" translate_y_desktop="10%" translate_x_desktop="-50%" zindex="-1" animation_offset="160%"][image_with_animation image_url="https://themenectar.com/img/demo-media/saas/saas-girl.webp" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" animation_movement_intensity="-0.8" hover_animation="none" alignment="" border_radius="none" box_shadow="custom" box_shadow_method="filter" image_loading="default" max_width="100%" max_width_mobile="default" custom_box_shadow="horizontal:-25,vertical:5,blur:25,spread:0,opacity:0" margin_bottom="-10%" margin_top="5%"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#000000" scene_position="center" top_padding="10%" bottom_padding="10%" left_padding_desktop="6vw" constrain_group_2="yes" right_padding_desktop="6vw" top_padding_tablet="20%" bottom_padding_tablet="10%" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="5%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_desktop="25%" bottom_margin_phone="30" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default" offset="vc_col-lg-8 vc_col-md-6"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Scale your brand and earn more revenue" font_size="4vw"][/split_line_heading][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" bottom_margin_tablet="0" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/6" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="150" offset="vc_col-lg-2 vc_col-md-3"][vc_column_text]
<h5>Connect</h5>
[/vc_column_text][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Testimonials" url="#features" margin_top="10" font_size_desktop="1.3vw" font_size_tablet="16px"][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Features" url="#features" font_size_desktop="1.3vw" font_size_tablet="16px"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/6" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="300" offset="vc_col-lg-2 vc_col-md-3"][vc_column_text]
<h5>Contact Us</h5>
[/vc_column_text][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="+216 (0)40 3629 4753" margin_top="10" font_size_desktop="1.3vw" font_size_tablet="16px"][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="hello@domain.com" font_size_desktop="1.3vw" font_size_tablet="16px"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="top" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" bottom_margin_phone="30" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_cta btn_style="text-reveal-wave" heading_tag="h6" button_color="accent-color" text_color="#ffffff" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" font_size_desktop="1.1vw" link_text="Start your trial" url="#" padding_top="1em" padding_bottom="1em" padding_left="2.5em" padding_right="2.5em" font_size_tablet="16"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="150" animation_offset="110%"][nectar_responsive_text]©  [nectar_current_year]. Website built with <a href="https://themenectar.com/salient">Salient</a>.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Happy FAQ Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['about'];
$data['custom_class'] = 'about date-7-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-faq.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="8%" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="4%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_highlighted_text style="none" custom_font_size="3vw" font_size_tablet="6vw" font_line_height="1.2"]
<h1>Frequently asked questions</h1>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="custom" column_margin_custom="7vw" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#f8f8f8" scene_position="center" top_padding="3%" bottom_padding="12%" left_padding_desktop="7vw" constrain_group_2="yes" right_padding_desktop="7vw" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.8" gradient_direction="left_to_right" shape_divider_color="#000000" shape_divider_position="bottom" shape_divider_height="99%" bg_image_animation="none" shape_type="straight_section" gradient_type="default"][vc_column left_padding_desktop="2vw" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][toggles style="minimal_shadow" accordion="true" accordion_starting_functionality="default" border_radius="none"][toggle color="Accent-Color" heading_tag="h3" heading_tag_functionality="default" title="What does CRM mean?"][vc_column_text]CRM stands for Content Relationship Management. Using a CRM platform gives everyone involved in your business a way to manage customer interactions to increase growth.[/vc_column_text][/toggle][toggle color="Accent-Color" heading_tag="h3" heading_tag_functionality="default" title="Is it really free to start?"][vc_column_text]Yes! You can opt to stay within the free tier for as long as you want to. It's a great way to get a feel for the platform before deciding to upgrade to take advantage of the more advanced features.[/vc_column_text][/toggle][toggle color="Accent-Color" heading_tag="h3" heading_tag_functionality="default" title="Can I import data?"][vc_column_text]Yes! Getting your existing data in is easy. Simply export your existing customers to a .csv file and import them within a couple of clicks.[/vc_column_text][/toggle][/toggles][/vc_column][vc_column right_padding_desktop="2vw" top_margin_tablet="10%" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ff6b3d" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="hidden" advanced_gradient_radial_position="top right" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="advanced" advanced_gradient_display_type="radial"][nectar_animated_shape shape_color="#ffce59" width_desktop="65vw" animation="none" animation_easing="easeInOutCubic" animation_movement_type="transform_y" position_desktop="absolute" top_position_desktop="0" bottom_position_desktop="0" left_position_desktop="0" translate_y_desktop="10%" translate_x_desktop="-50%" zindex="-1" animation_offset="160%"][image_with_animation image_url="https://themenectar.com/img/demo-media/saas/saas-girl.webp" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" animation_movement_intensity="-0.8" hover_animation="none" alignment="" border_radius="none" box_shadow="custom" box_shadow_method="filter" image_loading="default" max_width="100%" max_width_mobile="default" custom_box_shadow="horizontal:-25,vertical:5,blur:25,spread:0,opacity:0" margin_bottom="-10%" margin_top="5%"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Dark SAAS Footer', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-7-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-footer.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#000000" scene_position="center" top_padding="10%" bottom_padding="10%" left_padding_desktop="6vw" constrain_group_2="yes" right_padding_desktop="6vw" top_padding_tablet="20%" bottom_padding_tablet="10%" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="5%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_desktop="25%" bottom_margin_phone="30" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default" offset="vc_col-lg-8 vc_col-md-6"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Scale your brand and earn more revenue" font_size="4vw"][/split_line_heading][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" bottom_margin_tablet="0" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/6" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="150" offset="vc_col-lg-2 vc_col-md-3"][vc_column_text]
<h5>Connect</h5>
[/vc_column_text][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Testimonials" url="#features" margin_top="10" font_size_desktop="1.3vw" font_size_tablet="16px"][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Features" url="#features" font_size_desktop="1.3vw" font_size_tablet="16px"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/6" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="300" offset="vc_col-lg-2 vc_col-md-3"][vc_column_text]
<h5>Contact Us</h5>
[/vc_column_text][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="+216 (0)40 3629 4753" margin_top="10" font_size_desktop="1.3vw" font_size_tablet="16px"][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="hello@domain.com" font_size_desktop="1.3vw" font_size_tablet="16px"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="top" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" bottom_margin_phone="30" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_cta btn_style="text-reveal-wave" heading_tag="h6" button_color="accent-color" text_color="#ffffff" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" font_size_desktop="1.1vw" link_text="Start your trial" url="#" padding_top="1em" padding_bottom="1em" padding_left="2.5em" padding_right="2.5em" font_size_tablet="16"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="150" animation_offset="110%"][nectar_responsive_text]©  [nectar_current_year]. Website built with <a href="https://themenectar.com/salient">Salient</a>.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Animated Gradient Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'] . ', ' . $cat_display_names['lottie'];
$data['custom_class'] = 'hero_section lottie date-7-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2022-promo-heading.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#edeef1" full_height="yes" columns_placement="stretch" animated_gradient_bg="true" animated_gradient_bg_color_1="#ffb71e" animated_gradient_bg_speed="850" animated_gradient_bg_blending_mode="linear" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" advanced_gradient_angle="15" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="clip-path" clip_path_animation_type="default" clip_path_animation_applies="row" clip_path_start_top_desktop="0px" clip_path_start_bottom_desktop="0px" clip_path_start_left_desktop="0px" clip_path_start_right_desktop="0px" clip_path_end_top_desktop="30px" clip_path_end_bottom_desktop="30px" clip_path_end_left_desktop="30px" clip_path_end_right_desktop="30px" clip_path_end_top_phone="50px" clip_path_end_bottom_phone="24px" clip_path_end_left_phone="24px" clip_path_end_right_phone="24px" clip_path_start_roundness="0" clip_path_end_roundness="20px" clip_path_animation_addon="none" video_mute="true" shape_type="straight_section" gradient_type="default" bg_image_animation_delay="1000"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="-4" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="medium_fast" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="4%" bottom_padding="30" left_padding_desktop="22%" constrain_group_2="yes" right_padding_desktop="22%" left_padding_phone="14%" constrain_group_6="yes" right_padding_phone="14%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="1" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-twist" animation_easing="easeInOutCubic" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_color="rgba(255,255,255,0.22)" column_border_style="solid" gradient_type="default" column_padding_type="advanced" delay="200"][nectar_highlighted_text scribble_color="#000000" style="scribble" scribble_shape="basic-underline" scribble_thickness="thin" scribble_speed="1.6s" scribble_easing="ease_out" custom_font_size="6vw" delay="1000" font_size_tablet="6vw" font_line_height="1.1" font_size_phone="10vw"]
<h1><strong><em>Beautiful</em></strong> websites with less work</h1>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner left_padding_desktop="38%" constrain_group_101="yes" right_padding_desktop="38%" left_padding_tablet="30%" constrain_group_103="yes" right_padding_tablet="30%" left_padding_phone="20%" constrain_group_105="yes" right_padding_phone="20%" column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="1" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-twist" animation_easing="easeInOutCubic" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_color="rgba(255,255,255,0.22)" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="A next-generation WordPress theme that brings professional design results to anyone, without any coding required." font_size="1.2vw" font_line_height="1.6" animation_delay="1200" font_size_tablet="16"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" bottom_position_desktop="60" left_position_desktop="60" zindex="10" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="10px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="1300" animation_offset="100%" column_padding_type="default" offset="vc_hidden-sm vc_hidden-xs"][nectar_circle_images images="https://source.unsplash.com/6HVQ78WZEXg,https://source.unsplash.com/w4NPe3L9_E8,https://source.unsplash.com/Ku_L_W-cyDs,https://source.unsplash.com/54YvnfwCMyg" sizing="40px" positioning="overlapping" stacking_order="ltr" alignment="left" animation="none" image_size="nectar_small_square" image_loading="default"][nectar_responsive_text]<strong>6k+ reviews</strong> (4.8 <em>of</em> 5)[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_x="-50%" text_align="left" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" bottom_position_desktop="60" left_position_desktop="50%" zindex="10" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="1500" animation_offset="100%" column_padding_type="default" offset="vc_hidden-lg vc_hidden-md"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Scroll Down" url="#intro"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" bottom_position_desktop="60" right_position_desktop="60" zindex="10" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="1300" animation_offset="100%" column_padding_type="default" offset="vc_hidden-sm vc_hidden-xs"][nectar_lottie trigger_type="play" mobile_func="default" loop="true" trigger_offset="0.00,100.00" frame_constraint="0.00,100.00" speed="0.8" width_desktop="55px" alignment="center" preserve_aspect_ratio="xMidYMid meet" json_url="https://assets1.lottiefiles.com/packages/lf20_9r65d17y.json"][nectar_responsive_text font_line_height="1.3"]<strong>Salient</strong>[/nectar_responsive_text][nectar_responsive_text font_line_height="1.3" font_size_desktop="0.9em"]<em>by</em> ThemeNectar[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Sticky Media Sections', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-7-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2022-promo-sticky-media.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" top_padding="7%" bottom_padding="10%" left_padding_desktop="6%" constrain_group_2="yes" right_padding_desktop="6%" left_padding_tablet="8%" constrain_group_4="yes" right_padding_tablet="8%" top_padding_phone="25%" left_padding_phone="24px" constrain_group_6="yes" right_padding_phone="24px" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="10" overflow="visible" id="features" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_color="#0a0a0a" shape_divider_position="top" shape_divider_height="1" bg_image_animation="none" gradient_type="default" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_sticky_media_sections content_position="right" content_spacing="45vh" media_width="60%" media_height="75vh" mobile_aspect_ratio="4-3" border_radius="15px"][nectar_sticky_media_section section_type="image" image="https://themenectar.com/img/demo-media/promo/sticky-media-1.jpg"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="15vh" top_padding_tablet="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Template library" font_size="3vw"][/split_line_heading][nectar_responsive_text font_size_min="16px" font_size_max="21px" font_size_desktop="1.2vw" font_line_height="1.7"]Not all templates are created equal. Salient offers access to a perpetually updated library of <strong>professional</strong> section templates, with currently over 400 to choose from — all created with passion and held to a high standard for aesthetic quality.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/nectar_sticky_media_section][nectar_sticky_media_section section_type="image" image="https://themenectar.com/img/demo-media/promo/sticky-media-2.jpg"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding_tablet="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Visual page builder" font_size="3vw"][/split_line_heading][nectar_responsive_text font_size_min="16px" font_size_max="21px" font_size_desktop="1.2vw" font_line_height="1.7"]Build like it's [nectar_current_year]. Experience a high-performing, modern take on the WPBakery page builder — The editor you already know, but with supercharged power to handle complex designs and the flexibility to <strong>create any type of website.</strong>[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][fancy-ul icon_type="standard_dot" alignment="left" spacing="10px" font_size_min="16px" font_size_max="21px" font_size_desktop="1.2vw"]
<ul>
 	<li>Set option values unique based on screen size</li>
 	<li>Sidebar &amp; modal editing layout options</li>
 	<li>Visually intuitive graphical settings UI</li>
 	<li>Front-end &amp; back-end editors</li>
 	<li>Reusable global sections</li>
 	<li>Tree-list element view</li>
</ul>
[/fancy-ul][/vc_column_inner][/vc_row_inner][/nectar_sticky_media_section][nectar_sticky_media_section section_type="image" image="https://themenectar.com/img/demo-media/promo/sticky-media-3.jpg"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Premium elements" font_size="3vw"][/split_line_heading][nectar_responsive_text font_size_min="16px" font_size_max="21px" font_size_desktop="1.2vw" font_line_height="1.7"]A unique collection of over <strong>65 elements</strong> that make building a beautiful site easy. The Salient element set brings the latest web trends to your fingertips without any coding needed. We actively seek to bring fresh innovation by pushing the boundaries of what's possible on the web.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/nectar_sticky_media_section][/nectar_sticky_media_sections][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Trust-Building Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-5-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2022-promo-trusted.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" animated_gradient_bg="true" animated_gradient_bg_color_1="#ffb10a" animated_gradient_bg_speed="850" animated_gradient_bg_blending_mode="linear" scene_position="center" top_padding="1%" bottom_padding="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="2" overflow="visible" id="trusted" advanced_gradient="linear-gradient(0deg, rgb(255,255,255) 4%, rgba(255,255,255,0) 30%, rgba(255,255,255,0) 75%, rgb(255,255,255) 96%)" shape_divider_position="bottom" bg_image_animation="none" gradient_type="advanced" shape_type="" advanced_gradient_display_type="linear"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][carousel script="flickity" flickity_formatting="default" desktop_cols_flickity="6" desktop_small_cols_flickity="6" tablet_cols_flickity="5" phone_cols_flickity="4" flickity_controls="none" color="default" flickity_overflow="hidden" flickity_wrap_around="wrap" flickity_spacing="default" flickity_column_vertical_alignment="middle" column_padding="custom" column_padding_custom="4vw" flickity_element_spacing="default" border_radius="none" autorotate="true" autorotate_type="ticker" ticker_speed="slow"][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1659369460849-3" title="Item" tab_id="1659369460849-4"][image_with_animation image_url="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default"][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1659369460857-0" title="Item" tab_id="1659369460857-3"][image_with_animation image_url="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default"][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1659369460865-3" title="Item" tab_id="1659369460865-3"][image_with_animation image_url="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default"][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1659369460873-1" title="Item" tab_id="1659369460873-7"][image_with_animation image_url="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default"][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1659369460885-5" title="Item" tab_id="1659369460886-9"][image_with_animation image_url="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default"][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1659369460897-0" title="Item" tab_id="1659369460898-7"][image_with_animation image_url="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default"][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1659369460909-6" title="Item" tab_id="1659369460909-6"][image_with_animation image_url="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default"][/item][/carousel][divider line_type="No Line" custom_height="8vh" custom_height_phone="2vh"][split_line_heading animation_type="line-reveal-by-space" font_style="h3" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Trusted by" font_size="6vw" font_line_height="1"][/split_line_heading][nectar_rotating_words_title heading_tag="h3" dynamic_text="130k websites, industry leaders, top designers" duration="3000" dynamic_heading_tag="default" element_animation="none" mobile_display="inline" font_size="6vw"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Features Grid #1', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['lottie'];
$data['custom_class'] = 'general lottie date-6-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2022-promo-features-1.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="20px" equal_height="yes" content_placement="top" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#f0f2f6" scene_position="center" top_padding="4%" constrain_group_1="yes" bottom_padding="4%" left_padding_desktop="5%" constrain_group_2="yes" right_padding_desktop="5%" left_padding_phone="14px" constrain_group_6="yes" right_padding_phone="14px" bottom_margin="0" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="10" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column top_padding_desktop="4vw" bottom_padding_desktop="1vw" left_padding_desktop="4vw" constrain_group_101="yes" right_padding_desktop="4vw" top_padding_tablet="8vw" left_padding_tablet="8vw" constrain_group_103="yes" right_padding_tablet="8vw" bottom_margin_tablet="20" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="20px" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][nectar_badge display_tag="label" badge_style="default" bg_color_type="custom" bg_color_custom="#3452ff" text_color="#ffffff" padding="small" border_radius="20px" display="block" text="New" margin_bottom="20"][nectar_responsive_text font_size_desktop="1.8vw" font_size_tablet="22px" font_line_height="1.3"]
<h3>Lottie Integration</h3>
[/nectar_responsive_text][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_tablet="33vw" right_padding_phone="0" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]Tap into a vast library of free, beautiful animations or create your own using Adobe After Effects.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][nectar_lottie trigger_type="play" mobile_func="default" loop="true" trigger_offset="0.00,100.00" frame_constraint="0.00,100.00" speed="0.8" width_desktop="90%" width_tablet="70%" width_phone="90%" alignment="center" preserve_aspect_ratio="xMidYMid meet" json_url="https://assets2.lottiefiles.com/packages/lf20_f8xnmcvu.json"][/vc_column][vc_column top_padding_desktop="4vw" constrain_group_100="yes" bottom_padding_desktop="4vw" left_padding_desktop="4vw" constrain_group_101="yes" right_padding_desktop="4vw" top_padding_tablet="8vw" constrain_group_102="yes" bottom_padding_tablet="8vw" left_padding_tablet="8vw" constrain_group_103="yes" right_padding_tablet="8vw" bottom_margin_tablet="20" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#3452ff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#ffffff" column_shadow="none" column_border_radius="20px" column_link_target="_self" column_position="default" advanced_gradient_angle="135" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="advanced" advanced_gradient_display_type="linear" column_padding_type="advanced"][nectar_responsive_text font_size_desktop="1.8vw" font_size_tablet="22px" font_line_height="1.3"]
<h3>Mega Menu Builder</h3>
[/nectar_responsive_text][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_tablet="33vw" right_padding_phone="0" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]Build gorgeous megamenus with columns, images, icons, and buttons all through an easy interface.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][image_with_animation image_url="https://themenectar.com/img/demo-media/promo/megamenu.webp" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="center" border_radius="none" box_shadow="none" image_loading="default" max_width="110%" max_width_mobile="default" margin_top="13%"][/vc_column][vc_column top_padding_desktop="4vw" constrain_group_100="yes" bottom_padding_desktop="4vw" left_padding_desktop="4vw" constrain_group_101="yes" right_padding_desktop="4vw" top_padding_tablet="8vw" constrain_group_102="yes" bottom_padding_tablet="8vw" left_padding_tablet="8vw" constrain_group_103="yes" right_padding_tablet="8vw" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffc444" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#000000" column_shadow="none" column_border_radius="20px" column_link_target="_self" column_position="default" overflow="hidden" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_responsive_text font_size_desktop="1.8vw" font_size_tablet="22px" font_line_height="1.3"]
<h3>Search With Substance</h3>
[/nectar_responsive_text][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_tablet="33vw" right_padding_phone="0" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]Advanced AJAX search functionality with multiple layout options that are capable of bringing up results in real-time.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][divider line_type="No Line" custom_height_tablet="60vw"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" min_width_desktop="152%" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" bottom_position_desktop="-8%" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="custom" top_left_border_radius="20px" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][image_with_animation image_url="https://themenectar.com/img/demo-media/promo/promo-search.jpg" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Features Grid #2', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['lottie'];
$data['custom_class'] = 'general lottie date-5-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2022-promo-features-2.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="20px" equal_height="yes" content_placement="top" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#f0f2f6" scene_position="center" top_padding="4%" constrain_group_1="yes" bottom_padding="4%" left_padding_desktop="5%" constrain_group_2="yes" right_padding_desktop="5%" left_padding_phone="14px" constrain_group_6="yes" right_padding_phone="14px" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="10" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column top_padding_desktop="4vw" constrain_group_100="yes" bottom_padding_desktop="4vw" left_padding_desktop="4vw" constrain_group_101="yes" right_padding_desktop="4vw" top_padding_tablet="8vw" constrain_group_102="yes" bottom_padding_tablet="8vw" left_padding_tablet="8vw" constrain_group_103="yes" right_padding_tablet="8vw" bottom_margin_tablet="20" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" column_position="default" overflow="hidden" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="7/12" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_color="rgba(10,10,10,0.1)" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_desktop="25%" right_padding_tablet="33vw" right_padding_phone="0" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#0a0000" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][nectar_responsive_text font_size_desktop="1.8vw" font_size_tablet="22px" font_line_height="1.3"]
<h3>Responsive Editing</h3>
[/nectar_responsive_text][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]Maximize your control and create intricate responsive layouts with the ability to control settings uniquely per each device viewport.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="relative" row_position_tablet="inherit" row_position_phone="inherit" top_position_desktop="10%" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][image_with_animation image_url="https://themenectar.com/img/demo-media/promo/promo-responsive.jpg" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column top_padding_desktop="4vw" constrain_group_100="yes" bottom_padding_desktop="4vw" left_padding_desktop="4vw" constrain_group_101="yes" right_padding_desktop="4vw" top_padding_tablet="8vw" constrain_group_102="yes" bottom_padding_tablet="8vw" left_padding_tablet="8vw" constrain_group_103="yes" right_padding_tablet="8vw" column_element_direction_desktop="default" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#000000" column_shadow="none" column_border_radius="15px" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="5/12" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_color="rgba(0,0,0,0.15)" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_tablet="33vw" right_padding_phone="0" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#000000" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][nectar_badge display_tag="label" badge_style="default" bg_color_type="global" color="accent-color" text_color="#ffffff" padding="small" border_radius="20px" display="block" text="New" margin_bottom="20"][nectar_responsive_text font_size_desktop="1.8vw" font_size_tablet="22px" font_line_height="1.3"]
<h3>Global Sections</h3>
[/nectar_responsive_text][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]The easy way to manage a section that you place on multiple pages of your site. Edits made in one location will instantly reflect in all instances where the section is used.[/nectar_responsive_text][divider line_type="No Line" custom_height="1vh"][/vc_column_inner][/vc_row_inner][nectar_lottie trigger_type="play" mobile_func="default" trigger_offset="10.00,100.00" frame_constraint="0.00,100.00" width_desktop="80%" alignment="center" preserve_aspect_ratio="xMidYMid meet" enable_shadow="true" json_url="https://assets4.lottiefiles.com/packages/lf20_zxmqc93z.json" custom_box_shadow="horizontal:0,vertical:25,blur:14,spread:0,opacity:0.075"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Features Grid #4', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-3-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2022-promo-features-4.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="20px" equal_height="yes" content_placement="top" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#f0f2f6" scene_position="center" top_padding="4%" constrain_group_1="yes" bottom_padding="4%" left_padding_desktop="5%" constrain_group_2="yes" right_padding_desktop="5%" left_padding_phone="14px" constrain_group_6="yes" right_padding_phone="14px" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="10" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column top_padding_desktop="4vw" left_padding_desktop="4vw" constrain_group_101="yes" right_padding_desktop="4vw" top_padding_tablet="8vw" left_padding_tablet="8vw" constrain_group_103="yes" right_padding_tablet="8vw" bottom_margin_tablet="20" column_element_direction_desktop="default" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffc444" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#000000" column_shadow="none" column_border_radius="15px" column_link_target="_self" column_position="default" overflow="hidden" advanced_gradient_angle="150" width="5/12" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_color="rgba(0,0,0,0.15)" column_border_style="solid" gradient_type="advanced" advanced_gradient_display_type="linear" column_padding_type="advanced"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_tablet="33vw" right_padding_phone="0" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][nectar_responsive_text font_size_desktop="1.8vw" font_size_tablet="22px" font_line_height="1.3"]
<div class="wpb_text_column wpb_content_element vc_custom_1490624298920">
<div class="wpb_wrapper">
<h3>Free Updates for Life</h3>
</div>
</div>
[/nectar_responsive_text][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]Over the past 10 years, we've consistently released updates with new features and fixes. You'll get free access to all future updates with a single purchase.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" min_width_desktop="100%" row_position="relative" row_position_tablet="inherit" row_position_phone="inherit" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][image_with_animation image_url="https://themenectar.com/img/demo-media/promo/promo-updates.png" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="center" border_radius="none" box_shadow="none" image_loading="default" max_width="custom" max_width_custom="90%"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="7/12" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][vc_row_inner equal_height="yes" content_placement="top" column_margin="20px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="20px" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all" css=".vc_custom_1659929996435{margin-bottom: 0px !important;}"][vc_column_inner top_padding_desktop="4vw" constrain_group_100="yes" bottom_padding_desktop="4vw" left_padding_desktop="4vw" right_padding_desktop="60%" top_padding_tablet="8vw" constrain_group_102="yes" bottom_padding_tablet="8vw" left_padding_tablet="8vw" right_padding_tablet="50%" right_padding_phone="40%" bottom_margin_tablet="0" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#3452ff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#ffffff" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="hidden" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][nectar_responsive_text font_size_desktop="1.8vw" font_size_tablet="22px" font_line_height="1.3"]
<h3>Google Fonts</h3>
[/nectar_responsive_text][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]Choose from over 1,400 Google fonts with powerful responsive typography settings.[/nectar_responsive_text][image_with_animation image_url="https://themenectar.com/img/demo-media/promo/promo-google-fonts-logo.webp" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="right" border_radius="none" box_shadow="none" image_loading="default" max_width="custom" position_desktop="absolute" top_position_desktop="20%" right_position_desktop="5%" top_position_phone="50%" right_position_phone="10%" translate_y_phone="-50%" max_width_custom="23vw" max_width_custom_tablet="35vw" max_width_custom_phone="18vw"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="4vw" constrain_group_100="yes" bottom_padding_desktop="4vw" left_padding_desktop="4vw" constrain_group_101="yes" right_padding_desktop="4vw" top_padding_tablet="8vw" constrain_group_102="yes" bottom_padding_tablet="8vw" left_padding_tablet="8vw" constrain_group_103="yes" right_padding_tablet="8vw" bottom_margin="0" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#0a0000" column_shadow="none" column_border_radius="20px" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_color="rgba(0,0,0,0.15)" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][nectar_responsive_text font_size_desktop="1.8vw" font_size_tablet="22px" font_line_height="1.3"]
<h3>Blazing Performance</h3>
[/nectar_responsive_text][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]Salient is Built with modern tooling and includes a suite of simple to use, yet powerful performance options created to target page speed scoring. View the report from <a href="#" target="_blank" rel="noopener"><strong>GTMetrix</strong></a> or <a href="#" target="_blank" rel="noopener"><strong>Google Lighthouse</strong></a>.[/nectar_responsive_text][divider line_type="No Line" custom_height="1vh"][nectar_lottie trigger_type="play" mobile_func="default" loop="true" trigger_offset="0.00,100.00" frame_constraint="0.00,100.00" speed="0.7" width_desktop="50%" width_phone="100%" alignment="left" preserve_aspect_ratio="xMidYMid meet" json_url="https://assets7.lottiefiles.com/packages/lf20_xui5jtgp.json"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Features Grid #5', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['lottie'];
$data['custom_class'] = 'general lottie date-2-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2022-promo-features-5.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="20px" equal_height="yes" content_placement="top" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#f0f2f6" scene_position="center" top_padding="4%" constrain_group_1="yes" bottom_padding="4%" left_padding_desktop="5%" constrain_group_2="yes" right_padding_desktop="5%" left_padding_phone="14px" constrain_group_6="yes" right_padding_phone="14px" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="10" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" bottom_margin_tablet="20px" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#000000" column_shadow="none" column_border_radius="20px" column_link_target="_self" column_position="default" overflow="hidden" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_color="rgba(0,0,0,0.15)" column_border_style="solid" gradient_type="default" column_padding_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="24%" right_padding_phone="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="4vw" constrain_group_100="yes" bottom_padding_desktop="4vw" left_padding_desktop="4vw" constrain_group_101="yes" right_padding_desktop="4vw" top_padding_tablet="8vw" constrain_group_102="yes" bottom_padding_tablet="8vw" left_padding_tablet="8vw" constrain_group_103="yes" right_padding_tablet="8vw" bottom_margin="-5%" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][nectar_responsive_text font_size_desktop="1.8vw" font_size_tablet="22px" font_line_height="1.3"]
<h3>Salient Help Center</h3>
[/nectar_responsive_text][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]We offer hands-on support with a professional team of agents to ensure that your questions get answered in a timely manner.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][image_with_animation image_url="https://themenectar.com/img/demo-media/promo/helpcenter.webp" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="custom"][/vc_column][vc_column top_padding_desktop="4vw" constrain_group_100="yes" bottom_padding_desktop="4vw" left_padding_desktop="4vw" right_padding_desktop="22vw" top_padding_tablet="8vw" constrain_group_102="yes" bottom_padding_tablet="8vw" left_padding_tablet="8vw" right_padding_tablet="50vw" right_padding_phone="33vw" column_element_direction_desktop="default" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/promo/promo-docs.jpeg" background_image_position="center top" background_image_stacking="default" enable_bg_scale="true" background_image_loading="default" column_backdrop_filter="none" font_color="#ffffff" column_shadow="none" column_border_radius="20px" column_link_target="_self" column_position="default" overflow="hidden" advanced_gradient_angle="0" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="minimum" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="advanced" advanced_gradient_display_type="linear" column_padding_type="advanced"][nectar_responsive_text font_size_desktop="1.8vw" font_size_tablet="22px" font_line_height="1.3"]
<h3>Demo Importer</h3>
[/nectar_responsive_text][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]Easily import any of the demos with one click via our simple demo importer plugin.[/nectar_responsive_text][divider line_type="No Line" custom_height="30vh"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Minimal FAQ', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-2-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2022-promo-faq.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" top_padding="12%" bottom_padding="12%" left_padding_desktop="25%" constrain_group_2="yes" right_padding_desktop="25%" left_padding_tablet="20%" constrain_group_4="yes" right_padding_tablet="20%" left_padding_phone="24px" constrain_group_6="yes" right_padding_phone="24px" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="10" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.8" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="3%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_responsive_text font_size_desktop="3vw" font_size_tablet="5vw" font_size_phone="8vw" font_line_height="1.1"]
<h3>Frequently asked questions</h3>
[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][toggles style="minimal_shadow" accordion="true" accordion_starting_functionality="default" border_radius="20px"][toggle color="Default" heading_tag="h3" heading_tag_functionality="default" title="Was this site built with Salient?"][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.6"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis ultricies metus sed turpis pulvinar eleifend. Pellentesque a tempor turpis, quis congue odio.[/nectar_responsive_text][/toggle][toggle color="Default" heading_tag="h3" heading_tag_functionality="default" title="Where can I purchase Salient?"][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.6"]Proin accumsan mauris ut sem gravida, vel aliquam orci ornare. Cras sed urna neque. Vivamus mauris odio, pretium ac nunc a, ornare faucibus augue. Praesent quis lorem magna.[/nectar_responsive_text][/toggle][toggle color="Default" heading_tag="h3" heading_tag_functionality="default" title="What is included with my purchase?"][fancy-ul icon_type="standard_dot" alignment="left" spacing="5px" font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.6"]
<ul>
 	<li>Lorem ipsum dolor sit amet, consectetur.</li>
 	<li> adipiscing elit. Duis ultricies metus .</li>
 	<li>sed turpis pulvinar eleifend. Pellentesque.</li>
 	<li>a tempor turpis, quis congue odio.</li>
 	<li><strong>Aliquam tristique, quam sed vulputate lobortis.</strong></li>
</ul>
[/fancy-ul][/toggle][toggle color="Default" heading_tag="h3" heading_tag_functionality="default" title="How can I get support after purchasing?"][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.6"]Donec orci est, viverra a volutpat vel, tempus non ipsum. Donec pellentesque aliquam pharetra. Maecenas tincidunt molestie enim, quis fringilla nisi laoreet in. Etiam ac nibh eget odio porta laoreet a at dui.[/nectar_responsive_text][/toggle][toggle color="Default" heading_tag="h3" heading_tag_functionality="default" title="Why should I trust ThemeNectar?"][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.6"]Aenean facilisis facilisis nulla, non accumsan mauris gravida faucibus. <strong>Sed commodo laoreet erat</strong>, id elementum ipsum. Aliquam erat volutpat. Nulla ac dignissim elit, sit amet sollicitudin eros. Cras facilisis neque nec dui dignissim congue. Vestibulum ac fringilla lorem. Nulla dignissim mollis consequat.[/nectar_responsive_text][/toggle][/toggles][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );






$data = array();
$data['name'] = esc_html__( 'Project Testimonial', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['portfolio'];
$data['custom_class'] = 'portfolio date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-quote-image.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="10%" bottom_padding="5%" left_padding_desktop="5%" constrain_group_2="yes" right_padding_desktop="5%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="padding-3-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="right" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="7/12" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding_tablet="40" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/weekly?architecture" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="70vh" custom_height_tablet="50vh"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-3-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="left" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="5/12" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="The Outcome" font_size="3vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque ante quam, ultrices nec vulputate et, egestas et quam. Lorem ipsum dolor sit amet, consectetur adipiscing elit." font_size="1.1vw" font_line_height="1.7" font_size_tablet="18" font_size_phone="16"][/split_line_heading][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="Vertical Line" divider_color="black" custom_height="35"][nectar_single_testimonial testimonial_style="basic" image="https://source.unsplash.com/6anudmpILw4" quote="Alex was there every step of the way and brought my vision further than I could have imagined!" name="Josh Margolis" subtitle="Founder of DAF"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Project Header', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['portfolio'];
$data['custom_class'] = 'portfolio date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-project-header.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#566678" bg_image="https://source.unsplash.com/w-tbfMzP8dw" bg_position="center center" background_image_loading="default" bg_repeat="no-repeat" scene_position="center" top_padding="12%" constrain_group_1="yes" bottom_padding="12%" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" top_padding_tablet="25%" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" enable_gradient="true" color_overlay="rgba(10,10,10,0.4)" color_overlay_2="#0a0a0a" advanced_gradient_angle="0" overlay_strength="0.95" gradient_direction="top_to_bottom" shape_divider_position="bottom" bg_image_animation="zoom-out-slow" parallax_bg="true" parallax_bg_speed="fast" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-bottom" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Penn Center" font_size="8vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="1%" constrain_group_1="yes" bottom_padding="1%" left_padding_desktop="25%" constrain_group_2="yes" right_padding_desktop="25%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="300"][divider line_type="Vertical Line" divider_color="white" custom_height="50" custom_height_tablet="25"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="30%" constrain_group_2="yes" right_padding_desktop="30%" left_padding_tablet="15%" constrain_group_4="yes" right_padding_tablet="15%" left_padding_phone="8%" constrain_group_6="yes" right_padding_phone="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque ante quam, ultrices nec vulputate et, egestas et quam. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quisque vestibulum, nunc in finibus condimentum." font_size="1.1vw" font_line_height="1.6" animation_delay="500" animation_offset="100%" font_size_tablet="18" font_size_phone="16"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Company Culture List', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['about'];
$data['custom_class'] = 'general about date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-culture.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" bottom_padding="5%" left_padding_desktop="6%" constrain_group_2="yes" right_padding_desktop="6%" top_padding_tablet="10%" bottom_padding_tablet="20%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" id="values" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-bottom" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Culture" font_size="9vw" font_size_tablet="8vw" font_size_phone="10vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][divider line_type="Full Width Line" line_thickness="1" divider_color="black" animate="yes" custom_height="45"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" column_element_spacing="10px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_col-xs-10"][nectar_highlighted_text color_type="gradient" highlight_color="#9ebee7" secondary_color="#dcf0ff" style="full_text" highlight_expansion="default" custom_font_size="2vw"]
<h2>Innovate each project with <strong><em>no exceptions</em></strong>.</h2>
[/nectar_highlighted_text][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit.[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_col-xs-2"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="letter-reveal-bottom" content_alignment="right" mobile_content_alignment="inherit" link_target="_self" text_content="01" font_size="7vw" font_line_height="1" font_size_phone="46" font_size_tablet="70"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][divider line_type="Full Width Line" line_thickness="1" divider_color="black" animate="yes" custom_height="45"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" column_element_spacing="10px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_col-xs-10"][nectar_highlighted_text color_type="gradient" highlight_color="#9ebee7" secondary_color="#dcf0ff" style="full_text" highlight_expansion="default" custom_font_size="2vw"]
<h2>Always <strong><em>overdeliver</em></strong> to our clients.</h2>
[/nectar_highlighted_text][vc_column_text]Vivamus risus quam, dapibus non libero eu, bibendum.[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_col-xs-2"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="letter-reveal-bottom" content_alignment="right" mobile_content_alignment="inherit" link_target="_self" text_content="02" font_size="7vw" font_line_height="1" font_size_phone="46" font_size_tablet="70"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][divider line_type="Full Width Line" line_thickness="1" divider_color="black" animate="yes" custom_height="45"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" column_element_spacing="10px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_col-xs-10"][nectar_highlighted_text color_type="gradient" highlight_color="#9ebee7" secondary_color="#dcf0ff" style="full_text" highlight_expansion="default" custom_font_size="2vw"]
<h2>Build things that <strong><em>inspire</em></strong> people.</h2>
[/nectar_highlighted_text][vc_column_text]Nam magna dui, venenatis dignissim pharetra.[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_col-xs-2"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="letter-reveal-bottom" content_alignment="right" mobile_content_alignment="inherit" link_target="_self" text_content="03" font_size="7vw" font_line_height="1" font_size_phone="46" font_size_tablet="70"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Parallax Text and Image', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-text-image-3jpg.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" constrain_group_1="yes" bottom_padding="5%" left_padding_desktop="6%" constrain_group_2="yes" right_padding_desktop="6%" top_padding_tablet="10%" constrain_group_3="yes" bottom_padding_tablet="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" id="about" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" bottom_margin_tablet="40" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/DQpUeNzRj6s" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height_tablet="75vh"][/vc_column_inner][vc_column_inner column_padding="padding-6-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="1" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="30vh" custom_height_tablet="0"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Modern Architecture" font_size="3vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo. Lorem ipsum dolor sit amet, consectetur adipiscing elit." font_size="1.1vw" font_line_height="1.7" font_size_tablet="18" font_size_phone="16"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo. Lorem ipsum dolor sit amet, consectetur adipiscing elit." font_size="1.1vw" font_line_height="1.7" font_size_tablet="18" font_size_phone="16"][/split_line_heading][nectar_cta btn_style="arrow-animation" heading_tag="h6" text_color="#000000" button_color="default" button_border_color="#cccccc" button_border_color_hover="#0a0a0a" button_border_thickness="1px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" link_text="Contact Us" margin_top="50" padding_top="15" padding_bottom="15" padding_left="40" padding_right="40"][divider line_type="No Line" custom_height="30vh" custom_height_tablet="0" custom_height_phone="0"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Parallax Team Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general']  . ', ' . $cat_display_names['about'];
$data['custom_class'] = 'general about date-13-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-team.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" bottom_padding="5%" left_padding_desktop="6%" constrain_group_2="yes" right_padding_desktop="6%" top_padding_tablet="10%" constrain_group_3="yes" bottom_padding_tablet="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" id="team" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" sticky_content="true" sticky_content_functionality="css" sticky_content_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Meet The Team" font_size="3vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="We're an award-winning multidisciplinary team based in Philadelphia with a passion for creating innovative architecture. We work with businesses and people to create a more beautiful world." font_size="1.1vw" font_line_height="1.7" font_size_tablet="18" font_size_phone="16"][/split_line_heading][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="Vertical Line" divider_color="black" custom_height="35"][nectar_single_testimonial testimonial_style="basic" image="https://source.unsplash.com/weekly?smile" quote="Alex was there every step of the way and brought my vision further than I could have imagined!" name="Josh Margolis" subtitle="Founder of DAF"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-6-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="30px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="20" top_padding_tablet="40" bottom_padding_tablet="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][team_member image_url="https://source.unsplash.com/iEEBWgY_6lA/600x600" bio_alt_image_url="https://source.unsplash.com/iEEBWgY_6lA/600x600" team_memeber_style="bio_fullscreen_alt" bio_fullscreen_alt_parallax="true" bio_fullscreen_alt_hide_link_arrow="true" image_loading="default" team_member_bio_full_html="html" hide_link_arrow="true" name="Phil Martinez" job_position="CEO, Founder" image_size="regular" social_icon_1="fa fa-instagram" social_link_1="#" social_icon_2="fa fa-twitter" social_link_2="#"]Consectetur adipiscing elit. Etiam id mi faucibus, malesuada quam eget, facilisis turpis. Quisque ac purus erat.

Donec id pharetra tellus, vitae vehicula dolor. Aenean leo lorem, tempor vel mauris in, interdum fringilla erat. Nam auctor sodales dapibus. Ut et nibh sed neque lobortis mollis. Cras mauris tellus, ornare sed vestibulum eu, sagittis vitae justo. Vivamus pellentesque augue in orci commodo dignissim. Fusce id mi lacus.

Nullam ultricies mollis lorem, ac gravida diam pretium eget. Ut porttitor scelerisque lacus, a fringilla felis blandit sed.[/team_member][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][team_member image_url="https://source.unsplash.com/IF9TK5Uy-KI/600x600" bio_alt_image_url="https://source.unsplash.com/IF9TK5Uy-KI/600x600" team_memeber_style="bio_fullscreen_alt" bio_fullscreen_alt_parallax="true" bio_fullscreen_alt_hide_link_arrow="true" image_loading="default" team_member_bio_full_html="html" hide_link_arrow="true" name="Alex Smith" job_position="CFO, Partner" image_size="regular" social_icon_1="fa fa-facebook" social_link_1="#" social_icon_2="fa fa-envelope" social_link_2="#"]Consectetur adipiscing elit. Etiam id mi faucibus, malesuada quam eget, facilisis turpis. Quisque ac purus erat.Donec id pharetra tellus, vitae vehicula dolor. Aenean leo lorem, tempor vel mauris in, interdum fringilla erat.

Nam auctor sodales dapibus. Ut et nibh sed neque lobortis mollis. Cras mauris tellus, ornare sed vestibulum eu, sagittis vitae justo. Vivamus pellentesque augue in orci commodo dignissim. Fusce id mi lacus.

Nullam ultricies mollis lorem, ac gravida diam pretium eget. Ut porttitor scelerisque lacus, a fringilla felis blandit sed.[/team_member][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="30px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all" css=".vc_custom_1634415872169{margin-bottom: 0px !important;}"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][team_member image_url="https://source.unsplash.com/6anudmpILw4/600x600" bio_alt_image_url="https://source.unsplash.com/6anudmpILw4/600x600" team_memeber_style="bio_fullscreen_alt" bio_fullscreen_alt_parallax="true" bio_fullscreen_alt_hide_link_arrow="true" image_loading="default" team_member_bio_full_html="html" hide_link_arrow="true" name="Kara Cohen" job_position="Associate" image_size="regular" social_icon_1="fa fa-facebook" social_link_1="#" social_icon_2="fa fa-instagram" social_link_2="#" social_icon_3="fa fa-github" social_link_3="#"]Quisque elit nisl, varius nec ullamcorper eget, egestas vitae mi. Nam hendrerit eros a sagittis tempus. Mauris hendrerit hendrerit consequat. Nunc eget dui pulvinar, auctor neque sed, convallis ipsum. Fusce sagittis, dui a malesuada ullamcorper, nulla dolor interdum ipsum.

Ac condimentum eros lacus vestibulum nunc. Nunc maximus, massa et dictum dictum, risus massa dignissim nisl, at vestibulum ligula ante id metus. Morbi fringilla rhoncus porta.[/team_member][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][team_member image_url="https://source.unsplash.com/600x600/weekly?smile" bio_alt_image_url="https://source.unsplash.com/600x600/weekly?smile" team_memeber_style="bio_fullscreen_alt" bio_fullscreen_alt_parallax="true" bio_fullscreen_alt_hide_link_arrow="true" image_loading="default" team_member_bio_full_html="html" hide_link_arrow="true" name="Justin Klein" job_position="Office Manager" image_size="regular" social_icon_1="fa fa-instagram" social_link_1="#"]Etiam nulla velit, pharetra vel leo a, pretium rhoncus eros. Fusce eu hendrerit ipsum, vitae volutpat dui. Nunc eget mi tincidunt, luctus turpis at, pharetra diam. Nam sit amet purus cursus, rhoncus nibh nec, volutpat purus. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Vestibulum id iaculis velit, vitae faucibus augue. In quis lectus nisi.[/team_member][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][team_member image_url="https://source.unsplash.com/600x600/weekly?portrait" bio_alt_image_url="https://source.unsplash.com/600x600/weekly?portrait" team_memeber_style="bio_fullscreen_alt" bio_fullscreen_alt_parallax="true" bio_fullscreen_alt_hide_link_arrow="true" image_loading="default" team_member_bio_full_html="html" hide_link_arrow="true" name="Andy Morris" job_position="Designer" image_size="regular" social_icon_1="fa fa-twitter" social_link_1="#" social_icon_2="fa fa-instagram" social_link_2="#"]Etiam nulla velit, pharetra vel leo a, pretium rhoncus eros. Fusce eu hendrerit ipsum, vitae volutpat dui. Nunc eget mi tincidunt, luctus turpis at, pharetra diam. Nam sit amet purus cursus, rhoncus nibh nec, volutpat purus. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Vestibulum id iaculis velit, vitae faucibus augue. In quis lectus nisi.

Quisque elit nisl, varius nec ullamcorper eget, egestas vitae mi. Nam hendrerit eros a sagittis tempus. Mauris hendrerit hendrerit consequat. Nunc eget dui pulvinar, auctor neque sed, convallis ipsum. Fusce sagittis, dui a malesuada ullamcorper, nulla dolor interdum ipsum, ac condimentum eros lacus vestibulum nunc. Nunc maximus, massa et dictum dictum, risus massa dignissim nisl, at vestibulum ligula ante id metus. Morbi fringilla rhoncus porta.[/team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Clean text block', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-text-heading.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="10%" bottom_padding="5%" left_padding_desktop="27%" constrain_group_2="yes" right_padding_desktop="27%" top_padding_tablet="20%" bottom_padding_tablet="10%" left_padding_tablet="20%" constrain_group_4="yes" right_padding_tablet="20%" left_padding_phone="6%" constrain_group_6="yes" right_padding_phone="6%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="20px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" bottom_margin="20" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" animation_offset="80%"][vc_column_text]
<h5>COMPANY</h5>
[/vc_column_text][/vc_column_inner][/vc_row_inner][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="We are a professional architecture firm based in Philadelphia" font_size="4vw" font_size_phone="10vw"][/split_line_heading][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Page Header With Anchor Links', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['about'];
$data['custom_class'] = 'general about date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-about-header.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="8%" bottom_padding="10%" left_padding_desktop="6%" constrain_group_2="yes" right_padding_desktop="6%" top_padding_tablet="20%" top_padding_phone="25%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="100" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="fade-in" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" bottom_margin_tablet="20" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="4/5" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_col-md-9"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-bottom" stagger_animation="true" mobile_disable_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="About Salient" font_size="9vw" font_size_tablet="9vw" font_size_phone="10vw"][/split_line_heading][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="10px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/5" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="500" offset="vc_col-md-3"][nectar_cta btn_style="underline" heading_tag="h6" text_color="#0a0a0a" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inline-block" link_text="Team" url="#team" margin_right="25"][nectar_cta btn_style="underline" heading_tag="h6" text_color="#0a0a0a" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inline-block" link_text="Values" url="#about" margin_right="25"][nectar_cta btn_style="underline" heading_tag="h6" text_color="#0a0a0a" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inline-block" link_text="Culture" url="#values"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" left_padding_desktop="6%" constrain_group_2="yes" right_padding_desktop="6%" top_margin="-5%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/wawEfYdpkag" background_image_position="center bottom" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="600"][divider line_type="No Line" custom_height="100vh" custom_height_tablet="70vh" custom_height_phone="50vh"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );





$data = array();
$data['name'] = esc_html__( 'Parallax Typography Scene', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-typography-scene.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="15%" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="10" overflow="hidden" advanced_gradient="linear-gradient(183deg, rgb(158, 190, 231) 5%, rgb(220,240,255) 90%)" advanced_gradient_angle="183" shape_divider_position="bottom" bg_image_animation="slight-zoom-out-reveal" shape_type="" gradient_type="advanced" advanced_gradient_display_type="linear"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" zindex="10" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_x="-13%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="transform_x" column_parallax_intensity="2.5" persist_movement_on_mobile="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_scrolling_text scroll_direction="ltr" scroll_speed="slower" text_color="#ffffff" style="default" text_repeat_number="3" text_repeat_divider="none" overflow="visible" background_image_animation="None" custom_font_size="10vw" custom_font_size_mobile="11vw"]
<h1>salient architecture</h1>
[/nectar_scrolling_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="transform_x" column_parallax_intensity="-2.5" persist_movement_on_mobile="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_scrolling_text scroll_direction="rtl" scroll_speed="slower" text_color="#ffffff" style="default" text_repeat_number="3" text_repeat_divider="none" overflow="visible" background_image_animation="None" custom_font_size="10vw" custom_font_size_mobile="11vw"]
<h1>salient architecture</h1>
[/nectar_scrolling_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" top_margin="-20vw" top_margin_tablet="-23vw" column_element_spacing="default" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][image_with_animation image_url="https://themenectar.com/img/demo-media/architect/red-building-gPvqQOAOXCw.png" image_size="full" animation_type="entrance" animation="None" hover_animation="none" alignment="center" border_radius="none" box_shadow="none" image_loading="skip-lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Sticky Text Vertical Post Grid', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['portfolio'];
$data['custom_class'] = 'general portfolio date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-portfolio-sticky.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="10%" constrain_group_1="yes" bottom_padding="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="padding-6-percent" column_padding_tablet="padding-5-percent" column_padding_phone="inherit" column_padding_position="left-right" column_element_spacing="default" sticky_content="true" sticky_content_functionality="css" sticky_content_alignment="middle" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="15" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_column_text]
<h5>PORTFOLIO</h5>
[/vc_column_text][/vc_column_inner][/vc_row_inner][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Making the world a more beautiful place." font_size="3vw" max_width="80%"][/split_line_heading][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding_tablet="5%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_cta btn_style="arrow-animation" heading_tag="h6" text_color="#000000" button_color="default" button_border_color="#cccccc" button_border_color_hover="#0a0a0a" button_border_thickness="1px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" link_text="View All Projects" margin_top="30" padding_top="15" padding_bottom="15" padding_left="40" padding_right="40" url="https://themenectar.com/salient/architect/salient-architect-projects/"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="padding-5-percent" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="30px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" pagination="none" columns="1" grid_item_spacing="35px" grid_item_height="60vh" image_size="large" image_loading="default" animation="none" heading_tag="h3" enable_indicator="yes" mouse_indicator_style="default" mouse_indicator_text="view" mouse_indicator_color="#ff5149" display_categories="yes" category_functionality="static" category_position="default" display_excerpt="yes" grid_style="content_under_image" content_under_image_text_align="left" text_color="dark" hover_effect="animated_underline_zoom" border_radius="none" posts_per_page="3" custom_font_size="2vw"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Text with Inline Images', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-13-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-inline-images.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="6%" bottom_padding="12%" left_padding_desktop="27%" constrain_group_2="yes" right_padding_desktop="27%" bottom_padding_tablet="15%" left_padding_tablet="18%" constrain_group_4="yes" right_padding_tablet="18%" left_padding_phone="8%" constrain_group_6="yes" right_padding_phone="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_text_inline_images images="" image_size="nectar_small_square" image_effect="circle_fade_in" image_loading="default" line_reveal_by_space_text_effect="" content_alignment="" font_style="h1" font_size="3vw" font_line_height="1.4" font_size_desktop="3vw" font_size_tablet="4vw" max_width="" font_size_phone="5vw"]
<h2>We're * changing the way <a href="#"><strong>architecture</strong></a> is * built for clients by utilizing Virtual Reality * to provide * immersive previews during our <a href="#"><strong>build process</strong></a>.</h2>
[/nectar_text_inline_images][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Scrolling Text Heading', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-scrolling-text.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" constrain_group_1="yes" bottom_padding="5%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="transform_x" column_parallax_intensity="3.5" persist_movement_on_mobile="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_scrolling_text scroll_direction="ltr" scroll_speed="slowest" text_color="#0a0a0a" style="text_outline" outline_thickness="ultra-thin" text_repeat_number="5" text_repeat_divider="none" overflow="visible" background_image_animation="None" custom_font_size="11vw" custom_font_size_mobile="15vw"]
<h1><em>innovation </em></h1>
[/nectar_scrolling_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Parallax Images and Text Alt', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['about'];
$data['custom_class'] = 'general about date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-images-and-text-2.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="6%" constrain_group_1="yes" bottom_padding="6%" left_padding_tablet="8%" constrain_group_4="yes" right_padding_tablet="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="20%" right_padding_tablet="10%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/wawEfYdpkag" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="90vh" custom_height_tablet="70vh" custom_height_phone="60vh"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_y="-50%" text_align="left" min_width_desktop="40%" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" top_position_desktop="50%" right_position_desktop="0" zindex="50" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/A2kkOnHbemQ" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="x_large_depth" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="2.25" persist_movement_on_mobile="true" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="50vh" custom_height_tablet="40vh" custom_height_phone="35vh"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-8-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="10" top_padding_tablet="7%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_column_text]
<h5>COMMERICAL</h5>
[/vc_column_text][/vc_column_inner][/vc_row_inner][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_color="#000000" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="We create structural beauty by innovating" font_size="3vw"][/split_line_heading][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Aliquam non lectus id purus cursus porta. Nullam vel felis elementum, ornare magna non, feugiat ex. Phasellus erat ligula, laoreet sit amet magna vel, aliquet facilisis libero." font_size="1.1vw" font_line_height="1.7" font_size_tablet="18px" font_size_phone="16px"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="30" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_badge display_tag="label" bg_color_type="custom" bg_color_custom="#efefef" text_color="#1e1c1c" padding="medium" border_radius="20px" display="inline" text="Award Winning" margin_bottom="15" margin_right="15"][nectar_badge display_tag="label" bg_color_type="custom" bg_color_custom="#efefef" text_color="#1e1c1c" padding="medium" border_radius="20px" display="inline" text="Established Team" margin_bottom="15" margin_right="15"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Architect Carousel', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['services'];
$data['custom_class'] = 'general services date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-carousel-1.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="6%" bottom_padding="6%" left_padding_desktop="8%" right_padding_desktop="8%" top_padding_tablet="10%" bottom_padding_tablet="15%" left_padding_tablet="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_color="#000000" shape_divider_position="top" bg_image_animation="none" shape_type="straight_section" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][carousel script="flickity" flickity_formatting="default" desktop_cols_flickity="4" desktop_small_cols_flickity="3" tablet_cols_flickity="2" flickity_controls="touch_total" flickity_touch_total_style="solid_bg" flickity_touch_total_indicator_bg_color="#ff5149" flickity_touch_total_indicator_icon_color="#ffffff" flickity_touch_total_hide_indicator="true" color="default" flickity_overflow="visible" flickity_wrap_around="no-wrap" flickity_spacing="15px" flickity_column_vertical_alignment="default" column_padding="0" flickity_element_spacing="0" flickity_image_scale_on_drag="true" border_radius="none"][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636930600818-5" title="Item" tab_id="1636930600818-9"][fancy_box box_style="image_above_text_underline" image_url="https://source.unsplash.com/DQpUeNzRj6s" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" link_url="" link_screen_reader="Daily anti-aging cream"]
<h4>Perfect Exterior Lines</h4>
Lorem ipsum dolor sit amet, consectetur adipiscing elit.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636930600875-9" title="Item" tab_id="1636930600876-10"][fancy_box box_style="image_above_text_underline" image_url="https://source.unsplash.com/hYb7kbu4x7E" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" delay="100"]
<h4>Square footage optimzation</h4>
Praesent porttitor pharetra sodales. Sed quam elit, congue eget est.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636930600904-0" title="Item" tab_id="1636930600906-2"][fancy_box box_style="image_above_text_underline" image_url="https://source.unsplash.com/UypLIU-gkK8" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" delay="200"]
<h4>Aesthetic layouts</h4>
Vivamus tempor a mauris a consectetur. Duis lorem mauris, feugiat.[/fancy_box][/item][item simple_slider_bg_image_url="https://source.unsplash.com/M6E8SO73MPY" simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636930600937-2" title="Item" tab_id="1636930600938-7"][fancy_box box_style="image_above_text_underline" image_url="https://source.unsplash.com/lQhtkVIiWiE" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" delay="300"]
<h4>Natural light utilization</h4>
interdum accumsan libero. Etiam pretium laoreet tincidunt. Morbi semper quam orci.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636930600970-8" title="Item" tab_id="1636930600971-9"][fancy_box box_style="image_above_text_underline" image_url="https://source.unsplash.com/BILBJXEp6a8" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" delay="400"]
<h4>Precise details in every room</h4>
Praesent a urna non quam commodo scelerisque. Donec iaculis nunc.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636930600999-6" title="Item" tab_id="1636930601000-1"][fancy_box box_style="image_above_text_underline" image_url="https://source.unsplash.com/FVaimgno3dw" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" delay="500"]
<h4>Ultra modern designs</h4>
Donec venenatis faucibus nibh ut tristique. Mauris odio augue, pulvinar quis lacus at.[/fancy_box][/item][/carousel][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Parallax Images and Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['about'];
$data['custom_class'] = 'general about date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-images-and-text-1.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="column_reverse" column_direction_phone="column_reverse" scene_position="center" top_padding="12%" bottom_padding="6%" left_padding_tablet="8%" constrain_group_4="yes" right_padding_tablet="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="padding-8-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="10" top_padding_tablet="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_column_text]
<h5>RESIDENTIAL</h5>
[/vc_column_text][/vc_column_inner][/vc_row_inner][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_color="#000000" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Iconic architecture expertly developed" font_size="3vw"][/split_line_heading][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_tablet="25%" right_padding_phone="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam fringilla est sapien, nec semper neque auctor nec. Duis vehicula quis mi at vehicula. Vivamus at." font_size="1.1vw" font_line_height="1.7" font_size_tablet="18px" font_size_phone="16px"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="50" top_padding_tablet="30" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_col-xs-4"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="default" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="30+" font_size="2.5vw" font_line_height="1" animation_delay="200"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Years of experience" font_size="1.1vw" font_line_height="1.5" animation_delay="300" max_width="60%" font_size_tablet="16px" font_size_phone="13px"][/split_line_heading][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_col-xs-4"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="default" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="10x" font_size="2.5vw" font_line_height="1" animation_delay="200"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Builder of the year" font_size="1.1vw" font_line_height="1.5" max_width="55%" animation_delay="300" font_size_tablet="16px" font_size_phone="13px"][/split_line_heading][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_hidden-sm vc_hidden-xs"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="20%" left_padding_tablet="10%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/m0-OqeKBj5s" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="90vh" custom_height_tablet="70vh" custom_height_phone="60vh"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_y="-50%" text_align="left" min_width_desktop="40%" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" top_position_desktop="50%" left_position_desktop="0" zindex="50" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/FpuhDmLJCcA" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="x_large_depth" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="2.25" persist_movement_on_mobile="true" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="50vh" custom_height_tablet="40vh" custom_height_phone="35vh"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Fullscreen Video Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-13-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-landing-header.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#2b323a" bg_image="https://source.unsplash.com/MGaFENpDCsw" bg_position="left top" background_image_loading="default" bg_repeat="no-repeat" full_height="yes" scene_position="center" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="100" overflow="hidden" color_overlay="rgba(0,0,0,0.78)" advanced_gradient_angle="0" overlay_strength="0.8" gradient_direction="radial" shape_divider_position="bottom" bg_image_animation="fade-in" mobile_disable_bg_image_animation="true" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="13vw" constrain_group_2="yes" right_padding_desktop="13vw" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" zindex="10" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-bottom" stagger_animation="true" mobile_disable_animation="true" content_alignment="left" mobile_content_alignment="inherit" link_target="_self" text_content="Rethink architecture." font_size="9vw" font_line_height="0.95" font_size_tablet="10vw" animation_delay="150"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_y="55%" translate_x="-50%" text_align="left" min_width_desktop="175px" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" bottom_position_desktop="0" left_position_desktop="50%" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="1" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" mobile_disable_animation="true" gradient_type="default" column_link="#section-two" delay="600" animation_offset="100%"][image_with_animation image_url="https://themenectar.com/img/demo-media/spinners/scroll-down-light.png" image_size="full" animation_type="looped" loop_animation="rotate" hover_animation="none" alignment="" border_radius="none" image_loading="skip-lazy-load" max_width="custom" max_width_custom="175"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Minimal Blog Grid', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-news-full.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="175" bottom_padding="3%" top_padding_tablet="25%" top_padding_phone="35%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="straight_section" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-bottom" mobile_disable_animation="true" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="THE" font_size="13vw" font_line_height="0.8" font_size_tablet="13vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-bottom" mobile_disable_animation="true" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="NEWS" font_size="13vw" font_line_height="0.8" animation_delay="150" font_size_tablet="13vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" left_padding_desktop="5%" constrain_group_2="yes" right_padding_desktop="5%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="500" animation_offset="99%"][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" pagination="load-more" button_color="black" columns="3" grid_item_spacing="35px" grid_item_height="50vh" image_size="full" aspect_ratio_image_size="yes" custom_image_aspect_ratio="3-2" image_loading="default" animation="none" heading_tag="default" enable_indicator="yes" mouse_indicator_style="default" mouse_indicator_text="read" mouse_indicator_color="#eddecc" mouse_indicator_text_color="#000000" display_categories="yes" category_functionality="default" category_position="default" display_excerpt="yes" grid_style="content_under_image" content_under_image_text_align="left" text_color="dark" hover_effect="animated_underline_zoom" border_radius="none" shadow_on_hover="yes" custom_font_size="2.8vw" posts_per_page="12"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Parallax Image Gallery With Captions', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-image-gallery.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" enable_animation="true" animation="fade-in" mobile_disable_entrance_animation="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="800"][vc_gallery type="flickity_static_height_style" images="" flickity_spacing="10px" flickity_controls="touch_total_alt" flickity_touch_total_style="solid_bg" flickity_touch_total_indicator_bg_color="#f4ece2" flickity_touch_total_indicator_icon_color="#000000" flickity_overflow="hidden" flickity_wrap_around="wrap" flickity_image_parallax="true" flickity_box_shadow="none" image_loading="default" display_title_caption="true" onclick="link_image" flickity_img_height="70vh" flickity_img_small_desktop_height="70vh" flickity_img_tablet_height="40vh" flickity_img_mobile_height="250px"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Large Animated Header', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-page-heading.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="175" top_padding_tablet="25%" top_padding_phone="35%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="straight_section" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-bottom" mobile_disable_animation="true" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="RESORT" font_size="13vw" font_line_height="0.8" font_size_tablet="13vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-bottom" mobile_disable_animation="true" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="GALLERY" font_size="13vw" font_line_height="0.8" animation_delay="200" font_size_tablet="13vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="3%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="600"][vc_column_text]
<h5>Explore the resort</h5>
[/vc_column_text][divider line_type="Vertical Line" divider_color="black" custom_height="100" custom_height_tablet="60" custom_height_phone="50"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Scrolling Tabbed Rooms', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-vertical-tabbed-2.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="6%" bottom_padding="8%" left_padding_desktop="8%" left_padding_tablet="8%" constrain_group_4="yes" right_padding_tablet="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" enable_animation="true" animation="fade-in" mobile_disable_entrance_animation="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="400"][tabbed_section style="vertical_scrolling" tab_color="Accent-Color" vs_navigation_func="active_link_only" vs_navigation_width="regular" vs_tab_spacing="35%" vs_tab_tag="h2" vs_cta_style="text-reveal-wave" vs_cta_text_color="#0a0a0a" vs_cta_bg_color="accent-color" vs_cta_heading_tag="h5" vs_sticky_aspect="default" vs_font_size="3vw" vs_sub_desc_font_size="1.05vw"][tab icon_family="none" title="Standard selection" id="1636819609648-4" tab_id="1636819609649-0" sub_desc="Get a good night's sleep in our luxurious standard room. Featuring king size beds, walk-in showers and wifi internet."][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/YI2YkyaREHk/1000x1000" background_image_position="center center" enable_bg_scale="true" background_image_loading="skip-lazy-load" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="80vh" custom_height_tablet="50vh"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="12%" left_padding_tablet="10%" constrain_group_4="yes" right_padding_tablet="10%" translate_y="33%" translate_y_tablet="0" text_align="left" min_width_desktop="60%" row_position="absolute" row_position_tablet="relative" row_position_phone="inherit" bottom_position_desktop="0" left_position_desktop="0" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="padding-4-percent" column_padding_phone="inherit" column_padding_position="all" top_margin_tablet="-20%" column_element_spacing="10px" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="1.5" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="From $200/night" font_size="2vw" font_line_height="1" font_size_tablet="3vw" font_size_phone="5vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Junior Studio" font_size="4vw" font_line_height="1" font_size_tablet="6vw" font_size_phone="8vw"][/split_line_heading][divider line_type="No Line" custom_height="15"][fancy-ul icon_type="standard_dot" alignment="left" spacing="5px"]
<ul>
 	<li>Capacity: 2</li>
 	<li>Number of rooms: 30</li>
 	<li>Square Footage: 200</li>
 	<li>Beds: 1 Baths: 1</li>
</ul>
[/fancy-ul][nectar_cta btn_style="text-reveal-wave" heading_tag="h5" text_color="#000000" button_color="accent-color" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" link_text="Reserve Room" padding_top="15" padding_bottom="15" padding_left="35" padding_right="35" margin_top="40"][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="none" title="Rooms with a view" id="1636819609781-9" tab_id="1636819609782-9" sub_desc="We offer highrise rooms to elevate your view of the ocean even further. The perfect romantic getaway spot for couples."][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/RiOhen_OLPs/1000x1000" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="80vh" custom_height_tablet="50vh"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="12%" left_padding_tablet="10%" constrain_group_4="yes" right_padding_tablet="10%" translate_y="33%" translate_y_tablet="0" text_align="left" min_width_desktop="60%" row_position="absolute" row_position_tablet="relative" row_position_phone="inherit" bottom_position_desktop="0" right_position_desktop="0" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="padding-4-percent" column_padding_phone="inherit" column_padding_position="all" top_margin_tablet="-20%" column_element_spacing="10px" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="1.5" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="From $350/night" font_size="2vw" font_line_height="1" font_size_tablet="3vw" font_size_phone="5vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Highrise Suite" font_size="4vw" font_line_height="1" font_size_tablet="6vw" font_size_phone="8vw"][/split_line_heading][divider line_type="No Line" custom_height="15"][fancy-ul icon_type="standard_dot" alignment="left" spacing="5px"]
<ul>
 	<li>Capacity: 4</li>
 	<li>Number of rooms: 15</li>
 	<li>Square Footage: 350</li>
 	<li>Beds: 2 Baths: 2</li>
</ul>
[/fancy-ul][nectar_cta btn_style="text-reveal-wave" heading_tag="h5" text_color="#000000" button_color="accent-color" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" link_text="Reserve Room" padding_top="15" padding_bottom="15" padding_left="35" padding_right="35" margin_top="40"][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="none" title="For large groups" id="1636819609866-2" tab_id="1636819609867-8" sub_desc="Leave all of your troubles behind and enjoy the ultimate escape in our deluxe cabins, perfect for the vacationing family."][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/w-oF_ChTNNQ/1000x1000" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="80vh" custom_height_tablet="50vh"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="12%" left_padding_tablet="10%" constrain_group_4="yes" right_padding_tablet="10%" translate_y="33%" translate_y_tablet="0" text_align="left" min_width_desktop="60%" row_position="absolute" row_position_tablet="relative" row_position_phone="inherit" bottom_position_desktop="0" left_position_desktop="0" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="padding-4-percent" column_padding_phone="inherit" column_padding_position="all" top_margin_tablet="-20%" column_element_spacing="10px" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="1.5" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="From $750/night" font_size="2vw" font_line_height="1" font_size_tablet="3vw" font_size_phone="5vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Deluxe Villa" font_size="4vw" font_line_height="1" font_size_tablet="6vw" font_size_phone="8vw"][/split_line_heading][divider line_type="No Line" custom_height="15"][fancy-ul icon_type="standard_dot" alignment="left" spacing="5px"]
<ul>
 	<li>Capacity: 8</li>
 	<li>Number of rooms: 20</li>
 	<li>Square Footage: 800</li>
 	<li>Beds: 4 Baths: 3</li>
</ul>
[/fancy-ul][nectar_cta btn_style="text-reveal-wave" heading_tag="h5" text_color="#000000" button_color="accent-color" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" link_text="Reserve Room" padding_top="15" padding_bottom="15" padding_left="35" padding_right="35" margin_top="40"][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="none" title="Exclusive experience" id="1636819609960-0" tab_id="1636819609961-0" sub_desc="A once in a lifetime experience awaits you. Stay on the water in one of our exclusive bungalows hundreds of feet out on the ocean"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/NfFDxzd8IOo/1000x1000" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="80vh" custom_height_tablet="50vh"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="12%" left_padding_tablet="10%" constrain_group_4="yes" right_padding_tablet="10%" translate_y="33%" translate_y_tablet="0" text_align="left" min_width_desktop="60%" row_position="absolute" row_position_tablet="relative" row_position_phone="inherit" bottom_position_desktop="0" right_position_desktop="0" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="padding-4-percent" column_padding_phone="inherit" column_padding_position="all" top_margin_tablet="-20%" column_element_spacing="10px" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="1.5" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="From $1000/night" font_size="2vw" font_line_height="1" font_size_tablet="3vw" font_size_phone="5vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Water Bungalow" font_size="4vw" font_line_height="1" font_size_tablet="6vw" font_size_phone="8vw"][/split_line_heading][divider line_type="No Line" custom_height="15"][fancy-ul icon_type="standard_dot" alignment="left" spacing="5px"]
<ul>
 	<li>Capacity: 4</li>
 	<li>Number of rooms: 12</li>
 	<li>Square Footage: 550</li>
 	<li>Beds: 2 Baths: 2</li>
</ul>
[/fancy-ul][nectar_cta btn_style="text-reveal-wave" heading_tag="h5" text_color="#000000" button_color="accent-color" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" link_text="Reserve Room" padding_top="15" padding_bottom="15" padding_left="35" padding_right="35" margin_top="40"][/vc_column_inner][/vc_row_inner][/tab][/tabbed_section][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Light Footer', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-footer.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#f4ece2" scene_position="center" top_padding="6%" constrain_group_1="yes" bottom_padding="6%" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" top_padding_tablet="12%" constrain_group_3="yes" bottom_padding_tablet="12%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" enable_shape_divider="true" shape_divider_color="rgba(0,0,0,0.1)" shape_divider_position="both" shape_divider_height="1" bg_image_animation="none" shape_type="straight_section" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="center" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="advanced" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="40%" bottom_padding_tablet="10%" left_padding_phone="10%" constrain_group_6="yes" right_padding_phone="10%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="10px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_column_text]
<h4>Do you believe in magic?</h4>
[/vc_column_text][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" font_size="1.05vw" font_line_height="1.6" text_content="This entire website was built with Salient, a creative next-generation WordPress theme." font_size_tablet="16"][/split_line_heading][nectar_cta btn_style="text-reveal-wave" heading_tag="h5" text_color="#000000" button_color="accent-color" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" link_text="I don't believe it" margin_top="35" padding_top="15" padding_bottom="15" padding_left="35" padding_right="35"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="center" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="50px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="padding-5-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left" bottom_margin_phone="40" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="150"][vc_column_text css=".vc_custom_1636697193664{margin-bottom: 10px !important;}"]
<h4>Address</h4>
[/vc_column_text][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" font_size="1.05vw" font_line_height="1.6" text_content="The Castle" font_size_tablet="16"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" font_size="1.05vw" font_line_height="1.6" text_content="345 2500 Castle Dr." font_size_tablet="16"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" font_size="1.05vw" font_line_height="1.6" text_content="Port Douglas, Queensland" font_size_tablet="16"][/split_line_heading][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" bottom_margin_tablet="0" bottom_margin_phone="0" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="300"][vc_column_text css=".vc_custom_1636697263705{margin-bottom: 10px !important;}"]
<h4>Connect</h4>
[/vc_column_text][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" font_size="1.05vw" font_line_height="1.6" text_content="T: +216 (0)40 3629 4753" font_size_tablet="16"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" font_size="1.05vw" font_line_height="1.6" text_content="E: hello@themenectar.com" font_size_tablet="16"][/split_line_heading][vc_column_text] [/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#f4ece2" scene_position="center" top_padding="28" constrain_group_1="yes" bottom_padding="28" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" top_padding_tablet="6%" constrain_group_3="yes" bottom_padding_tablet="6%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="center" phone_text_alignment="center" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" animation_offset="101%"][vc_column_text]<b>© </b>[nectar_current_year] Salient Hotel[/vc_column_text][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="center" phone_text_alignment="center" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" animation_offset="101%"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding_tablet="10" text_align="right" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_cta btn_style="underline" heading_tag="p" button_color="default" button_border_thickness="0px" link_type="regular" alignment="right" alignment_tablet="center" alignment_phone="default" constrain_group_4="yes" display="inline" link_text="Terms &amp; Conditions" padding_left="25" padding_right="25"][nectar_cta btn_style="underline" heading_tag="p" button_color="default" button_border_thickness="0px" link_type="regular" alignment="right" alignment_tablet="center" alignment_phone="default" constrain_group_4="yes" display="inline" link_text="Privacy Policy" padding_left="25" padding_right="25"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Cropped Parallax CTA', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['cta'];
$data['custom_class'] = 'cta date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-cta.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="10%" top_padding_tablet="15%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="advanced" advanced_gradient_display_type="linear"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="3%" left_padding_desktop="30%" constrain_group_2="yes" right_padding_desktop="30%" bottom_padding_tablet="6%" left_padding_tablet="13%" constrain_group_4="yes" right_padding_tablet="13%" left_padding_phone="11%" constrain_group_6="yes" right_padding_phone="11%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_column_text]
<h5>RESERVATIONS</h5>
[/vc_column_text][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="It's time for that vacation" font_line_height="1" max_width="58%" font_size="4vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" bottom_padding="10%" bottom_padding_tablet="15%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="advanced" advanced_gradient_display_type="linear"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" translate_y="-50%" translate_x="-50%" text_align="left" min_width_desktop="100%" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" top_position_desktop="50%" left_position_desktop="50%" zindex="200" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="2" persist_movement_on_mobile="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-top" stagger_animation="true" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" link_indicator="true" link_indicator_bg_color="#f4ece2" link_indicator_icon_color="#000000" text_content="BOOK NOW" font_size="13vw" link_href="http://google.com" font_line_height="0.9" font_size_tablet="14vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="34%" constrain_group_2="yes" right_padding_desktop="34%" left_padding_tablet="30%" constrain_group_4="yes" right_padding_tablet="30%" left_padding_phone="27%" constrain_group_6="yes" right_padding_phone="27%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/S5uV7ro4UPY" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" video_mp4="" background_video_loading="lazy-load" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="radial" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="75vh" custom_height_tablet="45vh"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Full Width Layered Parallax Blocks', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['services'];
$data['custom_class'] = 'services date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-split-parallax.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#7a95a8" scene_position="center" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="5px" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/dvF6s1H1x68" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" enable_gradient="true" color_overlay="rgba(0,0,0,0.62)" advanced_gradient_angle="0" gradient_direction="radial" overlay_strength="0.5" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="35vh" custom_height_phone="150"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="Weddings" font_size="3vw"][/split_line_heading][nectar_cta btn_style="underline" heading_tag="span" text_color="#ffffff" button_color="default" button_border_thickness="0px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" display="block" link_text="Learn More" url="#"][/vc_column_inner][/vc_row_inner][divider line_type="No Line" custom_height="35vh" custom_height_phone="150"][/vc_column][vc_column column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="5px" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/FDV1BaKNKEo" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" enable_gradient="true" color_overlay="rgba(0,0,0,0.72)" color_overlay_2="rgba(0,0,0,0.24)" advanced_gradient_angle="0" gradient_direction="radial" overlay_strength="0.5" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="35vh" custom_height_phone="150"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="200"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="Conferences" font_size="3vw"][/split_line_heading][nectar_cta btn_style="underline" heading_tag="span" text_color="#ffffff" button_color="default" button_border_thickness="0px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" display="block" link_text="Learn More" url="#"][/vc_column_inner][/vc_row_inner][divider line_type="No Line" custom_height="35vh" custom_height_phone="150"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Featured Recent Posts List', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-news.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="6%" bottom_padding="5%" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" top_padding_tablet="15%" constrain_group_9="yes" constrain_group_10="yes" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" sticky_content="true" sticky_content_functionality="css" sticky_content_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" tablet_text_alignment="center" phone_text_alignment="center" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_tablet="10%" constrain_group_4="yes" right_padding_tablet="10%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h3" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="left" mobile_content_alignment="center" link_target="_self" text_content="Read the latest news" font_size="4vw" font_line_height="0.9" max_width="75%"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="20" right_padding_desktop="15%" top_padding_tablet="0" left_padding_tablet="10%" constrain_group_4="yes" right_padding_tablet="10%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_hidden-sm vc_hidden-xs"][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Track events, lean about activities and get vacation tips for your stay with us." font_size="1.05vw" font_line_height="1.6" font_size_tablet="16"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-6-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" pagination="none" ignore_sticky_posts="yes" grid_item_spacing="40px" image_size="portfolio-thumb_large" image_loading="default" animation="fade-in-from-bottom" heading_tag="h4" grid_style="vertical_list" vertical_list_hover_effect="slight_move" vertical_list_border_color="rgba(0,0,0,0.35)" vertical_list_read_more="yes" vertical_list_counter="yes" text_color="dark" posts_per_page="4"][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner content_placement="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="transform_x" column_parallax_intensity="3.5" persist_movement_on_mobile="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_scrolling_text scroll_direction="ltr" scroll_speed="slowest" text_color="#000000" style="text_outline" outline_thickness="ultra-thin" text_repeat_number="4" text_repeat_divider="space" overflow="visible" background_image_animation="None" custom_font_size="13vw" custom_font_size_mobile="20vw"]
<h1><em>PRIVATE EVENTS</em></h1>
[/nectar_scrolling_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Fancy Box Parallax Carousel', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['services'];
$data['custom_class'] = 'services date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-parallax-carousel.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="6%" constrain_group_1="yes" bottom_padding="6%" left_padding_desktop="8%" right_padding_desktop="8%" top_padding_tablet="15%" constrain_group_3="yes" bottom_padding_tablet="15%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" id="impact" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="top" shape_divider_height="50%" bg_image_animation="none" shape_type="straight_section" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="15" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_column_text]
<h5>ACTIVITIES</h5>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="3%" right_padding_desktop="70%" bottom_padding_tablet="6%" right_padding_tablet="40%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h3" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="The adventure starts now" font_size="4vw" font_line_height="0.9"][/split_line_heading][/vc_column_inner][/vc_row_inner][carousel script="flickity" flickity_formatting="default" desktop_cols_flickity="3" desktop_small_cols_flickity="2" tablet_cols_flickity="2" flickity_controls="touch_total" flickity_touch_total_style="solid_bg" flickity_touch_total_indicator_bg_color="#f4ece2" flickity_touch_total_indicator_icon_color="#000000" flickity_touch_total_hide_indicator="true" color="default" flickity_overflow="visible" flickity_wrap_around="no-wrap" flickity_spacing="10px" flickity_centered_cells="true" flickity_column_vertical_alignment="bottom" column_padding="0" flickity_element_spacing="0" border_radius="none"][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636816204207-0" title="Item" tab_id="1636816204207-0"][fancy_box box_style="hover_desc" icon_family="iconsmind" image_url="https://source.unsplash.com/UyTfzNdLHzs" hover_color="accent-color" hover_color_custom="#000000" hover_desc_color_opacity="0.9" hover_desc_hover_overlay_opacity="0.4" disable_hover_movement="true" bg_parallax="true" icon_position="top" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="75vh" icon_iconsmind="iconsmind-Golf" min_height_tablet="550"]
<h4>Premier Golf Course</h4>
A true test of the champion; Test your skills at our full 18-hole immaculate course overlooking the ocean.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636816204244-9" title="Item" tab_id="1636816204245-9"][fancy_box box_style="hover_desc" icon_family="iconsmind" image_url="https://source.unsplash.com/eoR0Ou7js5E" hover_color="accent-color" hover_color_custom="#0a0202" hover_desc_color_opacity="0.9" hover_desc_hover_overlay_opacity="0.4" disable_hover_movement="true" bg_parallax="true" icon_position="top" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="75vh" icon_iconsmind="iconsmind-Leafs" min_height_tablet="550"]
<h4>Relaxing Wellness Spa</h4>
Another layer of relaxation awaits you on your vacation. Featuring massages, a hair salon, and nail studio.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636816204265-8" title="Item" tab_id="1636816204266-1"][fancy_box box_style="hover_desc" icon_family="iconsmind" image_url="https://source.unsplash.com/8cQpL8kGqso" hover_color="accent-color" hover_color_custom="#000000" hover_desc_color_opacity="0.9" hover_desc_hover_overlay_opacity="0.4" disable_hover_movement="true" bg_parallax="true" icon_position="top" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="75vh" icon_iconsmind="iconsmind-Snorkel" min_height_tablet="550"]
<h4>Scuba Diving &amp; Snorkeling</h4>
Explore the crystal clear waters from down under with our scuba excursion.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636816204294-1" title="Item" tab_id="1636816204295-5"][fancy_box box_style="hover_desc" icon_family="iconsmind" image_url="https://source.unsplash.com/evDuzZd8Kc0" hover_color="extra-color-1" hover_color_custom="#000000" hover_desc_color_opacity="0.9" hover_desc_hover_overlay_opacity="0.4" disable_hover_movement="true" bg_parallax="true" icon_position="top" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="75vh" icon_iconsmind="iconsmind-Jeep" min_height_tablet="550"]
<h4>Premium Wildlife Tours</h4>
Expertly guided scenic and tours of the land available in group UTV sessions.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636816204322-6" title="Item" tab_id="1636816204323-10"][fancy_box box_style="hover_desc" icon_family="iconsmind" image_url="https://source.unsplash.com/mfzdRsWsiRA" hover_color="extra-color-1" hover_color_custom="#000000" hover_desc_color_opacity="0.9" hover_desc_hover_overlay_opacity="0.4" disable_hover_movement="true" bg_parallax="true" icon_position="top" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="75vh" icon_iconsmind="iconsmind-Wave" min_height_tablet="550"]
<h4>Professional Surf Lessons</h4>
Get another item off your bucket list and immerse yourself in the swell with our instructors.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636816204348-2" title="Item" tab_id="1636816204349-3"][fancy_box box_style="hover_desc" icon_family="iconsmind" image_url="https://source.unsplash.com/qjrjJnFypa0" hover_color="accent-color" hover_color_custom="#0a0202" hover_desc_color_opacity="0.9" hover_desc_hover_overlay_opacity="0.4" disable_hover_movement="true" bg_parallax="true" icon_position="top" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="75vh" icon_iconsmind="iconsmind-Tennis" min_height_tablet="550"]
<h4>Clay Tennis Courts</h4>
Professional-quality tennis courts that are available to you all year round. Classes and lessons are also available.[/fancy_box][/item][/carousel][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Images and Parallax Text Column', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['about'];
$data['custom_class'] = 'general about date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-parallax-text.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="14%" left_padding_desktop="8%" right_padding_desktop="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient="radial-gradient(circle at top right, rgb(255,200,129) 0%, rgba(243,243,243,0) 41%)" advanced_gradient_radial_position="top right" shape_divider_position="bottom" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" gradient_type="advanced" shape_type="" advanced_gradient_display_type="radial"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="radial" overlay_strength="0.5" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_y="-50%" translate_x="50%" text_align="left" min_width_desktop="175" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" top_position_desktop="0" right_position_desktop="0" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_hidden-sm vc_hidden-xs"][image_with_animation image_url="http://themenectar.com/img/demo-media/spinners/ocean-views.png" image_size="full" animation_type="looped" loop_animation="rotate" hover_animation="none" alignment="" border_radius="none" image_loading="skip-lazy-load" max_width="custom" el_class="dark-filter" max_width_custom="175"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding_tablet="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/1kfMQlkQhuw" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="radial" overlay_strength="0.5" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="90vh" custom_height_tablet="450"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-14-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="1.75" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="10vh" bottom_padding="15" top_padding_tablet="0" top_padding_phone="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_column_text]
<h5>Excellence</h5>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h3" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Where forest meets ocean" font_size="4vw" font_line_height="0.9" max_width="85%"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="4%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Nestled right in the middle of a natural juxtaposition. Salient is more than a resort; it's an unforgettable experience for you and your whole family." font_size="1.05vw" font_line_height="1.6" font_size_tablet="16"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="4%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="Vertical Line" divider_color="black" custom_height="34"][split_line_heading animation_type="line-reveal-by-space" font_style="i" line_reveal_by_space_text_effect="none" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="The best of both worlds; Refreshing greenery with scenic ocean views." font_line_height="1.3" max_width="70%" font_size="1.45vw" font_size_tablet="22px"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/3oTWRtEElPk" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="65vh" custom_height_tablet="350"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Image Slider with Static Text Overlaid', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['about'];
$data['custom_class'] = 'general about date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-slider-carousel.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" constrain_group_9="yes" constrain_group_10="yes" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient="linear-gradient(125deg, rgb(122, 149, 168) 15%, rgb(122, 149, 168) 15%)" advanced_gradient_angle="125" shape_divider_color="#f0ece5" shape_divider_position="bottom" shape_divider_height="33%" bg_image_animation="none" shape_type="straight_section" gradient_type="advanced" advanced_gradient_display_type="linear"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="35%" constrain_group_2="yes" right_padding_desktop="35%" left_padding_tablet="25%" constrain_group_4="yes" right_padding_tablet="25%" left_padding_phone="12%" constrain_group_6="yes" right_padding_phone="12%" translate_y="-50%" translate_x="-50%" text_align="left" min_width_desktop="100%" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" top_position_desktop="50%" left_position_desktop="50%" zindex="100" overflow="visible" pointer_events="none"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_icon icon_family="linea" enable_animation="true" animation_speed="medium" icon_style="default" icon_color_type="custom" icon_color_custom="#f4ece2" icon_padding="15px" icon_linea="icon-basic-compass"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_color="#f4ece2" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="Stunning views, outstanding service, and michelin star dining." font_size="3vw" font_size_tablet="5vw" font_line_height="1.3" font_size_phone="38px"][/split_line_heading][/vc_column_inner][/vc_row_inner][carousel script="simple_slider" simple_slider_sizing="aspect_ratio" simple_slider_aspect_ratio="2-1" simple_slider_pagination_controls="true" simple_slider_pagination_coloring="light" simple_slider_pagination_alignment="default" simple_slider_touch_indicator="true" simple_slider_touch_indicator_bg_color="#f4ece2" simple_slider_touch_indicator_icon_color="#000000" simple_slider_transition_type="slide" simple_slider_parallax="true" simple_slider_wrap="true" simple_slider_min_height="450"][item simple_slider_bg_image_url="https://source.unsplash.com/ecf_KoK1Gwo" simple_slider_bg_image_position="center-top" simple_slider_font_color="#ffffff" simple_slider_color_overlay="rgba(0,0,0,0.74)" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" simple_slider_gradient_direction="left_to_right" bg_image_url="" bg_image_position="default" image_url="" id="1636774480591-9" title="Item" tab_id="1636774480592-0"][vc_column_text][/vc_column_text][/item][item simple_slider_bg_image_url="https://source.unsplash.com/WymR2nYtj5M/1600x1000" simple_slider_bg_image_position="center-bottom" simple_slider_font_color="#ffffff" simple_slider_color_overlay="rgba(10,10,10,0.5)" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" simple_slider_gradient_direction="left_to_right" bg_image_url="" bg_image_position="default" image_url="" id="1636774480618-8" title="Item" tab_id="1636774480619-4"][vc_column_text][/vc_column_text][/item][item simple_slider_bg_image_url="https://source.unsplash.com/V4I401OEEhQ/1600x1000" simple_slider_bg_image_position="center-bottom" simple_slider_font_color="#ffffff" simple_slider_color_overlay="rgba(0,0,0,0.78)" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" simple_slider_gradient_direction="left_to_right" bg_image_url="" bg_image_position="default" image_url="" id="1636774480643-1" title="Item" tab_id="1636774480643-2"][vc_column_text][/vc_column_text][/item][/carousel][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Scrolling Tabbed Images', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-vertical-tabbed.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="6%" bottom_padding="12%" left_padding_desktop="8%" right_padding_tablet="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][tabbed_section style="vertical_scrolling" tab_color="Accent-Color" vs_navigation_func="active_link_only" vs_navigation_width="wide" vs_tab_spacing="20px" vs_tab_tag="h2" vs_enable_cta="true" vs_cta_style="text-reveal-wave" vs_cta_text_color="#0a0a0a" vs_cta_bg_color="accent-color" vs_cta_heading_tag="h5" constrain_group_1="yes" constrain_group_2="yes" vs_sticky_aspect="default" vs_cta_text="View All Accommodations" vs_cta_padding_top="15" vs_cta_padding_bottom="15" vs_cta_padding_left="25" vs_cta_padding_right="25" vs_font_size="4vw" vs_sub_desc_font_size="1.05vw"][tab icon_family="none" title="Single Suites" id="1636774480206-0" tab_id="1636774480207-0" sub_desc="Bohemian-inspired interiors with breathtaking views of the ocean from one side, and lushes greenery from the other. Ranges from 200 - 300 sqft."][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/RiOhen_OLPs/1000x1000"  background_image_position="center bottom" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="90vh" custom_height_tablet="50vh"][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="none" title="Private Cabins" id="1636774480315-8" tab_id="1636774480317-5" sub_desc="Leave all of your troubles behind and enjoy the ultimate escape in our deluxe cabins, perfect for the vacationing family. Ranges from 400 - 600 sqft."][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/w-oF_ChTNNQ/1000x1000" background_image_position="center bottom" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="90vh" custom_height_tablet="50vh"][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="none" title="Ocean Villas" id="1636774480370-4" tab_id="1636774480370-3" sub_desc="A once in a lifetime experience awaits you. Stay on the water in one of our exclusive bungalows hundreds of feet out on the ocean. Ranges from 300 - 500 sqft."][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/NfFDxzd8IOo/1000x1000" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="90vh" custom_height_tablet="50vh"][/vc_column_inner][/vc_row_inner][/tab][/tabbed_section][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Text With Inline Images', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-text-with-images.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="6%" constrain_group_1="yes" bottom_padding="6%" left_padding_desktop="16%" constrain_group_2="yes" right_padding_desktop="16%" left_padding_phone="8%" constrain_group_6="yes" right_padding_phone="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_text_inline_images images="" image_size="medium" image_effect="circle_reveal" image_effect_rm_mobile="yes" image_loading="skip-lazy-load" line_reveal_by_space_text_effect="default" content_alignment="default" font_size="3vw" font_size_desktop="6vw" font_line_height="1.3" font_size_tablet="6vw" font_size_phone="8vw"]
<h2>An * enchanting new resort nestled on the coast of  Queensland *</h2>
[/nectar_text_inline_images][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Landing Hero Video', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-landing-video.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="80" bottom_padding="6%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="straight_section" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" translate_y="26%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" zindex="200" overflow="visible" pointer_events="none"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="1" persist_movement_on_mobile="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" text_color="#0a0909" line_reveal_by_space_text_effect="letter-reveal-bottom" mobile_disable_animation="true" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="YOUR" font_size="13vw" font_line_height="0.8" font_size_tablet="13vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="h1" text_color="#0a0808" line_reveal_by_space_text_effect="letter-reveal-bottom" mobile_disable_animation="true" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="PARADISE" font_size="13vw" font_line_height="0.8" font_size_tablet="13vw" animation_delay="200"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" zindex="1" overflow="hidden" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" delay="550" gradient_type="default"][nectar_video_player_self_hosted video_mp4="" video_image="https://source.unsplash.com/5dZCBY9uFu0/" el_aspect="235" el_aspect_tablet="169" rm_on_mobile="true" player_functionality="lightbox" play_button_style="follow_mouse" play_button_color="#f4ece2" play_button_icon_color="#122120" border_radius="none" box_shadow="none" advanced_gradient="linear-gradient(180deg, rgba(244,236,226,0.22) 5%, rgba(255,255,255,0) 85%)" advanced_gradient_angle="180" video_lightbox_url="https://vimeo.com/118023315" advanced_gradient_display_type="linear"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Soft Footer With CTA', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general']. ', ' . $cat_display_names['cta'];
$data['custom_class'] = 'general cta date-22-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-footer-3.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#c498d9" scene_position="center" top_padding="10%" bottom_padding="5%" top_padding_tablet="20%" bottom_padding_tablet="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="20%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" text_content="Don't wait any longer, take control of your skin today" font_size="8vh"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="15" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" offset="vc_col-md-6"][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt" font_container="tag:p|font_size:18|text_align:left|line_height:1.8" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" offset="vc_col-md-6"][nectar_cta btn_style="see-through" heading_tag="h6" text_color="#ffffff" button_color="black" link_type="regular" alignment="right" alignment_tablet="default" alignment_phone="left" constrain_group_1="yes" constrain_group_3="yes" constrain_group_4="yes" display="block" link_text="Shop Now" padding_top="20" padding_bottom="20" padding_left="50" padding_right="50" url="http://themenectar.com/promo" margin_top="20" margin_bottom="20"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#c498d9" scene_position="center" top_padding="5%" bottom_padding="10%" top_padding_tablet="10%" bottom_padding_tablet="20%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" enable_shape_divider="true" shape_divider_color="#0a0a0a" shape_divider_position="top" shape_divider_height="1" bg_image_animation="none" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="advanced" column_border_style="solid"][vc_row_inner equal_height="yes" content_placement="top" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" offset="vc_col-md-6"][vc_column_text]
<h5>Contact Us</h5>
[/vc_column_text][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" link_text="+216 (0)40 3629 4753"][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" link_text="hello@domain.com"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" offset="vc_col-md-6"][vc_column_text]
<h5>Connect</h5>
[/vc_column_text][nectar_cta btn_style="underline" heading_tag="h6" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="inline" link_text="Instagram" margin_right="30" margin_bottom="10"][nectar_cta btn_style="underline" heading_tag="h6" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="inline" link_text="FaceBook" padding_right="30" margin_bottom="10"][nectar_cta btn_style="underline" heading_tag="h6" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="inline" link_text="Twitter" padding_right="25" margin_bottom="10"][nectar_cta btn_style="underline" heading_tag="h6" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="inline" link_text="YouTube" padding_right="25" margin_bottom="10"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Dark Footer With CTA', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general']. ', ' . $cat_display_names['cta'];
$data['custom_class'] = 'general cta date-22-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-footer-2.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#000000" scene_position="center" top_padding="10%" bottom_padding="5%" top_padding_tablet="20%" bottom_padding_tablet="10%" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="20%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" text_content="Don't wait any longer, take control of your skin today" font_size="8vh"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="15" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" offset="vc_col-md-6"][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt" font_container="tag:p|font_size:18|text_align:left|line_height:1.8" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" offset="vc_col-md-6"][nectar_cta btn_style="see-through" heading_tag="h6" button_color="accent-color" link_type="regular" alignment="right" alignment_tablet="default" alignment_phone="left" constrain_group_1="yes" constrain_group_3="yes" constrain_group_4="yes" display="block" link_text="Shop Now" padding_top="20" padding_bottom="20" padding_left="50" padding_right="50" url="http://themenectar.com/promo" margin_top="20" margin_bottom="20"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#000000" scene_position="center" top_padding="5%" bottom_padding="10%" top_padding_tablet="10%" bottom_padding_tablet="20%" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" enable_shape_divider="true" shape_divider_color="#5b5b5b" shape_divider_position="top" shape_divider_height="1" bg_image_animation="none" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="advanced" column_border_style="solid"][vc_row_inner equal_height="yes" content_placement="top" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" offset="vc_col-md-6"][vc_column_text]
<h5>Contact Us</h5>
[/vc_column_text][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" link_text="+216 (0)40 3629 4753"][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" link_text="hello@domain.com"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" offset="vc_col-md-6"][vc_column_text]
<h5>Connect</h5>
[/vc_column_text][nectar_cta btn_style="underline" heading_tag="h6" text_color="#ffffff" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="inline" link_text="Instagram" margin_right="30" margin_bottom="10"][nectar_cta btn_style="underline" heading_tag="h6" text_color="#ffffff" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="inline" link_text="FaceBook" padding_right="30" margin_bottom="10"][nectar_cta btn_style="underline" heading_tag="h6" text_color="#ffffff" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="inline" link_text="Twitter" padding_right="25" margin_bottom="10"][nectar_cta btn_style="underline" heading_tag="h6" text_color="#ffffff" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="inline" link_text="YouTube" padding_right="25" margin_bottom="10"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );





$data = array();
$data['name'] = esc_html__( 'WooCommerce Overflowing Product Carousel', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['shop'];
$data['custom_class'] = 'shop date-22-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-product-carousel.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_woo_products product_type="all" category="all" columns="4" flickity_mobile_column_width="100%" orderby="date" order="DESC" carousel="1" script="flickity" flickity_wrap="no-wrap" flickity_overflow="visible" flickity_controls="touch_indicator" flickity_image_scale_on_drag="true" flickity_item_animation="fade-in-side" per_page="8"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Minimal Full Width Grid Columns', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['services'];
$data['custom_class'] = 'general services date-23-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-three-col-text-img.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="advanced" border_bottom_desktop="1" column_border_color="#919ec6" column_border_style="solid"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in" border_type="advanced" border_bottom_desktop="1" column_border_color="#919ec6" column_border_style="solid" offset="vc_col-xs-7"][nectar_highlighted_text color_type="regular" highlight_color="#ff7530" text_color="#000000" style="full_text" highlight_expansion="default" custom_font_size="4vw"]
<h2>How your skin was <em>meant to be</em>.</h2>
[/nectar_highlighted_text][/vc_column_inner][vc_column_inner column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in" border_type="advanced" border_bottom_desktop="1" column_border_color="#919ec6" column_border_style="solid" offset="vc_col-xs-5"][vc_column_text max_width="300"]
<h5>A new way to replenish skin tone and texture.</h5>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1616207860454{margin-bottom: 30px !important;}"]
<h3>Glowing</h3>
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore.[/vc_column_text][image_with_animation image_url="https://source.unsplash.com/collection/49597329/600x800/weekly" animation="None" hover_animation="zoom-crop" alignment="" img_link_large="yes" border_radius="none" box_shadow="x_large_depth" image_loading="default" max_width="100%" max_width_mobile="default"][/vc_column_inner][vc_column_inner column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in" border_type="advanced" border_left_desktop="1" border_right_desktop="1" column_border_color="#919ec6" column_border_style="solid" delay="150"][vc_column_text css=".vc_custom_1616207874149{margin-bottom: 30px !important;}"]
<h3>Resilient</h3>
Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.[/vc_column_text][image_with_animation image_url="https://source.unsplash.com/collection/86446855/600x800/weekly" animation="None" hover_animation="zoom-crop" alignment="" img_link_large="yes" border_radius="none" box_shadow="x_large_depth" image_loading="default" max_width="100%" max_width_mobile="default"][/vc_column_inner][vc_column_inner column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in" border_type="simple" column_border_width="none" column_border_style="solid" delay="300"][vc_column_text css=".vc_custom_1616207884304{margin-bottom: 30px !important;}"]
<h3>Smooth</h3>
nostrud exercitation ullamco laboris nisi ut sunt in culpa qui officia deserunt mollit anim id est laborum.[/vc_column_text][image_with_animation image_url="https://source.unsplash.com/collection/24171282/600x800/weekly" animation="None" hover_animation="zoom-crop" alignment="" img_link_large="yes" border_radius="none" box_shadow="x_large_depth" image_loading="default" max_width="100%" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Rotating Text Hero Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-24-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-header.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#9fc5d0" bg_image="https://source.unsplash.com/collection/47980293/daily" bg_position="center center" background_image_loading="skip-lazy-load" bg_repeat="no-repeat" scene_position="center" top_padding="15%" bottom_padding="15%" top_padding_tablet="30%" constrain_group_3="yes" bottom_padding_tablet="30%" top_padding_phone="40%" constrain_group_5="yes" bottom_padding_phone="40%" text_color="custom" text_align="left" row_border_radius="none" row_border_radius_applies="bg" color_overlay="#000000" overlay_strength="0.3" gradient_direction="radial" shape_divider_color="#ffffff" shape_divider_position="bottom" shape_divider_height="45%" bg_image_animation="zoom-out" parallax_bg="true" parallax_bg_speed="fast" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="radial" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="center" bg_image_animation="zoom-out-reveal" parallax_bg="true" parallax_bg_speed="fast" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" zindex="20"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" font_color="#ffffff" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" text_content="Skincare made" font_size="10vh" animation_delay="200"][/split_line_heading][nectar_rotating_words_title heading_tag="h1" dynamic_text="simple, pure, honest, custom" ending_text="for you." duration="2500" dynamic_heading_tag="default" element_animation="stagger_words" mobile_display="inline" text_flow="inline" element_animation_delay="550" font_size="10vh"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" zindex="20"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" font_color="#ffffff" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" delay="650"][nectar_cta btn_style="underline" heading_tag="span" text_color="#ffffff" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" display="block" link_text="Shop Now" margin_top="30" padding_top="18" padding_bottom="18" margin_bottom="20" url="http://themenectar.com/demo/salient-ecommerce-robust/product-category/skincare/"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Fancy Box Carousel', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-23-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-carousel.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" top_padding="8%" bottom_padding="8%" top_padding_tablet="16%" bottom_padding_tablet="16%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_color="#000000" shape_divider_position="top" bg_image_animation="none" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner equal_height="yes" content_placement="bottom" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="30" bottom_padding_tablet="20" text_align="left"][vc_column_inner column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" column_element_spacing="5px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text]</p>
<h2>Featured Products</h2>
<p>Quality ingredients. Real results.[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" offset="vc_hidden-xs"][nectar_cta btn_style="underline" heading_tag="span" text_color="#000000" button_color="default" link_type="regular" alignment="right" alignment_tablet="default" alignment_phone="default" display="block" link_text="View All Products" url=""][/vc_column_inner][/vc_row_inner][carousel script="flickity" flickity_formatting="default" desktop_cols_flickity="4" desktop_small_cols_flickity="3" tablet_cols_flickity="2" flickity_controls="touch_total" flickity_touch_total_hide_indicator="true" flickity_touch_total_icon_color="dark" color="extra-color-2" flickity_overflow="visible" flickity_wrap_around="no-wrap" flickity_spacing="15px" column_padding="0" flickity_element_spacing="0" flickity_image_scale_on_drag="true" border_radius="none"][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" id="1616288228607-7" tab_id="1616288228608-5" title="Item"][fancy_box box_style="image_above_text_underline" image_url="https://source.unsplash.com/collection/49597329/weekly" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" link_url="http://themenectar.com/promo" link_screen_reader="Daily anti-aging cream"]</p>
<h4>Daily anti-acne cream with Tretinoin</h4>
<p>A multi purpose cream that fights breakouts while keeping skin youthful.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" id="1616288228653-4" tab_id="1616288228653-6" title="Item"][fancy_box box_style="image_above_text_underline" image_url="https://source.unsplash.com/collection/55613530/daily" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" link_url="" delay="100" link_screen_reader="Magic eye cream"]</p>
<h4>Magic eye kit</h4>
<p>Super charged active retinol cream that fights off stubborn eye bags 24/7.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" id="1616288228676-8" tab_id="1616288228677-10" title="Item"][fancy_box box_style="image_above_text_underline" image_url="https://source.unsplash.com/collection/93326529/daily" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" link_url="" delay="200" link_screen_reader="Multi-peptide soothing moisturizer"]</p>
<h4>Multi-peptide soothing moisturizer</h4>
<p>An excellent source of antioxidants to sooth your skin. Made from waterlily extracts.[/fancy_box][/item][item simple_slider_bg_image_url="670" simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" id="1616288228696-1" tab_id="1616288228696-10" title="Item"][fancy_box box_style="image_above_text_underline" image_url="https://source.unsplash.com/collection/24171282/daily" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" link_url="" delay="300" link_screen_reader="Refreshing complete vitamin C Nectar serum"]</p>
<h4>Refreshing complete vitamin C Nectar serum</h4>
<p>Protect and rejuvenate your skin with our most potent vitamin C serum yet.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" id="1616288228721-9" tab_id="1616288228722-10" title="Item"][fancy_box box_style="image_above_text_underline" image_url="https://source.unsplash.com/collection/81229186/weekly" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" link_url="" delay="400" link_screen_reader="The All-In-One Anti Ace"]</p>
<h4>The All-In-One Anti Ace</h4>
<p>A simple daily supplement that combats acne before it starts.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" id="1616288228768-4" tab_id="1616288228769-4" title="Item"][fancy_box box_style="image_above_text_underline" image_url="https://source.unsplash.com/collection/86446855/weekly" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" link_url="" delay="500" link_screen_reader="The Nectar Super Secret Serum"]</p>
<h4>The Nectar Super Secret Serum</h4>
<p>The best kept secret in the skincare world can finally be yours.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" id="1616288228793-7" tab_id="1616288228794-9" title="Item"][fancy_box box_style="image_above_text_underline" image_url="https://source.unsplash.com/collection/70342232/weekly" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" link_url="http://themenectar.com/" delay="600" link_screen_reader="Vegetable Vitamins"]</p>
<h4>Natural Face Wash</h4>
<p>Easily get the vitamins you've been missing for perfect skin.[/fancy_box][/item][/carousel][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Overflowing Parallax Left With Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['about'];
$data['custom_class'] = 'about general date-23-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-cascading-left.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" top_padding="4%" bottom_padding="2%" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" top_padding_tablet="8%" constrain_group_3="yes" bottom_padding_tablet="8%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="90px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-4-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_cascading_images image_1_bg_color="#ff7530" image_1_offset_x_sign="+" image_1_offset_x="0%" image_1_offset_y_sign="+" image_1_offset_y="20%" image_1_rotate_sign="+" image_1_rotate="none" image_1_scale="1" image_1_padding="none" image_1_box_shadow="none" image_1_max_width_desktop="100%" image_1_max_width_mobile="100%" image_1_image_width_mobile="default" image_2_url="http://54cb3baa74d4d851e8b7-2e7f88565dceb0a8192c6645d1f8b1b4.r12.cf2.rackcdn.com/bottle-mockup.png" image_2_offset_x_sign="+" image_2_offset_x="0%" image_2_offset_y_sign="+" image_2_offset_y="10%" image_2_rotate_sign="+" image_2_rotate="none" image_2_scale="1" image_2_padding="none" image_2_box_shadow="none" image_2_max_width_desktop="100%" image_2_max_width_mobile="100%" image_2_image_width_mobile="default" image_3_offset_x_sign="+" image_3_offset_x="0%" image_3_offset_y_sign="+" image_3_offset_y="0%" image_3_rotate_sign="+" image_3_rotate="none" image_3_scale="1" image_3_padding="auto" image_3_box_shadow="none" image_3_max_width_desktop="100%" image_3_max_width_mobile="100%" image_3_image_width_mobile="default" image_4_offset_x_sign="+" image_4_offset_x="0%" image_4_offset_y_sign="+" image_4_offset_y="0%" image_4_rotate_sign="+" image_4_rotate="none" image_4_scale="1" image_4_padding="auto" image_4_box_shadow="none" image_4_max_width_desktop="100%" image_4_max_width_mobile="100%" image_4_image_width_mobile="default" element_sizing="forced" element_sizing_aspect="1-1" image_loading="default" border_radius="none" parallax_scrolling="yes" layer_1_parallax_scrolling="no" parallax_scrolling_intensity="subtle" overflow="hidden"][/vc_column_inner][vc_column_inner column_padding="padding-4-percent" column_padding_tablet="inherit" column_padding_phone="no-extra-padding" column_padding_position="all" top_margin="6%" top_margin_tablet="0" top_margin_phone="4%" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" text_content="Anti-Acne solutions that yield fast results" max_width="550"][/split_line_heading][vc_column_text max_width="550"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.[/vc_column_text][nectar_cta btn_style="underline" heading_tag="span" text_color="#000000" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" link_text="Shop Anti-Acne" url=""][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Overflowing Parallax Right With Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['about'];
$data['custom_class'] = 'about general date-23-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-cascading-right.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" top_padding="2%" bottom_padding="4%" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" top_padding_tablet="8%" constrain_group_3="yes" bottom_padding_tablet="8%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="90px" column_direction="default" column_direction_tablet="column_reverse" column_direction_phone="column_reverse" text_align="left"][vc_column_inner column_padding="padding-4-percent" column_padding_tablet="inherit" column_padding_phone="no-extra-padding" column_padding_position="all" top_margin="6%" top_margin_tablet="0" top_margin_phone="4%" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="radial" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" text_content="Expertly crafted serums for all skin types" max_width="550"][/split_line_heading][vc_column_text max_width="550"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.[/vc_column_text][nectar_cta btn_style="underline" heading_tag="span" text_color="#000000" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" link_text="Shop Serums" url=""][/vc_column_inner][vc_column_inner column_padding="padding-4-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_cascading_images image_1_bg_color="#bcafd3" image_1_offset_x_sign="+" image_1_offset_x="0%" image_1_offset_y_sign="+" image_1_offset_y="20%" image_1_rotate_sign="+" image_1_rotate="none" image_1_scale="1" image_1_padding="none" image_1_box_shadow="none" image_1_max_width_desktop="100%" image_1_max_width_mobile="100%" image_1_image_width_mobile="default" image_2_url="http://54cb3baa74d4d851e8b7-2e7f88565dceb0a8192c6645d1f8b1b4.r12.cf2.rackcdn.com/bottle-mockup.png" image_2_offset_x_sign="+" image_2_offset_x="0%" image_2_offset_y_sign="+" image_2_offset_y="10%" image_2_rotate_sign="+" image_2_rotate="none" image_2_scale="1" image_2_padding="none" image_2_box_shadow="none" image_2_max_width_desktop="100%" image_2_max_width_mobile="100%" image_2_image_width_mobile="default" image_3_offset_x_sign="+" image_3_offset_x="0%" image_3_offset_y_sign="+" image_3_offset_y="0%" image_3_rotate_sign="+" image_3_rotate="none" image_3_scale="1" image_3_padding="auto" image_3_box_shadow="none" image_3_max_width_desktop="100%" image_3_max_width_mobile="100%" image_3_image_width_mobile="default" image_4_offset_x_sign="+" image_4_offset_x="0%" image_4_offset_y_sign="+" image_4_offset_y="0%" image_4_rotate_sign="+" image_4_rotate="none" image_4_scale="1" image_4_padding="auto" image_4_box_shadow="none" image_4_max_width_desktop="100%" image_4_max_width_mobile="100%" image_4_image_width_mobile="default" element_sizing="forced" element_sizing_aspect="1-1" image_loading="default" border_radius="none" parallax_scrolling="yes" layer_1_parallax_scrolling="no" parallax_scrolling_intensity="subtle" overflow="hidden"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Interactive Shop Categories', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['shop'];
$data['custom_class'] = 'shop date-21-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-category-grid.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" top_padding="8%" bottom_padding="8%" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" top_padding_tablet="8%" bottom_padding_tablet="20%" top_padding_phone="20%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" enable_shape_divider="true" shape_divider_color="#e0e0e0" shape_divider_position="bottom" shape_divider_height="1" bg_image_animation="none" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="20" bottom_padding_tablet="10" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text]</p>
<h6>All Categories</h6>
<p>[/vc_column_text][/vc_column_inner][/vc_row_inner][nectar_category_grid post_type="products" product_category="all" heading_tag="h2" subtext="none" image_loading="lazy-load" grid_style="mouse_follow_image" image_aspect_ratio="4-5" text_color="dark" text_color_hover="dark" subtext_visibility="always" item_divider_custom=""][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Show-stopper Slider Carousel', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-23-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-slider.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ff7747" scene_position="center" top_padding="12%" left_padding_desktop="15%" constrain_group_2="yes" right_padding_desktop="15%" top_padding_tablet="20%" left_padding_tablet="10%" constrain_group_4="yes" right_padding_tablet="10%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="20" bottom_padding_tablet="10" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text]</p>
<h6>Real Results, Guaranteed</h6>
<p>[/vc_column_text][/vc_column_inner][/vc_row_inner][split_line_heading animation_type="line-reveal-by-space" font_style="h2" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" text_content="Our products are FDA approved and backed by real science" font_size="9vh"][/split_line_heading][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ff7747" scene_position="center" top_padding="6%" bottom_padding="6%" top_padding_tablet="7%" bottom_padding_tablet="10%" text_color="custom" custom_text_color="#d4c0ff" text_align="left" row_border_radius="none" row_border_radius_applies="bg" id="impact" overlay_strength="0.3" gradient_direction="left_to_right" enable_shape_divider="true" shape_divider_color="#ffffff" shape_divider_position="bottom" shape_divider_height="50%" bg_image_animation="none" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][carousel script="simple_slider" simple_slider_sizing="aspect_ratio" simple_slider_aspect_ratio="2-1" simple_slider_arrow_controls="true" simple_slider_arrow_positioning="inside" simple_slider_pagination_controls="true" simple_slider_pagination_coloring="light" simple_slider_pagination_alignment="right" simple_slider_parallax="true" simple_slider_min_height="575" autorotation_speed="6000"][item simple_slider_bg_image_url="https://source.unsplash.com/collection/81229186/weekly" simple_slider_bg_image_position="center-center" simple_slider_font_color="#ffffff" simple_slider_overlay_strength="0.3" simple_slider_gradient_direction="left_to_right" bg_image_url="" bg_image_position="default" image_url="" id="1616288229240-2" tab_id="1616288229241-6" title="Item"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text max_width="425"]</p>
<h2>Clear up acne breakouts in as little as two days.</h2>
<p>[/vc_column_text][nectar_cta btn_style="underline" heading_tag="span" text_color="#ffffff" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" link_text="Shop Now" url="" margin_top="35"][/vc_column_inner][/vc_row_inner][/item][item simple_slider_bg_image_url="https://source.unsplash.com/collection/49597329/weekly" simple_slider_bg_image_position="center-center" simple_slider_font_color="#ffffff" simple_slider_overlay_strength="0.3" simple_slider_gradient_direction="left_to_right" bg_image_url="" bg_image_position="default" image_url="" id="1616288229294-4" tab_id="1616288229295-10" title="Item"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text max_width="450"]</p>
<h2>Finally, a face wash that delivers.</h2>
<p>[/vc_column_text][nectar_cta btn_style="underline" heading_tag="span" text_color="#ffffff" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" link_text="Explore" url="" margin_top="35"][/vc_column_inner][/vc_row_inner][/item][item simple_slider_bg_image_url="https://source.unsplash.com/collection/95519860/weekly" simple_slider_bg_image_position="center-center" simple_slider_font_color="#ffffff" simple_slider_overlay_strength="0.3" simple_slider_gradient_direction="left_to_right" bg_image_url="" bg_image_position="default" image_url="" id="1616288229350-5" tab_id="1616288229351-10" title="Item"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text max_width="450"]</p>
<h2>Developed to provide deep regeneration.</h2>
<p>[/vc_column_text][nectar_cta btn_style="underline" heading_tag="span" text_color="#ffffff" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" link_text="Explore" url="http://themenectar.com/" margin_top="35"][/vc_column_inner][/vc_row_inner][/item][/carousel][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Staggered Testimonials', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['testimonials'];
$data['custom_class'] = 'testimonials date-22-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-testimonials.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="90px" column_direction="default" column_direction_tablet="column_reverse" column_direction_phone="column_reverse" bg_color="#ffffff" scene_position="center" top_padding="6%" bottom_padding="2%" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" top_padding_tablet="10%" bottom_padding_tablet="8%" left_padding_tablet="0" constrain_group_4="yes" right_padding_tablet="0" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" enable_shape_divider="true" shape_divider_color="#ffffff" shape_divider_position="bottom" shape_divider_height="50%" shape_divider_height_tablet="75%" bg_image_animation="none" shape_type="straight_section"][vc_column column_padding="padding-3-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left-right" top_margin_tablet="20" column_element_spacing="10px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-10-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/collection/92341890/weekly" background_image_position="left top" enable_bg_scale="true" background_image_loading="default" font_color="#ffffff" column_shadow="none" column_border_radius="none" column_link_target="_self" enable_gradient="true" color_overlay_2="#ff4600" gradient_direction="top_to_bottom" overlay_strength="0.5" width="1/1" tablet_width_inherit="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="40vh" custom_height_phone="200"][vc_column_text]
<h4>Marley Cohen</h4>
[/vc_column_text][vc_column_text]Dry Skin[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="10%" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="5px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="fontawesome" icon_style="default" icon_color_type="color_scheme" icon_color="Accent-Color" icon_padding="0px" icon_fontawesome="fa fa-star" icon_size="14" margin_right="5"][nectar_icon icon_family="fontawesome" icon_style="default" icon_color_type="color_scheme" icon_color="Accent-Color" icon_padding="0px" icon_fontawesome="fa fa-star" icon_size="14" margin_right="5"][nectar_icon icon_family="fontawesome" icon_style="default" icon_color_type="color_scheme" icon_color="Accent-Color" icon_padding="0px" icon_fontawesome="fa fa-star" icon_size="14" margin_right="5"][nectar_icon icon_family="fontawesome" icon_style="default" icon_color_type="color_scheme" icon_color="Accent-Color" icon_padding="0px" icon_fontawesome="fa fa-star" icon_size="14" margin_right="5"][nectar_icon icon_family="fontawesome" icon_style="default" icon_color_type="color_scheme" icon_color="Accent-Color" icon_padding="0px" icon_fontawesome="fa fa-star" icon_size="14" margin_right="5"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="10%" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="5px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h5" stagger_animation="true" mobile_disable_animation="true" content_alignment="default" mobile_content_alignment="inherit" text_content="``Vivamus egestas tincidunt sapien at pulvinar. Nullam pretium lorem est. Mauris orci lectus, porttitor ac quam a, egestas.``" max_width="650"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-3-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left-right" column_element_spacing="10px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="30" bottom_padding_tablet="15" right_padding_tablet="15%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" text_content="Real people with life-changing results" max_width="575"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-10-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/collection/70342232/weekly" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" font_color="#ffffff" column_shadow="none" column_border_radius="none" column_link_target="_self" enable_gradient="true" color_overlay_2="#ff4600" gradient_direction="top_to_bottom" overlay_strength="0.5" width="1/1" tablet_width_inherit="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="40vh" custom_height_phone="200"][vc_column_text]
<h4>TJ Davis</h4>
[/vc_column_text][vc_column_text]Oily Skin[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="10%" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="5px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="fontawesome" icon_style="default" icon_color_type="color_scheme" icon_color="Accent-Color" icon_padding="0px" icon_fontawesome="fa fa-star" icon_size="14" margin_right="5"][nectar_icon icon_family="fontawesome" icon_style="default" icon_color_type="color_scheme" icon_color="Accent-Color" icon_padding="0px" icon_fontawesome="fa fa-star" icon_size="14" margin_right="5"][nectar_icon icon_family="fontawesome" icon_style="default" icon_color_type="color_scheme" icon_color="Accent-Color" icon_padding="0px" icon_fontawesome="fa fa-star" icon_size="14" margin_right="5"][nectar_icon icon_family="fontawesome" icon_style="default" icon_color_type="color_scheme" icon_color="Accent-Color" icon_padding="0px" icon_fontawesome="fa fa-star" icon_size="14" margin_right="5"][nectar_icon icon_family="fontawesome" icon_style="default" icon_color_type="color_scheme" icon_color="Accent-Color" icon_padding="0px" icon_fontawesome="fa fa-star-half-o" icon_size="14"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="10%" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="5px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h5" stagger_animation="true" mobile_disable_animation="true" content_alignment="default" mobile_content_alignment="inherit" text_content="``Mauris orci lectus, porttitor ac quam a, egestas consequat lorem. Nullam tincidunt. Mauris orci lectus, porttitor ac quam.``" max_width="650"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Triple Info Columns', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['services'];
$data['custom_class'] = 'general services date-22-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-three-col-text.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="6%" bottom_padding="12%" bottom_padding_tablet="30%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner equal_height="yes" column_margin="90px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text max_width="350"]
<h4>Quality Ingredients</h4>
[/vc_column_text][divider line_type="No Line" custom_height="15"][vc_column_text max_width="350"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.[/vc_column_text][nectar_cta btn_style="underline" heading_tag="span" text_color="#000000" button_color="default" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" display="block" link_text="Explore" url="" margin_top="15"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" top_margin_tablet="50" constrain_group_3="yes" bottom_margin_tablet="50" top_margin_phone="30" constrain_group_5="yes" bottom_margin_phone="30" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" delay="100"][vc_column_text max_width="350"]
<h4>Lasting Results</h4>
[/vc_column_text][divider line_type="No Line" custom_height="15"][vc_column_text max_width="350"]Even the all-powerful Pointing has no control about the blind texts. One day a line of blind text by the name.[/vc_column_text][nectar_cta btn_style="underline" heading_tag="span" text_color="#000000" button_color="default" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" display="block" link_text="Explore" url="" margin_top="15"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" top_margin_tablet="20" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" delay="200"][vc_column_text max_width="350"]
<h4>Fast Shipping</h4>
[/vc_column_text][divider line_type="No Line" custom_height="15"][vc_column_text max_width="350"]A small river named Duden flows by their place and supplies it with the necessary regelialia.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Fun Dual Column Footer', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-22-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-footer.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="none" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#111111" scene_position="center" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" color_overlay="#111111" overlay_strength="0.8" gradient_direction="radial" shape_divider_position="bottom" bg_image_animation="none" shape_type="straight_section"][vc_column column_padding="padding-10-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner equal_height="yes" column_margin="70px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="25%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text]
<h4>Come Visit</h4>
The Castle Unit 345 2500 Castle Dr
Manhattan, NY[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text]
<h4>Contact Us</h4>
+216 (0)40 3629 4753
hello@themenectar.com[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="5%" bottom_padding="25%" bottom_padding_tablet="15%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_cta btn_style="underline" heading_tag="span" text_color="#ffffff" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="inline" link_text="Instagram" margin_right="30" margin_bottom="10"][nectar_cta btn_style="underline" heading_tag="span" text_color="#ffffff" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="inline" link_text="FaceBook" padding_right="30" margin_bottom="10"][nectar_cta btn_style="underline" heading_tag="span" text_color="#ffffff" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="inline" link_text="Twitter" padding_right="25" margin_bottom="10"][nectar_cta btn_style="underline" heading_tag="span" text_color="#ffffff" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="inline" link_text="YouTube" padding_right="25" margin_bottom="10"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-10-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="advanced" border_left_desktop="1" border_left_tablet="0" border_top_tablet="1" border_left_phone="0" border_top_phone="1" column_border_color="#5e5e5e" column_border_style="solid"][vc_row_inner column_margin="90px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="15%" constrain_group_1="yes" bottom_padding="15%" top_padding_tablet="15%" bottom_padding_tablet="10%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text max_width="500"]
<h2>Stay in the loop with our weekly newsletter</h2>
[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#111111" scene_position="center" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" color_overlay="#111111" overlay_strength="0.8" gradient_direction="radial" shape_divider_position="bottom" bg_image_animation="none" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="advanced" border_top_desktop="1" border_top_tablet="0" border_top_phone="0" column_border_color="#5e5e5e" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="50" constrain_group_1="yes" bottom_padding="50" top_padding_tablet="0" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_scrolling_text scroll_direction="ltr" scroll_speed="slowest" style="text_outline" outline_thickness="thin" text_repeat_number="5" text_repeat_divider="custom" text_repeat_divider_scale="half" overflow="hidden" background_image_animation="None" custom_font_size="11vh" text_repeat_divider_custom="·" custom_font_size_mobile="8vh"]
<h2><a href="#"><em>Salient WordPress Theme</em></a></h2>
[/nectar_scrolling_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );





$data = array();
$data['name'] = esc_html__( 'Text right with parallax image', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-22-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-left-parallax-img.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="90px" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="column_reverse" column_direction_phone="column_reverse" bg_color="#ffffff" scene_position="center" top_padding="6%" bottom_padding="2%" top_padding_tablet="8%" bottom_padding_tablet="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" id="home" overlay_strength="0.5" gradient_direction="top_to_bottom" shape_divider_position="bottom" bg_image_animation="none" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.5" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/collection/49597329/weekly" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.5" width="1/1" tablet_width_inherit="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" border_type="simple" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="55vh" custom_height_tablet="40vh" custom_height_phone="300px"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-4-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="right" column_element_spacing="10px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" zindex="100" gradient_direction="left_t_to_right_b" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" min_width="47vh"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="5px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" enable_border_animation="true"][nectar_highlighted_text color_type="regular" highlight_color="#ff7530" text_color="#ff7530" style="regular_underline" highlight_expansion="default" underline_thickness="1px" delay="400"]
<h5><em>No Shortcuts</em></h5>
[/nectar_highlighted_text][vc_column_text css_animation="none" css=".vc_custom_1615162301211{margin-bottom: 20px !important;}"]
<h3>Glowing Skin</h3>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" min_width="47vh"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="5px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" enable_border_animation="true"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer lobortis, nunc quis pharetra volutpat, nulla tellus commodo quam, non rutrum purus leo laoreet risus. Praesent id ipsum in nibh interdum eleifend quis et tellus. Suspendisse eu facilisis eros. Cras egestas convallis sem, a rutrum nisl.

Quisque pulvinar, metus ac scelerisque scelerisque, arcu dui consectetur lorem, at tristique magna magna vel sapien. Vivamus commodo sodales sem faucibus tincidunt. Nunc ut mi id dui suscipit varius et vel mi.

Nunc vel nunc vitae risus ornare convallis. Vestibulum non sem at turpis dictum pulvinar at interdum urna. Ut nec iaculis urna.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Text left with parallax image', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-22-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-right-parallax-img.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="90px" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" top_padding_tablet="8%" bottom_padding_tablet="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" id="home" overlay_strength="0.5" gradient_direction="top_to_bottom" shape_divider_position="bottom" bg_image_animation="none" shape_type="straight_section"][vc_column column_padding="padding-4-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="right" column_element_spacing="10px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" zindex="100" gradient_direction="left_t_to_right_b" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" min_width="47vh"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="5px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" enable_border_animation="true"][nectar_highlighted_text color_type="regular" highlight_color="#ff7530" text_color="#ff7530" style="regular_underline" highlight_expansion="default" underline_thickness="1px" delay="400"]
<h5><em>The difference</em></h5>
[/nectar_highlighted_text][vc_column_text css_animation="none" css=".vc_custom_1615162291092{margin-bottom: 20px !important;}"]
<h3>Gentle Exfoliation</h3>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" min_width="47vh"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="5px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" enable_border_animation="true"][vc_column_text]
<h6>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer lobortis, nunc quis pharetra volutpat, nulla tellus commodo quam, non rutrum purus leo laoreet risus. Praesent id ipsum in nibh interdum eleifend quis et tellus. Suspendisse eu facilisis eros.</h6>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="90px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="30" top_padding_tablet="0" top_padding_phone="0" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" top_margin="20" bottom_margin="20" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" offset="vc_col-lg-6 vc_col-md-12"][vc_column_text css_animation="none" css=".vc_custom_1615162320908{margin-bottom: 10px !important;}"]
<h4>Vegan</h4>
[/vc_column_text][vc_column_text]The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli.[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" top_margin="20" bottom_margin="20" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" offset="vc_col-lg-6 vc_col-md-12"][vc_column_text css_animation="none" css=".vc_custom_1615162311994{margin-bottom: 10px !important;}"]
<h4>Non-abrasive</h4>
[/vc_column_text][vc_column_text]Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.5" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/collection/49597329/daily" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.5" width="1/1" tablet_width_inherit="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" border_type="simple" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="55vh" custom_height_tablet="40vh" custom_height_phone="300px"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Carousel FAQ', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-20-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-faq.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" top_padding="4%" bottom_padding="9%" top_padding_tablet="20%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="1" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="1.5%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_color="#000000" stagger_animation="true" content_alignment="center" mobile_content_alignment="inherit" text_content="Need more info? Check out our most frequently asked questions." max_width="700"][/split_line_heading][/vc_column_inner][/vc_row_inner][carousel script="flickity" flickity_formatting="default" desktop_cols_flickity="3" desktop_small_cols_flickity="2" tablet_cols_flickity="2" flickity_controls="default" color="default" flickity_overflow="visible" flickity_wrap_around="no-wrap" pagination_alignment_flickity="default" flickity_spacing="15px" column_padding="30px" flickity_element_spacing="30px" flickity_image_scale_on_drag="true" border_radius="none" enable_column_border="true"][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" id="1616281899173-8" tab_id="1616281899174-2" title="Item"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="inherit" column_padding_phone="no-extra-padding" column_padding_position="all" column_element_spacing="10px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text max_width="375"]</p>
<h4>How soon will products ship outside the U.S.?</h4>
<p>[/vc_column_text][vc_column_text css=".vc_custom_1616282728232{margin-top: 10px !important;}" max_width="375"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris facilisis lorem sed nisl vulputate varius. Integer quis fermentum enim.[/vc_column_text][/vc_column_inner][/vc_row_inner][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" id="1616281899251-5" tab_id="1616281899252-9" title="Item"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="inherit" column_padding_phone="no-extra-padding" column_padding_position="all" column_element_spacing="10px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text max_width="375"]</p>
<h4>What is your return policy for opened products?</h4>
<p>[/vc_column_text][vc_column_text css=".vc_custom_1616282737786{margin-top: 10px !important;}" max_width="375"]In vulputate dolor eu fermentum pharetra. Sed finibus nunc sed hendrerit imperdiet. Nam nisi justo, maximus id elit vel, dictum lacinia turpis.[/vc_column_text][/vc_column_inner][/vc_row_inner][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" id="1616281899312-6" tab_id="1616281899313-6" title="Item"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="inherit" column_padding_phone="no-extra-padding" column_padding_position="all" column_element_spacing="10px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text max_width="375"]</p>
<h4>Are all of your products organic and cruely-free?</h4>
<p>[/vc_column_text][vc_column_text css=".vc_custom_1616282746674{margin-top: 10px !important;}" max_width="375"]Nam nisi justo, maximus id elit vel, dictum lacinia turpis. Integer cursus lorem vitae urna pharetra, ac aliquet metus condimentum.[/vc_column_text][/vc_column_inner][/vc_row_inner][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" id="1616281899370-3" tab_id="1616281899371-10" title="Item"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="inherit" column_padding_phone="no-extra-padding" column_padding_position="all" column_element_spacing="10px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text max_width="375"]</p>
<h4>Do you offer any promotions for first-time buyers?</h4>
<p>[/vc_column_text][vc_column_text css=".vc_custom_1616282753059{margin-top: 10px !important;}" max_width="375"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris facilisis lorem sed nisl vulputate varius. Integer quis fermentum enim.[/vc_column_text][/vc_column_inner][/vc_row_inner][/item][/carousel][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Layered Parallax Blocks', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['services'] . ', ' . $cat_display_names['cta'];
$data['custom_class'] = 'services cta date-21-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-dual-parallax.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" top_padding="4%" bottom_padding="4%" top_padding_tablet="8%" constrain_group_3="yes" bottom_padding_tablet="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/collection/55613530/daily" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" font_color="#ffffff" column_shadow="none" column_border_radius="none" column_link_target="_self" enable_gradient="true" color_overlay="#0a0a0a" gradient_direction="radial" overlay_strength="0.5" width="1/2" tablet_width_inherit="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="35vh" custom_height_phone="150"][vc_column_text max_width="350" css=".vc_custom_1607992185528{margin-bottom: 15px !important;}"]
<h2>Serums</h2>
[/vc_column_text][nectar_cta btn_style="underline" heading_tag="span" text_color="#ffffff" button_color="default" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" display="block" link_text="Shop Now" url="#"][divider line_type="No Line" custom_height="35vh" custom_height_phone="150"][/vc_column_inner][vc_column_inner column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/collection/86446855/daily" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" font_color="#ffffff" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="radial" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" border_type="simple" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="35vh" custom_height_phone="150"][vc_column_text css=".vc_custom_1607992178595{margin-bottom: 15px !important;}" max_width="350"]
<h2>Anti-Acne</h2>
[/vc_column_text][nectar_cta btn_style="underline" heading_tag="span" text_color="#ffffff" button_color="default" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" display="block" link_text="Shop Now" url="#"][divider line_type="No Line" custom_height="35vh" custom_height_phone="150"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Rotating Words, Text Above Image', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-20-Feb-2018';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-header-2.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffeddc" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" text_color="custom" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" enable_shape_divider="true" shape_divider_color="#ffffff" shape_divider_position="bottom" shape_divider_height="33%" bg_image_animation="none" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="radial" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="35" left_padding_desktop="6%" constrain_group_2="yes" right_padding_desktop="6%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" text_content="Premium skincare" font_size="7vh"][/split_line_heading][nectar_rotating_words_title heading_tag="h1" beginning_text="made" dynamic_text="simple, affordable, honestly, suited" ending_text="for you." duration="2500" dynamic_heading_tag="default" element_animation="stagger_words" mobile_display="inline" text_flow="inline" element_animation_delay="300" font_size="7vh"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/collection/81229186/daily" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" parallax_bg="true" parallax_bg_speed="fast" border_type="simple" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="60vh" custom_height_tablet="50vh" custom_height_phone="40vh"][split_line_heading animation_type="line-reveal-by-space" font_style="h5" text_color="#ffffff" stagger_animation="true" content_alignment="right" mobile_content_alignment="left" text_content="Skin that glows, guaranteed." max_width="300"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Call To Action with Scrolling Text Button', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['cta'];
$data['custom_class'] = 'cta date-19-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-cta.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" constrain_group_1="yes" bottom_padding="5%" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="padding-11-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/collection/310797/daily" background_image_position="center center" background_image_loading="default" column_shadow="none" column_border_radius="15px" column_link_target="_self" enable_gradient="true" color_overlay="#3648d6" color_overlay_2="#ff7530" gradient_direction="left_b_to_right_t" overlay_strength="0.95" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" border_type="simple" column_border_width="none"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="20" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" text_content="Take the leap today and start building your site" max_width="700" font_size="65px"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="25%" constrain_group_2="yes" right_padding_desktop="25%" left_padding_tablet="20%" constrain_group_4="yes" right_padding_tablet="20%" left_padding_phone="15%" constrain_group_6="yes" right_padding_phone="15%" text_align="left"][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" column_element_spacing="default" background_color="#ff7530" background_color_opacity="1" background_color_hover="#3648d6" background_hover_color_opacity="1" column_shadow="none" column_border_radius="10px" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" column_link="#"][nectar_scrolling_text scroll_direction="ltr" scroll_speed="medium" text_color="#ffffff" style="default" text_repeat_number="6" text_repeat_divider="space" overflow="hidden" background_image_animation="None" custom_font_size="30px"]
<h4> Learn More</h4>
[/nectar_scrolling_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="10" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text]⚬ Quality guarantee ⚬ Free 30-day trial ⚬ Trusted globally[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );






$data = array();
$data['name'] = esc_html__( 'Post Grid, Content Under Featured Image', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-18-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/npo-blog-2.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="in_container" full_screen_row_position="middle" column_margin="default" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" pagination="load-more" button_color="black" columns="3" grid_item_spacing="25px" grid_item_height="30vh" image_size="large" image_loading="default" heading_tag="default" enable_indicator="yes" mouse_indicator_style="default" mouse_indicator_text="view" mouse_indicator_color="#000000" animation="none" display_categories="yes" display_date="yes" display_excerpt="yes" grid_style="content_under_image" text_color="dark" hover_effect="zoom" border_radius="5px" posts_per_page="6"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Post Grid, Content Under Featured Image Masonry', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-18-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/npo-blog-1.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="in_container" full_screen_row_position="middle" column_margin="default" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" pagination="load-more" button_color="black" columns="4" grid_item_spacing="25px" grid_item_height="30vh" enable_masonry="yes" image_size="large" image_loading="default" heading_tag="default" enable_indicator="yes" mouse_indicator_style="default" mouse_indicator_text="view" mouse_indicator_color="#000000" animation="none" display_categories="yes" display_date="yes" display_excerpt="yes" grid_style="content_under_image" text_color="dark" hover_effect="zoom" border_radius="5px" posts_per_page="6"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Nonprofit Dual CTA', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['cta'];
$data['custom_class'] = 'cta date-18-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/npo-cta.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_color="#ffffff" scene_position="center" top_padding="8%" text_color="dark" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_b_to_right_t" overlay_strength="1" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" bottom_padding="5%" text_align="left"][vc_column_inner centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_content="It's time to make nature our priority. Let's change the world together." max_width="650"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" column_margin="none" equal_height="yes" content_placement="middle" bg_color="#ffffff" scene_position="center" bottom_padding="8%" text_color="dark" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color="#f4f4f4" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="center" phone_text_alignment="center" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="none" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/featured/daily/?monkey" background_image_position="center center" enable_bg_scale="true" column_shadow="none" column_border_radius="none" column_link_target="_self" enable_gradient="true" color_overlay_2="#f4f4f4" gradient_direction="left_to_right" overlay_strength="1" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_hidden-sm vc_hidden-xs"][/vc_column_inner][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="padding-6-percent" column_padding_phone="padding-12-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="5/12" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][divider line_type="No Line" custom_height="5vh" custom_height_tablet="0vh"][vc_column_text css=".vc_custom_1579541117059{margin-bottom: 50px !important;}"]Every little bit helps the greater good of the world.[/vc_column_text][nectar_cta btn_style="arrow-animation" heading_tag="h5" text_color="#ffffff" button_color="accent-color" link_type="regular" alignment="left" display="block" link_text="Donate" url="#" padding_top="15" padding_right="30" padding_bottom="15" padding_left="25"][divider line_type="No Line" custom_height="5vh" custom_height_tablet="0vh"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/12" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/featured/daily/?tree" background_image_position="center center" enable_bg_scale="true" column_shadow="none" column_border_radius="none" column_link_target="_self" color_overlay="rgba(0,0,0,0.7)" gradient_direction="left_to_right" overlay_strength="0.8" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner centered_text="true" column_padding="padding-12-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" font_color="#ffffff" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_column_text css=".vc_custom_1579541110385{margin-bottom: 50px !important;}" max_width="280"]We have a long track record of wide-reaching effects.[/vc_column_text][nectar_cta btn_style="arrow-animation" heading_tag="h5" text_color="#000000" button_color="white" link_type="regular" alignment="center" display="block" link_text="See our Impact" url="#" padding_top="15" padding_right="30" padding_bottom="15" padding_left="25"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Nonprofit Scrolling Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['about'] . ', ' . $cat_display_names['general'];
$data['custom_class'] = 'about general date-19-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/npo-scrolling2.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#f7f7f7" scene_position="center" top_padding="14%" constrain_group_1="yes" bottom_padding="14%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="100" id="beliefs" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="90px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="5%" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_column_text]
<h3>If we can find the right way to teach people about wildlife, they will be touched.</h3>
[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_column_text]Aliquam ligula lectus, efficitur non pretium quis, elementum quis sapien. Nunc dapibus mi vitae mi placerat eleifend. Cras ullamcorper. Aliquam ligula lectus, efficitur non pretium quis.[/vc_column_text][nectar_cta btn_style="arrow-animation" heading_tag="h5" text_color="#000000" button_color="default" link_type="regular" alignment="left" display="block" link_text="Make a Donation" url="#" margin_top="30"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_scrolling_text scroll_direction="ltr" scroll_speed="slow" text_color="#b5b5b5" style="text_outline" outline_thickness="thin" text_repeat_number="3" text_repeat_divider="none" overflow="hidden" background_image_url="https://source.unsplash.com/5T1KR5g5EZw" background_image_animation="ro-reveal-from-bottom" separate_text_coloring="true" text_color_front="#ffffff" scroll_functionality="automatic" custom_font_size="15vh" custom_font_size_mobile="11vw" background_image_height="55vh"]
<h2><i>You Can Make A Difference</i></h2>
[/nectar_scrolling_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Nonprofit Scrolling Text Dark', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['about'] . ', ' . $cat_display_names['general'];
$data['custom_class'] = 'about general date-19-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/npo-scrolling.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_color="#000000" scene_position="center" top_padding="14%" constrain_group_1="yes" bottom_padding="14%" text_color="light" text_align="left" zindex="100" id="beliefs" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="90px" bottom_padding="5%" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_column_text]</p>
<h3>If we can find the right way to teach people about wildlife, they will be touched.</h3>
<p>[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_column_text]Aliquam ligula lectus, efficitur non pretium quis, elementum quis sapien. Nunc dapibus mi vitae mi placerat eleifend. Cras ullamcorper molestie massa, at suscipit quam rhoncus vel. Suspendisse accumsan id diam et laoreet. Etiam eu feugiat nulla.[/vc_column_text][nectar_cta btn_style="arrow-animation" heading_tag="h5" text_color="#ffffff" button_color="default" link_type="regular" alignment="left" display="block" link_text="Make a Donation" url="#" margin_top="30"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_scrolling_text scroll_direction="ltr" scroll_speed="slow" text_color="#595959" style="text_outline" outline_thickness="thin" text_repeat_number="3" text_repeat_divider="none" overflow="hidden" background_image_url="https://source.unsplash.com/1200x800/daily/?sky" background_image_animation="ro-reveal-from-bottom" separate_text_coloring="true" text_color_front="#ffffff" scroll_functionality="automatic" custom_font_size="15vh" custom_font_size_mobile="11vw" background_image_height="55vh"]</p>
<h2><i>You Can Make A Difference</i></h2>
<p>[/nectar_scrolling_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );





$data = array();
$data['name'] = esc_html__( 'Nonprofit Recent Posts', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'services blog date-19-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/npo-recent-posts.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" text_color="dark" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_content="Recent News Articles" max_width="600"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in"][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" pagination="none" columns="3" image_size="large" image_loading="lazy-load" heading_tag="h3" animation="fade-in-from-bottom" display_date="yes" grid_style="mouse_follow_image" text_color="dark" post_title_overlay="yes" mouse_follow_image_alignment="middle" mouse_follow_post_spacing="45px" border_radius="none" meta_visibility="always" posts_per_page="6" custom_font_size="28px"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Nonprofit Services and Testimonials', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['services'] . ', ' . $cat_display_names['testimonials'];
$data['custom_class'] = 'services testimonials date-20-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/npo-services.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" scene_position="center" top_padding="12%" text_color="dark" text_align="left" id="testimonials" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" bottom_padding="3%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_content="Measurable results are the name of the game" max_width="450"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="90px" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="right" bottom_margin_tablet="5%" bottom_margin_phone="5%" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_single_testimonial testimonial_style="basic_left_image" image="https://source.unsplash.com/featured/250x250/daily/?happy" add_image_shadow="true" quote="Phasellus viverra nulla ut metus varius laoreet. Quisque rutrum. Aenean imperdiet elementum semper. Etiam ultricies nisi vel augue. Curabitur ullamcorper." name="Kara Lucas" subtitle="Animal Activist"][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left" top_margin="150px" top_margin_tablet="5%" top_margin_phone="5%" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_single_testimonial testimonial_style="basic_left_image" image="https://source.unsplash.com/featured/250x250/daily/?man" add_image_shadow="true" quote="Nullam quis ante. Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Fringilla mauris sit amet. Donec sodales sagittis. Aenean commodo ligula." name="Alexander Gerard" subtitle="Conversationalist"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_color="#ffffff" scene_position="center" bottom_padding="12%" text_color="dark" text_align="left" id="impact" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][carousel script="flickity" flickity_formatting="default" desktop_cols_flickity="3" desktop_small_cols_flickity="3" tablet_cols_flickity="2" flickity_controls="touch_total" color="default" flickity_overflow="visible" flickity_wrap_around="no-wrap" flickity_spacing="default" column_padding="0" flickity_image_scale_on_drag="true" border_radius="none"][item id="1583163501716-5" title="Item" tab_id="1583163501718-4"][fancy_box box_style="hover_desc" icon_family="none" image_url="https://source.unsplash.com/featured/daily/?forest" hover_color="accent-color" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="450" hover_content="Phasellus viverra nulla ut metus varius laoreet. Quisque rutrum."]
<h3>Forests</h3>
[/fancy_box][/item][item id="1583163501860-1" title="Item" tab_id="1583163501861-9"][fancy_box box_style="hover_desc" icon_family="none" image_url="https://source.unsplash.com/featured/daily/?bird" hover_color="accent-color" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="450" hover_content="Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula."]
<h3>Birds</h3>
[/fancy_box][/item][item id="1583163501970-2" title="Item" tab_id="1583163501971-2"][fancy_box box_style="hover_desc" icon_family="none" image_url="https://source.unsplash.com/featured/daily/?dolphin" hover_color="accent-color" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="450" hover_content="Socis natoque penatibus et magnis dis parturient montes."]
<h3>Dolphin</h3>
[/fancy_box][/item][item id="1583163502066-1" title="Item" tab_id="1583163502067-3"][fancy_box box_style="hover_desc" icon_family="none" image_url="https://source.unsplash.com/featured/daily/?panda" hover_color="accent-color" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="450" hover_content="Phasellus viverra nulla ut metus varius laoreet. Quisque rutrum."]
<h3>Pandas</h3>
[/fancy_box][/item][item id="1583163502157-8" title="Item" tab_id="1583163502158-10"][fancy_box box_style="hover_desc" icon_family="none" image_url="https://source.unsplash.com/featured/daily/?rhino" hover_color="accent-color" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="450" hover_content="Sed vulputate purus sed facilisis dignissim erat."]
<h3>Rhino</h3>
[/fancy_box][/item][item id="1583163502244-7" title="Item" tab_id="1583163502246-2"][fancy_box box_style="hover_desc" icon_family="none" image_url="https://source.unsplash.com/featured/daily/?turtle" hover_color="accent-color" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="450" hover_content="Socis natoque penatibus et magnis dis parturient montes."]
<h3>Turtles</h3>
[/fancy_box][/item][item id="1583163502353-0" title="Item" tab_id="1583163502354-1"][fancy_box box_style="hover_desc" icon_family="none" image_url="https://source.unsplash.com/featured/daily/?cow" hover_color="accent-color" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="450" hover_content="Sed vulputate purus sed facilisis dignissim erat."]
<h3>Cattle</h3>
[/fancy_box][/item][/carousel][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Nonprofit Reveal Image and Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'general date-20-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/npo-image-overlap.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" zindex="100" gradient_direction="left_to_right" overlay_strength="0.3" width="5/12" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][image_with_animation image_url="https://source.unsplash.com/1000x900/daily/?animal" alignment="" animation="ro-reveal-from-left" hover_animation="none" border_radius="none" image_loading="default" max_width="125%" max_width_mobile="default" margin_top="25%" margin_bottom="25%" margin_top_tablet="0px" margin_bottom_tablet="0px" margin_top_phone="0px" margin_bottom_phone="0px"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-12-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color="#f0f5f9" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_t_to_right_b" overlay_strength="1" width="7/12" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" translate_y="20px" translate_x="10%" translate_y_tablet="30px" translate_x_tablet="0px" translate_x_phone="nonw"][vc_row_inner column_margin="default" translate_x="15%" translate_x_tablet="0%" translate_x_phone="0%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_column_text css_animation="none" css=".vc_custom_1582826380836{margin-bottom: 40px !important;}" max_width="550"]
<h2>Nature can be fully saved through love from people</h2>
[/vc_column_text][vc_column_text css_animation="none" css=".vc_custom_1579198858100{margin-bottom: 40px !important;}" max_width="550"]Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Nulla consequat massa quis enim. Sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus lorem mus.[/vc_column_text][nectar_cta btn_style="arrow-animation" heading_tag="h5" text_color="#000000" button_color="default" link_type="video_lightbox" alignment="left" display="block" link_text="Watch Our Video" url="https://www.youtube.com/watch?v=RDC1ZFFhZq8"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Nonprofit Reveal Image and Text Alt', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'general date-20-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/npo-image-overlap-2.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="padding-12-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color="#f0f5f9" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_t_to_right_b" overlay_strength="1" width="7/12" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" column_border_width="none" column_border_style="solid" translate_y="20px" translate_x="10%" translate_y_tablet="30px" translate_x_tablet="0px" translate_x_phone="nonw"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_x="-15%" translate_x_tablet="0%" translate_x_phone="0%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="none" css=".vc_custom_1582826380836{margin-bottom: 40px !important;}" max_width="550"]
<h2>Nature can be fully saved through love from people</h2>
[/vc_column_text][vc_column_text css_animation="none" css=".vc_custom_1579198858100{margin-bottom: 40px !important;}" max_width="550"]Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Nulla consequat massa quis enim. Sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus lorem mus.[/vc_column_text][nectar_cta btn_style="arrow-animation" heading_tag="h5" text_color="#000000" button_color="default" link_type="video_lightbox" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" link_text="Watch Our Video" url="https://www.youtube.com/watch?v=RDC1ZFFhZq8"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" zindex="100" gradient_direction="left_to_right" overlay_strength="0.3" width="5/12" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" column_border_width="none" column_border_style="solid"][image_with_animation image_url="https://source.unsplash.com/1000x900/daily/?animal" animation="ro-reveal-from-right" hover_animation="none" alignment="right" border_radius="none" image_loading="default" max_width="125%" max_width_mobile="default" margin_top="25%" margin_bottom="25%" margin_top_tablet="0px" margin_bottom_tablet="0px" margin_top_phone="0px" margin_bottom_phone="0px"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );





$data = array();
$data['name'] = esc_html__( 'Nonprofit Intro Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'general date-20-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/npo-text.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_color="#ffffff" scene_position="center" top_padding="10%" constrain_group_1="yes" bottom_padding="10%" text_color="dark" text_align="left" id="philosophy" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_highlighted_text color_type="regular" highlight_color="#00cae8" style="regular_underline" delay="200"]
<h3>We stand proudly <a href="#"><em>united as one</em></a>. Our goal is to protect the all lifeforms on our planet. Together, we're part of something larger and <em><a href="#">extraordinary</a></em>. The future of wildlife depends on all of us acting now. With our combined efforts, we can prevent species on the <a href="#"><em>verge of extinction</em></a> from disappearing forever.</h3>
[/nectar_highlighted_text][nectar_cta btn_style="arrow-animation" heading_tag="h5" text_color="#000000" button_color="default" link_type="new_tab" alignment="left" display="block" link_text="Make a Donation" url="#" margin_top="60"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Ageless Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-21-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/npo-header.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="in_container" full_screen_row_position="middle" column_margin="none" equal_height="yes" content_placement="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" id="home" overlay_strength="0.5" gradient_direction="top_to_bottom" shape_divider_position="bottom" bg_image_animation="none" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="padding-6-percent" column_padding_phone="inherit" column_padding_position="top" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" zindex="100" gradient_direction="left_t_to_right_b" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="400" offset="vc_col-xs-6"][vc_row_inner column_margin="default" top_padding_tablet="40" text_align="left" min_width_desktop="60vh" min_width_tablet="50vw" min_width_phone="50vw" min_width="47vh"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" enable_border_animation="true" bg_image_animation="none"][nectar_highlighted_text style="text_outline" outline_thickness="regular" text_outline_color="#000000" text="9vh" custom_font_size="11vh"]
<h1>Protecting our Diverse <em>Wildlife</em></h1>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding_tablet="0px" top_padding_phone="0px" text_align="left" min_width_tablet="0px" min_width_phone="0px" min_width="47vh"][vc_column_inner column_padding="padding-9-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" enable_border_animation="true" bg_image_animation="none"][vc_column_text]Through steady action, we will ensure a bright future for our beautiful planet.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.5" width="3/4" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-xs-6"][vc_row_inner column_margin="default" text_align="left" min_width_desktop="75vw" min_width_tablet="50vw" min_width_phone="50vw"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/9GHW302mRBk" background_image_position="center center" enable_bg_scale="true" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.5" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="ro-reveal-from-bottom"][divider line_type="No Line" custom_height="100vh" custom_height_tablet="80vh"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Dark Wellness Gradient Highlight Intro', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-8-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/gradient-highlight-intro-text-dark.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_color="#000000" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" text_color="light" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" bottom_padding="" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_highlighted_text color_type="gradient" highlight_color="#ff6b30" secondary_color="#000000" style="regular_underline"]
<h3><em><a href="#">Achieve</a></em> your goals easier than ever before. We offer a wide range of rewarding amenities which are all <em><a href="#">personalized</a></em> to specific <a href="#"><em>your needs</em></a>.</h3>
[/nectar_highlighted_text][/vc_column_inner][vc_column_inner centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Dark Wellness Gradient Highlight Text Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-8-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/overlapping-highlight-text-dark.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="90px" equal_height="yes" content_placement="middle" bg_color="#000000" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" top_padding_tablet="15%" constrain_group_3="yes" bottom_padding_tablet="15%" text_color="light" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/5UbIqV58CW8" background_image_position="center top" enable_bg_scale="true" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="zoom-out"][divider line_type="No Line" custom_height_tablet="600" custom_height_phone="500"][/vc_column][vc_column column_padding="padding-7-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" zindex="100" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" translate_x="-28%" translate_x_tablet="0%" translate_x_phone="0%" text_align="left"][vc_column_inner column_padding="padding-10-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_highlighted_text color_type="gradient" highlight_color="#ff6b30" secondary_color="rgba(255,107,48,0.01)" style="half_text" custom_font_size="7vh"]
<h2>Elevate Your Body and <em>Mind</em></h2>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" top_margin="40" top_margin_tablet="0px" top_margin_phone="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_column_text css=".vc_custom_1580329676960{padding-right: 10% !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.[/vc_column_text][nectar_cta btn_style="arrow-animation" heading_tag="h5" text_color="#ffffff" button_color="default" link_type="regular" alignment="left" display="block" link_text="Explore amenities" url="#" margin_top="10"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Wellness Services', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['services'];
$data['custom_class'] = 'services date-8-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/colored-services-dark.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_color="#000000" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" text_color="light" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][fancy_box box_style="parallax_hover" icon_family="none" image_url="https://source.unsplash.com/featured/daily/?food" parallax_hover_box_alignment="bottom" parallax_hover_box_overlay="#0b473a" parallax_hover_box_overlay_opacity="0.9" parallax_hover_box_overlay_opacity_hover="0.3" border_radius="default" image_loading="default" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="400"]
<h4>Nutritional Plans</h4>
Catered to suit your lifestyle.[/fancy_box][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="50"][fancy_box box_style="parallax_hover" icon_family="none" image_url="https://source.unsplash.com/featured/daily/?fitness" parallax_hover_box_alignment="bottom" parallax_hover_box_overlay="#ff6b30" parallax_hover_box_overlay_opacity="0.9" parallax_hover_box_overlay_opacity_hover="0.3" border_radius="default" image_loading="default" color_scheme="dark" secondary_content="" min_height="400"]
<h4>Fitness Center</h4>
Custom programs built for you.[/fancy_box][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="100"][fancy_box box_style="parallax_hover" icon_family="none" image_url="https://source.unsplash.com/featured/daily/?spa" parallax_hover_box_alignment="bottom" parallax_hover_box_overlay="#36302c" parallax_hover_box_overlay_opacity="0.9" parallax_hover_box_overlay_opacity_hover="0.3" border_radius="default" image_loading="default" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="400"]
<h4>Full Day Spa</h4>
5,000 square feet of pure bliss.[/fancy_box][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="4%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" offset="vc_col-xs-6"][vc_column_text css=".vc_custom_1581452718117{margin-bottom: 15px !important;}"]
<h4>Skin Care</h4>
[/vc_column_text][fancy-ul icon_type="none" alignment="left" spacing="15px"]
<ul>
 	<li>Vitamin C Cleanse</li>
 	<li>Organic Tea Facial</li>
 	<li>Ultra Hydration Facial</li>
 	<li>Vampire Facial</li>
</ul>
[/fancy-ul][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="50" offset="vc_col-xs-6"][vc_column_text css=".vc_custom_1581452713162{margin-bottom: 15px !important;}"]
<h4>Psychology</h4>
[/vc_column_text][fancy-ul icon_type="none" alignment="left" spacing="15px"]
<ul>
 	<li>Mature life</li>
 	<li>Prenatal well-being</li>
 	<li>Relationship Counseling</li>
 	<li>General Stress</li>
</ul>
[/fancy-ul][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="100" offset="vc_col-xs-6"][vc_column_text css=".vc_custom_1581452723639{margin-bottom: 15px !important;}"]
<h4>Grooming</h4>
[/vc_column_text][fancy-ul icon_type="none" alignment="left" spacing="15px"]
<ul>
 	<li>Blow-Outs</li>
 	<li>General Styling</li>
 	<li>Keratin Treatments</li>
 	<li>Scalp Treatments</li>
</ul>
[/fancy-ul][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="150" offset="vc_col-xs-6"][vc_column_text css=".vc_custom_1581452728136{margin-bottom: 15px !important;}"]
<h4>Massage</h4>
[/vc_column_text][fancy-ul icon_type="none" alignment="left" spacing="15px"]
<ul>
 	<li>Therapeutic</li>
 	<li>Deep Tissue</li>
 	<li>Essential Oil</li>
 	<li>Couples</li>
</ul>
[/fancy-ul][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Dark Wellness Pricing Tiers', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['pricing'];
$data['custom_class'] = 'pricing date-8-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/pricing-tiers-dark.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_color="#000000" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" text_color="light" text_align="left" overlay_strength="0.8" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="none" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="large_first" col_1_text_align="left" col_2_text_align="left" col_3_text_align="right" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="h4" col_4_text_element="p" font_family="p" hover_effect="full_border" hover_color="accent-color" border_radius="5px" icon_family="iconsmind" icon_size="large" col_1_content="Bronze" col_2_content="Access to facility 7 days out of the month, Basic group classes, Personal Coach." cta_1_text="Join Now" col_3_content="$25/mo" icon_iconsmind="iconsmind-Dry"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="large_first" col_1_text_align="left" col_2_text_align="left" col_3_text_align="right" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="h4" col_4_text_element="p" font_family="p" hover_effect="full_border" hover_color="accent-color" border_radius="5px" icon_family="iconsmind" icon_size="large" col_1_content="Silver" col_2_content="Bronze + Unlimited Access to facilties from every day from 9am - 10pm, Personal nutritionist, Personal trainer." cta_1_text="Join Now" col_3_content="$35/mo" icon_iconsmind="iconsmind-Plant"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="large_first" col_1_text_align="left" col_2_text_align="left" col_3_text_align="right" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="h4" col_4_text_element="p" font_family="p" hover_effect="full_border" hover_color="accent-color" border_radius="5px" icon_family="iconsmind" icon_size="large" col_1_content="Gold" col_2_content="Silver + Fully unlimited access to facility, Bi-monthly therapy, Monthly massage." cta_1_text="Join Now" col_3_content="$50/mo" icon_iconsmind="iconsmind-Flowerpot"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="large_first" col_1_text_align="left" col_2_text_align="left" col_3_text_align="right" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="h4" col_4_text_element="p" font_family="p" hover_effect="full_border" hover_color="accent-color" border_radius="5px" icon_family="iconsmind" icon_size="large" col_1_content="Platinum" col_2_content="Gold + Business Coaching, Bi-weekly therapy, Access to cryotherapy and thermotherapy rooms, Spa package discounts." cta_1_text="Join Now" col_3_content="$100/mo" icon_iconsmind="iconsmind-Palm-Tree"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Dark Wellness Gradient Highlight Text Section 2', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-8-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/overlapping-highlight-text2-dark.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="90px" equal_height="yes" content_placement="middle" bg_color="#000000" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" top_padding_tablet="20%" constrain_group_3="yes" bottom_padding_tablet="20%" text_color="light" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="padding-7-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" zindex="100" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" translate_x="15%" translate_x_tablet="0%" translate_x_phone="0%" text_align="left" min_width_desktop="120%" min_width_tablet="0px"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_highlighted_text color_type="gradient" highlight_color="#ff6b30" secondary_color="rgba(255,107,48,0.01)" style="half_text" custom_font_size="7vh"]
<h2>Flourish with Optimism, Live <em>Deliberately</em></h2>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" top_margin="40" top_margin_tablet="0px" top_margin_phone="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_column_text css=".vc_custom_1580329697124{padding-right: 10% !important;}"]A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" column_margin="70px" top_padding="40" text_align="left"][vc_column_inner centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-xs-4"][image_with_animation image_url="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-light.png" alignment="" animation="None" hover_animation="none" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][vc_column_inner centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-xs-4"][image_with_animation image_url="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-light.png" alignment="" animation="None" hover_animation="none" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][vc_column_inner centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-sm-offset-0 vc_col-xs-4"][image_with_animation image_url="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-light.png" alignment="" animation="None" hover_animation="none" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" column_margin="70px" text_align="left"][vc_column_inner centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-xs-4"][image_with_animation image_url="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-light.png" alignment="" animation="None" hover_animation="none" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][vc_column_inner centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-xs-4"][image_with_animation image_url="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-light.png" alignment="" animation="None" hover_animation="none" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][vc_column_inner centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-sm-offset-0 vc_col-xs-4"][image_with_animation image_url="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-light.png" alignment="" animation="None" hover_animation="none" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/PQYaFb9Z-UI" background_image_position="right center" enable_bg_scale="true" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="zoom-out"][divider line_type="No Line" custom_height_tablet="600" custom_height_phone="500"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Dark Wellness Interactive Recent Posts', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-8-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/featured-img-mouse-follow-post-grid-2.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_color="#000000" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" text_color="light" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="none" bottom_padding="3%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text max_width="450"]
<h2>Recent blog articles we've written</h2>
[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][/vc_column_inner][/vc_row_inner][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" pagination="none" columns="3" image_size="large" image_loading="lazy-load" heading_tag="h3" animation="fade-in-from-bottom" display_date="yes" grid_style="mouse_follow_image" text_color="light" post_title_overlay="yes" mouse_follow_image_alignment="middle" mouse_follow_post_spacing="25px" border_radius="none" posts_per_page="3" custom_font_size="28px"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Wellness Interactive Recent Posts', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-10-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/featured-img-mouse-follow-post-grid.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_color="#ffffff" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" text_color="dark" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="none" bottom_padding="3%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text max_width="450"]
<h2>Recent blog articles we've written</h2>
[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][/vc_column_inner][/vc_row_inner][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" pagination="none" columns="3" image_size="large" image_loading="lazy-load" heading_tag="h3" animation="fade-in-from-bottom" display_date="yes" grid_style="mouse_follow_image" text_color="dark" post_title_overlay="yes" mouse_follow_image_alignment="middle" mouse_follow_post_spacing="25px" border_radius="none" posts_per_page="3" custom_font_size="28px"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Wellness Video Overlap', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-10-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/video-lightbox-split-bg.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_color="#ffffff" scene_position="center" bottom_padding="8%" constrain_group_1="yes" top_padding="8%" text_color="light" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" enable_shape_divider="true" shape_divider_color="#0b473a" shape_divider_position="bottom" shape_divider_height="50%" bg_image_animation="none" shape_type="straight_section"][vc_column centered_text="true" column_padding="padding-4-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="left-right" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/RPT3AjdXlZc" background_image_position="center center" enable_bg_scale="true" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="zoom-out"][divider line_type="No Line" custom_height="25vh" custom_height_tablet="20vh"][vc_row_inner column_margin="20px" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_video_lightbox link_style="play_button" video_url="https://vimeo.com/118023315"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_column_text]
<h2>Your Life, Rejuvenated</h2>
[/vc_column_text][/vc_column_inner][/vc_row_inner][divider line_type="No Line" custom_height="25vh" custom_height_tablet="20vh"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Wellness Pricing Tiers', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['pricing'];
$data['custom_class'] = 'pricing date-10-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/pricing-tiers.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_color="#ffffff" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" text_color="dark" text_align="left" overlay_strength="0.8" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="none" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="large_first" col_1_text_align="left" col_2_text_align="left" col_3_text_align="right" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="h4" col_4_text_element="p" font_family="p" hover_effect="full_border" hover_color="accent-color" border_radius="5px" icon_family="iconsmind" icon_size="large" col_1_content="Bronze" col_2_content="Access to facility 7 days out of the month, Basic group classes, Personal Coach." cta_1_text="Join Now" col_3_content="$25/mo" icon_iconsmind="iconsmind-Dry"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="large_first" col_1_text_align="left" col_2_text_align="left" col_3_text_align="right" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="h4" col_4_text_element="p" font_family="p" hover_effect="full_border" hover_color="accent-color" border_radius="5px" icon_family="iconsmind" icon_size="large" col_1_content="Silver" col_2_content="Bronze + Unlimited Access to facilties from every day from 9am - 10pm, Personal nutritionist, Personal trainer." cta_1_text="Join Now" col_3_content="$35/mo" icon_iconsmind="iconsmind-Plant"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="large_first" col_1_text_align="left" col_2_text_align="left" col_3_text_align="right" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="h4" col_4_text_element="p" font_family="p" hover_effect="full_border" hover_color="accent-color" border_radius="5px" icon_family="iconsmind" icon_size="large" col_1_content="Gold" col_2_content="Silver + Fully unlimited access to facility, Bi-monthly therapy, Monthly massage." cta_1_text="Join Now" col_3_content="$50/mo" icon_iconsmind="iconsmind-Flowerpot"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="large_first" col_1_text_align="left" col_2_text_align="left" col_3_text_align="right" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="h4" col_4_text_element="p" font_family="p" hover_effect="full_border" hover_color="accent-color" border_radius="5px" icon_family="iconsmind" icon_size="large" col_1_content="Platinum" col_2_content="Gold + Business Coaching, Bi-weekly therapy, Access to cryotherapy and thermotherapy rooms, Spa package discounts." cta_1_text="Join Now" col_3_content="$100/mo" icon_iconsmind="iconsmind-Palm-Tree"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Wellness Testimonials with Scrolling Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['testimonials'];
$data['custom_class'] = 'testimonials date-10-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/testimonials-scrolling-text.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" equal_height="yes" bg_color="#0b473a" bg_image="https://source.unsplash.com/featured/daily/?leaf" bg_position="center center" bg_repeat="no-repeat" scene_position="center" top_padding="12%" bottom_padding="1%" text_color="light" text_align="left" enable_gradient="true" color_overlay="#0b473a" color_overlay_2="rgba(11,71,58,0.7)" overlay_strength="1" gradient_direction="top_to_bottom" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" font_color="#ffffff" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="90px" bottom_padding="14%" text_align="left"][vc_column_inner column_padding="padding-4-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_single_testimonial testimonial_style="basic" text_color="#ffffff" quote="People take different roads seeking fulfillment and happiness. Just because they’re not on your road doesn’t mean they’ve gotten lost." name="Kara Lucas" subtitle="Yoga Instructor"][/vc_column_inner][vc_column_inner column_padding="padding-4-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left" top_margin="200px" top_margin_tablet="50px" top_margin_phone="50px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_single_testimonial testimonial_style="basic" text_color="#ffffff" quote="If we are to create a more peaceful world, made up of peaceful individuals, we need a greater concern for others. Altruism. That gives inner strength, self-confidence." name="Alex Cohen" subtitle="Life Coach"][/vc_column_inner][/vc_row_inner][nectar_scrolling_text scroll_direction="rtl" scroll_speed="medium" text_color="#ffffff" style="text_outline" outline_thickness="thin" text_repeat_number="5" text_repeat_divider="custom" text_repeat_divider_scale="half" overflow="visible" background_image_animation="None" custom_font_size="10vh" text_repeat_divider_custom="⚬"]
<h2>a better life</h2>
[/nectar_scrolling_text][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_color="#ffffff" scene_position="center" top_padding="1%" bottom_padding="12%" text_color="dark" text_align="left" overlay_strength="0.8" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_scrolling_text scroll_direction="ltr" scroll_speed="medium" text_color="#0b473a" style="text_outline" outline_thickness="thin" text_repeat_number="5" text_repeat_divider="custom" text_repeat_divider_scale="half" overflow="visible" background_image_animation="None" custom_font_size="10vh" text_repeat_divider_custom="⚬"]
<h2>awaits you</h2>
[/nectar_scrolling_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Wellness Gradient Highlight Text Section 2', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-10-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/overlapping-highlight-text2.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="90px" equal_height="yes" content_placement="middle" bg_color="#ffffff" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" top_padding_tablet="20%" constrain_group_3="yes" bottom_padding_tablet="20%" text_color="dark" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="padding-7-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" zindex="100" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" translate_x="15%" translate_x_tablet="0%" translate_x_phone="0%" text_align="left" min_width_desktop="120%" min_width_tablet="0px"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_highlighted_text color_type="gradient" highlight_color="#ff6b30" secondary_color="rgba(255,107,48,0.01)" style="half_text" custom_font_size="7vh"]</p>
<h2>Flourish with Optimism, Live <em>Deliberately</em></h2>
<p>[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" top_margin="40" top_margin_tablet="0px" top_margin_phone="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_column_text css=".vc_custom_1580329697124{padding-right: 10% !important;}"]A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" column_margin="70px" top_padding="40" text_align="left"][vc_column_inner centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-xs-4"][image_with_animation image_url="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-grey.png" alignment="" animation="None" hover_animation="none" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][vc_column_inner centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-xs-4"][image_with_animation image_url="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-grey.png" alignment="" animation="None" hover_animation="none" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][vc_column_inner centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-sm-offset-0 vc_col-xs-4"][image_with_animation image_url="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-grey.png" alignment="" animation="None" hover_animation="none" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" column_margin="70px" text_align="left"][vc_column_inner centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-xs-4"][image_with_animation image_url="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-grey.png" alignment="" animation="None" hover_animation="none" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][vc_column_inner centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-xs-4"][image_with_animation image_url="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-grey.png" alignment="" animation="None" hover_animation="none" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][vc_column_inner centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-sm-offset-0 vc_col-xs-4"][image_with_animation image_url="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-grey.png" alignment="" animation="None" hover_animation="none" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/PQYaFb9Z-UI" background_image_position="right center" enable_bg_scale="true" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="zoom-out"][divider line_type="No Line" custom_height_tablet="600" custom_height_phone="500"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Wellness Services', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['services'];
$data['custom_class'] = 'services date-10-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/colored-services.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_color="#ffffff" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" text_color="dark" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][fancy_box box_style="parallax_hover" icon_family="none" image_url="https://source.unsplash.com/featured/daily/?food" parallax_hover_box_alignment="bottom" parallax_hover_box_overlay="#0b473a" parallax_hover_box_overlay_opacity="0.9" parallax_hover_box_overlay_opacity_hover="0.3" border_radius="default" image_loading="default" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="400"]
<h4>Nutritional Plans</h4>
Catered to suit your lifestyle.[/fancy_box][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="50"][fancy_box box_style="parallax_hover" icon_family="none" image_url="https://source.unsplash.com/featured/daily/?fitness" parallax_hover_box_alignment="bottom" parallax_hover_box_overlay="#ff6b30" parallax_hover_box_overlay_opacity="0.9" parallax_hover_box_overlay_opacity_hover="0.3" border_radius="default" image_loading="default" color_scheme="dark" secondary_content="" min_height="400"]
<h4>Fitness Center</h4>
Custom programs built for you.[/fancy_box][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="100"][fancy_box box_style="parallax_hover" icon_family="none" image_url="https://source.unsplash.com/featured/daily/?spa" parallax_hover_box_alignment="bottom" parallax_hover_box_overlay="#36302c" parallax_hover_box_overlay_opacity="0.9" parallax_hover_box_overlay_opacity_hover="0.3" border_radius="default" image_loading="default" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="400"]
<h4>Full Day Spa</h4>
5,000 square feet of pure bliss.[/fancy_box][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="4%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" offset="vc_col-xs-6"][vc_column_text css=".vc_custom_1581452718117{margin-bottom: 15px !important;}"]
<h4>Skin Care</h4>
[/vc_column_text][fancy-ul icon_type="none" alignment="left" spacing="15px"]
<ul>
 	<li>Vitamin C Cleanse</li>
 	<li>Organic Tea Facial</li>
 	<li>Ultra Hydration Facial</li>
 	<li>Vampire Facial</li>
</ul>
[/fancy-ul][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="50" offset="vc_col-xs-6"][vc_column_text css=".vc_custom_1581452713162{margin-bottom: 15px !important;}"]
<h4>Psychology</h4>
[/vc_column_text][fancy-ul icon_type="none" alignment="left" spacing="15px"]
<ul>
 	<li>Mature life</li>
 	<li>Prenatal well-being</li>
 	<li>Relationship Counseling</li>
 	<li>General Stress</li>
</ul>
[/fancy-ul][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="100" offset="vc_col-xs-6"][vc_column_text css=".vc_custom_1581452723639{margin-bottom: 15px !important;}"]
<h4>Grooming</h4>
[/vc_column_text][fancy-ul icon_type="none" alignment="left" spacing="15px"]
<ul>
 	<li>Blow-Outs</li>
 	<li>General Styling</li>
 	<li>Keratin Treatments</li>
 	<li>Scalp Treatments</li>
</ul>
[/fancy-ul][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="150" offset="vc_col-xs-6"][vc_column_text css=".vc_custom_1581452728136{margin-bottom: 15px !important;}"]
<h4>Massage</h4>
[/vc_column_text][fancy-ul icon_type="none" alignment="left" spacing="15px"]
<ul>
 	<li>Therapeutic</li>
 	<li>Deep Tissue</li>
 	<li>Essential Oil</li>
 	<li>Couples</li>
</ul>
[/fancy-ul][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Wellness Gradient Highlight Intro', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-10-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/gradient-highlight-intro-text.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_color="#ffffff" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" text_color="dark" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" bottom_padding="" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_highlighted_text color_type="gradient" highlight_color="#ff6b30" secondary_color="#ffffff" style="regular_underline"]
<h3><em><a href="#">Achieve</a></em> your goals easier than ever before. We offer a wide range of rewarding amenities which are all <em><a href="#">personalized</a></em> to specific <a href="#"><em>your needs</em></a>.</h3>
[/nectar_highlighted_text][/vc_column_inner][vc_column_inner centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Wellness Gradient Highlight Text Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-10-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/overlapping-highlight-text.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="90px" equal_height="yes" content_placement="middle" bg_color="#ffffff" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" top_padding_tablet="15%" constrain_group_3="yes" bottom_padding_tablet="15%" text_color="dark" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/2Uv3BGH0z-E" background_image_position="center top" enable_bg_scale="true" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="zoom-out"][divider line_type="No Line" custom_height_tablet="600" custom_height_phone="500"][/vc_column][vc_column column_padding="padding-7-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" zindex="100" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" translate_x="-28%" translate_x_tablet="0%" translate_x_phone="0%" text_align="left"][vc_column_inner column_padding="padding-10-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_highlighted_text color_type="gradient" highlight_color="#ff6b30" secondary_color="rgba(255,107,48,0.01)" style="half_text" custom_font_size="7vh"]
<h2>Elevate Your Body and <em>Mind</em></h2>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" top_margin="40" top_margin_tablet="0px" top_margin_phone="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_column_text css=".vc_custom_1580329676960{padding-right: 10% !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.[/vc_column_text][nectar_cta btn_style="arrow-animation" heading_tag="h5" text_color="#000000" button_color="default" link_type="regular" alignment="left" display="block" link_text="Explore amenities" url="#" margin_top="10"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Gradient Highlight Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-10-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/gradient-highlight-hero.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" equal_height="yes" bg_image="https://source.unsplash.com/featured/daily/?mountains" bg_color="#0b473a" video_bg="use_video" video_mp4="" scene_position="center" top_padding="13%" constrain_group_1="yes" bottom_padding="13%" top_padding_tablet="20%" bottom_padding_tablet="25%" text_color="light" text_align="left" color_overlay="rgba(11,71,58,0.9)" overlay_strength="0.95" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" shape_type="curve"][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="none" bottom_padding="60" bottom_padding_tablet="20" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/6" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_highlighted_text color_type="gradient" highlight_color="#ff6b30" secondary_color="rgba(255,107,48,0.01)" text_color="#f8eadc" style="half_text" custom_font_size="10vh" delay="200"]
<h1>Outside Health Starts <em>Inside</em></h1>
[/nectar_highlighted_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/6" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="600"][nectar_cta btn_style="next-section" btn_type="minimal-arrow" alignment="center" next_section_color="#f8eadc"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );






$data = array();
$data['name'] = esc_html__( 'Clean Image and Left Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['about'];
$data['custom_class'] = 'general about date-17-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/basic-left-text.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="90px" equal_height="yes" content_placement="middle" bg_color="#ffffff" top_padding_tablet="8%" constrain_group_1="yes" bottom_padding_tablet="8%" scene_position="center" text_color="dark" text_align="left" id="home" overlay_strength="0.5" gradient_direction="top_to_bottom" shape_divider_position="bottom" bg_image_animation="none" shape_type="straight_section"][vc_column column_padding="padding-2-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" zindex="100" gradient_direction="left_t_to_right_b" overlay_strength="0.3" width="3/5" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-xs-12"][vc_row_inner column_margin="default" text_align="left" min_width="47vh"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" enable_border_animation="true" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text css_animation="none" css=".vc_custom_1583244983471{margin-bottom: 20px !important;}"]
<h2>Why we're different</h2>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean." font_container="tag:p|font_size:20px|text_align:left|line_height:2em" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="70px" top_padding="25" bottom_padding="15" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text css_animation="none" css=".vc_custom_1583243653891{margin-bottom: 10px !important;}"]
<h4>Attention to Detail</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts." font_container="tag:p|font_size:16px|text_align:left|line_height:2em" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text css_animation="none" css=".vc_custom_1583243657396{margin-bottom: 10px !important;}"]
<h4>Experience</h4>
[/vc_column_text][vc_custom_heading text="Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean." font_container="tag:p|font_size:16px|text_align:left|line_height:2em" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" bottom_padding="0px" bottom_padding_tablet="40px" bottom_padding_phone="40px" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_cta btn_style="arrow-animation" heading_tag="h6" text_color="#ffffff" button_color="accent-color" link_type="regular" alignment="left" display="block" link_text="Contact Us" padding_top="15" padding_right="35" padding_bottom="15" padding_left="35"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.5" width="2/5" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-xs-12"][vc_row_inner column_margin="default" text_align="left" min_width_desktop="43vw" min_width_tablet="50vw" min_width_phone="50vw"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/600x900/daily/?mountains" background_image_position="center center" enable_bg_scale="true" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.5" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="ro-reveal-from-right"][divider line_type="No Line" custom_height="80vh" custom_height_tablet="40vh" custom_height_phone="300px"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Clean Image and Right Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['about'];
$data['custom_class'] = 'general about date-17-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/basic-right-text.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" bg_color="#ffffff" scene_position="center" top_padding_tablet="8%" constrain_group_1="yes" bottom_padding_tablet="8%" text_color="dark" text_align="left" id="home" overlay_strength="0.5" gradient_direction="top_to_bottom" shape_divider_position="bottom" bg_image_animation="none" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" right_margin_tablet="auto" left_margin_tablet="auto" right_margin_phone="auto" left_margin_phone="auto" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" max_width_tablet="600" max_width_phone="420px" gradient_direction="left_to_right" overlay_strength="0.5" width="2/5" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-xs-12"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/600x900/daily/?water" background_image_position="center center" enable_bg_scale="true" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.5" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="ro-reveal-from-left"][divider line_type="No Line" custom_height="90vh" custom_height_tablet="40vh" custom_height_phone="300px"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-7-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left-right" top_margin_tablet="40" right_margin_tablet="auto" left_margin_tablet="auto" right_margin_phone="auto" left_margin_phone="auto" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" max_width_desktop="1000px" max_width_tablet="600px" max_width_phone="420px" zindex="100" gradient_direction="left_t_to_right_b" overlay_strength="0.3" width="3/5" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-xs-12"][vc_row_inner column_margin="40px" text_align="left" min_width="47vh"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" enable_border_animation="true" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text css_animation="none" css=".vc_custom_1583270538634{margin-bottom: 20px !important;}"]
<h2>Our Philosophy</h2>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean." font_container="tag:p|font_size:20px|text_align:left|line_height:2em" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="70px" top_padding="25" bottom_padding="15" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text css_animation="none" css=".vc_custom_1583270560188{margin-bottom: 10px !important;}"]
<h4>Quality over Quantity</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts." font_container="tag:p|font_size:16px|text_align:left|line_height:2em" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text css_animation="none" css=".vc_custom_1583270575677{margin-bottom: 10px !important;}"]
<h4>Design Focused</h4>
[/vc_column_text][vc_custom_heading text="Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean." font_container="tag:p|font_size:16px|text_align:left|line_height:2em" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" bottom_padding="0px" bottom_padding_tablet="40px" bottom_padding_phone="40px" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_cta btn_style="arrow-animation" heading_tag="h6" text_color="#ffffff" button_color="accent-color" link_type="regular" alignment="left" display="block" link_text="Contact Us" padding_top="15" padding_right="35" padding_bottom="15" padding_left="35"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Clean Self Hosted Video Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-18-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/npo-video-hero.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" scene_position="center" top_padding="12%" constrain_group_1="yes" bottom_padding="12%" top_padding_tablet="20%" bottom_padding_tablet="20%" top_padding_phone="20%" bottom_padding_phone="20%" text_color="dark" text_align="left" overlay_strength="0.8" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1579718474257{margin-bottom: 10px !important;}"]
<h5>Salient WordPress Theme</h5>
[/vc_column_text][split_line_heading animation_type="line-reveal-by-space" font_style="h1" text_content="Build a beautiful website, visually" max_width="475"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_cta btn_style="arrow-animation" heading_tag="h4" text_color="#ffffff" button_color="accent-color" link_type="regular" alignment="left" display="block" link_text="Get Started" margin_top="30" padding_top="20" padding_right="40" padding_bottom="20" padding_left="40"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-4-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-left"][nectar_video_player_self_hosted video_webm="" video_image="https://source.unsplash.com/J1Xhz1AvEzw/1000x600/" loop="yes" border_radius="10px" box_shadow="none"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Promo Video Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-18-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/yellow-header.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffcf6d" scene_position="center" top_padding="15%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="20" overlay_strength="1" gradient_direction="top_to_bottom" enable_shape_divider="true" shape_divider_color="#ffffff" shape_divider_position="bottom" shape_divider_height="20%" bg_image_animation="none" video_mute="true" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="slight-twist"][vc_column_text]
<h4>Salient WordPress Theme</h4>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="13%" constrain_group_2="yes" right_padding_desktop="13%" left_padding_tablet="0" right_padding_tablet="0" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="slight-twist"][nectar_highlighted_text text_color="#000000" style="text_outline" outline_thickness="regular" custom_font_size="10vh"]
<h1>Beautiful &amp; unique
websites made easy</h1>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="0" constrain_group_2="yes" right_padding_desktop="0" text_align="left"][vc_column_inner column_padding="padding-6-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="slight-twist"][nectar_cta btn_style="basic" heading_tag="span" text_color="#000000" button_color="white" button_color_hover="#fff5e2" link_type="regular" alignment="center" constrain_group_1="yes" constrain_group_2="yes" constrain_group_3="yes" constrain_group_4="yes" display="inline" margin_top="20" margin_bottom="20" margin_left="15" margin_right="15" link_text="Why Choose Salient" padding_top="20" padding_bottom="20" padding_left="45" padding_right="45"][nectar_cta btn_style="arrow-animation" heading_tag="span" text_color="#ffffff" button_color="accent-color" button_color_hover="#2643ef" link_type="new_tab" alignment="left" constrain_group_1="yes" constrain_group_2="yes" constrain_group_3="yes" constrain_group_4="yes" display="inline" link_text="Purchase Salient" margin_top="20" margin_bottom="20" margin_left="15" margin_right="15" padding_top="20" padding_bottom="20" padding_left="45" padding_right="45"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="5%" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" left_padding_tablet="0" constrain_group_4="yes" right_padding_tablet="0" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="no-extra-padding" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="200"][nectar_video_player_self_hosted video_image="https://source.unsplash.com/dVRD8E3XUGs/1000x600/" hide_controls="yes" loop="yes" autoplay="yes" border_radius="15px" box_shadow="none"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" top_padding="6%" bottom_padding="8%" left_padding_desktop="12%" constrain_group_2="yes" right_padding_desktop="12%" left_padding_tablet="0" constrain_group_4="yes" right_padding_tablet="0" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.8" gradient_direction="left_t_to_right_b" shape_divider_color="#ff8b50" shape_divider_position="bottom" shape_divider_height="250" bg_image_animation="none" video_mute="true" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="40px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-1-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="left-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/5" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-xs-4"][image_with_animation image_url="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-grey.png" animation="Grow In" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][vc_column_inner column_padding="padding-1-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="left-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/5" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-xs-4"][image_with_animation image_url="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-grey.png" animation="Grow In" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default" delay="70"][/vc_column_inner][vc_column_inner column_padding="padding-1-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="left-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/5" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-xs-4"][image_with_animation image_url="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-grey.png" animation="Grow In" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default" delay="140"][/vc_column_inner][vc_column_inner column_padding="padding-1-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="left-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/5" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_hidden-sm vc_hidden-xs"][image_with_animation image_url="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-grey.png" animation="Grow In" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default" delay="210"][/vc_column_inner][vc_column_inner column_padding="padding-1-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="left-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/5" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_hidden-sm vc_hidden-xs"][image_with_animation image_url="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-grey.png" animation="Grow In" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default" delay="280"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Video Overflow Right', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-18-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/promo-right-overflow-video.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="50px" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="column_reverse" column_direction_phone="column_reverse" bg_color="#ffffff" scene_position="center" top_padding="10%" constrain_group_1="yes" bottom_padding="10%" top_padding_tablet="15%" constrain_group_3="yes" bottom_padding_tablet="15%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.8" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="padding-4-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self"  gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-lg-6"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="15" text_align="left" min_width="47vh"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" enable_border_animation="true" bg_image_animation="none"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_content="Intuitive Interface"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="no-extra-padding" column_padding_phone="inherit" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec posuere mi eget felis placerat, quis condimentum quam mattis. Aenean id diam sit amet lacus.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="no-extra-padding" column_padding_phone="inherit" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_cta btn_style="arrow-animation" heading_tag="span" text_color="#000000" button_color="default" link_type="regular" alignment="left" constrain_group_3="yes" constrain_group_4="yes" display="block" link_text="Discover More" url="#design" padding_top="20" padding_bottom="20"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-4-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-lg-6"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" min_width_desktop="58vw"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_video_player_self_hosted video_image="https://source.unsplash.com/1000x700/daily/?yellow" hide_controls="yes" loop="yes" autoplay="yes" border_radius="10px" box_shadow="none"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Video Overflow Left', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-18-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/promo-left-overflow-video.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" top_padding="10%" bottom_padding="10%" top_padding_tablet="15%" bottom_padding_tablet="15%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="200" id="design" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" left_margin_tablet="auto" right_margin_tablet="auto" left_margin_phone="auto" right_margin_phone="auto" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" max_width_tablet="600px" max_width_phone="420px" gradient_direction="left_to_right" overlay_strength="0.3" width="5/12" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding_tablet="40" translate_x="-20%" translate_x_tablet="0" text_align="left" min_width_desktop="50vw" min_width_tablet="none"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_video_player_self_hosted video_image="https://source.unsplash.com/1000x700/daily/?stars" hide_controls="yes" loop="yes" autoplay="yes" border_radius="10px" box_shadow="none"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-10-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left" left_margin_tablet="auto" right_margin_tablet="auto" left_margin_phone="auto" right_margin_phone="auto" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" max_width_desktop="850" max_width_tablet="600px" max_width_phone="420px" gradient_direction="left_to_right" overlay_strength="0.3" width="7/12" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="15" right_padding_desktop="90" right_padding_tablet="0" text_align="left" min_width="47vh"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" enable_border_animation="true" bg_image_animation="none"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_content="Award-Winning Design"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="40" right_padding_desktop="90" right_padding_tablet="0" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="no-extra-padding" column_padding_phone="inherit" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text]
<div class="wpb_text_column wpb_content_element vc_custom_1490624298920">
<div class="wpb_wrapper">
<h6>For over 7 years, we've focused on creating trend-setting designs that make people stop and stare.  Details matter, and we rush nothing. Quality, not quantity, is what guides us.</h6>
</div>
</div>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="no-extra-padding" column_padding_phone="inherit" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_cta btn_style="arrow-animation" heading_tag="span" text_color="#000000" button_color="default" link_type="regular" alignment="left" constrain_group_3="yes" constrain_group_4="yes" display="block" link_text="Great design for all" url="#" padding_top="20" padding_bottom="20"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Clean Dual CTA', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-17-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/promo-cta.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" top_padding="2%" bottom_padding="7%" top_padding_tablet="8%" bottom_padding_tablet="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_b_to_right_t" overlay_strength="1" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="slight-twist"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding_tablet="10" bottom_padding_phone="5" left_padding_phone="25%" constrain_group_6="yes" right_padding_phone="25%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="slight-twist"][vc_column_text]
<h6>This site was built with Salient</h6>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_highlighted_text text_color="#000000" style="text_outline" outline_thickness="regular" custom_font_size="10vh"]
<h1>You Can Build a</h1>
<h1>Stunning Website</h1>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" column_margin="none" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" bottom_padding="8%" text_color="dark" text_align="left" row_border_radius="10px" row_border_radius_applies="inner" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color="#ffcf6d" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="center" phone_text_alignment="center" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding_tablet="10" left_padding_tablet="20%" constrain_group_4="yes" right_padding_tablet="20%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/RYyr-k3Ysqg" background_image_position="left top" enable_bg_scale="true" column_shadow="none" column_border_radius="none" column_link_target="_self" enable_gradient="true" color_overlay_2="#ffcf6d" gradient_direction="left_to_right" overlay_strength="1" width="5/6" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-lg-6 vc_col-md-5 vc_hidden-sm vc_hidden-xs"][/vc_column_inner][vc_column_inner column_padding="padding-15-percent" column_padding_tablet="padding-8-percent" column_padding_phone="padding-8-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-lg-5 vc_col-md-6"][vc_column_text css=".vc_custom_1586179428508{margin-bottom: 50px !important;}"]Start by checking out the premade demo websites to see what's possible.[/vc_column_text][nectar_cta btn_style="basic" heading_tag="span" text_color="#ffffff" button_color="accent-color" button_color_hover="#2643ef" link_type="video_lightbox" alignment="left" display="block" link_text="See The Magic" url="https://www.youtube.com/watch?v=RDC1ZFFhZq8" padding_top="15" padding_right="35" padding_bottom="15" padding_left="35"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/800x600/daily/?sky" background_image_position="center center" enable_bg_scale="true" column_shadow="none" column_border_radius="none" column_link_target="_self" color_overlay="#3452ff" gradient_direction="left_to_right" overlay_strength="0.8" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding_tablet="10" text_align="left"][vc_column_inner column_padding="padding-12-percent" column_padding_tablet="inherit" column_padding_phone="padding-8-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" font_color="#ffffff" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_column_text css=".vc_custom_1586179434669{margin-bottom: 50px !important;}" max_width="280"]Salient is the ultimate WordPress theme for building beautiful websites.[/vc_column_text][nectar_cta btn_style="arrow-animation" heading_tag="span" text_color="#000000" button_color="white" button_color_hover="#e8e8ff" link_type="regular" alignment="center" display="block" link_text="Purchase Salient" url="#" padding_top="15" padding_right="35" padding_bottom="15" padding_left="35"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Sticky Vertical Tabs', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-17-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/sticky-tabs.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" top_padding="6%" bottom_padding="6%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][tabbed_section style="vertical_scrolling" tab_color="Accent-Color" vs_navigation_width="regular" vs_navigation_spacing="45px" vs_tab_spacing="40%" vs_tab_tag="h3"][tab icon_family="none" title="The Best Features" id="1586441707425-5" sub_desc="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia." tab_id="1586441707426-2"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_video_player_self_hosted video_image="https://source.unsplash.com/MwmFJL5AYkU" border_radius="10px" box_shadow="none"][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="none" title="Intuitive User Interface" id="1586441707538-9" sub_desc="Separated they live in Bookmarksgrove right at the coast of the Semantics." tab_id="1586441707540-6"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_custom_heading text="Look deep into nature, and then you will understand everything better." font_container="tag:h2|font_size:40|text_align:left|line_height:50px" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text css=".vc_custom_1586380254133{padding-right: 10% !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="100"][vc_column_text css=".vc_custom_1586380260249{padding-right: 10% !important;}"]Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.[/vc_column_text][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="none" title="Scorching Hot Design" id="1586441707700-1" sub_desc="It is a paradisematic country, in which roasted parts of sentences fly into your mouth." tab_id="1586441707701-2"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_custom_heading text="Try not to become a man of success, but rather try to become a man of value." font_container="tag:h2|font_size:40|text_align:left|line_height:50px" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text css=".vc_custom_1586380277392{padding-right: 10% !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="100"][vc_column_text css=".vc_custom_1586380281399{padding-right: 10% !important;}"]Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.[/vc_column_text][/vc_column_inner][/vc_row_inner][/tab][/tabbed_section][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Dark Sticky Vertical Tabs', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-8-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/sticky-tabs-dark.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#000000" scene_position="center" top_padding="10%" constrain_group_1="yes" bottom_padding="10%" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][tabbed_section style="vertical_scrolling" tab_color="extra-color-gradient-1" vs_navigation_width="regular" vs_navigation_spacing="45px" vs_tab_spacing="40%" vs_tab_tag="h3"][tab icon_family="none" title="Best Features Provided" id="1586451527673-0" tab_id="1586451527675-4"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_video_player_self_hosted video_image="https://source.unsplash.com/3WQdiZPCtnM" border_radius="10px" box_shadow="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text css=".vc_custom_1586450820355{padding-right: 10% !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. They live.[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="100"][vc_column_text css=".vc_custom_1586450820355{padding-right: 10% !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. They live.[/vc_column_text][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="none" title="Intuitive User Interface" id="1586451527867-5" tab_id="1586451527868-3"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_video_player_self_hosted video_image="https://source.unsplash.com/pocktEPqo6o" border_radius="10px" box_shadow="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text css=".vc_custom_1586450830737{padding-right: 10% !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. They live.[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="100"][vc_column_text css=".vc_custom_1586450830737{padding-right: 10% !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. They live.[/vc_column_text][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="none" title="Scorching Hot Design" id="1586451528012-3" tab_id="1586451528013-6"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_custom_heading text="Try not to become a man of success, but rather try to become a man of value." font_container="tag:h2|font_size:40|text_align:left|line_height:50px" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text css=".vc_custom_1586380277392{padding-right: 10% !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="100"][vc_column_text css=".vc_custom_1586380281399{padding-right: 10% !important;}"]Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.[/vc_column_text][/vc_column_inner][/vc_row_inner][/tab][/tabbed_section][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Services Carousel', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['services'];
$data['custom_class'] = 'services date-18-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/promo-services-carousel.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="14%" constrain_group_1="yes" bottom_padding="14%" top_padding_tablet="20%" constrain_group_3="yes" bottom_padding_tablet="20%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" id="more-features" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="15" text_align="left"][vc_column_inner column_padding="padding-4-percent" column_padding_tablet="padding-13-percent" column_padding_phone="padding-4-percent" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text css_animation="none" css=".vc_custom_1585945715457{margin-bottom: 20px !important;}" max_width="500"]
<h2>Salient is loaded with the features you need</h2>
[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="100"][nectar_single_testimonial testimonial_style="basic" quote="Salient is an overall amazing theme. It packs all the features one may need, it's snappy, fast, incredibly user-friendly, and is by far, one of the best I've used."][nectar_cta btn_style="arrow-animation" heading_tag="span" text_color="#000000" button_color="default" link_type="regular" alignment="left" constrain_group_3="yes" display="block" link_text="See what people are saying" url="#" padding_top="20" padding_bottom="20" margin_top="40"][/vc_column_inner][/vc_row_inner][carousel script="flickity" flickity_formatting="default" desktop_cols_flickity="3" desktop_small_cols_flickity="3" tablet_cols_flickity="2" flickity_controls="touch_total" flickity_touch_total_hide_indicator="true" color="default" flickity_overflow="visible" flickity_wrap_around="no-wrap" flickity_spacing="20px" column_padding="0" flickity_image_scale_on_drag="true" border_radius="none" touch_total_hide_indicator="true"][item id="1586088313912-3" tab_id="1586088313913-8" title="Item"][fancy_box box_style="color_box_hover" icon_family="iconsmind" image_url="https://source.unsplash.com/600x600/daily/?fun" color="accent-color" color_custom="#000000" color_box_hover_overlay_opacity="0.5" box_alignment="left" enable_border="true" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" icon_iconsmind="iconsmind-Edit" min_height="300" min_height_tablet="275" min_height_phone="255"]
<h3>Front-end Editor &amp; Back-end Editor</h3>
Edit your site visually or through a simplified interface. The choice is yours.[/fancy_box][/item][item id="1586088314180-7" tab_id="1586088314181-8" title="Item"][fancy_box box_style="color_box_hover" icon_family="iconsmind" image_url="https://source.unsplash.com/600x600/daily/?nature" color="accent-color" color_custom="#000000" color_box_hover_overlay_opacity="0.5" box_alignment="left" enable_border="true" border_radius="default" image_loading="lazy-load" enable_animation="true" animation="none" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" icon_iconsmind="iconsmind-Duplicate-Layer" min_height="300" min_height_tablet="275" min_height_phone="255"]
<h3>Huge Collection of Elements</h3>
Over 55 unique page builder elements to create your masterpiece.[/fancy_box][/item][item id="1586088314414-2" tab_id="1586088314415-9" title="Item"][fancy_box box_style="color_box_hover" icon_family="iconsmind" image_url="https://source.unsplash.com/600x600/daily/?animal" color="accent-color" color_custom="#000000" color_box_hover_overlay_opacity="0.5" box_alignment="left" enable_border="true" border_radius="default" image_loading="lazy-load" enable_animation="true" animation="none" color_scheme="dark" secondary_content="" icon_iconsmind="iconsmind-Flash" min_height="300" min_height_tablet="275" min_height_phone="255"]
<h3>Blazing Fast Performance</h3>
97% PageSpeed score &amp; 93% YSlow Score on GTMetrix.[/fancy_box][/item][item id="1586088314647-8" tab_id="1586088314648-4" title="Item"][fancy_box box_style="color_box_hover" icon_family="iconsmind" image_url="https://source.unsplash.com/600x600/daily/?mountains" color="accent-color" color_custom="#000000" color_box_hover_overlay_opacity="0.5" box_alignment="left" enable_border="true" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" icon_iconsmind="iconsmind-Window-2" min_height="300" min_height_tablet="275" min_height_phone="255"]
<h3>Suitable for Any Website</h3>
Unlimited customization possibilities allow Salient to shine no matter the use case.[/fancy_box][/item][item id="1586088314855-1" tab_id="1586088314856-6" title="Item"][fancy_box box_style="color_box_hover" icon_family="iconsmind" image_url="https://source.unsplash.com/600x600/daily/?happy" color="accent-color" color_custom="#000000" color_box_hover_overlay_opacity="0.5" box_alignment="left" enable_border="true" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="" icon_iconsmind="iconsmind-Monitor-phone" min_height="300" min_height_tablet="275" min_height_phone="255"]
<h3>Ultra Responsive and Retina Ready</h3>
Built with mobile in mind rather than it being an afterthought.[/fancy_box][/item][item id="1586088315048-2" tab_id="1586088315049-6" title="Item"][fancy_box box_style="color_box_hover" icon_family="iconsmind" image_url="https://source.unsplash.com/600x600/daily/?smile" color="accent-color" color_custom="#000000" color_box_hover_overlay_opacity="0.5" box_alignment="left" enable_border="true" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" icon_iconsmind="iconsmind-Newsvine" min_height="300" min_height_tablet="275" min_height_phone="255"]
<h3>Frequently Updated With New Features</h3>
With a single purchase, you'll enjoy lifetime updates.[/fancy_box][/item][item id="1586088315255-9" tab_id="1586088315257-6" title="Item"][fancy_box box_style="color_box_hover" icon_family="iconsmind" image_url="https://source.unsplash.com/600x600/daily/?office" color="accent-color" color_custom="#000000" color_box_hover_overlay_opacity="0.5" box_alignment="left" enable_border="true" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" icon_iconsmind="iconsmind-Capricorn-2" min_height="300" min_height_tablet="275" min_height_phone="255"]
<h3>Thousands of Beautiful Icons</h3>
3,500+ icons ($59 value) are included to choose from.[/fancy_box][/item][item id="1586088315454-0" tab_id="1586088315455-4" title="Item"][fancy_box box_style="color_box_hover" icon_family="iconsmind" image_url="https://source.unsplash.com/600x600/daily/?trees" color="accent-color" color_custom="#000000" color_box_hover_overlay_opacity="0.5" box_alignment="left" enable_border="true" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" icon_iconsmind="iconsmind-Cursor-Click2" min_height="300" min_height_tablet="275" min_height_phone="255"]
<h3>One-Click Demo Importer</h3>
Get started in a flash with our user-friendly demo importer.[/fancy_box][/item][item id="1586088315649-9" tab_id="1586088315650-1" title="Item"][fancy_box box_style="color_box_hover" icon_family="iconsmind" image_url="https://source.unsplash.com/600x600/daily/?city" color="accent-color" color_custom="#000000" color_box_hover_overlay_opacity="0.5" box_alignment="left" enable_border="true" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" icon_iconsmind="iconsmind-Book" min_height="300" min_height_tablet="275" min_height_phone="255"]
<h3>Salient Help Center</h3>
Find the answers you're looking for or request assistance in our forum.[/fancy_box][/item][/carousel][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Autoplaying Video Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-04-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/promo-hero.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" bg_image="https://source.unsplash.com/AC6qkD4Jv9w" bg_position="left top" bg_repeat="no-repeat" scene_position="center" top_padding="14%" constrain_group_1="yes" bottom_padding="14%" top_padding_tablet="20%" constrain_group_3="yes" bottom_padding_tablet="20%" top_padding_phone="20%" bottom_padding_phone="20%" text_color="light" text_align="left" color_overlay="#1b1c26d9" overlay_strength="0.8" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="zoom-out-slow" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1579718474257{margin-bottom: 10px !important;}"]
<h5>Salient WordPress Theme</h5>
[/vc_column_text][split_line_heading animation_type="line-reveal-by-space" font_style="h1" text_content="Build a beautiful website, visually" max_width="475"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="padding-4-percent" column_padding_phone="padding-4-percent" column_padding_position="bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="450"][nectar_video_lightbox link_style="play_button_with_text" nectar_play_button_color="Default-Accent-Color" nectar_play_button_style="default" font_style="h4" video_url="https://www.youtube.com/watch?v=6oTurM7gESE etc." link_text="Watch how easy it is"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="grow-in" delay="300"][nectar_video_player_self_hosted video_webm="" video_image="https://source.unsplash.com/RPMcxbm2zi4/1000x600/" hide_controls="yes" loop="yes" autoplay="yes" border_radius="10px" box_shadow="x_large_depth"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Dark Portfolio Grid Cards', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['portfolio'];
$data['custom_class'] = 'portfolio date-7-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/promo-dark-post-grid.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#131418" scene_position="center" top_padding="14%" bottom_padding="14%" top_padding_tablet="20%" bottom_padding_tablet="20%" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="35" left_padding_desktop="24%" constrain_group_2="yes" right_padding_desktop="24%" bottom_padding_tablet="25" constrain_group_4="yes" left_padding_phone="12%" constrain_group_6="yes" right_padding_phone="12%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_content="Pre-built Websites Included with Salient" max_width="435"][/split_line_heading][/vc_column_inner][/vc_row_inner][nectar_post_grid post_type="portfolio" portfolio_category="all" order="DESC" orderby="date" pagination="load-more" button_color="accent-color" columns="3" grid_item_spacing="25px" grid_item_height="30vh" enable_sortable="yes" sortable_color="accent-color" enable_masonry="yes" image_size="portfolio-thumb_large" aspect_ratio_image_size="yes" image_loading="lazy-load" animation="fade-in-from-bottom" heading_tag="h4" enable_indicator="yes" mouse_indicator_style="default" mouse_indicator_text="view" mouse_indicator_color="#3452ff" display_categories="yes" category_functionality="static" grid_style="content_under_image" card_design="yes" card_bg_color="#1f2125" card_bg_color_hover="#25272b" content_under_image_text_align="center" text_color="light" hover_effect="none" border_radius="10px" card_design_bg_color="#00cae8" posts_per_page="15" css_class_name="nectar-browser-window-style"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Single Testimonial', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['testimonials'];
$data['custom_class'] = 'testimonials date-16-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/clean-image-testimonial.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" top_padding="14%" constrain_group_1="yes" bottom_padding="14%" top_padding_tablet="20%" constrain_group_3="yes" bottom_padding_tablet="20%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_b_to_right_t" overlay_strength="1" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="90px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="padding-3-percent" column_padding_phone="inherit" column_padding_position="bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][image_with_animation image_url="https://source.unsplash.com/800x800/daily/?happy" animation="None" hover_animation="none" alignment="" border_radius="15px" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_single_testimonial testimonial_style="basic" quote="I'm wondering why I never contacted these guys sooner! Seriously, they all have commendable talent in their respective fields and knocked my concept out of the ballpark. Thanks for an amazing experience!" name="phil martinez" subtitle="Interior Decorator"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'SVG Draw Animation Icons', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['icons']  .', '. $cat_display_names['general'];
$data['custom_class'] = 'general icons';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/svg_icon_draw.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#3a6ee8" scene_position="center" text_color="light" text_align="center" top_padding="16%" bottom_padding="5%" overlay_strength="0.3" shape_divider_position="bottom"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/6" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="linea" enable_animation="true" animation_speed="fast" icon_style="default" icon_color="Extra-Color-3" icon_padding="0px" icon_linea="icon-software-transform-bezier" icon_size="60"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid"][vc_column_text]
<h6>Sexy Design</h6>
[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/6" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="linea" enable_animation="true" animation_speed="fast" icon_style="default" icon_color="Extra-Color-3" icon_padding="0px" icon_linea="icon-basic-mixer2" icon_size="60" animation_delay="500"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" delay="500"][vc_column_text]
<h6>True Power</h6>
[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/6" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="linea" enable_animation="true" animation_speed="fast" icon_style="default" icon_color="Extra-Color-3" icon_padding="0px" icon_linea="icon-weather-wind-fullmoon" icon_size="60" animation_delay="1000"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" delay="1000"][vc_column_text]
<h6>Icon Paradise</h6>
[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/6" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="linea" enable_animation="true" animation_speed="fast" icon_style="default" icon_color="Extra-Color-3" icon_padding="0px" icon_linea="icon-software-layout-header-complex" icon_size="60" animation_delay="1500"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" delay="1500"][vc_column_text]
<h6>Page Builder</h6>
[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/6" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="linea" enable_animation="true" animation_speed="fast" icon_style="default" icon_color="Extra-Color-3" icon_padding="0px" icon_linea="icon-ecommerce-diamond" icon_size="60" animation_delay="2000"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" delay="2000"][vc_column_text]
<h6>Top Quality</h6>
[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/6" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="linea" enable_animation="true" animation_speed="fast" icon_style="default" icon_color="Extra-Color-3" icon_padding="0px" icon_linea="icon-software-paintroller" icon_size="60" animation_delay="2500"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" delay="2500"][vc_column_text]
<h6>Customizable</h6>
[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#3a6ee8" scene_position="center" text_color="light" text_align="left" bottom_padding="17%" overlay_strength="0.3" shape_divider_position="bottom"][vc_column enable_animation="true" animation="fade-in" column_padding="padding-1-percent" column_padding_position="left-right" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text]
<h3 style="text-align: right;">Hello. We're Salient, A Creative Agency Located In New York City. Take A Look Around &amp; Don't Be Shy.</h3>
[/vc_column_text][/vc_column][vc_column enable_animation="true" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" font_color="#cdf4f4" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid"][vc_column_text]Phasellus enim libero, blandit vel sapien vitae, condimentum ultricies magna et. Quisque euismod orci ut et lobortis aliquam.[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid"][vc_column_text]Phasellus enim libero, blandit vel sapien vitae, condimentum ultricies magna et. Quisque euismod orci ut et lobortis aliquam.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid"][vc_column_text]Phasellus enim libero, blandit vel sapien vitae, condimentum ultricies magna et. Quisque euismod orci ut et lobortis aliquam.[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid"][vc_column_text]Phasellus enim libero, blandit vel sapien vitae, condimentum ultricies magna et. Quisque euismod orci ut et lobortis aliquam.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Mouse Based Parallax', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['about'] .', '. $cat_display_names['hero_section'];
$data['custom_class'] = 'about hero_section';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/mouse_parallax.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" mouse_based_parallax_bg="true" scene_position="center" mouse_sensitivity="19" layer_one_image="http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/Comp-1-0-00-15-11_1.jpg" layer_one_strength="0.11" layer_two_image="http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/mountains.png" layer_two_strength="0.24" layer_three_image="http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/ground-revised.png" layer_three_strength="0.5" text_color="light" text_align="left" top_padding="20%" bottom_padding="18%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/1" tablet_text_alignment="default" phone_text_alignment="default"][vc_column_text]<h1 class="jumbo">Hello</h1><h5><i>We are Salient. It's nice to meet you!</i></h5>[/vc_column_text][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Fondly Simple Service List', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['icons'] .', '. $cat_display_names['services'] .', '. $cat_display_names['general'];
$data['custom_class'] = 'icons services general date-15-Oct-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/services-icons.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="0.5"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="2/3" column_border_width="none" column_border_style="solid"][vc_custom_heading text="We make it simple to share your ideas with target audiences." font_container="tag:h2|font_size:48px|text_align:center|line_height:57px" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="2/3" column_border_width="none" column_border_style="solid" delay="50"][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. A small river named Duden." font_container="tag:p|text_align:center|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="none" css=".vc_custom_1485869848994{padding-right: 13% !important;padding-left: 13% !important;}"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="20" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="grey" icon_padding="0px" icon_iconsmind="iconsmind-Upload-toCloud" url="#"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485869613252{margin-bottom: 15px !important;}"]
<h5>Upload your ideas to Salient</h5>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and texts" font_container="tag:p|text_align:center|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid" delay="100"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="grey" icon_padding="0px" icon_iconsmind="iconsmind-D-Eyeglasses2" url="#"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485869633028{margin-bottom: 15px !important;}"]
<h5>Watch the magic happen</h5>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and texts" font_container="tag:p|text_align:center|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid" delay="200"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="grey" icon_padding="0px" icon_iconsmind="iconsmind-Happy" url="#"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485869652646{margin-bottom: 15px !important;}"]
<h5>Enjoy your increased revenue</h5>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and texts" font_container="tag:p|text_align:center|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][nectar_btn size="large" button_style="see-through-2" color_override="#b2b2b2" hover_color_override="#0a0a0a" hover_text_color_override="#ffffff" icon_family="none" url="#" text="Learn More" margin_top="50"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Restaurant CTA', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['cta'];
$data['custom_class'] = 'cta date-27-Sep-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/eat-with-us.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/iRguZkRTQyA" bg_position="center center" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" bg_color="#000000" scene_position="center" text_color="light" text_align="left" top_padding="8%" bottom_padding="8%" color_overlay="#000000" overlay_strength="0.8"][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" width="2/3" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1487011499391{margin-bottom: 35px !important;}"]
<h2>Come in and eat with us</h2>
[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][vc_column_text]<strong>Monday – Thursday:</strong> 9:00 am – 10:00 pm[/vc_column_text][vc_custom_heading text="<i>Food service until 9:00 pm</i>" font_container="tag:p|text_align:center|color:rgba(255%2C255%2C255%2C0.7)" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid" delay="100"][vc_column_text]<strong>Friday - Saturday:</strong> 9:00 am – Midnight[/vc_column_text][vc_custom_heading text="<i>Food service until 10:00 pm</i>" font_container="tag:p|text_align:center|color:rgba(255%2C255%2C255%2C0.7)" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid" delay="200"][vc_column_text]<strong>Sunday:</strong> 11:00 am – 10:00 pm[/vc_column_text][vc_custom_heading text="<i>Food service until 9:00 pm</i>" font_container="tag:p|text_align:center|color:rgba(255%2C255%2C255%2C0.7)" use_theme_fonts="yes"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="300"][nectar_btn size="jumbo" open_new_tab="true" button_style="regular" button_color_2="Accent-Color" icon_family="none" url="http://opentable.com" text="Make A Reservation" margin_top="35"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );






$data = array();
$data['name'] = esc_html__( 'Tour Schedule Dark', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'];
$data['custom_class'] = 'general date-03-Oct-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/dark-tour.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/ePfBHXM0tyA" bg_position="left top" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" bg_color="#111111" scene_position="center" text_color="light" text_align="left" top_padding="10%" bottom_padding="10%" color_overlay="#0a0a0a" overlay_strength="0.95"][vc_column enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1486348408362{margin-bottom: 90px !important;}"]
<h1>USA Tour</h1>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="small_first_last" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" font_family="h6" hover_color="accent-color" col_1_content="May 24" col_2_content="Massey Hall" col_3_content="Toronto, ON" cta_1_text="Buy Tickets"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="small_first_last" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" font_family="h6" hover_color="accent-color" col_1_content="May 28" col_2_content="Electric Factory" col_3_content="Philadelphia, PA" cta_1_text="Buy Tickets"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="small_first_last" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" font_family="h6" hover_color="accent-color" col_1_content="June 12" col_2_content="Manhattan Center" col_3_content="New York, NY" cta_1_text="Buy Tickets" cta_1_url="#"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="small_first_last" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" font_family="h6" hover_color="accent-color" col_1_content="June 25" col_2_content="BB&amp;T Pavilion" col_3_content="Camden, NJ" cta_1_text="Buy Tickets" cta_1_url="#"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="small_first_last" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" font_family="h6" hover_color="accent-color" col_1_content="July 02" col_2_content="Aragon Ballroom" col_3_content="Chicago, IL" cta_1_text="Buy Tickets"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="small_first_last" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" font_family="h6" hover_color="accent-color" col_1_content="July 08" col_2_content="WaMu Theater" col_3_content="Seattle, WA" cta_1_text="Buy Tickets" cta_1_url="#"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="small_first_last" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" font_family="h6" hover_color="accent-color" col_1_content="July 15" col_2_content="Fox Theater" col_3_content="Oakland, CA" cta_1_text="Buy Tickets" cta_1_url="#"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="small_first_last" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" font_family="h6" hover_color="accent-color" col_1_content="July 21" col_2_content="Shrine Expo Hall" col_3_content="Los Angeles" cta_1_text="Buy Tickets"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Awesome Shape Divider Hero', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-20-Oct-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/corporate-2-landing.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" video_bg="use_video" video_mute="true" video_webm="" video_mp4="" video_external="https://www.youtube.com/watch?v=4BfKFCOCJe8" text_color="light" text_align="left" top_padding="12%" bottom_padding="7%" enable_gradient="true" color_overlay="#3452ff" color_overlay_2="#ff1053" gradient_direction="left_t_to_right_b" overlay_strength="0.8" enable_shape_divider="true" shape_divider_color="#ffffff" shape_divider_position="bottom" shape_divider_height="250" shape_type="curve"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column centered_text="true" column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1504325323751{margin-bottom: 15px !important;}"]
<h5>Have you noticed</h5>
[/vc_column_text][split_line_heading text_content="Small details create the big picture"][/split_line_heading][nectar_btn size="large" button_style="see-through-2" color_override="#ffffff" hover_color_override="#ffffff" hover_text_color_override="#000000" icon_family="none" url="#creative-services" text="Learn More" margin_top="25" css_animation="slideInUp" margin_bottom="85"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="padding-4-percent" column_padding_position="left-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" bottom_margin="-26%" width="1/1" column_border_width="none" column_border_style="solid"][nectar_video_lightbox link_style="play_button_2" nectar_play_button_color="Default-Accent-Color" image_url="https://source.unsplash.com/800x600/daily/?face,happy" hover_effect="defaut" box_shadow="x_large_depth" border_radius="10px" play_button_size="larger" video_url="https://www.youtube.com/watch?v=i9NZfXRnA70"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Color Changing Client Rows', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'] .', '. $cat_display_names['about'];
$data['custom_class'] = 'general about date-20-Oct-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/clients-hover-color.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle"  bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="7%" bottom_padding="7%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="10/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][clients columns="4" hover_effect="greyscale_to_color" additional_padding="4"][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1502894777216-0-4" tab_id="1502894621516-2" url="#" name="elevate"]  [/client][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1502894065-1-80" tab_id="1502894621516-3" url="#" name="harper"] [/client][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1502894782547-0-5" tab_id="1502894621516-4" url="#" name="waveform"] [/client][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1502894777848-0-9" tab_id="1502894621516-5" url="#" name="brooklyn"] [/client][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1502894784816-0-0" tab_id="1502894621516-9" url="#" name="camallero"][/client][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1503948180817-0-9" tab_id="1502894621516-6" url="#" name="ollostream"] [/client][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1503948181836-0-4" tab_id="1502894621516-7" url="#" name="golden grid"][/client][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1502894776482-0-6" tab_id="1502894621516-8" url="#" name="jacks"] [/client][/clients][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Delightful Service Blocks', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['services'];
$data['custom_class'] = 'services date-20-Oct-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/colorful-services.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" scene_position="center" text_color="dark" text_align="left" top_padding="5%" bottom_padding="5%" id="creative-services" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="padding-2-percent" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text]
<h3>Striving to make the web a more beautiful place every single day</h3>
[/vc_column_text][vc_column_text css=".vc_custom_1504286255898{padding-right: 10% !important;}"]Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes.[/vc_column_text][nectar_btn size="large" button_style="see-through-2" color_override="#ff1053" hover_color_override="#ff1053" hover_text_color_override="#ffffff" icon_family="default_arrow" url="#explainer" text="Learn More" margin_top="15"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="none" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_basic" icon_family="iconsmind" box_color="#2ac4ea" content_color="#ffffff" box_color_opacity="0.6" box_alignment="left" enable_animation="true" animation="fade-in-from-bottom" color_scheme="none" secondary_content="here's some awesome text that would only be shown on hover" min_height="0" link_url="#http://google.com" icon_iconsmind="iconsmind-Environmental-3" css=".vc_custom_1504285427120{margin-top: 50px !important;margin-bottom: 2em !important;padding-top: 15% !important;padding-right: 15% !important;padding-bottom: 15% !important;padding-left: 15% !important;}" icon_size="40"]
<h4>Natural Flow</h4>
Sed cursus turpis vitae tortor donec eaque ipsa quaeab illo.[/fancy_box][fancy_box box_style="color_box_basic" icon_family="iconsmind" box_color_opacity="1" box_alignment="left" enable_animation="true" animation="fade-in-from-bottom" color_scheme="none" secondary_content="here's some awesome text that would only be shown on hover" min_height="0" link_url="#" icon_iconsmind="iconsmind-Sun" css=".vc_custom_1504285795178{margin-bottom: 50px !important;padding-top: 15% !important;padding-right: 15% !important;padding-bottom: 15% !important;padding-left: 15% !important;}" icon_size="40"]
<h4>Hot Looks</h4>
Nemo enim ipsam volup tatem quia vol uptas sit sunt in.[/fancy_box][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_basic" icon_family="iconsmind" box_color="#ff1053" box_color_opacity="1" box_alignment="left" enable_animation="true" animation="fade-in-from-bottom" color_scheme="none" secondary_content="here's some awesome text that would only be shown on hover" min_height="0" link_url="#" icon_iconsmind="iconsmind-Rock-andRoll" css=".vc_custom_1504285430965{margin-bottom: 2em !important;padding-top: 15% !important;padding-right: 15% !important;padding-bottom: 15% !important;padding-left: 15% !important;}" delay="100" icon_size="40"]
<h4>Awesome Design</h4>
Nam libero tempore, cum soluta nobis placeat facere.[/fancy_box][fancy_box box_style="color_box_basic" icon_family="iconsmind" box_color="#fbbc05" box_color_opacity="1" box_alignment="left" enable_animation="true" animation="fade-in-from-bottom" color_scheme="none" secondary_content="here's some awesome text that would only be shown on hover" min_height="0" link_url="#" icon_iconsmind="iconsmind-Atom" delay="100" css=".vc_custom_1504286112774{padding-top: 15% !important;padding-right: 15% !important;padding-bottom: 15% !important;padding-left: 15% !important;}" icon_size="40"]
<h4>Unrivaled Quality</h4>
At vero eos et lorem accusamus et iusto ullam corporis.[/fancy_box][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_basic" icon_family="iconsmind" box_color="#2f88d6" content_color="#ffffff" box_color_opacity="1" box_alignment="left" enable_animation="true" animation="fade-in-from-bottom" color_scheme="none" secondary_content="here's some awesome text that would only be shown on hover" min_height="0" link_url="#" icon_iconsmind="iconsmind-Motorcycle" css=".vc_custom_1504286068726{margin-top: 50px !important;margin-bottom: 2em !important;padding-top: 15% !important;padding-right: 15% !important;padding-bottom: 15% !important;padding-left: 15% !important;}" delay="200" icon_size="40"]
<h4>Visual Builder</h4>
Ipsum totam rem aperiam, eaque ipsa quae ab illo.[/fancy_box][fancy_box box_style="color_box_basic" icon_family="iconsmind" box_color="#34a853" box_color_opacity="1" box_alignment="left" enable_animation="true" animation="fade-in-from-bottom" color_scheme="none" secondary_content="here's some awesome text that would only be shown on hover" min_height="0" link_url="#" icon_iconsmind="iconsmind-Folder-Organizing" delay="200" css=".vc_custom_1504286089409{padding-top: 15% !important;padding-right: 15% !important;padding-bottom: 15% !important;padding-left: 15% !important;}" icon_size="40"]
<h4>Ton of Features</h4>
Incidunt ut labore et dolore magnam ali quam quaerat.[/fancy_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Quick FAQ & Overflowing Image', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'];
$data['custom_class'] = 'general date-20-Oct-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/quick-faq-and-image.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" scene_position="center" text_color="dark" text_align="left" top_padding="6%" bottom_padding="6%" id="explainer" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="padding-2-percent" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1505433788851{margin-bottom: 30px !important;}"]
<h3>Salient Studio changes the WordPress game forever.</h3>
[/vc_column_text][toggles style="minimal_small" accordion="true"][toggle color="Default" title="Over 200 Section Templates"][vc_column_text]Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque.[/vc_column_text][/toggle][toggle color="Default" title="Available Directly in Page Builder"][vc_column_text]Malesuada fames ac turpis egestas. Ut non enim eleifend felis pretium feugiat. Vivamus quis mi.[/vc_column_text][/toggle][toggle color="Default" title="One Click Template Insert"][vc_column_text]Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc, quis gravida magna mi a libero.[/vc_column_text][/toggle][/toggles][nectar_btn size="large" button_style="see-through-2" color_override="#3452ff" hover_text_color_override="#ffffff" icon_family="default_arrow" url="http://themenectar.com/demo/salient-corporate-2/about-us" text="Learn More" margin_top="35"][/vc_column][vc_column column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][image_with_animation image_url="https://source.unsplash.com/1200x800/daily/?office" alignment="" animation="Fade In From Right" border_radius="10px" box_shadow="x_large_depth" max_width="150%"][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Monotone Milestones', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['counters'];
$data['custom_class'] = 'counters date-20-Oct-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/minimal-milestones.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="6%" bottom_padding="6%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="5/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text max_width="500"]
<h3>Helping people reclaim their time</h3>
[/vc_column_text][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" column_border_width="none" column_border_style="solid"][milestone heading_inherit="h2" symbol_position="after" subject_padding="2%" color="Default" effect="count" symbol_alignment="Superscript" milestone_alignment="default" number="97" symbol="%" subject="Percent of users recommend us to friends and family" number_font_size="92" symbol_font_size="40"][/vc_column_inner][vc_column_inner column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" column_border_width="none" column_border_style="solid"][milestone heading_inherit="h2" symbol_position="after" subject_padding="2%" color="Default" effect="count" symbol_alignment="Superscript" milestone_alignment="default" number="350" subject="Companies have shifted to using us recently" number_font_size="92" symbol="+" symbol_font_size="42"][/vc_column_inner][vc_column_inner column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" column_border_width="none" column_border_style="solid"][milestone heading_inherit="h2" symbol_position="after" subject_padding="2%" color="Default" effect="count" symbol_alignment="Superscript" milestone_alignment="default" number="16" subject="We deliver so much more than the competition " number_font_size="92" symbol="x" symbol_font_size="40"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Auto Masonry Recent Posts', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['blog'];
$data['custom_class'] = 'blog date-19-Oct-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/auto-masonry-recent-posts.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="6%" bottom_padding="6%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text max_width="500" css=".vc_custom_1503969123885{margin-bottom: 40px !important;}"]
<h3>Our Recent Writings</h3>
[/vc_column_text][/vc_column_inner][/vc_row_inner][nectar_blog layout="masonry-blog-fullwidth" blog_masonry_style="auto_meta_overlaid_spaced" auto_masonry_spacing="16px" category="all" load_in_animation="none" order="DESC" orderby="date" posts_per_page="3"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" bottom_margin="20" width="1/1" column_border_width="none" column_border_style="solid"][nectar_cta btn_style="material" heading_tag="h4" text_color="#34a853" link_type="regular" alignment="center" text="Like what you see?" link_text="See more posts" url="http://themenectar.com/demo/salient-corporate-2/news"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Rounded Box Over Shape Divider', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['cta'];
$data['custom_class'] = 'cta date-20-Oct-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/color-box-cta.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#f2f2f2" scene_position="center" text_color="dark" text_align="left" top_padding="60" overlay_strength="0.3" enable_shape_divider="true" shape_divider_color="#ffffff" shape_divider_position="top" shape_divider_height="80" shape_type="curve"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" font_color="#ffffff" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" translate_y="-50%"][vc_row_inner column_margin="default" translate_y="-50%" text_align="left"][vc_column_inner enable_animation="true" animation="flip-in-vertical" column_padding="padding-5-percent" column_padding_position="all" centered_text="true" background_color="#ff1053" background_color_opacity="1" background_hover_color_opacity="1" font_color="#ffffff" column_shadow="x_large_depth" column_border_radius="20px" top_margin="15" width="1/1" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="15"][vc_custom_heading text="Build your dream website today." font_container="tag:h3|text_align:center" google_fonts="font_family:Nunito%3A300%2Cregular%2C700|font_style:700%20bold%20regular%3A700%3Anormal"][nectar_btn size="large" open_new_tab="true" button_style="see-through-2" color_override="#ffffff" hover_color_override="#ffffff" hover_text_color_override="#000000" icon_family="none" url="https://themeforest.net/item/salient-responsive-multipurpose-theme/4363266" text="Purchase Salient" margin_top="30" margin_bottom="1"][divider line_type="No Line" custom_height="15"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Impactful Header Text', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'] .', '. $cat_display_names['hero_section'];
$data['custom_class'] = 'general hero_section';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/impactful-header.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="8%" bottom_padding="10%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid"][nectar_gradient_text heading_tag="h5" color="extra-color-gradient-2" gradient_direction="horizontal" text="Together We Build Dreams"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1504326206457{margin-bottom: 20px !important;}"]
<h2>A wonderful serenity <strong>has</strong> <strong>taken possession</strong> of my entire soul, like these sweet mornings of spring which I enjoy with my <strong>whole heart</strong>.</h2>
[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Testimonial Popout', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['testimonials'];
$data['custom_class'] = 'testimonials date-20-Oct-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/testimonial-popout.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="in_container" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3" shape_divider_position="bottom"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="250"][/vc_column][/vc_row][vc_row type="in_container" full_screen_row_position="middle" equal_height="yes" content_placement="bottom" bg_image="https://source.unsplash.com/featured/daily/?happy" bg_position="center center" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" scene_position="center" text_color="light" text_align="left" enable_gradient="true" color_overlay_2="rgba(10,10,10,0.87)" gradient_direction="left_t_to_right_b" overlay_strength="0.5" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" translate_y="-50%" translate_x="-17%" text_align="left"][vc_column_inner column_padding="padding-17-percent" column_padding_position="all" background_color="#ff3366" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid"][nectar_single_testimonial testimonial_style="small_modern" image="https://source.unsplash.com/featured/200x200/daily/?face" color="Default" quote="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. " name="Jessie Cohen" subtitle="Web Developer"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-6-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="right"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid"][nectar_btn size="large" button_style="see-through" button_color_2="Accent-Color" color_override="#ffffff" icon_family="none" url="#team" text="Meet The Team"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Team Overlapping Section Below', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['team'];
$data['custom_class'] = 'team date-20-Oct-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/team-overlap-milestones.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="8%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" bottom_margin="-6%" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" bottom_padding="60" text_align="left" el_id="team"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Say hello to your team" font_container="tag:h3|text_align:center" use_theme_fonts="yes"][divider line_type="Small Line" line_thickness="2" divider_color="accent-color" animate="yes" custom_height="40" custom_line_width="40"][vc_column_text max_width="650"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec quis nisi vel dui porttitor volutpat. Curabitur vel maximus mauris. Sed in dictum sem.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="x_large_depth" column_border_radius="10px" width="1/3" column_border_width="none" column_border_style="solid"][team_member image_url="https://source.unsplash.com/featured/600x400/daily/?man" bio_image_url="https://source.unsplash.com/featured/600x1000/daily/?man" team_memeber_style="bio_fullscreen" name="Claire Kozlov" job_position="Graphic Designer" team_member_bio="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. " social_icon_1="fa fa-facebook" social_link_1="# " social_icon_2="fa fa-twitter" social_link_2="# " social_icon_3="fa fa-instagram" social_link_3="# "][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="x_large_depth" column_border_radius="10px" width="1/3" column_border_width="none" column_border_style="solid" delay="100"][team_member image_url="https://source.unsplash.com/featured/600x400/daily/?girl" bio_image_url="https://source.unsplash.com/featured/700x1000/daily/?man" team_memeber_style="bio_fullscreen" name="Mark Jones" job_position="Back-end Developer" team_member_bio="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. " social_icon_1="fa fa-github-alt" social_icon_2="fa fa-instagram" social_icon_3="fa fa-facebook"][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="x_large_depth" column_border_radius="10px" width="1/3" column_border_width="none" column_border_style="solid" delay="200"][team_member image_url="https://source.unsplash.com/featured/600x400/daily/?face" bio_image_url="https://source.unsplash.com/featured/700x1000/daily/?man" team_memeber_style="bio_fullscreen" name="Andrea Smith" job_position="Fine Artist" team_member_bio="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. " social_icon_1="fa fa-dribbble" social_link_1="# " social_icon_2="fa fa-deviantart" social_link_2="# " social_icon_3="fa fa-instagram" social_link_3="# "][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="x_large_depth" column_border_radius="10px" width="1/3" column_border_width="none" column_border_style="solid"][team_member image_url="https://source.unsplash.com/featured/600x400/daily/?person" bio_image_url="https://source.unsplash.com/featured/700x1000/daily/?man" team_memeber_style="bio_fullscreen" name="Ethan Young" job_position="Team Leader" team_member_bio="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. " social_icon_1="fa fa-facebook" social_link_1="#" social_icon_2="fa fa-instagram" social_link_2="#" social_icon_3="fa fa-linkedin" social_link_3="#"][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="x_large_depth" column_border_radius="10px" width="1/3" column_border_width="none" column_border_style="solid" delay="100"][team_member image_url="https://source.unsplash.com/featured/600x400/daily/?happy" bio_image_url="https://source.unsplash.com/featured/700x1000/daily/?happy" team_memeber_style="bio_fullscreen" name="Ava Morgan" job_position="The SEO Expert" team_member_bio="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. " social_icon_1="fa fa-instagram" social_link_1="#" social_icon_2="fa fa-twitter" social_link_2="#"][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="x_large_depth" column_border_radius="10px" width="1/3" column_border_width="none" column_border_style="solid" delay="200"][team_member image_url="https://source.unsplash.com/featured/600x400/daily/?woman" bio_image_url="https://source.unsplash.com/featured/700x1000/daily/?woman" team_memeber_style="bio_fullscreen" name="James Anderson" job_position="Front-end Developer" team_member_bio="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. " social_icon_1="fa fa-twitter" social_link_1="#" social_icon_2="fa fa-youtube-play" social_link_2="#"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" bg_image="7094" background_image_mobile_hidden="true" bg_position="center top" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" scene_position="center" text_color="light" text_align="left" top_padding="18%" bottom_padding="13%" enable_gradient="true" color_overlay="#3452ff" color_overlay_2="#ff1053" gradient_direction="left_t_to_right_b" overlay_strength="0.8" shape_divider_color="#ffffff" shape_divider_position="bottom" shape_divider_height="250" shape_type="curve_opacity"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/4" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Percent Increase" font_container="tag:h5|text_align:center|color:rgba(255%2C255%2C255%2C0.63)" use_theme_fonts="yes" css=".vc_custom_1504326242419{margin-bottom: 10px !important;}"][milestone heading_inherit="h5" subject_padding="2%" color="Default" effect="count" milestone_alignment="default" number="87" number_font_size="92"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/4" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Referrals " font_container="tag:h5|text_align:center|color:rgba(255%2C255%2C255%2C0.63)" use_theme_fonts="yes" css=".vc_custom_1504290730551{margin-bottom: 10px !important;}"][milestone heading_inherit="h5" symbol_position="after" subject_padding="2%" color="Default" effect="count" symbol_alignment="Superscript" milestone_alignment="default" number="479" symbol="+" number_font_size="92" symbol_font_size="40"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/4" column_border_width="none" column_border_style="solid"][vc_custom_heading text="New Accounts" font_container="tag:h5|text_align:center|color:rgba(255%2C255%2C255%2C0.63)" use_theme_fonts="yes" css=".vc_custom_1504288841908{margin-bottom: 10px !important;}"][milestone heading_inherit="h5" subject_padding="2%" color="Default" effect="count" milestone_alignment="default" number="247" number_font_size="92"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/4" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Subscribers" font_container="tag:h5|text_align:center|color:rgba(255%2C255%2C255%2C0.63)" use_theme_fonts="yes" css=".vc_custom_1504290761477{margin-bottom: 10px !important;}"][milestone heading_inherit="h5" symbol_position="after" subject_padding="2%" color="Default" effect="count" symbol_alignment="Superscript" milestone_alignment="default" number="13" number_font_size="92" symbol="k" symbol_font_size="40"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Overflowing Testimonials & Text Snippet', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['testimonials'];
$data['custom_class'] = 'testimonials date-20-Oct-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/testimonial-carousel-with-text.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="in_container" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="7%" bottom_padding="7%" id="testimonials" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" top_margin="30" bottom_margin="30" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][carousel script="flickity" flickity_formatting="fixed_text_content_fullwidth" flickity_fixed_content="
<h4>What they've said about us</h4>
lorem ipsum dolor set amet et it lorem ipsum dolor set amet et it" button_color="Accent-Color" desktop_cols_flickity="3" desktop_small_cols_flickity="2" tablet_cols_flickity="1" column_padding="50px" autorotate="true" column_color="#ffffff" border_radius="10px" enable_column_border="true" cta_button_text="Contact Us" cta_button_url="#" autorotation_speed="7000"][item id="1504038498-1-94" tab_id="1504038676473-4" title="Item"][nectar_single_testimonial testimonial_style="basic" image="https://source.unsplash.com/featured/200x200/daily/?girl" quote="I've learned that people will forget what you said, people will forget what you did, but people will never forget how you made them feel." name="Ray Jackson" subtitle="Structural Engineer "][/item][item id="1504055252242-0-2" tab_id="1504038676473-4" title="Item"][nectar_single_testimonial testimonial_style="basic" image="https://source.unsplash.com/featured/200x200/daily/?man" quote="Science is fun. Science is curiosity. We all have natural curiosity. Science is a process of investigating. It's posing questions and coming up with a method. It's delving in." name="Sam Murray " subtitle="Lead Architect"][/item][item id="1504038498-2-81" tab_id="1504038676738-8" title="Item"][nectar_single_testimonial testimonial_style="basic" image="https://source.unsplash.com/featured/200x200/daily/?face" quote="I feel confident imposing change on myself. It's a lot more fun progressing than looking back. That's why I need to throw curve balls." name="Jake Smith" subtitle="Salient Corp"][/item][item id="1504038498-3-53" tab_id="1504038677047-7" title="Item"][nectar_single_testimonial testimonial_style="basic" image="https://source.unsplash.com/featured/200x200/daily/?happy" quote="Our task must be to free ourselves by widening our circle of compassion to embrace all living creatures and the whole of nature and its beauty." name="Alice Johnson" subtitle="Writer at ThemeNectar"][/item][/carousel][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );





$data = array();
$data['name'] = esc_html__( 'Info/Contact Box Overlapping Map', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'];
$data['custom_class'] = 'general date-20-Oct-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/contact-box-overlaying-map.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="5715" bg_position="center center" bg_repeat="no-repeat" scene_position="center" text_color="dark" text_align="left" top_padding="14%" zindex="100" enable_gradient="true" color_overlay="rgba(52,82,255,0.93)" color_overlay_2="rgba(255,16,83,0.92)" gradient_direction="left_t_to_right_b" overlay_strength="0.95" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" bottom_padding="7%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" font_color="#ffffff" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text]
<h5>Available booking space</h5>
<h2>Have a project in mind?</h2>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-6-percent" column_padding_position="all" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="x_large_depth" column_border_radius="10px" bottom_margin="-25%" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text]
<h5 style="text-align:center;">Check this out.</h5>
<h2 style="text-align:center;">This area is where <br/> your text or contact<br/> form can go.</h2>
[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_gmap zoom="14" enable_zoom="1" marker_style="nectar" nectar_marker_color="accent-color" map_greyscale="1" ultra_flat="1" size="650" map_center_lat="39.955" map_center_lng="-75.171" map_markers="39.949|-75.171|Our Location "][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );





$data = array();
$data['name'] = esc_html__( 'Simple Client Carousel', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/clients-carousel.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="7%" bottom_padding="7%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][clients columns="6" hover_effect="opacity" additional_padding="4" carousel="true"][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1502894621516-25bfe-029b" url="#" name="elevate" tab_id="1507130915658-5"]  [/client][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1502894621516-35bfe-029b" url="#" name="harper" tab_id="1507130915688-2"] [/client][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1502894621516-45bfe-029b" url="#" name="waveform" tab_id="1507130915722-3"] [/client][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1502894621516-55bfe-029b" url="#" name="brooklyn" tab_id="1507130915763-3"] [/client][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1502894621516-95bfe-029b" url="#" name="camallero" tab_id="1507130915805-3"][/client][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1502894621516-65bfe-029b" url="#" name="ollostream" tab_id="1507130915846-4"] [/client][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1502894621516-75bfe-029b" url="#" name="golden grid" tab_id="1507130915873-4"][/client][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1502894621516-85bfe-029b" url="#" name="jacks" tab_id="1507130915901-6"] [/client][/clients][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Shape Divider Hero Solid Color', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-07-Oct-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/blue-hero-shape-divider.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#3452ff" scene_position="center" top_padding="13%" bottom_padding="19%" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" color_overlay="rgba(52,82,255,0.94)" overlay_strength="0.95" gradient_direction="left_to_right" enable_shape_divider="true" shape_divider_position="bottom" shape_divider_height="350" bg_image_animation="none" shape_type="mountains"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/6" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="default" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="WordPress Design as it should be"][/split_line_heading][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/6" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" delay="200"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts The Big Oxmox advised her." font_container="tag:h4|font_size:20|text_align:center|color:rgba(255%2C255%2C255%2C0.7)|line_height:36px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:500%20bold%20regular%3A500%3Anormal" css=".vc_custom_1507135671940{padding-right: 5% !important;padding-left: 5% !important;}"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/6" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="grow-in" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_btn size="jumbo" button_style="see-through-2" color_override="#ffffff" hover_color_override="#ffffff" hover_text_color_override="#000000" icon_family="none" url="#discover" text="Discover More" margin_top="40"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/6" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Image And Text With Dark Image BG', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/image-and-text-btn.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_image="https://source.unsplash.com/featured/?exciting" bg_position="left top" bg_repeat="no-repeat" scene_position="center" text_color="light" text_align="left" top_padding="8%" bottom_padding="8%" color_overlay="#0a0a0a" overlay_strength="0.8" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="5/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="none" css=".vc_custom_1487084437567{margin-top: 20px !important;margin-bottom: 5px !important;}"]
<h5>Salient Powered</h5>
[/vc_column_text][vc_custom_heading text=" it's easy to feel the charm of existence in this spot." use_theme_fonts="yes" css_animation="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid" delay="50"][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, they live." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.75)" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid"][nectar_btn size="large" button_style="regular" button_color_2="Accent-Color" icon_family="default_arrow" url="#" text="Learn More" margin_top="25"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][image_with_animation image_url="https://source.unsplash.com/featured/700x500/daily/?happy" alignment="" animation="Grow In" border_radius="10px" box_shadow="large_depth" max_width="100%"][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Pricing Table 4 Column Dark', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['pricing'];
$data['custom_class'] = 'pricing date-10-Aug-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/4-col-pricing.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/featured/daily/?craft" bg_position="left top" bg_repeat="no-repeat" scene_position="center" text_color="light" text_align="left" top_padding="7%" bottom_padding="7%" color_overlay="#232323" overlay_strength="0.8" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_hover" icon_family="none" image_url="https://source.unsplash.com/featured/daily/?mountains" color="Extra-Color-1" box_alignment="center" min_height="400"]
<h5>Try It Now</h5>
<h2>$5.99</h2>
Get a free domain name and custom cookies delivered to your door every month.

&nbsp;

[nectar_cta btn_style="see-through" heading_tag="h5" link_type="regular" alignment="center" link_text="Purchase now"][/fancy_box][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_hover" icon_family="none" image_url="https://source.unsplash.com/featured/daily/?happy" color="Extra-Color-1" box_alignment="center" min_height="400"]
<h5>Most Popular</h5>
<h2>$9.99</h2>
Get a free domain name and 24/7 customer support &amp; month of free bandwidth.

&nbsp;

[nectar_cta btn_style="see-through" heading_tag="h5" link_type="regular" alignment="center" link_text="Purchase now"][/fancy_box][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_hover" icon_family="none" image_url="https://source.unsplash.com/featured/daily/?tech" color="Extra-Color-1" box_alignment="center" min_height="400"]
<h5>Good Value</h5>
<h2>$19.99</h2>
Get a free domain name and 24/7 customer support &amp; design consultation &amp; premium support

&nbsp;

[nectar_cta btn_style="see-through" heading_tag="h5" link_type="regular" alignment="center" link_text="Purchase now"][/fancy_box][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_hover" icon_family="none" image_url="https://source.unsplash.com/featured/daily/?view" color="Extra-Color-1" box_alignment="center" min_height="400"]
<h5>Ultimate</h5>
<h2>$49.99</h2>
Everything the other plans have plus an annual subscription to nectar magazine

&nbsp;

[nectar_cta btn_style="see-through" heading_tag="h5" link_type="regular" alignment="center" link_text="Purchase now"][/fancy_box][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'FAQ Toggles And Image', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'];
$data['custom_class'] = 'general date-01-Oct-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/faq-and-img.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_image="https://source.unsplash.com/featured/1600x900/daily/?underwater" bg_position="center center" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" bg_color="#1c1c1c" scene_position="center" text_color="light" text_align="left" top_padding="7%" bottom_padding="7%" color_overlay="#1e1e1e" overlay_strength="0.8" shape_divider_position="bottom" shape_type=""][vc_column column_padding="padding-2-percent" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1505433788851{margin-bottom: 30px !important;}"]
<h3>Salient Studio changes the WordPress game forever.</h3>
[/vc_column_text][toggles style="minimal_small" accordion="true"][toggle color="Default" title="Over 200 Section Templates"][vc_column_text]Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque.[/vc_column_text][/toggle][toggle color="Default" title="Available Directly in Page Builder"][vc_column_text]Malesuada fames ac turpis egestas. Ut non enim eleifend felis pretium feugiat. Vivamus quis mi.[/vc_column_text][/toggle][toggle color="Default" title="One Click Template Insert"][vc_column_text]Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc, quis gravida magna mi a libero.[/vc_column_text][/toggle][/toggles][nectar_btn size="large" button_style="regular" button_color_2="Accent-Color" icon_family="default_arrow" url="" text="Learn More" margin_top="40"][/vc_column][vc_column column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][image_with_animation image_url="https://source.unsplash.com/featured/800x600/daily/?whale" alignment="" animation="Fade In From Right" border_radius="10px" box_shadow="x_large_depth" max_width="100%"][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Huge Image Transition Hero', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-03-Oct-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/image-trans.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/daily/?music" bg_position="center top" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" scene_position="center" text_color="light" text_align="left" top_padding="16%" bottom_padding="16%" id="intro" row_name="Intro" enable_gradient="true" color_overlay="rgba(16,16,16,0.2)" color_overlay_2="#101010" gradient_direction="top_to_bottom" overlay_strength="image_trans"][vc_column centered_text="true" column_padding="padding-6-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Salient" font_container="tag:h1|font_size:103|text_align:center|color:%23ffffff|line_height:116px" use_theme_fonts="yes"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="200"][nectar_btn size="large" button_style="see-through-3" color_override="#3452ff" hover_color_override="#3452ff" hover_text_color_override="#ffffff" icon_family="iconsmind" url="#" text="View Tour Dates" icon_iconsmind="iconsmind-Triangle-ArrowRight"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#101010" scene_position="center" text_color="light" text_align="left" top_padding="7%" bottom_padding="7%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column centered_text="true" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_custom_heading text="THE STORY" font_container="tag:h5|font_size:14|text_align:center|color:%233452ff|line_height:24px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="50"][vc_column_text css=".vc_custom_1486330423766{margin-top: -8px !important;margin-bottom: -8px !important;}"]
<h3>An American progressive band from Washington, D.C</h3>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="100"][vc_column_text]A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Music Video Lightbox Link', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'];
$data['custom_class'] = 'general date-03-Oct-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/band-video.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_image="https://source.unsplash.com/weekly/?music" bg_position="center center" bg_repeat="no-repeat" scene_position="center" text_color="light" text_align="left" top_padding="15%" bottom_padding="15%" color_overlay="#3452ff" overlay_strength="0.8" shape_divider_position="bottom" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast"][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" overlay_strength="0.3" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" tablet_width_inherit="default" overlay_strength="0.3" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text css=".vc_custom_1486347995892{margin-bottom: -10px !important;}"]
<h5>Look Inside</h5>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" tablet_width_inherit="default" overlay_strength="0.3" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text css=".vc_custom_1486348233904{margin-bottom: 10px !important;}"]
<h3>Live Concert Promo</h3>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" tablet_width_inherit="default" overlay_strength="0.3" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="grow-in"][nectar_video_lightbox link_style="play_button" video_url="https://www.youtube.com/watch?v=6oTurM7gESE"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Layout Text Block Dark', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'];
$data['custom_class'] = 'general date-03-Oct-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/dark-text-block.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#101010" scene_position="center" text_color="light" text_align="left" top_padding="7%" bottom_padding="7%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column centered_text="true" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_custom_heading text="THE STORY" font_container="tag:h5|font_size:14|text_align:center|color:%233452ff|line_height:24px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:900%20bold%20regular%3A900%3Anormal"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="50"][vc_column_text css=".vc_custom_1486330423766{margin-top: -8px !important;margin-bottom: -8px !important;}"]
<h3>An American progressive band from Washington, D.C</h3>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="100"][vc_custom_heading text="A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth." font_container="tag:p|text_align:center|color:rgba(255%2C255%2C255%2C0.69)" use_theme_fonts="yes"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Minimal Pricing Table', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['pricing'];
$data['custom_class'] = 'pricing';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/minimal_pricing.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="4%" bottom_padding="7%" overlay_strength="0.3"][vc_column column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/1" tablet_text_alignment="default" phone_text_alignment="default"][pricing_table style="flat-alternative" columns="3"][pricing_column color="Extra-Color-1" title="Free" price="0.00" currency_symbol="$" interval="Per Month" id="1435950853864-5" tab_id="1435950853865-3"]<ul class="features"><li>[icon color="Extra-Color-1" size="tiny" image="fa-check"] Custom Domain</li><li><del>[icon color="Extra-Color-1" size="tiny" image="fa-check"] 24/7 Customer Support</del></li><li><del>[icon color="Extra-Color-1" size="tiny" image="fa-check"] Month Of Free Bandwidth</del></li><li><del>[icon color="Extra-Color-1" size="tiny" image="fa-check"] Free WordPress Setup</del></li><li><del>[icon color="Extra-Color-1" size="tiny" image="fa-check"] Cake Delivered Daily</del></li></ul>[button color="see-through" hover_text_color_override="#fff" size="large" url="#" text="Get Free" color_override="#3a6ee8" image="default-arrow"][/pricing_column][pricing_column color="Extra-Color-2" title="Plus" price="7.99" currency_symbol="$" interval="Per Month" id="1435950853864-2" tab_id="1435950853865-2"]<ul class="features"><li>[icon color="Extra-Color-2" size="tiny" image="fa-check"] Custom Domain</li><li>[icon color="Extra-Color-2" size="tiny" image="fa-check"] 24/7 Customer Support</li><li>[icon color="Extra-Color-2" size="tiny" image="fa-check"] Month Of Free Bandwidth</li><li><del>[icon color="Extra-Color-2" size="tiny" image="fa-check"] Free WordPress Setup</del></li><li><del>[icon color="Extra-Color-2" size="tiny" image="fa-check"] Cake Delivered Daily</del></li></ul>[button color="see-through" hover_text_color_override="#fff" size="large" url="#" text="Sign Up Now" color_override="#fd0025" image="default-arrow"][/pricing_column][pricing_column highlight="true" color="Accent-Color" title="Premium" highlight_reason="Recommended" price="19.99" currency_symbol="$" interval="Per Month" id="1435950853953-5" tab_id="1435950853954-0"]<ul class="features"><li>[icon color="Accent-Color" size="tiny" image="fa-check"] Custom Domain</li><li>[icon color="Accent-Color" size="tiny" image="fa-check"] 24/7 Customer Support</li><li>[icon color="Accent-Color" size="tiny" image="fa-check"] Month Of Free Bandwidth</li><li>[icon color="Accent-Color" size="tiny" image="fa-check"] Free WordPress Setup</li><li>[icon color="Accent-Color" size="tiny" image="fa-check"] Cake Delivered Daily</li></ul>[button size="large" url="#" text="Sign Up Now" color="Accent-Color" image="default-arrow"][/pricing_column][/pricing_table][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" bottom_padding="4%" overlay_strength="0.3"][vc_column column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/2" tablet_text_alignment="default" phone_text_alignment="default"][vc_column_text]<h4>Are there more plans?</h4>[/vc_column_text][divider line_type="No Line" custom_height="15"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec porta, mi ut facilisis ullamcorper, magna risus vehicula augue, eget faucibus magna massa at justo. Nulla a arcu ut massa hendrerit.[/vc_column_text][/vc_column][vc_column column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/2" tablet_text_alignment="default" phone_text_alignment="default"][vc_column_text]<h4>Plan Discounts</h4>[/vc_column_text][divider line_type="No Line" custom_height="15"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec porta, mi ut facilisis ullamcorper, magna risus vehicula augue, eget faucibus magna massa at justo. Nulla a arcu ut massa hendrerit[/vc_column_text][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

$data = array();
$data['name'] = esc_html__( 'Team Members Full Width Meta Overlaid', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['team'] .', '. $cat_display_names['about'];
$data['custom_class'] = 'team about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/about-meta-overlaid.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3"][vc_column column_padding="padding-1-percent" column_padding_position="left-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][team_member team_memeber_style="meta_overlaid_alt" name="Jake Graham" image_url="https://source.unsplash.com/BZ2PNGD5Emw/500x500" job_position="Founder"][/vc_column_inner][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][team_member team_memeber_style="meta_overlaid_alt" image_url="https://source.unsplash.com/tBt9JxuQBYs/500x500" name="Aura Brooks" job_position="Graphic Designer"][/vc_column_inner][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][team_member team_memeber_style="meta_overlaid_alt" image_url="https://source.unsplash.com/R5tHd-aYmPs/500x500" name="Eve Crawford" job_position="Product Designer"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" bottom_padding="1%" text_align="left"][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][team_member team_memeber_style="meta_overlaid_alt" image_url="https://source.unsplash.com/HZGkX1vKJvo/500x500" name="Alex Parker" job_position="Founder"][/vc_column_inner][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][team_member team_memeber_style="meta_overlaid_alt" image_url="https://source.unsplash.com/featured/daily/?face" name="Ashley Collins" job_position="Graphic Designer"][/vc_column_inner][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][team_member team_memeber_style="meta_overlaid_alt" image_url="https://source.unsplash.com/5lexwsAzUT4/500x500" name="Luke Smith" job_position="Web Developer"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Incisive Text Columns', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/three-cols.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="8%" bottom_padding="8%" overlay_strength="0.5"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" top_padding="20" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="none" css=".vc_custom_1486920762999{margin-bottom: 15px !important;}"]
<h4>Customer Support</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts" font_container="tag:p|text_align:left|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="none" css=".vc_custom_1486920757884{padding-right: 10% !important;}"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid" delay="100"][vc_column_text css_animation="none" css=".vc_custom_1486920768475{margin-bottom: 15px !important;}"]
<h4>Web Design</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts" font_container="tag:p|text_align:left|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="none" css=".vc_custom_1486920774094{padding-right: 10% !important;}"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid" delay="200"][vc_column_text css_animation="none" css=".vc_custom_1486920745710{margin-bottom: 15px !important;}"]
<h4>Quality Assurance</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts" font_container="tag:p|text_align:left|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="none" css=".vc_custom_1486920740195{padding-right: 10% !important;}"][nectar_cta heading_tag="h5" text_color="#3452ff" link_type="regular" alignment="left" link_text="Discover More" url="#"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Enhanced Recent Posts', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['blog'];
$data['custom_class'] = 'blog date-04-Oct-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/recent_posts.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#eaeaea" scene_position="center" text_color="dark" text_align="left" top_padding="7%" bottom_padding="7%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][recent_posts style="classic_enhanced" category="all" columns="3" posts_per_page="3"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][nectar_btn size="large" button_style="regular" button_color_2="Accent-Color" icon_family="iconsmind" url="#" text="View All Posts" icon_iconsmind="iconsmind-Triangle-ArrowRight"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Youtube Video Background Row With Video Lightbox', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'] .', '. $cat_display_names['about'];
$data['custom_class'] = 'general about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/youtube-video-bg.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" video_bg="use_video" video_external="https://www.youtube.com/watch?v=4BfKFCOCJe8" text_color="light" text_align="left" top_padding="15%" bottom_padding="15%" enable_gradient="true" color_overlay="#585b64" color_overlay_2="#2c2f38" gradient_direction="left_to_right" overlay_strength="0.8"][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_video_lightbox link_style="play_button" video_url="https://www.youtube.com/watch?v=6oTurM7gESE"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Image Overflowing Left Of Screen & Gradient Header', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['about'] .', '. $cat_display_names['services'];
$data['custom_class'] = 'general about date-29-Sep-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/img-overflow-left.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="4%" bottom_padding="4%" id="save-time" row_name="Save Time" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="7/12" tablet_text_alignment="default" phone_text_alignment="default"][image_with_animation image_url="http://themenectar.com/dummy_data_creation/wp-content/uploads/2016/07/app-1.jpg" alignment="right" animation="Fade In From Left" box_shadow="none" max_width="165%"][/vc_column][vc_column column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="5/12" tablet_text_alignment="default" phone_text_alignment="default"][vc_row_inner text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1"][nectar_gradient_text heading_tag="h1" color="extra-color-gradient-1" gradient_direction="diagonal" text="Save Yourself Time By Using Salient"][/vc_column_inner][/vc_row_inner][vc_row_inner text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" delay="150"][vc_column_text]Handling how you manage payments online is very important. Salient is a new innovative and easy to use method of sending &amp; receiving money online. It's fast, secure and free to sign up.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" delay="300"][fancy-ul icon_type="standard_dash" color="Extra-Color-3"]
<ul>
	<li>Top Customer Support</li>
	<li>Most Liked Company</li>
	<li>Best In Class 2016</li>
	<li>Friendliest Group</li>
	<li>Innovative Brand</li>
</ul>
[/fancy-ul][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Flip Box Carousel', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['about'] .', '. $cat_display_names['services'];
$data['custom_class'] = 'general about date-29-Sep-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/flipbox-carousel.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="8%" bottom_padding="8%" id="core-features" row_name="Core Features" overlay_strength="0.3"][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1469639641867{padding-bottom: 10px !important;}"]
<h2>Our Awesome Core Features</h2>
[/vc_column_text][divider line_type="Small Line" line_thickness="3" divider_color="extra-color-1" animate="yes" custom_height="30" custom_line_width="120" delay="100"][vc_column_text max_width="450"]<span style="color: #999999;">There are countless reasons why our service is better than the rest, but here you can learn about why we're different.</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][carousel script="owl_carousel" desktop_cols="3" desktop_small_cols="2" tablet_cols="2" mobile_cols="1" column_padding="15px" enable_animation="true" delay="100"][item id="1485907949923-10af59-8004" title="Item" tab_id="1485999357987-9"][nectar_flip_box image_url_1="https://source.unsplash.com/collection/467163/daily" bg_color="#0a0a0a" bg_color_overlay="true" text_color="light" icon_family="steadysets" icon_color="Extra-Color-1" image_url_2="https://source.unsplash.com/collection/467163/daily" bg_color_2="#0a0a0a" bg_color_overlay_2="true" text_color_2="light" h_text_align="center" v_text_align="center" flip_direction="horizontal-to-left" front_content="
<h3>Use It Anywhere</h3>
Nullam gravida tellus lectus, in bibendum quam euismod" min_height="300" icon_size="44" icon_steadysets="steadysets-icon-map"]
<h3>Use It Anywhere</h3>
This is an amazing Nectar Flip Box element. Any content can be displayed on both sides to suit your specific project needs.[/nectar_flip_box][/item][item id="1485907949937-4af59-8004" title="Item" tab_id="1485999358001-10"][nectar_flip_box image_url_1="https://source.unsplash.com/collection/310797/daily" bg_color="#0a0a0a" bg_color_overlay="true" text_color="light" icon_family="steadysets" icon_color="Extra-Color-1" image_url_2="https://source.unsplash.com/collection/310797/daily" bg_color_2="#0a0a0a" bg_color_overlay_2="true" text_color_2="light" h_text_align="center" v_text_align="center" flip_direction="horizontal-to-left" front_content="
<h3>Secure Payments</h3>
Duis lorem magna, bibendum sed suscipit ut nec mauris." min_height="300" icon_size="44" icon_steadysets="steadysets-icon-lock"]
<h3>Secure Payments</h3>
You have control over the background image &amp; color in addition to the optional color overlay as well.[/nectar_flip_box][/item][item id="1485907949953-10af59-8004" title="Item" tab_id="1485999358019-1"][nectar_flip_box image_url_1="https://source.unsplash.com/collection/190727/daily" bg_color="#0a0a0a" bg_color_overlay="true" text_color="light" icon_family="steadysets" icon_color="Extra-Color-1" image_url_2="https://source.unsplash.com/collection/190727/daily" bg_color_2="#0a0a0a" bg_color_overlay_2="true" text_color_2="light" h_text_align="center" v_text_align="center" flip_direction="horizontal-to-left" front_content="
<h3>Detailed Statistics</h3>
In pharetra imperdiet facilisis. Integer elementum augue" min_height="300" icon_size="44" icon_steadysets="steadysets-icon-browser"]
<h3>Detailed Statistics</h3>
You also can control the flip direction. This example shows the "horizontal flip to left" option exclusively though.[/nectar_flip_box][/item][item id="1485907949982-6af59-8004" title="Item" tab_id="1485999358051-10"][nectar_flip_box image_url_1="https://source.unsplash.com/collection/467163/daily" bg_color="#0a0a0a" bg_color_overlay="true" text_color="light" icon_family="steadysets" icon_color="Extra-Color-1" image_url_2="https://source.unsplash.com/collection/467163/daily" bg_color_2="#0a0a0a" bg_color_overlay_2="true" text_color_2="light" h_text_align="center" v_text_align="center" flip_direction="horizontal-to-left" front_content="
<h3>Scheduled Payments</h3>
Nullam gravida tellus lectus, in bibendum quam euismod" min_height="300" icon_size="44" icon_steadysets="steadysets-icon-bookmark"]
<h3>Scheduled Payments</h3>
You can also control the X and Y axis for content positioning. This example shows all set to the middle.[/nectar_flip_box][/item][item id="1485907950009-2af59-8004" title="Item" tab_id="1485999358072-7"][nectar_flip_box image_url_1="https://source.unsplash.com/collection/422400/daily" bg_color="#0a0a0a" bg_color_overlay="true" text_color="light" icon_color="Extra-Color-1" image_url_2="https://source.unsplash.com/collection/422400/daily" bg_color_2="#0a0a0a" bg_color_overlay_2="true" text_color_2="light" h_text_align="center" v_text_align="center" flip_direction="horizontal-to-left" front_content="
<h3>Visa Gateway</h3>
Interdum et malesuada fames ac ante ipsum primis" min_height="300" icon_size="42" icon_fontawesome="fa fa-credit-card"]
<h3>Visa Gateway</h3>
These flip boxes are also placed within a carousel element which is completely optional. They can live in regular columns if desired.[/nectar_flip_box][/item][/carousel][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Pricing Table Dark', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['pricing'];
$data['custom_class'] = 'pricing date-10-Aug-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/dark-pricing.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#1c1c1c" scene_position="center" text_color="light" text_align="left" top_padding="8%" bottom_padding="8%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner equal_height="yes" content_placement="top" column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-5-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" font_color="#919191" width="1/3" column_border_width="2px" column_border_color="#3a3a3a" column_border_style="solid"][vc_column_text css=".vc_custom_1485706251777{margin-bottom: 5px !important;}"]
<h5>Basic</h5>
[/vc_column_text][vc_custom_heading text="$10" font_container="tag:h2|font_size:80|text_align:center|color:%23ffffff|line_height:80px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"][vc_custom_heading text="/month" font_container="tag:h4|font_size:24|text_align:center|color:%23ffffff|line_height:34px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"][divider line_type="No Line" custom_height="40"][fancy-ul icon_type="none" alignment="center"]
<ul>
 	<li>Custom Domain</li>
 	<li>24/7 Customer Support</li>
 	<li>Month Of Free Bandwidth</li>
 	<li>-</li>
 	<li>-</li>
 	<li>-</li>
 	<li>-</li>
</ul>
[/fancy-ul][nectar_btn size="large" button_style="see-through-2" hover_text_color_override="#ffffff" icon_family="iconsmind" url="#" text="Buy Now" margin_top="20" icon_iconsmind="iconsmind-Triangle-ArrowRight"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-5-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" font_color="#919191" width="1/3" column_border_width="2px" column_border_color="#3a3a3a" column_border_style="solid" delay="100"][vc_column_text css=".vc_custom_1485706256916{margin-bottom: 5px !important;}"]
<h5>Premium</h5>
[/vc_column_text][vc_custom_heading text="$20" font_container="tag:h2|font_size:80|text_align:center|color:%23ffffff|line_height:80px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"][vc_custom_heading text="/month" font_container="tag:h4|font_size:24|text_align:center|color:%23ffffff|line_height:34px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"][divider line_type="No Line" custom_height="40"][fancy-ul icon_type="none" alignment="center"]
<ul>
 	<li>Custom Domain</li>
 	<li>24/7 Customer Support</li>
 	<li>Month Of Free Bandwidth</li>
 	<li>Free WordPress Setup</li>
 	<li>Cake Delivered Daily</li>
 	<li>-</li>
 	<li>-</li>
</ul>
[/fancy-ul][nectar_btn size="large" button_style="see-through-2" hover_text_color_override="#ffffff" icon_family="iconsmind" url="#" text="Buy Now" margin_top="20" icon_iconsmind="iconsmind-Triangle-ArrowRight"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-5-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" font_color="#919191" width="1/3" column_border_width="2px" column_border_color="#3a3a3a" column_border_style="solid" delay="200"][vc_column_text css=".vc_custom_1485706261609{margin-bottom: 5px !important;}"]
<h5>Developer</h5>
[/vc_column_text][vc_custom_heading text="$40" font_container="tag:h2|font_size:80|text_align:center|color:%23ffffff|line_height:80px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"][vc_custom_heading text="/month" font_container="tag:h4|font_size:24|text_align:center|color:%23ffffff|line_height:34px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"][divider line_type="No Line" custom_height="40"][fancy-ul icon_type="none" alignment="center"]
<ul>
 	<li>Custom Domain</li>
 	<li>24/7 Customer Support</li>
 	<li>Month Of Free Bandwidth</li>
 	<li>Free WordPress Setup</li>
 	<li>Cake Delivered Daily</li>
 	<li>Premium Support</li>
 	<li>Design Consultation</li>
</ul>
[/fancy-ul][nectar_btn size="large" button_style="see-through-2" hover_text_color_override="#ffffff" icon_family="iconsmind" url="#" text="Buy Now" margin_top="20" icon_iconsmind="iconsmind-Triangle-ArrowRight"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Image Overflowing Right Of Screen & Numerical Icon List', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['about'] .', '. $cat_display_names['services'];
$data['custom_class'] = 'general about date-29-Sep-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/img-overflow-right.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_color="#ecf7ff" scene_position="center" text_color="dark" text_align="left" id="steps" row_name="Sign Up Steps" overlay_strength="0.3"][vc_column column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="5/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][nectar_icon_list animate="true" color="default" icon_size="small" icon_style="border"][nectar_icon_list_item icon_type="numerical" title="List Item" id="1469496380463-1039da-01ea" header="Sign Up For Free" text="Create your free account in a matter of minutes with our patented awesome sign up process." tab_id="1485703048239-5"] [/nectar_icon_list_item][nectar_icon_list_item icon_type="numerical" title="List Item" id="1469496380621-239da-01ea" header="Sell Goods Online" text="Next start integrating it with your e-commerce platform of choice and start accepting payments." tab_id="1485703048245-4"] [/nectar_icon_list_item][nectar_icon_list_item icon_type="numerical" title="List Item" id="1469496416453-939da-01ea" header="Love Your Life" text="Sit back, relax and pop a cold one because your life just got a whole lot easier by using Salient." tab_id="1485703048251-2"][/nectar_icon_list_item][/nectar_icon_list][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="7/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][image_with_animation image_url="http://themenectar.com/dummy_data_creation/wp-content/uploads/2016/07/laptop.jpg" alignment="" animation="Fade In From Right" box_shadow="none" max_width="175%"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Simple Text Columns', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/text-columns.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="1"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text]
<h3>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantic</h3>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="40" bottom_padding="35" text_align="left"][vc_column_inner enable_animation="true" animation="none" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][divider line_type="Full Width Line" line_thickness="1" divider_color="default" animate="yes" custom_height="1"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="Accent-Color" icon_padding="0px" icon_iconsmind="iconsmind-King-2" icon_size="36"][vc_column_text css=".vc_custom_1486918825917{padding-bottom: 10px !important;}"]
<h5>Who are we</h5>
[/vc_column_text][vc_column_text css=".vc_custom_1486918759317{padding-right: 10% !important;}"]A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid" delay="100"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="Accent-Color" icon_padding="0px" icon_iconsmind="iconsmind-Duplicate-Window" icon_size="36"][vc_column_text css=".vc_custom_1486918830515{padding-bottom: 10px !important;}"]
<h5>What we do</h5>
[/vc_column_text][vc_column_text css=".vc_custom_1486919428207{padding-right: 10% !important;}"]Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Testimonial Slider Parallax', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['testimonials'];
$data['custom_class'] = 'testimonials';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/parallax-testimonial.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/rMmibFe4czY" bg_position="left top" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" bg_color="#383838" scene_position="center" text_color="light" text_align="left" top_padding="10%" bottom_padding="10%" color_overlay="#0a0a0a" overlay_strength="0.5"][vc_column enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][testimonial_slider style="minimal" star_rating_color="accent-color" disable_height_animation="true"][testimonial star_rating="none" title="Testimonial" id="1475858133769-1f702-2797" name="Eve Crawford" subtitle="Product Designer" quote="It was really fun getting to know the team during the project. They were all helpful in answering my questions and made me feel at ease. The design ended up being better than I could have envisioned!" tab_id="1486839778816-4"] Click the edit button to add your testimonial. [/testimonial][testimonial star_rating="none" title="Testimonial" id="1475858133938-7f702-2797" name="Aura Brooks" subtitle="Graphic Designer" quote="By far the best team I've ever worked with. They truly understood the look I was going for and completely nailed it! I would highly recommend them as a company, you simply just won't find any better team!" tab_id="1486839779007-9"] Click the edit button to add your testimonial. [/testimonial][testimonial star_rating="none" title="Testimonial" id="1475867833938-7f702-2797" name="Zak Reid" subtitle="Instructor, Skate Nao" quote="Salient is by far the most astonishing WP theme out there! I literally could not be happier that I chose to buy your theme! Your regular updates and superb attention to detail blows me away every time I visit my new site!" tab_id="1486839779963-10"] Click the edit button to add your testimonial. [/testimonial][testimonial star_rating="none" title="Testimonial" id="1475858133939-7f702-2797" name="Jack Graham" subtitle="Co Founder, Coffee Inc" quote="I'm wondering why I never contacted these guys sooner! Seriously, they all have commendable talent in their respective fields and knocked my concept out of the ballpark. Thanks for an amazing experience!" tab_id="1486839779323-6"] Click the edit button to add your testimonial. [/testimonial][/testimonial_slider][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Practical Map & Contact Info Split', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['google_map'] .', '. $cat_display_names['general'];
$data['custom_class'] = 'general map';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/map-color-split.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" equal_height="yes" bg_color="#141414" scene_position="center" text_color="light" text_align="left" overlay_strength="0.3"][vc_column enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" delay="200"][nectar_gmap zoom="6" enable_zoom="1" marker_style="nectar" nectar_marker_color="accent-color" map_greyscale="1" ultra_flat="1" dark_color_scheme="1" size="750" map_center_lat="40.793" map_center_lng="-73.954" map_markers="37.748458|-122.475586|Our Location
40.793|-73.954|Our Location #2"][/vc_column][vc_column enable_animation="true" animation="grow-in" column_padding="padding-8-percent" column_padding_position="all" background_color="#3452ff" background_color_opacity="0.9" background_hover_color_opacity="1" background_image="123" enable_bg_scale="true" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" delay="300"][vc_column_text css_animation="none"]
<h3>Contact.</h3>
We’re currently in look of a few new designers – If you’re a passionate worker and think you have what it takes, send your resume and details to for all opportunities.

&nbsp;
<h5>San Francisco</h5>
123 Nectar St. Suite 4917
hello@themenectar.com
<h5></h5>
<h5>New York</h5>
58 Nectar Rd. Apt 2C
hello@themenectar.com[/vc_column_text][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Map & Contact Info Split', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['google_map'] .', '. $cat_display_names['general'];
$data['custom_class'] = 'general map';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/map-split-light.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_gmap zoom="16" marker_style="nectar" nectar_marker_color="accent-color" map_greyscale="1" dark_color_scheme="1" size="750" map_center_lat="39.949" map_center_lng="-75.172" map_markers="39.949|-75.171|
"][/vc_column][vc_column column_padding="padding-7-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text]
<h3>Contact.</h3>
We’re currently in look of a few new designers – If you’re a passionate worker and think you have what it takes, send your resume and details to <a href="http://themenectar.com/demo/salient-corporate/contact/#">jobs@demo.com</a> for all opportunities.

&nbsp;
<h5>San Francisco</h5>
123 Nectar St. Suite 4917
hello@themenectar.com
<h5></h5>
<h5>New York</h5>
58 Nectar Rd. Apt 2C
hello@themenectar.com[/vc_column_text][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'The Awards Section Dark', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['about'] .', '. $cat_display_names['general'];
$data['custom_class'] = 'general about date-03-Oct-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/dark-awards.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#0a0a0a" scene_position="center" text_color="light" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="0.95"][vc_column enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1486836945876{margin-top: -8px !important;margin-bottom: -8px !important;}"]
<h2>They Appreciate Us</h2>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" bottom_padding="80" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid" delay="50"][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. A small river named Duden flows by their place and supplies it with the necessary regelialia." font_container="tag:p|text_align:center|color:rgba(255%2C255%2C255%2C0.65)" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][nectar_horizontal_list_item columns="3" column_layout_using_3_columns="large_first" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" font_family="p" hover_color="accent-color" col_1_content="Design Awards" col_2_content="Nectar Convention" col_3_content="2016-01-23"][nectar_horizontal_list_item columns="3" column_layout_using_3_columns="large_first" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" font_family="p" hover_color="accent-color" col_1_content="UI Convention" col_2_content="Salient Awards" col_3_content="2016-04-12"][nectar_horizontal_list_item columns="3" column_layout_using_3_columns="large_first" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" font_family="p" hover_color="accent-color" col_1_content="Web Design Envy" col_2_content="ThemeNectar" col_3_content="2016-06-15"][nectar_horizontal_list_item columns="3" column_layout_using_3_columns="large_first" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" font_family="p" hover_color="accent-color" col_1_content="Design Fusion" col_2_content="Salient Team" col_3_content="2016-07-28"][nectar_horizontal_list_item columns="3" column_layout_using_3_columns="large_first" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" font_family="p" hover_color="accent-color" col_1_content="Nectar Gathering" col_2_content="Frostwave" col_3_content="2016-09-23"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Well-made Intro Section', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['about'] .', '. $cat_display_names['general'];
$data['custom_class'] = 'about general hero_section date-02-Oct-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/gradient-text.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="1"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][split_line_heading]
<h2>If you wish to make an apple</h2>
<h2>pie from scratch, you must first</h2>
<h2>invent the universe.</h2>
[/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="top-bottom" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1485638236800{padding-right: 10% !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="top-bottom" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid" delay="100"][vc_column_text css=".vc_custom_1485638241294{padding-right: 10% !important;}"]Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar. The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="20" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-left" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][nectar_cta heading_tag="h5" text_color="#0a0000" link_type="regular" alignment="left" link_text="Learn More" url="#"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Well-made Intro Section Dark', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['about'] .', '. $cat_display_names['general'];
$data['custom_class'] = 'general about date-02-Oct-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/dark-text-section.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#0a0a0a" scene_position="center" text_color="light" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="1"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][split_line_heading]
<h3>If you wish to make an apple</h3>
<h3>pie from scratch, you must first</h3>
<h3>invent the universe.</h3>
[/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="top-bottom" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.71)" use_theme_fonts="yes" css=".vc_custom_1486839091142{padding-right: 10% !important;}"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="top-bottom" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid" delay="100"][vc_custom_heading text="Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar. The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.71)" use_theme_fonts="yes"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="20" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][nectar_btn size="large" button_style="see-through-2" hover_text_color_override="#ffffff" icon_family="default_arrow" url="#" text="Start a project" css_animation="none" margin_top="35"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Fullscreen Recent Project Slider', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['portfolio'] .', '. $cat_display_names['hero_section'];
$data['custom_class'] = 'portfolio hero_section date-05-Oct-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/recent-proj-slider.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" bg_color="#0a0a0a" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][recent_projects category="all" project_style="fullscreen_zoom_slider" slider_controls="both" slider_text_color="light" overlay_strength="0.4" number_to_display="10"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Minimal Dark About Section', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['about'];
$data['custom_class'] = 'about date-05-Oct-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/dark-about.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" equal_height="yes" content_placement="middle" full_height="yes" columns_placement="stretch" bg_color="#141414" scene_position="center" text_color="light" text_align="left" overlay_strength="0.3"][vc_column column_padding="padding-10-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Philip Martinez" font_container="tag:h5|text_align:left|color:%23bfbfbf" use_theme_fonts="yes" css=".vc_custom_1485193607322{margin-bottom: 10px !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="100"][vc_custom_heading text="Creator of quality designs and thinker of fresh ideas." font_container="tag:h2|font_size:40|text_align:left|line_height:50px" use_theme_fonts="yes"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="200"][vc_column_text css=".vc_custom_1485195197203{margin-top: 30px !important;margin-bottom: 30px !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. A small river named Duden flows by their place and supplies it with the necessary regelialia[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="300"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="white" open_new_tab="true" icon_padding="20px" icon_iconsmind="iconsmind-Facebook-2" icon_size="29" margin_left="-20px" url="#"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="white" open_new_tab="true" icon_padding="20px" icon_iconsmind="iconsmind-Twitter" icon_size="29" url="#"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="white" open_new_tab="true" icon_padding="20px" icon_iconsmind="iconsmind-Dribble" icon_size="29" url="#"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column enable_animation="true" animation="fade-in-from-left" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/daily/?personsitting" enable_bg_scale="true" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" delay="300"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Video Background Testimonial Slider Dark', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['testimonials'] .', '. $cat_display_names['about'];
$data['custom_class'] = 'testimonials about date-05-Oct-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/video-bg-testimonials.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#333333" scene_position="center" video_bg="use_video" enable_video_color_overlay="true" video_overlay_color="#000000" video_external="https://www.youtube.com/watch?v=6oTurM7gESE" text_color="light" text_align="left" top_padding="15%" bottom_padding="15%" id="services" overlay_strength="0.3"][vc_column enable_animation="true" animation="flip-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][testimonial_slider style="default"][testimonial name="Carly Young, ThemeNectar" quote="By far the best team I've ever worked with. They truly understood the look I was going for and completely nailed it! I would highly recommend them as a company, you won't find any better!" id="1484513879050-1f107-50ab" title="Testimonial" tab_id="1485366100980-9"][/testimonial][testimonial name="Jeff Gemmell, ThemeNectar" quote="It was really fun getting to know the team during the project. They were all helpful in answering questions and made me feel at ease. The design ended up being better than I could've envisioned!" id="1484513879156-2f107-50ab" title="Testimonial" tab_id="1485366100985-3"][/testimonial][testimonial name="Mark Levin, ThemeNectar" quote="I'm wondering why I never contacted these guys sooner! They have commendable talent in their fields and knocked my concept out of the ballpark. An amazing experience!" id="1484513879236-7f107-50ab" title="Testimonial" tab_id="1485366101002-0"][/testimonial][/testimonial_slider][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Restaurant Hero', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-28-Sep-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/restaurant-hero.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_image="https://source.unsplash.com/featured/daily/?restaurant" bg_position="center center" bg_repeat="no-repeat" scene_position="center" top_padding="18%" bottom_padding="18%" text_color="light" text_align="left" color_overlay="#0a0a0a" overlay_strength="0.5" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" shape_type=""][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][split_line_heading animation_type="default"]
<h6>Honest.  Wholesome.  Quality</h6>
[/split_line_heading][split_line_heading animation_type="default"]
<h1>Voted Best In Philly</h1>
[/split_line_heading][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_color="#dde5f3" scene_position="center" text_color="light" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" enable_shape_divider="true" shape_divider_color="#ffffff" shape_divider_position="bottom" shape_divider_height="5%" bg_image_animation="none" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" top_margin="-7%" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="large_depth" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="none" text_align="left" id="about" css=".vc_custom_1486684329109{background-color: #ffffff !important;}"][vc_column_inner column_padding="padding-7-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color="#5b74ff" background_color_opacity="0.9" background_hover_color_opacity="1" background_image="https://source.unsplash.com/featured/800x800/daily/?italty" background_image_position="center center" enable_bg_scale="true" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_column_text]
<h2>The Great Story Of Our Culinary Journey</h2>
[/vc_column_text][vc_column_text css=".vc_custom_1579814999722{margin-top: 40px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus hendrerit placerat feugiat. Praesent luctus est urna, id bibendum odio efficitur et. Cras imperdiet ipsum tincidunt lobortis accumsan.[/vc_column_text][vc_column_text css=".vc_custom_1483409005371{margin-top: 40px !important;}"]<strong>Claire Bianco</strong> - <em>Master Chef at Salient</em>[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/featured/800x800/daily/?face,smile" background_image_position="center center" enable_bg_scale="true" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][divider line_type="No Line" custom_height="200"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" column_margin="none" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/featured/800x800/daily/?food" background_image_position="center center" enable_bg_scale="true" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][divider line_type="No Line" custom_height="400"][/vc_column_inner][vc_column_inner column_padding="padding-7-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color="#e9e9e9" background_color_opacity="1" background_hover_color_opacity="1" font_color="#000000" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_column_text max_width="350"]
<h2>Salient Hours Of Operation</h2>
[/vc_column_text][vc_column_text css=".vc_custom_1483374687395{margin-top: 40px !important;margin-bottom: 20px !important;}"]<strong>Monday – Thursday:</strong> 9:00 am – 10:00 pm
<em>Food service until 9:00 pm</em>[/vc_column_text][vc_column_text css=".vc_custom_1483374679842{margin-bottom: 20px !important;}"]<strong>Friday - Saturday:</strong> 9:00 am – Midnight
<em>Food service until 10:00 pm</em>[/vc_column_text][vc_column_text css=".vc_custom_1483373919590{margin-bottom: 40px !important;}"]<strong>Sunday:</strong> 11:00 am – 10:00 pm
<em>Food service until 9:00 pm</em>[/vc_column_text][nectar_cta btn_style="see-through" heading_tag="h5" text_color="#3452ff" button_color="default" link_type="new_tab" alignment="left" display="block" link_text="Make A Reservation" url="#"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Restaurant Testimonial Slider', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['testimonials'];
$data['custom_class'] = 'testimonials date-28-Sep-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/restaurant-testimonials.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_image="https://source.unsplash.com/featured/1600x800/daily/?cooking" bg_position="center center" bg_repeat="no-repeat" scene_position="center" top_padding="13%" bottom_padding="13%" text_color="light" text_align="left" color_overlay="#000000" overlay_strength="0.5" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" bottom_padding="3%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][/vc_column_inner][vc_column_inner centered_text="true" column_padding="padding-3-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" column_border_width="2px" column_border_color="#ffffff" column_border_style="double_offset" enable_border_animation="true" bg_image_animation="none" enable_animation="true" animation="fade-in"][vc_column_text]
<h3>The Press</h3>
[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][/vc_column_inner][/vc_row_inner][testimonial_slider style="minimal" star_rating_color="accent-color" disable_height_animation="true"][testimonial star_rating="none" title="Testimonial" id="1579816010380-3" tab_id="1579816010381-7" name="Chase Carlson" subtitle="Salient FoodMag" quote="Something magical happened to my taste buds, it was one of the most beautiful things that I've ever experienced. ar far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live."][testimonial star_rating="none" title="Testimonial" id="1579816010453-0" tab_id="1579816010455-10" name="Carley Kohen" subtitle="WeDoFood" quote="The subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then The Big Oxmox advised her not to do so, because there were thousands of bad Commas."][testimonial star_rating="none" title="Testimonial" id="1579816010503-7" tab_id="1579816010503-2" name="Corey Smith" subtitle="FoodReviewz" quote="A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control."][/testimonial_slider][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Restaurant Food Menu (Tabbed)', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['pricing'];
$data['custom_class'] = 'pricing date-27-Sep-2019';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/food-menu.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="8%" bottom_padding="8%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" top_padding="3%" bottom_padding="5%" text_align="left" id="menu"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="2px" column_border_color="#000000" column_border_style="double_offset" enable_border_animation="true"][vc_column_text]
<h3>The Menu</h3>
[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][tabbed_section style="minimal_alt" alignment="center" cta_button_style="extra-color-3"][tab title="Breakfast &amp; Brunch" id="1483371702-1-88" tab_id="1483371715854-2"][vc_row_inner column_margin="default" top_padding="30" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1484520003986{margin-bottom: 30px !important;}"]
<h5>The Griddle</h5>
[/vc_column_text][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Western Sunrise" text="$9" item_price="$19" item_description="Two fried eggs with cheese &amp;two breakfast meats made to perfection"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Classic California" text="$9" item_price="$17" item_description="You know it's good, just order it"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Fried Eggs &amp; Ham" text="$9" item_price="$12" item_description="It's just plain and simple, but also tasty"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1484520027757{margin-bottom: 30px !important;}"]
<h5>Omelettes &amp; Skillets</h5>
[/vc_column_text][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Mr. Nectar Benedict " text="$9" item_price="$13" item_description="The best grilled English muffin, two poached eggs"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Great Waffles" text="$9" item_price="$17" item_description="Chocolate chips, imported syrup"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="``Country`` Breakfast" text="$9" item_price="$12" item_description="Biscuits with fresh sausage patties &amp; country gravy"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1484520078924{margin-bottom: 30px !important;}"]
<h5>Pancakes</h5>
[/vc_column_text][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="American Pancakes" text="$9" item_price="$9" item_description="Large stack of three with maple syrup "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Danish Style Pancakes" text="$9" item_price="$7" item_description="Served with pigs in a blanket"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Sweet Tooth" text="$9" item_price="$9" item_description="Basically just a dessert "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="``Can't make up my mind``" text="$9" item_price="$12" item_description="Served with a sample of French toast"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="2px" column_border_color="#3452ff" column_border_style="double_offset" enable_border_animation="true"][vc_column_text css=".vc_custom_1484520037671{margin-bottom: 30px !important;}"]
<h5>Breakfast Specials</h5>
[/vc_column_text][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Salient Style" text="$9" item_price="$17" item_description="Three scrambled eggs, bacon &amp; a side of hash browns"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="The Really Good Stuff" text="$9" item_price="$12" item_description="It's just plain and simple"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Nectar's Choice" text="$9" item_price="$11" item_description="Ask your server for more details"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="60" text_align="left" css=".vc_custom_1486083303611{padding-right: 2% !important;padding-left: 2% !important;}"][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][nectar_food_menu_item style="default" item_name_heading_tag="h4" item_name="Sodas" text="$9" item_price="$4" item_description="Coca cola, Pepsi, Sprite, Fanta, Nectar Soda, Salient Fizz"][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][nectar_food_menu_item style="default" item_name_heading_tag="h4" item_name="Tea" text="$9" item_price="$6" item_description="Green, Red, Black, Yellow, White Warm &amp; Hot"][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][nectar_food_menu_item style="default" item_name_heading_tag="h4" item_name="Juices" text="$9" item_price="$3" item_description="Orange, Apple, Vegetable, Strawberry, Blackberry, Lime"][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][nectar_food_menu_item style="default" item_name_heading_tag="h4" item_name="Water" text="$9" item_price="$1" item_description="Tap, Distilled, Reverse Osmosis "][/vc_column_inner][/vc_row_inner][/tab][tab title="Lunch" id="1486682634354-4-7" tab_id="1483371745398-1"][vc_row_inner column_margin="default" top_padding="30" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1486682668056{margin-bottom: 30px !important;}"]
<h5>Appetizers</h5>
[/vc_column_text][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Shrimp Cocktail" text="$9" item_price="$10" item_description="A little shrimp, a little cocktail "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Fried Mozzarella " text="$9" item_price="$8" item_description="It's just plain and simple, but also tasty"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Classic California" text="$9" item_price="$11" item_description="You know it's good, just order it"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1486682675326{margin-bottom: 30px !important;}"]
<h5>Pasta</h5>
[/vc_column_text][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Nectar Linguine " text="$9" item_price="$15" item_description="The best pasta you'll ever eat"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="The Ravioli " text="$9" item_price="$17" item_description="Cooked to perfection by Chef Nectar "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="``Very Big`` Bowl" text="$9" item_price="$22" item_description="Made to share, four separate samples in one "][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1486682685532{margin-bottom: 30px !important;}"]
<h5>Sandwiches</h5>
[/vc_column_text][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="The Italian" text="$9" item_price="$13" item_description="Smoked ham, peppers and your choice of cheese "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Double Decker Club" text="$9" item_price="$12" item_description="Grilled chicken, tomato and cheese "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Classic BLT" text="$9" item_price="$13" item_description="Bacon, Lettuce and Tomatoes "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="``Can't make up my mind``" text="$9" item_price="$12" item_description="Served with a sample of everything"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="2px" column_border_color="#3452ff" column_border_style="double_offset" enable_border_animation="true"][vc_column_text css=".vc_custom_1486682692238{margin-bottom: 30px !important;}"]
<h5>Lunch Specials</h5>
[/vc_column_text][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Salient Style" text="$9" item_price="$17" item_description="Warn homemade chicken with melted cheese "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="The Really Good Stuff" text="$9" item_price="$12" item_description="It's just plain and simple"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Nectar's Choice" text="$9" item_price="$11" item_description="Ask your server for more details"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="60" text_align="left" css=".vc_custom_1486083303611{padding-right: 2% !important;padding-left: 2% !important;}"][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][nectar_food_menu_item style="default" item_name_heading_tag="h4" item_name="Sodas" text="$9" item_price="$4" item_description="Coca cola, Pepsi, Sprite, Fanta, Nectar Soda, Salient Fizz"][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][nectar_food_menu_item style="default" item_name_heading_tag="h4" item_name="Tea" text="$9" item_price="$6" item_description="Green, Red, Black, Yellow, White Warm &amp; Hot"][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][nectar_food_menu_item style="default" item_name_heading_tag="h4" item_name="Juices" text="$9" item_price="$3" item_description="Orange, Apple, Vegetable, Strawberry, Blackberry, Lime"][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][nectar_food_menu_item style="default" item_name_heading_tag="h4" item_name="Water" text="$9" item_price="$1" item_description="Tap, Distilled, Reverse Osmosis "][/vc_column_inner][/vc_row_inner][/tab][tab title="Dinner" id="1486683129769-4-9" tab_id="1483371745354-1"][vc_row_inner column_margin="default" top_padding="30" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1486682668056{margin-bottom: 30px !important;}"]
<h5>Appetizers</h5>
[/vc_column_text][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Fried Mozzarella " text="$9" item_price="$8" item_description="It's just plain and simple, but also tasty"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Shrimp Cocktail" text="$9" item_price="$10" item_description="A little shrimp, a little cocktail "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Classic California" text="$9" item_price="$11" item_description="You know it's good, just order it"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1486683213935{margin-bottom: 30px !important;}"]
<h5>Salads</h5>
[/vc_column_text][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="The Caesar " text="$9" item_price="$13" item_description="Served with choice of chicken &amp; cheese "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Stuffed Tomato" text="$9" item_price="$12" item_description="Chicken Salad stuffed with Roma Tomatoes "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Club Salda" text="$9" item_price="$12" item_description="Fresh romaine lettuce &amp; grated cheese"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1486683207946{margin-bottom: 30px !important;}"]
<h5>Pasta</h5>
[/vc_column_text][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="The Ravioli " text="$9" item_price="$27" item_description="Cooked to perfection by Chef Nectar "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Nectar Linguine " text="$9" item_price="$25" item_description="The best pasta you'll ever eat"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Vodka Sauce" text="$9" item_price="$22" item_description="With Grilled chicken, tomato and cheese "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="``Very Big`` Bowl" text="$9" item_price="$22" item_description="Made to share, four separate samples in one "][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="2px" column_border_color="#3452ff" column_border_style="double_offset" enable_border_animation="true"][vc_column_text css=".vc_custom_1486683185332{margin-bottom: 30px !important;}"]
<h5>Steak &amp; Seafood</h5>
[/vc_column_text][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Salient Filet" text="$9" item_price="$37" item_description="Served best medium rare "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Oscar Salient FIlet" text="$9" item_price="$42" item_description="The Salient Filet with crab meat"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Nectar's Choice" text="$9" item_price="$31" item_description="Ask your server for more details"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="60" text_align="left" css=".vc_custom_1486083303611{padding-right: 2% !important;padding-left: 2% !important;}"][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][nectar_food_menu_item style="default" item_name_heading_tag="h4" item_name="Sodas" text="$9" item_price="$4" item_description="Coca cola, Pepsi, Sprite, Fanta, Nectar Soda, Salient Fizz"][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][nectar_food_menu_item style="default" item_name_heading_tag="h4" item_name="Tea" text="$9" item_price="$6" item_description="Green, Red, Black, Yellow, White Warm &amp; Hot"][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][nectar_food_menu_item style="default" item_name_heading_tag="h4" item_name="Juices" text="$9" item_price="$3" item_description="Orange, Apple, Vegetable, Strawberry, Blackberry, Lime"][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][nectar_food_menu_item style="default" item_name_heading_tag="h4" item_name="Water" text="$9" item_price="$1" item_description="Tap, Distilled, Reverse Osmosis "][/vc_column_inner][/vc_row_inner][/tab][tab title="Drink List" id="1486683598327-4-5" tab_id="1483371745312-1"][vc_row_inner column_margin="default" top_padding="30" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1486683632214{margin-bottom: 30px !important;}"]
<h5>Reds</h5>
[/vc_column_text][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Gina Pinot Noir" text="$9" item_price="$8" item_description="Black cherry notes, light bodied "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Guilty Pleasure Merlot" text="$9" item_price="$10" item_description="Medium to full bodied, premium taste"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Classic California" text="$9" item_price="$11" item_description="You know it's good, just order it"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1486683638682{margin-bottom: 30px !important;}"]
<h5>Whites</h5>
[/vc_column_text][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Flawless Pinot Grigo" text="$9" item_price="$10" item_description="Fresh, medium bodied "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Sauvignon Blanc " text="$9" item_price="$12" item_description="The perfect medium bodied white"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Chardon-hey " text="$9" item_price="$12" item_description="Chardonnay with a little twist"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1486683647410{margin-bottom: 30px !important;}"]
<h5>Rose</h5>
[/vc_column_text][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Pacific Heights" text="$9" item_price="$12" item_description="A fun light tasty addition "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Friday night out" text="$9" item_price="$11" item_description="Medium - full bodied mix"][nectar_food_menu_item style="line_between" item_na