<?php
/*
Plugin Name: Gravity Post & Tracking Continental
Plugin URI: http://www.publitiva.com
Description: Envia el Formulario de Gravity via HTTP request, ademas pudiendo trackear el formulario con el Sistema de Tracking de la UC. [Jun-23]
Version: 1.7.6.1
Author: Paulo Ramos
Author Email: pauloramosc@gmail.com

*/

use YahnisElsts\PluginUpdateChecker\v5\PucFactory;


if ( !defined( 'GRAVITY_HTTP_PATH' ) ) define( 'GRAVITY_HTTP_PATH',   plugin_dir_path( __FILE__ ) . 'inc/' );
if ( !defined( 'GRAVITY_HTTP_URL' ) ) define( 'GRAVITY_HTTP_URL',   plugin_dir_url( __FILE__ ) . 'inc/' );


class GravityHTTPRequest {

	/*--------------------------------------------*
	 * Constants
	 *--------------------------------------------*/
	const name = 'Post Tracking UC';
	const slug = 'post_track_uc';

	/**
	 * Constructor
	 */
	function __construct() {

		add_filter('gform_form_settings_menu', array($this, 'gravity_http_settings_menu'));

		add_action('gform_form_settings_page_'.self::slug, array($this, 'gravity_http_settings_page'));

		add_action('admin_enqueue_scripts', array($this, 'register_scripts_and_styles'));

		add_action('gform_after_submission', array($this, 'gravity_http_post_data'), 10, 2);

		add_shortcode('track_uc', array($this, 'track_uc_func'));

		add_action('send_headers', array($this, 'set_newuser_cookie'));

		add_filter('gform_field_value_token', array($this, 'populate_affiliate_t'));

		add_filter('gform_field_value_periodo', array($this, 'populate_affiliate_periodo'));
		add_filter('gform_field_value_periodofuturo', array($this, 'populate_affiliate_periodo_future'));
		add_filter('gform_field_value_periodoic', array($this, 'populate_affiliate_periodo_ic'));

		add_action('init', array($this, 'check_state_gravity_post_track'));

		if (class_exists('WpFastestCache')) {
			add_action( 'wp_head', array($this, 'add_head_nocache'));
		}

	}


	function gravity_http_post_data($entry, $form) {

		if ($form['http_request_settings']['http_request_active']):

			$post_url = $form['http_request_settings']['form_http_url'];

		$request = new WP_Http();

		foreach ( $form['fields'] as $field ) {

			if ( $field['inputs'] ) {

				if ($field['http_output'] === 'map') {

					foreach ($field['inputs'] as $input) {

						$id = (string)$input['id'];

						$post_body[$input['http_map']] = $entry[$id];

					}

				} elseif ($field['http_output'] === 'serialize') {


					foreach ($field['inputs'] as $input) {

						$id =  (string)$input['id'];

						$serialize[] = $entry[$id];

					}

					$post_body[$field['http_map']] = json_encode($serialize);

				}

			} else {

				$post_body[$field['http_map']] = $entry[$field['id']];

			}


		}

		if ($form['http_request_settings']['http_request_type'] === 'post_request') {

			$response = $request->request( $post_url, array( 'method' => 'POST', 'body' => $post_body, 'sslverify' => false ) );

		} elseif ($form['http_request_settings']['http_request_type'] === 'get_request') {

			$response = $request->request( $post_url, array( 'method' => 'GET', 'body' => $post_body) );

		}

		if (is_wp_error($response)) {

			$error = $response->get_error_message();

			error_log("WP Error:" . $error, 0);

		}

		else {

			$log = $response['body'];

			error_log("Form:" . $log, 0);

		}

		endif;

	}


	// add a custom menu item to the Form Settings page menu
	function gravity_http_settings_menu($menu_items) {

		$menu_items[] = array(
			'name' => self::slug,
			'label' => self::name
		);

		return $menu_items;
	}


	// handle displaying content for our custom menu when selected
	function gravity_http_settings_page() {

		//see if there is a form id in the querystring
		$form_id = RGForms::get("id");

		$form = GFAPI::get_form($form_id);

		if ( ! empty( $_POST ) && check_admin_referer('gforms_save_http_settings', 'gforms_save_http_settings') ) {

			$form['http_request_settings']['form_http_url'] = rgpost('form_http_url');
			$form['http_request_settings']['http_request_type'] = rgpost('form_request_type');
			$form['http_request_settings']['date_updated'] = rgpost('date_updated');
			$form['http_request_settings']['http_request_active'] = rgpost('http_request_active');
			$form['http_request_settings']['form_track_code'] = rgpost('form_track_code');

			$i=0;
			foreach ($form['fields'] as $field) {

				if ($field['inputs']) {

					$form['fields'][$i]['http_map'] = rgpost('field_'.$field['id'].'_map');

					$form['fields'][$i]['http_output'] = rgpost('field_'.$field['id'].'_serialize');


					$k=0;
					foreach ($field['inputs'] as $input) {

						$input_id = str_replace('.', '_', $input['id']);

						$form['fields'][$i]['inputs'][$k]['http_map'] = rgpost('field_'.$input_id.'_map');

						$k++;
					}



				} else {

					$form['fields'][$i]['http_map'] = rgpost('field_'.$field['id'].'_map');

					if ($field['choices']) {

						$form['fields'][$i]['value_output'] = rgpost('field_'.$field['id'].'_value_output');

					}

				}

				$i++;
			}

			$result = GFAPI::update_form($form);

		}


		GFFormSettings::page_header();

		include_once(GRAVITY_HTTP_PATH.'settings-screen.php');

		GFFormSettings::page_footer();

	}


	/**
	 * Registers and enqueues stylesheets for the administration panel and the
	 * public facing site.
	 */
	function register_scripts_and_styles() {
		if ( is_admin() ) {

			wp_register_style('gravity_http_styles', GRAVITY_HTTP_URL . 'css/plugin-admin.css');
			wp_enqueue_style('gravity_http_styles');

		} else {

		} // end if/else
	} // end register_scripts_and_styles


	function getCampaign( $url, $code ) {
		$track_url = parse_url($url);
		$json = array('respuesta' => 'encontrada', 'name' => 'Url no perteneciente al Tracking actual, revisar bien el código de campaña');
		if ($track_url['host'] == 'continua.continental.education') {
			$url = $track_url['scheme'].'://'.$track_url['host'].'/api/?k=ce77d2dc-0fb44f90-879e6fdb&campaign='.$code;
			$content = self::url_get_contents($url);
			$json = json_decode($content, true);
			return $json;
		}
		if ($track_url['host'] == 'tc.continental.education') {
			$url = $track_url['scheme'].'://'.$track_url['host'].'/api/?k=ce77d2dc-0fb44f90-879e6fdb&campaign='.$code;
			$content = self::url_get_contents($url);
			$json = json_decode($content, true);
		}
		if ($track_url['host'] == 'tc.icontinental.edu.pe') {
			$url = $track_url['scheme'].'://'.$track_url['host'].'/api/?k=ce77d2dc-0fb44f90-879e6fdb&campaign='.$code;
			$content = self::url_get_contents($url);
			$json = json_decode($content, true);
		}
		return $json;
	}


	function url_get_contents ($Url) {
		if (!function_exists('curl_init')){
			die('CURL is not installed!');
		}
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $Url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		$output = curl_exec($ch);
		curl_close($ch);
		return $output;
	}


	//crear pixel
	function track_uc_func( $atts ) {

		$ipaddress = '';
		if (getenv('HTTP_CLIENT_IP'))
			$ipaddress = getenv('HTTP_CLIENT_IP');
		else if(getenv('HTTP_X_FORWARDED_FOR'))
			$ipaddress = getenv('HTTP_X_FORWARDED_FOR');
		else if(getenv('HTTP_X_FORWARDED'))
			$ipaddress = getenv('HTTP_X_FORWARDED');
		else if(getenv('HTTP_FORWARDED_FOR'))
			$ipaddress = getenv('HTTP_FORWARDED_FOR');
		else if(getenv('HTTP_FORWARDED'))
			$ipaddress = getenv('HTTP_FORWARDED');
		else if(getenv('REMOTE_ADDR'))
			$ipaddress = getenv('REMOTE_ADDR');
		else
			$ipaddress = 'UNKNOWN';

		$uri_parts_img = explode('?', $_SERVER['REQUEST_URI'], 2);
		$string_img = $uri_parts_img[0];
		$url_cookie_img = self::Slug($_SERVER['HTTP_HOST'].'-'.$string_img);

		$actual_link = urldecode("https://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]");

		$referido = '';
		if (!isset($_COOKIE['refer'])) {
			if (isset($_SERVER['HTTP_REFERER'])) {
				$referido = base64_encode($_SERVER['HTTP_REFERER']);
			}
		} else {
			$referido = $_COOKIE['refer'];
		}

		extract( shortcode_atts( array(
			'campaign' => false,
			'type' => 'text',
			'cookie' => $_COOKIE[$url_cookie_img],
			'ip' => $ipaddress,
			'refer' => $referido,
			'utm' => base64_encode($actual_link),
			), $atts ) );

		if (!empty($campaign)) {

			$campain = explode('-', $campaign);
			$form = GFAPI::get_form($campain[1]);

			$track_code = $form['http_request_settings']['form_track_code'];
			$track_url = parse_url($form['http_request_settings']['form_http_url']);
			$track_url = $track_url['host'];

			if ($campain[0] == $track_code) {
				return '<img src="//'.$track_url.'/pixel/'. $campain[0] .'_'. $cookie .'_'. $ip .'_'. $refer .'_'. $utm .'_.png" >';
			} else {
				return 'Codigo de campaña erroneo.';
			}

		} else {
			return 'Se requiere el código de la campaña.';
		}
	}


	// crear token
	function set_newuser_cookie() {
		$domain = ($_SERVER['HTTP_HOST'] != 'localhost') ? $_SERVER['HTTP_HOST'] : false;
		if (!is_admin()) {
			$uri_parts = explode('?', $_SERVER['REQUEST_URI'], 2);
			$string = $uri_parts[0];
			if (strpos($string, '.css') === false && strpos($string, '.js') === false && strpos($string, '.png') === false && strpos($string, '.svg') === false && strpos($string, '/css/') === false ) {
				$url_cookie = self::Slug($_SERVER['HTTP_HOST'].'-'.$string);
				$get_token = self::getToken();
				if ( !isset($_COOKIE[$url_cookie]) && $url_cookie != '') {
					setcookie($url_cookie, $get_token, time()+3600*24, '/', $domain, TRUE, TRUE);
					$_COOKIE[$url_cookie] = $get_token;
				}
			}
			if (isset($_SERVER['HTTP_REFERER'])) {
				setcookie('refer', base64_encode($_SERVER['HTTP_REFERER']), time()+30, '/', $domain, TRUE, TRUE);
			}
		}
	}

	function getToken($length=17){
		$token = "";
		$codeAlphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
		$codeAlphabet.= "abcdefghijklmnopqrstuvwxyz";
		$codeAlphabet.= "0123456789";
		for($i=0;$i<$length;$i++){
			$token .= $codeAlphabet[self::crypto_rand_secure(0,strlen($codeAlphabet))];
		}

		//  adicionar sub utm al token

		$actual_link = "https://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
		$url = parse_url(urldecode($actual_link));
		$sub = false;

		$host = $url['host'];

		$sub = '-';
		if (isset($url['query'])) {
			$query = $url['query'];
			parse_str($query, $output);//se obtiene la variable url y se convierte en variable php
			if (isset($output['sub'])) {
				$sub = '-'.$output['sub'];
			}
		}

		return $token.$sub;
	}


	function crypto_rand_secure($min, $max) {
		$range = $max - $min;
		if ($range < 0) return $min; // not so random...
		$log = log($range, 2);
		$bytes = (int) ($log / 8) + 1; // length in bytes
		$bits = (int) $log + 1; // length in bits
		$filter = (int) (1 << $bits) - 1; // set all lower bits to 1
		do {
			$rnd = hexdec(bin2hex(openssl_random_pseudo_bytes($bytes)));
			$rnd = $rnd & $filter; // discard irrelevant bits
		} while ($rnd >= $range);
		return $min + $rnd;
	}


	//populate token en form
	function populate_affiliate_t(){
		$uri_parts_ = explode('?', $_SERVER['REQUEST_URI'], 2);
		$string_ = $uri_parts_[0];
		$url_cookie_ = self::Slug($_SERVER['HTTP_HOST'].'-'.$string_);
		return $_COOKIE[$url_cookie_];
	}


	//populate periodo en form
	function populate_affiliate_periodo(){
		$track_url = 'https://tc.continental.education';
		$url = $track_url.'/api/?k=ce77d2dc-0fb44f90-879e6fdb&periodo=get';
		$content = self::url_get_contents($url);
		$json = json_decode($content, true);
		if ($json['respuesta'] !== 'false') {
			return $json['respuesta'];
		}
	}

	function populate_affiliate_periodo_future(){
		$track_url = 'https://tc.continental.education';
		$url = $track_url.'/api/?k=ce77d2dc-0fb44f90-879e6fdb&periodo=future';
		$content = self::url_get_contents($url);
		$json = json_decode($content, true);
		if ($json['respuesta'] !== 'false') {
			return $json['respuesta'];
		}
	}

	function populate_affiliate_periodo_ic(){
		$track_url = 'https://tc.icontinental.edu.pe';
		$url = $track_url.'/api/?k=ce77d2dc-0fb44f90-879e6fdb&periodo=get';
		$content = self::url_get_contents($url);
		$json = json_decode($content, true);
		if ($json['respuesta'] !== 'false') {
			return $json['respuesta'];
		}
	}

	function populate_affiliate_periodo_continua(){
		$track_url = 'https://continua.continental.education';
		$url = $track_url.'/api/?k=ce77d2dc-0fb44f90-879e6fdb&periodo=get';
		$content = self::url_get_contents($url);
		$json = json_decode($content, true);
		if ($json['respuesta'] !== 'false') {
			return $json['respuesta'];
		}
	}


	function check_state_gravity_post_track() {
		include( plugin_dir_path( __FILE__ ) . 'inc/update/plugin-update-checker.php');
		$MyUpdateChecker = PucFactory::buildUpdateChecker(
			'https://publitiva.com/wp-update/?action=get_metadata&slug=gravity-post-track',
			__FILE__,
			'gravity-post-track'
		);
	}


	//Exclude to WP FastestCache
	function add_head_nocache() {
		return '<!–[wpfcNOT]>';
	}

	function Slug($string){
		return strtolower(trim(preg_replace('~[^0-9a-z]+~i', '-', html_entity_decode(preg_replace('~&([a-z]{1,2})(?:acute|cedil|circ|grave|lig|orn|ring|slash|th|tilde|uml);~i', '$1', htmlentities($string, ENT_QUOTES, 'UTF-8')), ENT_QUOTES, 'UTF-8')), '-'));
	}


} // end class


/**
* Load Classs
*/
if (class_exists('GFForms')) {

	new GravityHTTPRequest();

	if (!class_exists('GWMapFieldToField')) {
		new GWMapFieldToFieldTrack();
	}


}



/** Can populate fields in another field **/
class GWMapFieldToFieldTrack {
	public $lead = null;
	function __construct( ) {
		add_filter( 'gform_pre_validation', array( $this, 'map_field_to_field' ), 11 );
	}
	function map_field_to_field( $form ) {
		foreach( $form['fields'] as $field ) {
			if( is_array( $field['inputs'] ) ) {
				$inputs = $field['inputs'];
			} else {
				$inputs = array(
					array(
					'id' => $field['id'],
					'name' => $field['inputName']
					)
				);
			}
			foreach( $inputs as $input ) {
				$value = rgar( $input, 'name' );
				if( ! $value )
					continue;
				$post_key = 'input_' . str_replace( '.', '_', $input['id'] );
				$current_value = rgpost( $post_key );
				preg_match_all( '/{[^{]*?:(\d+(\.\d+)?)(:(.*?))?}/mi', $input['name'], $matches, PREG_SET_ORDER );
				// if there is no merge tag in inputName - OR - if there is already a value populated for this field, don't overwrite
				if( empty( $matches ) )
					continue;
				$entry = $this->get_lead( $form );
				foreach( $matches as $match ) {
					list( $tag, $field_id, $input_id, $filters, $filter ) = array_pad( $match, 5, 0 );
					$force = $filter === 'force';
					$tag_field = RGFormsModel::get_field( $form, $field_id );
					// only process replacement if there is !no value OR if force filter is provided
					$process_replacement = ! $current_value || $force;
					if( $process_replacement && ! RGFormsModel::is_field_hidden( $form, $tag_field, array() ) ) {
						$field_value = GFFormsModel::get_field_value( $tag_field );
						if( is_array( $field_value ) ) {
							$field_value = implode( ',', array_filter( $field_value ) );
						}
					} else {
						$field_value = '';
					}
					$value = trim( str_replace( $match[0], $field_value, $value ) );
				}
				if( $value ) {
					$_POST[$post_key] = $value;
				}
			}
		}
		return $form;
	}
	function get_lead( $form ) {
		if( ! $this->lead )
			$this->lead = GFFormsModel::create_lead( $form );
		return $this->lead;
	}
}

?>