<?php
/**
 * Plugin Name: Continental Elementos UC 2023
 * Description: Adición de elementos para tema Salient
 * Plugin URI: https://publitiva.com/
 * Author: Paulo Ramos
 * Author URI: https://publitiva.com/
 * Version: 0.7
 */

use YahnisElsts\PluginUpdateChecker\v5\PucFactory;

define('VERSION', '0.7');
// define('VERSION', time());

new ContinentalSalientbyPublitiva();

class ContinentalSalientbyPublitiva {

	function __construct() {

		add_action( 'init', array( $this, 'activate' ) );

		add_action( 'admin_enqueue_scripts', array($this, 'backend_scripts'));
		add_action( 'wp_enqueue_scripts', array($this, 'frontend_scripts'));

		add_action( 'init', array($this, 'load_vc_elements'), 0);

		add_action('init', array($this, 'check_state_update'));
	}

	function activate() {
        if ( ! defined( 'WPB_VC_VERSION' ) ) {
            // Display notice that Extend WPBakery Page Builder is required
            add_action('admin_notices', array( $this, 'showVcVersionNotice' ));
            return;
        }
	}

	function check_state_update() {
		include( plugin_dir_path( __FILE__ ) . 'inc/update/plugin-update-checker.php');
		$MyUpdateChecker = PucFactory::buildUpdateChecker(
			'https://publitiva.com/wp-update/?action=get_metadata&slug=continental-salient',
			__FILE__,
			'continental-salient'
		);
	}

	function backend_scripts() {
		if (is_admin()) {
			$ver = VERSION;
			wp_enqueue_style('continental_silent_back', plugin_dir_url(__DIR__) . plugin_basename(__DIR__) . '/assets/css/back.css?'.$ver);
		}
	}

	function frontend_scripts() {
		$ver = VERSION;
		wp_enqueue_style('continental_silent_css', plugin_dir_url(__DIR__) . plugin_basename(__DIR__) . '/assets/css/style.css?'.$ver);
		wp_enqueue_script('continental_silent_js', plugin_dir_url(__DIR__) . plugin_basename(__DIR__) . '/assets/js/script.js?'.$ver, array('jquery'));
	}


	function load_vc_elements()
	{
		require_once(plugin_dir_path( __FILE__ ) . 'inc/vc-addons.php');
	}

}
