<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


class WPBakeryShortCode_testimonial_uc_slider extends WPBakeryShortCode_Tabbed_Section {}
class WPBakeryShortCode_testimonial_uc_element extends WPBakeryShortCode {}

class PublitivaTestimonialUcSlider {

	function __construct() {
		add_shortcode( "testimonial_uc_slider", array($this, "pa_vc_render_testimonios" ));
		add_shortcode( "testimonial_uc_element", array($this, "pa_vc_atts_testimonios" ));
		add_action( 'admin_init', array($this, 'pa_vc_maps_testimonios_uc' ));
	}

	function pa_vc_maps_testimonios_uc() {
		$tab_id_1 = time().'-1-'.rand(0, 10);
		$tab_id_2 = time().'-2-'.rand(0, 10);
		vc_map([
			"name" => __("Testimonio UC Slider", "continental-salient"),
			"base" => "testimonial_uc_slider",
			"icon" => "icon-wpb-testimonial-slider",
			"category"    => 'Continental',
			"description" => __('Testimonios en formato slider', 'continental-salient'),
			"show_settings_on_create" => false,
			"is_container" => true,
			"params" => [
				[
					"type" => "textfield",
					"heading" => __("Auto rotación", "continental-salient"),
					"param_name" => "autorotate",
					"value" => '7000',
					"description" => __("Si desea que gire automáticamente, ingrese aquí la velocidad de rotación en milisegundos. Ejemplo: 7000", "continental-salient")
				],
				[
					"type" => "textfield",
					"heading" => __("Clase adicional", "continental-salient"),
					"param_name" => "class",
					"value" => '',
				]
			],
			"custom_markup" => '
				<div class="wpb_tabs_holder wpb_holder vc_container_for_children">
				<ul class="tabs_controls">
				</ul>
				%content%
				</div>'
			,
			'default_content' => '
				[testimonial_uc_element title="'.__('Testimonio','continental-salient').'" id="'.$tab_id_1.'"] Clic en el botón editar para agregar su testimonio. [/testimonial_uc_element]
				[testimonial_uc_element title="'.__('Testimonio','continental-salient').'" id="'.$tab_id_2.'"] Clic en el botón editar para agregar su testimonio. [/testimonial_uc_element]
			',
			"js_view" => 'VcTabsView'
		]);

		vc_map(array(
			"name" => __("Testimonial", "continental-salient"),
			"base" => "testimonial_uc_element",
			"allowed_container_element" => 'vc_row',
			"is_container" => false,
			"content_element" => false,
			"params" => [
				[
					"type" => "textfield",
					"heading" => __("Titulo", "continental-salient"),
					"param_name" => "header",
					"admin_label" => true,
					"description" => __("Titulo del testimonio", "continental-salient")
				],
				[
					"type" => "textfield",
					"heading" => __("Descripción", "continental-salient"),
					"param_name" => "description",
					"description" => __("Descripción del testimonio", "continental-salient")
				],
				[
					"type" => "textfield",
					"heading" => __("Youtube ID", "continental-salient"),
					"param_name" => "video",
					"description" => __("Incluir solo la ID del video de Youtube", "continental-salient")
				],
				[
					"type" => "attach_image",
					"class" => "",
					"heading" => __("Imagen", "continental-salient"),
					"value" => "",
					"param_name" => "image",
					"description" => __("Agrega la imagen del cover del video", "continental-salient")
				],
				[
					"type" => "textarea_raw_html",
					"heading" => __("Mensaje", "continental-salient"),
					"param_name" => "quote",
					"description" => __("El mensaje del testimonio", "continental-salient")
				],
				[
					"type" => "textfield",
					"heading" => __("Nombre", "continental-salient"),
					"param_name" => "name",
					"description" => __("Name or source of the testimonial", "continental-salient")
				],
				[
					"type" => "textfield",
					"heading" => __("Subtitulo", "continental-salient"),
					"param_name" => "subtitle",
					"description" => __("El subtítulo opcional que seguirá al nombre", "continental-salient")
				],
				[
					"type" => "textfield",
					"heading" => __("Subtitulo 2", "continental-salient"),
					"param_name" => "subtitle2",
					"description" => __("El segundo subtítulo opcional que seguirá al subtitulo", "continental-salient")
				],
				[
					"type" => "tab_id",
					"heading" => __("Testimonio ID", "continental-salient"),
					"param_name" => "id"
				]
			],
			'js_view' => 'VcTabView'
		));

	}

	function pa_vc_atts_testimonios( $atts, $content ) {

		extract( shortcode_atts( [
			'autorotate' => '',
			'class' => '',
			'header' => '',
			'description' => '',
			'video' => '',
			'image' => '',
			'quote' => '',
			'name' => '',
			'subtitle' => '',
			'subtitle2' => '',
		], $atts ) );

		echo do_shortcode( $content );

	}

	function pa_vc_render_testimonios( $atts, $content = null, $tag ) {

		$pattern = get_shortcode_regex(['testimonial_uc_element']);
		preg_match_all('/'. $pattern .'/s', $content, $matches);
		$testimonios = [];
		foreach( $matches[3] as $match ){
			$testimonios[] = shortcode_parse_atts($match);
		};

		$clase_testimonio = $atts['class'] ?? '';
		$SliderTestimonio = ['autorotate' => $atts['autorotate'] ?? 7000];

		$element = '';
		if (count($testimonios) > 0) {
			foreach ($testimonios as $j => $c) {
				if (isset($c['name'])) {
					$_image = [];
					$_image[0] = '';
					$_image_none = 'd-none';
					if (isset($c['image'])) {
						$_image_none = '';
						$_image = wp_get_attachment_image_src( $c['image'], 'full' );
					}

					$_title = $c['header'] ?? '';
					$_description = $c['description'] ?? '';
					$_quote = $c['quote'] ?? '';
					$_name = $c['name'] ?? '';
					$_subtitle = $c['subtitle'] ?? '';
					$_subtitle2 = $c['subtitle2'] ?? '';

					$video_start = $video_end = '';
					if (isset($c['video'])) {
						$video_start = '<a href="javascript:;" class="js-modal-btn" data-video-id="'.$c['video'].'">';
						$video_end = '
						<svg version="1.1" class="play-svg" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 100 100" enable-background="new 0 0 100 100" xml:space="preserve">
							<path class="stroke-solid" fill="none" stroke="white"  d="M49.9,2.5C23.6,2.8,2.1,24.4,2.5,50.4C2.9,76.5,24.7,98,50.3,97.5c26.4-0.6,47.4-21.8,47.2-47.7
								C97.3,23.7,75.7,2.3,49.9,2.5"/>
							<path class="stroke-dotted" fill="none" stroke="white"  d="M49.9,2.5C23.6,2.8,2.1,24.4,2.5,50.4C2.9,76.5,24.7,98,50.3,97.5c26.4-0.6,47.4-21.8,47.2-47.7
								C97.3,23.7,75.7,2.3,49.9,2.5"/>
							<path class="icon" fill="white" d="M38,69c-1,0.5-1.8,0-1.8-1.1V32.1c0-1.1,0.8-1.6,1.8-1.1l34,18c1,0.5,1,1.4,0,1.9L38,69z"/></svg>
						</a>';
					}

					$element .= '
		<div class="swiper-slide">
			<div data-column-margin="default" class="wpb_row vc_row-fluid vc_row inner_row">
				<div class="row_col_wrap_12_inner col span_12 left">
					<div class="vc_col-sm-7 wpb_column column_container vc_column_container col child_column no-extra-padding inherit_tablet inherit_phone ">
						<div class="vc_column-inner">
							<div class="wpb_wrapper">
								<div class="wpb_content_element ">
									<div class="wpb_wrapper">
										<h3 class="title">'.wp_kses_post($_title).'</h3>
										<p class="description">'.wp_kses_post($_description).'</p>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div data-column-margin="default" class="wpb_row vc_row-fluid vc_row inner_row">
				<div class="row_col_wrap_12_inner col span_12 left">
					<div class="vc_col-sm-6 wpb_column column_container vc_column_container vc_col-xs child_column no-extra-padding inherit_tablet inherit_phone">
						<div class="vc_column-inner">
							<div class="wpb_wrapper">
								<div class="wpb_content_element image-play">
									<div class="wpb_wrapper">
										<div class="rectangle-top '.$_image_none.'"></div>
										<div class="square-bottom '.$_image_none.'"></div>
										'.$video_start.'
										<img src="'.$_image[0].'" width="500" height="290">
										'.$video_end.'
									</div>
								</div>
							</div>
						</div>
					</div>

					<div class="vc_col-sm-6 wpb_column column_container vc_column_container col child_column no-extra-padding inherit_tablet inherit_phone">
						<div class="vc_column-inner">
							<div class="wpb_wrapper">
								<div class="wpb_content_element testimonio-quote">
									<div class="wpb_wrapper">
										<div class="icon"><i class="fa fa-quote-left"></i></div>
										<p class="quote">'.urldecode(base64_decode($_quote)).'</p>
										<h5 class="">'.wp_kses_post($_name).'</h5>
										<h6 class="">'.wp_kses_post($_subtitle).'</h6>
										<h6 class="text-verde">'.wp_kses_post($_subtitle2).'</h6>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
					';
				}
			}
		}

		$output = '
<div class="swiper swiper-testimonio '.$clase_testimonio.'">
	<div class="autoplay-progress">
		<svg viewBox="0 0 48 48">
			<circle cx="24" cy="24" r="20"></circle>
		</svg>
	</div>
	<div class="swiper-wrapper">
		'.$element.'
	</div>
	<div class="swiper-footer">
		<div class="swiper-pagination"></div>
		<div class="swiper-button-prev"></div>
		<div class="swiper-button-next"></div>
	</div>
</div>
';
		wp_enqueue_script( 'continental_uc_data', get_template_directory_uri() . '/../salient-child/script.js' );
		wp_add_inline_script( 'continental_uc_data', 'var SliderTestimonio = ' . wp_json_encode( $SliderTestimonio ), 'before' );

		return $output;
	}

}