<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class WPBakeryShortCode_similar_carrera_element extends WPBakeryShortCode {}

class PublitivaSimilarPortfolio {

	function __construct() {
		add_shortcode( "similar_carrera_element", array($this, "pa_vc_render_similar" ));
		add_action( 'admin_init', array($this, 'pa_vc_maps_similar_uc' ));
	}

	function pa_vc_maps_similar_uc() {

		vc_map(array(
			"name" => __("Carrera similar", "continental-salient"),
			"base" => "similar_carrera_element",
			"icon" => "icon-wpb-carousel",
			"category"    => 'Continental',
			"is_container" => false,
			"params" => [
				[
					"type" => "textfield",
					"heading" => __("Clase adicional", "continental-salient"),
					"param_name" => "class",
					"admin_label" => true,
				]
			]
		));

	}


	function pa_vc_render_similar( $atts ) {

		extract( shortcode_atts( [
			'class' => '',
		], $atts ) );

		$clase_logro = $class;

		$post_id = get_the_ID();

		$project_cat_list  = get_the_terms($post_id, 'project-type');
		// $project_att_list  = get_terms( [
		// 	'taxonomy' => 'project-attributes'
		// ] );

		$posts_array = get_posts(
			[
				'showposts' => -1,
				'post_type' => 'portfolio',
				'tax_query' => [
					[
						'taxonomy' => 'project-type',
						'field' => 'term_id',
						'terms' => $project_cat_list[0]->term_id,
					]
				]
			]
		);

		$carreras = [];

		foreach ($posts_array as $key => $p) {
			if ( $p->ID != $post_id ) {
				$carreras[$key] = [
					'facultad' => $project_cat_list[0]->name,
					'title' => $p->post_title,
					'excerpt' => get_post_meta($p->ID, '_nectar_project_excerpt', true),
					'url' => get_permalink( $p->ID ),
				];
			}
		}
		// echo "<br><br>";
		// print_r( $posts_array );

		$element = '';
		if (count($carreras) > 0) {
			foreach ($carreras as $k => $c) {

				$element .= '
		<div class="swiper-slide">
			<div data-column-margin="default" class="wpb_row vc_row-fluid vc_row inner_row">
				<div class="row_col_wrap_12_inner col span_12 left">
					<div class="vc_col-sm-12 wpb_column column_container vc_column_container col child_column no-extra-padding inherit_tablet inherit_phone">
						<div class="vc_column-inner">
							<div class="wpb_wrapper">
								<div class="wpb_content_element card-carrera-similar">
									<div class="wpb_wrapper">
										<div>
											<span class="meta-category">'.$c['facultad'].'</span>
										</div>
										<div class="item-main">
											<h3 class="post-heading">
												<a href="'.$c['url'].'">'.$c['title'].'</a>
											</h3>
											<div class="item-meta-extra">
												<span class="meta-excerpt">'.$c['excerpt'].'</span>
											</div>
										</div>
										<div class="link">
											<a class="" href="'.$c['url'].'">Más detalle <i class="icon-button-arrow"></i></a>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
				';

			}
		}

		$output = '
<div class="swiper swiper-similar '.$clase_logro.'">
	<div class="swiper-wrapper">
		'.$element.'
	</div>
	<div class="swiper-footer">
		<div class="swiper-pagination"></div>
		<div class="swiper-button-prev"></div>
		<div class="swiper-button-next"></div>
	</div>
</div>
';
		return $output;
	}

}