<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class WPBakeryShortCode_modalidad_carrera_select extends WPBakeryShortCode {}

class PublitivaModalidadCarrera {

	function __construct() {
		add_shortcode( "modalidad_carrera_select", array($this, "pa_vc_render_modadalidad_carrera" ));
		add_action( 'admin_init', array($this, 'pa_vc_maps_modalidad_carrera' ));
	}

	function pa_vc_maps_modalidad_carrera() {

		vc_map(array(
			"name" => __("Modalidades por Carrera", "continental-salient"),
			"base" => "modalidad_carrera_select",
			"icon" => "icon-wpb-progress_bar",
			"category"    => 'Continental',
			"is_container" => false,
			"params" => [
				[
					"type" => "dropdown",
					"heading" => __("Carrera", "continental-salient"),
					"value" => [
						"Ninguno" => 0,
						'Administración' => '118',
						'Administración y Finanzas' => '115',
						'Administración y Gestión Publica' => '104',
						'Administración y Marketing' => '117',
						'Administración y Negocios Digitales' => '320',
						'Administración y Negocios Internacionales' => '114',
						'Administración y Recursos Humanos' => '116',
						'Administración: Marketing y Neg. Internac.' => '133',
						'Arquitectura' => '122',
						'Ciencias de la Computación' => '315',
						'Ciencias y Tecnologías de la Comunicación' => '103',
						'Contabilidad' => '124',
						'Contabilidad y Auditoria' => '121',
						'Derecho' => '106',
						'Economía' => '107',
						'Educación con especialidad en innovación y aprendizaje digital' => '321',
						'Enfermería' => '111',
						'Ingeniería Ambiental' => '130',
						'Ingeniería Civil' => '119',
						'Ingeniería de Minas' => '123',
						'Ingeniería de Sistemas e Informatica' => '129',
						'Ingeniería Eléctrica' => '108',
						'Ingeniería Electrónica' => '128',
						'Ingeniería Empresarial' => '109',
						'Ingeniería en Agronegocios' => '105',
						'Ingeniería Industrial' => '126',
						'Ingeniería Mecánica' => '131',
						'Ingeniería Mecatrónica' => '132',
						'Medicina Humana' => '113',
						'Obstetricia' => '134',
						'Odontología' => '110',
						'Psicología' => '125',
						'Tecnología Médica - Laboratorio Clínico y Anatomía Patológica' => '127',
						'Tecnología Médica - Terapia Física y Rehabilitación' => '120',
					],
					"save_always" => true,
					"param_name" => "carrera",
					"admin_label" => true,
					"description" => __("Selecciona la carrera", "continental-salient")
				],
				[
					"type" => "textfield",
					"heading" => __("Clase adicional", "continental-salient"),
					"param_name" => "class"
				]
			]
		));

	}


	function pa_vc_render_modadalidad_carrera( $atts ) {

		extract( shortcode_atts( [
			'carrera' => '',
			'class' => '',
		], $atts ) );

		$element = $list = '';

		$sedes = [
			'F01' => 'Arequipa',
			'F03' => 'Cusco',
			'S01' => 'Huancayo',
			'F04' => 'Ica',
			'F02' => 'Lima',
		];
		$icons = [
			'PRES' => '<svg xmlns="http://www.w3.org/2000/svg" width="40" height="38" fill="none" viewBox="0 0 40 40"><circle cx="20" cy="20" r="20" fill="#E7E8E9" opacity=".15"/><path fill="#CCCED1" d="M19 19.9V25a1 1 0 0 0 2 0v-5.1a5 5 0 1 0-2 0Zm1-7.9a3 3 0 1 1 0 6 3 3 0 0 1 0-6Zm4.21 10.42a1.021 1.021 0 1 0-.42 2C26.06 24.87 27 25.68 27 26c0 .58-2.45 2-7 2s-7-1.42-7-2c0-.32.94-1.13 3.21-1.62a1.023 1.023 0 0 0 .349-1.856 1.022 1.022 0 0 0-.769-.144C12.75 23.08 11 24.39 11 26c0 2.63 4.53 4 9 4s9-1.37 9-4c0-1.61-1.75-2.92-4.79-3.58Z"/></svg>',
			'GQT' => '<svg xmlns="http://www.w3.org/2000/svg" width="40" height="38" fill="none" viewBox="0 0 40 40"><circle cx="20" cy="20" r="20" fill="#E7E8E9" opacity=".15"/><path fill="#CCCED1" d="M27 14h-3v-1a2 2 0 0 0-2-2h-4a2 2 0 0 0-2 2v1h-3a3 3 0 0 0-3 3v9a3 3 0 0 0 3 3h14a3 3 0 0 0 3-3v-9a3 3 0 0 0-3-3Zm-9-1h4v1h-4v-1Zm10 13a1 1 0 0 1-1 1H13a1 1 0 0 1-1-1v-5.61L16.68 22c.106.014.214.014.32 0h6a1.19 1.19 0 0 0 .32-.05L28 20.39V26Zm0-7.72L22.84 20h-5.68L12 18.28V17a1 1 0 0 1 1-1h14a1 1 0 0 1 1 1v1.28Z"/></svg>',
			'DIS' => '<svg xmlns="http://www.w3.org/2000/svg" width="40" height="38" fill="none" viewBox="0 0 40 40"><circle cx="20" cy="20" r="20" fill="#E7E8E9" opacity=".15"/><path fill="#CCCED1" d="M27 11H13a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h6v2h-4a1 1 0 0 0 0 2h10a1 1 0 0 0 0-2h-4v-2h6a3 3 0 0 0 3-3v-8a3 3 0 0 0-3-3Zm1 11a1 1 0 0 1-1 1H13a1 1 0 0 1-1-1v-8a1 1 0 0 1 1-1h14a1 1 0 0 1 1 1v8Z"/></svg>',
		];
		$list_json = false;

		if ($carrera > 0) {
			$url = 'https://lp.ucontinental.edu.pe/amp/api/sede/null/'.$carrera.'?key=o88eOhgYKD';

			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_HEADER, 0);
			$json = curl_exec($ch);
			curl_close($ch);
			// $json = file_get_contents($url);
			$list_json = json_decode($json);

			if ($list_json) {

				// $element .= '
				// <select name="carrera_sede" id="carrera_sede_vc" class="select-sede-vc">
				// 	<option value="">Selecciona el campus</option>
				// ';
				$element .= '
				<div class="custom-select-vc-sede" id="carrera_sede_vc">
					<button class="select-button" role="combobox" aria-labelledby="select button" aria-expanded="false" aria-controls="select-dropdown">
						<span class="selected-value">Selecciona el campus</span>
						<span class="arrow"></span>
					</button>
					<ul class="select-dropdown-vc-carrera" role="listbox" id="select-dropdown">
				';
				foreach ($list_json as $s => $m) {
					$element .= '
					<li role="option">
						<input type="radio" id="option-'.$s.'" value="'.$s.'" name="carrera_sede" />
						<label for="option-'.$s.'">Campus '.$sedes[$s].'</label>
					</li>
					';
					// $element .= '
					// <option value="'.$s.'">Campus '.$sedes[$s].'</option>
					// ';
					$list .= '
					<div class="carrera-modalidad-vc d-none" id="sede-'.$s.'">
					';
					foreach ($m as $key => $value) {
						$list .= '
						<div class="modalidad-vc"><icon>'.$icons[$key].'</icon>'.$value.'</div>
						';
					}
					$list .= '
					</div>
					';
				}
				// $element .= '
				// </select>
				// ';
				$element .= '
					</ul>
				</div>
				';
			}

		}



		$output = '
<div data-column-margin="default" class="wpb_row vc_row-fluid vc_row inner_row">
	<div class="row_col_wrap_12_inner col span_12 left" style="align-items: center;">
		<div class="vc_col-sm-4 wpb_column column_container vc_column_container col child_column">
			<div class="vc_column-inner">
				<div class="wpb_wrapper">
					'.$element.'
				</div>
			</div>
		</div>
		<div class="vc_col-sm-8 wpb_column column_container vc_column_container col child_column">
			<div class="vc_column-inner">
				<div class="wpb_wrapper mb-m-2">
					'.$list.'
				</div>
			</div>
		</div>
	</div>
</div>
';
		return $output;
	}

}