<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


class WPBakeryShortCode_logros_uc_carousel extends WPBakeryShortCode_Tabbed_Section {}
class WPBakeryShortCode_logros_uc_element extends WPBakeryShortCode {}

class PublitivaLogrosUcCarousel {

	function __construct() {
		add_shortcode( "logros_uc_carousel", array($this, "pa_vc_render_logros" ));
		add_shortcode( "logros_uc_element", array($this, "pa_vc_atts_logros" ));
		add_action( 'admin_init', array($this, 'pa_vc_maps_logros_uc' ));
	}

	function pa_vc_maps_logros_uc() {
		$tab_id_1 = time().'-1-'.rand(0, 10);
		$tab_id_2 = time().'-2-'.rand(0, 10);
		vc_map([
			"name" => __("Logros UC Carousel", "continental-salient"),
			"base" => "logros_uc_carousel",
			"icon" => "icon-wpb-carousel",
			"category"    => 'Continental',
			"description" => __('Logros en formato carrusel', 'continental-salient'),
			"show_settings_on_create" => false,
			"is_container" => true,
			"params" => [
				[
					"type" => "textfield",
					"heading" => __("Auto rotación", "continental-salient"),
					"param_name" => "autorotate",
					"value" => '0',
					"description" => __("Si desea que gire automáticamente, ingrese aquí la velocidad de rotación en milisegundos. Ejemplo: 7000", "continental-salient")
				],
				[
					"type" => "textfield",
					"heading" => __("Clase adicional", "continental-salient"),
					"param_name" => "class",
					"value" => '',
				]
			],
			"custom_markup" => '
				<div class="wpb_tabs_holder wpb_holder vc_container_for_children">
				<ul class="tabs_controls">
				</ul>
				%content%
				</div>'
			,
			'default_content' => '
				[logros_uc_element title="'.__('Logro','continental-salient').'" id="'.$tab_id_1.'"] Clic en el botón editar para agregar su logro. [/logros_uc_element]
				[logros_uc_element title="'.__('Logro','continental-salient').'" id="'.$tab_id_2.'"] Clic en el botón editar para agregar su logro. [/logros_uc_element]
			',
			"js_view" => 'VcTabsView'
		]);

		vc_map(array(
			"name" => __("Logro", "continental-salient"),
			"base" => "logros_uc_element",
			"allowed_container_element" => 'vc_row',
			"is_container" => false,
			"content_element" => false,
			"params" => [
				[
					"type" => "attach_image",
					"class" => "",
					"heading" => __("Logo", "continental-salient"),
					"value" => "",
					"param_name" => "image",
					"description" => __("Agrega logo para el logro", "continental-salient")
				],
				[
					"type" => "textarea",
					"heading" => __("Titulo", "continental-salient"),
					"param_name" => "header",
					"admin_label" => true,
					"description" => __("Titulo del logro", "continental-salient")
				],
				[
					"type" => "textarea",
					"heading" => __("Descripción", "continental-salient"),
					"param_name" => "description",
					"description" => __("Descripción del logro", "continental-salient")
				],
				[
					"type" => "vc_link",
					"heading" => __("Enlace botón", "continental-salient"),
					"param_name" => "link",
				],
				[
					"type" => "textfield",
					"heading" => __("Texto botón", "continental-salient"),
					"param_name" => "texto",
				],
				[
					"type" => "dropdown",
					"heading" => __("Decoración", "continental-salient"),
					"value" => [
						"Ninguno" => 0,
						"Rectangulo inferior" => "rectangle-bottom",
						"Cuadrado inferior" => "square-bottom-verde",
					],
					"save_always" => true,
					"param_name" => "decoration",
					"description" => __("Agrega decoración a la tarjeta", "continental-salient")
				],
				[
					"type" => "textfield",
					"heading" => __("Clase elemento", "continental-salient"),
					"param_name" => "class_item",
				],
				[
					"type" => "tab_id",
					"heading" => __("Logro ID", "continental-salient"),
					"param_name" => "id"
				]
			],
			'js_view' => 'VcTabView'
		));

	}

	function pa_vc_atts_logros( $atts, $content ) {

		extract( shortcode_atts( [
			'autorotate' => '',
			'class' => '',
			'image' => '',
			'header' => '',
			'description' => '',
			'link' => '',
			'texto' => '',
			'decoration' => '',
			'class_item' => '',
		], $atts ) );

		echo do_shortcode( $content );

	}

	function pa_vc_render_logros( $atts, $content = null, $tag ) {

		$pattern = get_shortcode_regex(['logros_uc_element']);
		preg_match_all('/'. $pattern .'/s', $content, $matches);
		$logros = [];
		foreach( $matches[3] as $match ){
			$logros[] = shortcode_parse_atts($match);
		};

		$clase_logro = $atts['class'] ?? '';
		$SliderLogro = ['autorotate' => $atts['autorotate'] ?? 0];

		$element = '';
		if (count($logros) > 0) {
			foreach ($logros as $j => $c) {
				if (isset($c['header'])) {
					$_image = [];
					$_image[0] = '';
					$_image_none = 'd-none';
					if (isset($c['image'])) {
						$_image_none = '';
						$_image = wp_get_attachment_image_src( $c['image'], 'full' );
					}

					$_title = $c['header'] ?? '';
					$_description = $c['description'] ?? '';
					$_link = $c['link'] ?? '';
					$_link_render = 'href="#"';
					if (isset($c['link'])) {
						$href = vc_build_link($_link);
						$_link_render = 'href="'.$href['url'].'" target="'.$href['target'].'"';
					}
					$_text = $c['texto'] ?? 'Texto del botón';
					$_decoration = '';
					if (isset($c['decoration'])) {
						$_decoration = '<div class="'.$c['decoration'].'"></div>';
					}
					$_class = $c['class_item'] ?? '';

					$element .= '
		<div class="swiper-slide">
			<div data-column-margin="default" class="wpb_row vc_row-fluid vc_row inner_row">
				<div class="row_col_wrap_12_inner col span_12 left">
					<div class="vc_col-sm-12 wpb_column column_container vc_column_container col child_column no-extra-padding inherit_tablet inherit_phone">
						<div class="vc_column-inner">
							<div class="wpb_wrapper">
								<div class="wpb_content_element card-logro '.$_class.'">
									<div class="wpb_wrapper">
										<img src="'.$_image[0].'" class="nectar-lazy">
										<p class="text-center">'.wp_kses_post($_title).'</p>
										<small class="">'.wp_kses_post($_description).'</small>
';
					if (isset($c['link'])) {
						$element .= '
										<div class="link">
											<a class="" '.$_link_render.'>'.wp_kses_post($_text).' <i class="icon-button-arrow"></i></a>
										</div>
						';
					}
					$element .= '
									</div>
								</div>
							</div>
						</div>
					</div>
					'.$_decoration.'
				</div>
			</div>
		</div>
					';
				}
			}
		}

		$output = '
<div class="swiper swiper-logro '.$clase_logro.'">
	<div class="swiper-wrapper">
		'.$element.'
	</div>
	<div class="swiper-footer">
		<div class="swiper-pagination"></div>
		<div class="swiper-button-prev"></div>
		<div class="swiper-button-next"></div>
	</div>
</div>
';
		return $output;
	}

}