<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


class WPBakeryShortCode_homeslider_uc_slider extends WPBakeryShortCode_Tabbed_Section {}
class WPBakeryShortCode_homeslider_uc_element extends WPBakeryShortCode {}

class PublitivaHomeSliderUcSlider {

	function __construct() {
		add_shortcode( "homeslider_uc_slider", array($this, "pa_vc_render_homeslider" ));
		add_shortcode( "homeslider_uc_element", array($this, "pa_vc_atts_homeslider" ));
		add_action( 'admin_init', array($this, 'pa_vc_maps_homeslider_uc' ));
	}

	function pa_vc_maps_homeslider_uc() {
		$tab_id_1 = time().'-1-'.rand(0, 10);
		$tab_id_2 = time().'-2-'.rand(0, 10);
		vc_map([
			"name" => __("Home UC Slider", "continental-salient"),
			"base" => "homeslider_uc_slider",
			"icon" => "icon-wpb-carousel",
			"category"    => 'Continental',
			"description" => __('Home slider', 'continental-salient'),
			"show_settings_on_create" => false,
			"is_container" => true,
			"params" => [
				[
					"type" => "textfield",
					"heading" => __("Auto rotación", "continental-salient"),
					"param_name" => "autorotate",
					"value" => '10000',
					"description" => __("Si desea que gire automáticamente, ingrese aquí la velocidad de rotación en milisegundos. Ejemplo: 10000", "continental-salient")
				],
				[
					"type" => "checkbox",
					"heading" => __("Forzar webp", "continental-salient"),
					"param_name" => "webp",
					"value" => array("Forzar webp?" => "true" ),
					'edit_field_class' => 'vc_col-xs-12 salient-fancy-checkbox',
				],
				[
					"type" => "textfield",
					"heading" => __("Clase adicional", "continental-salient"),
					"param_name" => "class",
					"value" => '',
				]
			],
			"custom_markup" => '
				<div class="wpb_tabs_holder wpb_holder vc_container_for_children">
				<ul class="tabs_controls">
				</ul>
				%content%
				</div>'
			,
			'default_content' => '
				[homeslider_uc_element title="'.__('Slide','continental-salient').'" id="'.$tab_id_1.'"] Clic en el botón editar para agregar su testimonio. [/homeslider_uc_element]
				[homeslider_uc_element title="'.__('Slide','continental-salient').'" id="'.$tab_id_2.'"] Clic en el botón editar para agregar su testimonio. [/homeslider_uc_element]
			',
			"js_view" => 'VcTabsView'
		]);

		vc_map(array(
			"name" => __("Slide", "continental-salient"),
			"base" => "homeslider_uc_element",
			"allowed_container_element" => 'vc_row',
			"is_container" => false,
			"content_element" => false,
			"params" => [
				[
					"type" => "attach_image",
					"class" => "",
					"heading" => __("Imagen de fondo", "continental-salient"),
					"value" => "",
					"param_name" => "image",
					"admin_label" => true,
					"description" => __("Agrega la imagen de fondo", "continental-salient")
				],
				[
					"type" => "dropdown",
					"heading" => __("Color a resaltar", "continental-salient"),
					"value" => [
						"Morado" => "morado",
						"Salmon" => "salmon",
						"Verde" => "verde",
					],
					"save_always" => true,
					"param_name" => "color",
					"description" => __("Color a resaltar", "continental-salient")
				],
				[
					"type" => "attach_image",
					"class" => "",
					"heading" => __("Logo", "continental-salient"),
					"value" => "",
					"param_name" => "logo",
					"description" => __("Agrega logo al slide", "continental-salient")
				],
				[
					"type" => "textarea_raw_html",
					"heading" => __("Titulo", "continental-salient"),
					"param_name" => "header",
					"description" => __("El titulo del slide", "continental-salient")
				],
				[
					"type" => "textarea_raw_html",
					"heading" => __("Subitulo", "continental-salient"),
					"param_name" => "subtitle",
					"description" => __("El subtitulo del slide", "continental-salient")
				],
				[
					"type" => "vc_link",
					"heading" => __("Enlace botón", "continental-salient"),
					"param_name" => "link",
				],
				[
					"type" => "textfield",
					"heading" => __("Texto botón", "continental-salient"),
					"param_name" => "texto",
				],
				[
					"type" => "textfield",
					"heading" => __("Clase adicional", "continental-salient"),
					"param_name" => "clase",
				],
				[
					"type" => "attach_image",
					"class" => "",
					"heading" => __("Imagen de fondo", "continental-salient"),
					"value" => "",
					"param_name" => "image_mobile",
					"group" => "Mobile",
					"description" => __("Agrega la imagen de fondo", "continental-salient")
				],
				[
					"type" => "textfield",
					"heading" => __("Altura imagen", "continental-salient"),
					"param_name" => "altura",
					"value" => '17',
					"group" => "Mobile",
					"description" => __("Agrega altura para la imagen, valor por defecto 17em", "continental-salient")
				],
				[
					"type" => "textarea_raw_html",
					"heading" => __("Titulo mobile", "continental-salient"),
					"param_name" => "header_mobile",
					"group" => "Mobile",
					"description" => __("El titulo sólo para mobile", "continental-salient")
				],
				[
					"type" => "tab_id",
					"heading" => __("Slide ID", "continental-salient"),
					"param_name" => "id"
				]
			],
			'js_view' => 'VcTabView'
		));

	}

	function pa_vc_atts_homeslider( $atts, $content ) {

		extract( shortcode_atts( [
			'autorotate' => '',
			'class' => '',
			'image' => '',
			'color' => '',
			'logo' => '',
			'header' => '',
			'subtitle' => '',
			'link' => '',
			'texto' => '',
		], $atts ) );

		echo do_shortcode( $content );

	}

	function pa_vc_render_homeslider( $atts, $content = null, $tag ) {

		add_action('wp_footer', array($this, 'render_pa_vc_homeslide_footer'), 100);

		$pattern = get_shortcode_regex(['homeslider_uc_element']);
		preg_match_all('/'. $pattern .'/s', $content, $matches);
		$slides = [];
		foreach( $matches[3] as $match ){
			$slides[] = shortcode_parse_atts($match);
		};

		$clase_home = $atts['class'] ?? '';
		$SliderBackground = ['autorotate' => $atts['autorotate'] ?? 10000];
		$webp = $atts['webp'] ?? '';

		$element = '';
		if (count($slides) > 0) {
			foreach ($slides as $j => $c) {
				if (isset($c['image'])) {
					$_image = $_logo = $_image_m = [];
					$extension = $extension_m = '';
					$_image[0] = '';
					if (isset($c['image'])) {
						$_image = wp_get_attachment_image_src( $c['image'], 'full' );
						if (substr($_image[0], -4) != 'webp' && $webp === 'true') {
							$extension = '.webp';
						}
					}
					$_image_m[0] = '';
					if (isset($c['image_mobile'])) {
						$_image_m = wp_get_attachment_image_src( $c['image_mobile'], 'full' );
						if (substr($_image_m[0], -4) != 'webp' && $webp === 'true') {
							$extension_m = '.webp';
						}
					}
					$SliderBackground[] = [
						'URL' => $_image[0].$extension,
						'URLM' => $_image_m[0].$extension_m,
					];
					$_logo[0] = '';
					$_logo_none = 'd-none';
					if (isset($c['logo'])) {
						$_logo_none = '';
						$_logo = wp_get_attachment_image_src( $c['logo'], 'full' );
					}
					$_color = $c['color'] ?? '';
					$_title = $c['header'] ?? '';
					$_subtitle = $c['subtitle'] ?? '';
					$_link = $c['link'] ?? '';
					$_link_render = 'href="#"';
					if (isset($c['link'])) {
						$href = vc_build_link($_link);
						$_link_render = 'href="'.$href['url'].'" target="'.$href['target'].'"';
					}
					$_text = $c['texto'] ?? 'Texto del botón';
					$_clase = $c['clase'] ?? '';
					$_title_m = $c['header_mobile'] ?? '';
					$_altura = '17';
					if (isset($c['altura']) && (int)$c['altura'] > 0) {
						$_altura = $c['altura'];
					}
					$element .= '
		<div class="swiper-slide">
			<div data-column-margin="default" class="wpb_row vc_row-fluid vc_row inner_row '.$_color.'">
				<div class="row_col_wrap_12_inner col span_12 left">
					<div class="vc_col-sm-6 wpb_column column_container vc_column_container vc_col-xs">
						<div class="wpb_wrapper home-slider-container '.$_clase.'" style="--altura-slide:'.$_altura.'em">
							<div class="logo '.$_logo_none.'">
								<img src="'.esc_url($_logo[0]).'" class="">
							</div>
							<h2 class="title">'.urldecode(base64_decode($_title)).'</h2>
							<div class="subtitle">'.urldecode(base64_decode($_subtitle)).'</div>
							<h2 class="title mobile">'.urldecode(base64_decode($_title_m)).'</h2>
							<div class="cta">
								<a class="nectar-button large regular regular-button" '.$_link_render.'><span>'.wp_kses_post($_text).'</span></a>
							</div>
						</div>
					</div>

					<div class="vc_col-sm-6 wpb_column column_container vc_column_container col">
						<div class="wpb_wrapper">
						</div>
					</div>
				</div>
			</div>
		</div>
					';
				}
			}
		}
		$output = '
<div class="swiper swiper-homeslide '.$clase_home.'">
	<div class="autoplay-progress">
		<svg viewBox="0 0 48 48">
			<circle cx="24" cy="24" r="20"></circle>
		</svg>
	</div>
	<div class="swiper-wrapper">
		'.$element.'
	</div>
	<div class="swiper-footer">
		<div class="swiper-pagination"></div>
		<div class="swiper-button-prev"></div>
		<div class="swiper-button-next"></div>
	</div>
</div>
';
		wp_enqueue_script( 'continental_uc_data', get_template_directory_uri() . '/../salient-child/script.js' );
		wp_add_inline_script( 'continental_uc_data', 'var SliderBackground = ' . wp_json_encode( $SliderBackground ), 'before' );

		return $output;
	}

	function render_pa_vc_homeslide_footer() {
		echo '
<script>
(function($){
var widthM = $("body").width();
var rowBG = $(".home-slider .row-bg-layer .row-bg");
if (widthM <= 768 && SliderBackground[0].URLM !== "") {
	rowBG.css({ "background-image": "url("+SliderBackground[0].URLM+")" });
} else {
	rowBG.css({ "background-image": "url("+SliderBackground[0].URL+")" });
}
})(jQuery);
</script>
		';
	}

}