<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


class WPBakeryShortCode_history_uc_carousel extends WPBakeryShortCode_Tabbed_Section {}
class WPBakeryShortCode_history_uc_element extends WPBakeryShortCode {}

class PublitivaHistoryCarousel {

	function __construct() {
		add_shortcode( "history_uc_carousel", array($this, "pa_vc_render_history" ));
		add_shortcode( "history_uc_element", array($this, "pa_vc_atts_history" ));
		add_action( 'admin_init', array($this, 'pa_vc_maps_history' ));
	}

	function pa_vc_maps_history() {
		$tab_id_1 = time().'-1-'.rand(0, 10);
		$tab_id_2 = time().'-2-'.rand(0, 10);
		vc_map([
			"name" => __("Historia UC Carousel", "continental-salient"),
			"base" => "history_uc_carousel",
			"icon" => "icon-wpb-carousel",
			"category"    => 'Continental',
			"description" => __('Historia en formato carrusel', 'continental-salient'),
			"show_settings_on_create" => false,
			"is_container" => true,
			"params" => [
				[
					"type" => "textfield",
					"heading" => __("Clase adicional", "continental-salient"),
					"param_name" => "class",
					"value" => '',
				]
			],
			"custom_markup" => '
				<div class="wpb_tabs_holder wpb_holder vc_container_for_children">
				<ul class="tabs_controls">
				</ul>
				%content%
				</div>'
			,
			'default_content' => '
				[history_uc_element title="'.__('Historia','continental-salient').'" id="'.$tab_id_1.'"] Clic en el botón editar para agregar su historia. [/history_uc_element]
				[history_uc_element title="'.__('Historia','continental-salient').'" id="'.$tab_id_2.'"] Clic en el botón editar para agregar su historia. [/history_uc_element]
			',
			"js_view" => 'VcTabsView'
		]);

		vc_map(array(
			"name" => __("Historia", "continental-salient"),
			"base" => "history_uc_element",
			"allowed_container_element" => 'vc_row',
			"is_container" => false,
			"content_element" => false,
			"params" => [
				[
					"type" => "attach_image",
					"class" => "",
					"heading" => __("Imagen", "continental-salient"),
					"value" => "",
					"param_name" => "image",
					"description" => __("Agrega imagen para la historia", "continental-salient")
				],
				[
					"type" => "textfield",
					"heading" => __("Titulo", "continental-salient"),
					"param_name" => "header",
					"admin_label" => true,
					"description" => __("Titulo la historia", "continental-salient")
				],
				[
					"type" => "textfield",
					"heading" => __("Subtitulo", "continental-salient"),
					"param_name" => "subheader",
					"admin_label" => true,
					"description" => __("Subtitulo la historia", "continental-salient")
				],
				[
					"type" => "textarea",
					"heading" => __("Descripción", "continental-salient"),
					"param_name" => "description",
					"description" => __("Descripción la historia", "continental-salient")
				],
				[
					"type" => "vc_link",
					"heading" => __("Enlace botón", "continental-salient"),
					"param_name" => "link",
				],
				[
					"type" => "textfield",
					"heading" => __("Texto botón", "continental-salient"),
					"param_name" => "texto",
				],
				[
					"type" => "tab_id",
					"heading" => __("Logro ID", "continental-salient"),
					"param_name" => "id"
				]
			],
			'js_view' => 'VcTabView'
		));

	}

	function pa_vc_atts_history( $atts, $content ) {

		extract( shortcode_atts( [
			'autorotate' => '',
			'class' => '',
			'image' => '',
			'header' => '',
			'subheader' => '',
			'description' => '',
			'link' => '',
			'texto' => '',
		], $atts ) );

		echo do_shortcode( $content );

	}

	function pa_vc_render_history( $atts, $content = null, $tag ) {

		$pattern = get_shortcode_regex(['history_uc_element']);
		preg_match_all('/'. $pattern .'/s', $content, $matches);
		$logros = [];
		foreach( $matches[3] as $match ){
			$logros[] = shortcode_parse_atts($match);
		};

		$clase_logro = $atts['class'] ?? '';
		$SliderHistory = ['autorotate' => $atts['autorotate'] ?? 0];

		$element = '';
		if (count($logros) > 0) {
			foreach ($logros as $j => $c) {
				if (isset($c['header'])) {
					$_image = [];
					$_image[0] = '';
					if (isset($c['image'])) {
						$_image = wp_get_attachment_image_src( $c['image'], 'full' );
					}

					$_title = $c['header'] ?? '';
					$_subtitle = $c['subheader'] ?? '';
					$_description = $c['description'] ?? '';
					$_link = $c['link'] ?? '';
					$_link_render = 'href="#"';
					if (isset($c['link'])) {
						$href = vc_build_link($_link);
						$_link_render = 'href="'.$href['url'].'" target="'.$href['target'].'"';
					}
					$_text = $c['texto'] ?? 'Texto del botón';

					$element .= '
		<div class="swiper-slide">
			<div data-column-margin="default" class="wpb_row vc_row-fluid vc_row inner_row">
				<div class="row_col_wrap_12_inner col span_12 left">
					<div class="vc_col-sm-12 wpb_column column_container vc_column_container col child_column no-extra-padding inherit_tablet inherit_phone">
						<div class="vc_column-inner">
							<div class="wpb_wrapper">
								<div class="wpb_content_element card-history">
									<div class="wpb_wrapper">
										<img src="'.$_image[0].'" width="342" height="170" class="nectar-lazy">
										<h3 class="title">'.wp_kses_post($_title).'</h3>
										<p class="">'.wp_kses_post($_subtitle).'</p>
										<small class="">'.wp_kses_post($_description).'</small>
					';
					if (isset($c['link'])) {
						$element .= '
										<div class="link">
											<a class="" '.$_link_render.'>'.wp_kses_post($_text).' <i class="icon-button-arrow"></i></a>
										</div>
						';
					}
					$element .= '
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
					';
				}
			}
		}

		$output = '
<div class="swiper swiper-history '.$clase_logro.'">
	<div class="swiper-wrapper">
		'.$element.'
	</div>
	<div class="swiper-footer">
		<div class="swiper-pagination"></div>
		<div class="swiper-button-prev"></div>
		<div class="swiper-button-next"></div>
	</div>
</div>
';

		return $output;
	}

}