jQuery(document).ready(function($){

	if ($('.swiper-testimonio').length > 0) {
		const progressTestimonio = document.querySelector(".swiper-testimonio .autoplay-progress svg");
		const swiper_testimonio = new Swiper('.swiper-testimonio', {
			loop: false,
			slidesPerView: 1,
			spaceBetween: 20,
			autoplay: {
				delay: SliderTestimonio['autorotate'],
				disableOnInteraction: false
			},
			pagination: {
				el: '.swiper-pagination',
				type: 'custom',
				renderCustom: function (swiper, current, total) {
					return current + '<span></span>' + (total);
				}
			},
			navigation: {
				nextEl: '.swiper-button-next',
				prevEl: '.swiper-button-prev',
			},
			on: {
				autoplayTimeLeft(s, time, progress) {
					progressTestimonio.style.setProperty("--progress", 1 - progress);
				}
			}
		});
	}

	if ($('.swiper-homeslide').length > 0) {
		const progressHomeSlider = document.querySelector(".swiper-homeslide .autoplay-progress svg");
		// const progressContent = document.querySelector(".autoplay-progress span");
		const swiper_homeslide = new Swiper('.swiper-homeslide', {
			loop: false,
			slidesPerView: 1,
			spaceBetween: 20,
			autoplay: {
				delay: SliderBackground['autorotate'],
				disableOnInteraction: false
			},
			pagination: {
				el: '.swiper-pagination',
				type: 'custom',
				renderCustom: function (swiper, current, total) {
					return current + '<span></span>' + (total);
				}
			},
			navigation: {
				nextEl: '.swiper-button-next',
				prevEl: '.swiper-button-prev',
			},
			on: {
				autoplayTimeLeft(s, time, progress) {
					progressHomeSlider.style.setProperty("--progress", 1 - progress);
					// progressContent.textContent = `${Math.ceil(time / 1000)}s`;
				}
			}
		});

		swiper_homeslide.on('transitionStart', function () {
			var widthM = $("body").width();
			var rowBG = $(".home-slider .row-bg-layer .row-bg");
			if (widthM <= 768 && SliderBackground[swiper_homeslide.realIndex].URLM !== "") {
				rowBG.css({ "background-image": "url("+SliderBackground[swiper_homeslide.realIndex].URLM+")", "transition": "all 0.7s ease" });
			} else {
				rowBG.css({ "background-image": "url("+SliderBackground[swiper_homeslide.realIndex].URL+")", "transition": "all 0.7s ease" });
			}
		});
	}

	if ($('.swiper-logro').length > 0) {

		const swiper_logro = new Swiper('.swiper-logro', {
			loop: false,
			slidesPerView: 1,
			spaceBetween: 10,
			pagination: {
				el: '.swiper-pagination',
				type: 'custom',
				renderCustom: function (swiper, current, total) {
					return current + '<span></span>' + (total);
				}
			},
			navigation: {
				nextEl: '.swiper-button-next',
				prevEl: '.swiper-button-prev',
			},
			breakpoints: {
				640: {
					slidesPerView: 2,
					spaceBetween: 10,
				},
				768: {
					slidesPerView: 3,
					spaceBetween: 20,
				},
				1024: {
					slidesPerView: 4,
					spaceBetween: 30,
				},
			},
		});

	}

	if ($('.swiper-similar').length > 0) {

		const swiper_similar = new Swiper('.swiper-similar', {
			loop: false,
			slidesPerView: 1,
			spaceBetween: 10,
			pagination: {
				el: '.swiper-pagination',
				type: 'custom',
				renderCustom: function (swiper, current, total) {
					return current + '<span></span>' + (total);
				}
			},
			navigation: {
				nextEl: '.swiper-button-next',
				prevEl: '.swiper-button-prev',
			},
			breakpoints: {
				640: {
					slidesPerView: 2,
					spaceBetween: 10,
				},
				768: {
					slidesPerView: 2,
					spaceBetween: 20,
				},
				1024: {
					slidesPerView: 3,
					spaceBetween: 30,
				},
			},
		});

	}

	if ($('.swiper-history').length > 0) {

		const swiper_history = new Swiper('.swiper-history', {
			loop: false,
			slidesPerView: 1,
			spaceBetween: 10,
			pagination: {
				el: '.swiper-pagination',
				type: 'custom',
				renderCustom: function (swiper, current, total) {
					return current + '<span></span>' + (total);
				}
			},
			navigation: {
				nextEl: '.swiper-button-next',
				prevEl: '.swiper-button-prev',
			},
			breakpoints: {
				640: {
					slidesPerView: 2,
					spaceBetween: 10,
				},
				768: {
					slidesPerView: 2,
					spaceBetween: 20,
				},
				1024: {
					slidesPerView: 3,
					spaceBetween: 30,
				},
			},
		});

	}

	if ($('.swiper-blog').length > 0) {

		const swiper_similar = new Swiper('.swiper-blog', {
			loop: false,
			slidesPerView: 1,
			spaceBetween: 10,
			pagination: {
				el: '.swiper-pagination',
				type: 'custom',
				renderCustom: function (swiper, current, total) {
					return current + '<span></span>' + (total);
				}
			},
			navigation: {
				nextEl: '.swiper-button-next',
				prevEl: '.swiper-button-prev',
			},
			breakpoints: {
				640: {
					slidesPerView: 2,
					spaceBetween: 10,
				},
				768: {
					slidesPerView: 2,
					spaceBetween: 20,
				},
				1024: {
					slidesPerView: 3,
					spaceBetween: 30,
				},
			},
		});

	}

	$(".js-modal-btn").modalVideo();

	if ($('#carrera_sede_vc').length > 0) {

		const customSelectCarrera = document.querySelector(".custom-select-vc-sede");
		const selectBtn = document.querySelector(".select-button");
		const selectedValue = document.querySelector(".selected-value");
		const optionsList = document.querySelectorAll(".select-dropdown-vc-carrera li");
		const listCarreras = document.querySelectorAll('.carrera-modalidad-vc');
		var carrera_sede;

		// add click event to select button
		selectBtn.addEventListener("click", () => {
			// add/remove active class on the container element
			customSelectCarrera.classList.toggle("active");
  			// update the aria-expanded attribute based on the current state
			selectBtn.setAttribute(
				"aria-expanded",
				selectBtn.getAttribute("aria-expanded") === "true" ? "false" : "true"
			);
		});

		optionsList.forEach((option) => {
			function handler(e) {
				e.preventDefault()
    			// Click Events
				if (e.type === "click" && e.clientX !== 0 && e.clientY !== 0) {
					selectedValue.textContent = this.children[1].textContent;
					selectBtn.setAttribute("aria-expanded", "false")
					customSelectCarrera.classList.remove("active");
					carrera_sede = this.children[0].value;
					listCarreras.forEach((element) => {
						element.classList.add('d-none');
					});
					this.children[0].checked = true;
					document.querySelector("#sede-"+carrera_sede).classList.remove("d-none");
				}
			}
			option.addEventListener("click", handler);
		});

		function onClickOutside(ele, cb) {
			document.addEventListener('click', event => {
				if (!ele.contains(event.target)) cb();
			});
		};
		onClickOutside(document.querySelector('#carrera_sede_vc'), () => {
			if (selectBtn.getAttribute("aria-expanded") === "true") {
				customSelectCarrera.classList.remove("active");
				selectBtn.setAttribute("aria-expanded", "false")
			}
		});

		// var carrera_sede;
		// $("#carrera_sede_vc").on("change", function() {
		// 	carrera_sede = this.value;
		// 	$(".carrera-modalidad-vc").addClass('d-none');
		// 	if (carrera_sede) {
		// 		$("#sede-"+carrera_sede).removeClass('d-none');
		// 	}
		// });
	}

});