/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.notification.pagerduty;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.watcher.common.http.HttpClient;
import org.elasticsearch.xpack.watcher.notification.NotificationService;
import org.elasticsearch.xpack.watcher.notification.pagerduty.PagerDutyAccount;

public class PagerDutyService
extends NotificationService<PagerDutyAccount> {
    private static final Setting<String> SETTING_DEFAULT_ACCOUNT = Setting.simpleString((String)"xpack.notification.pagerduty.default_account", (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private static final Setting.AffixSetting<SecureString> SETTING_SECURE_SERVICE_API_KEY = Setting.affixKeySetting((String)"xpack.notification.pagerduty.account.", (String)"secure_service_api_key", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Setting.AffixSetting<Settings> SETTING_DEFAULTS = Setting.affixKeySetting((String)"xpack.notification.pagerduty.account.", (String)"event_defaults", key -> Setting.groupSetting((String)(key + "."), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private final HttpClient httpClient;

    public PagerDutyService(Settings settings, HttpClient httpClient, ClusterSettings clusterSettings) {
        super("pagerduty", settings, clusterSettings, PagerDutyService.getDynamicSettings(), PagerDutyService.getSecureSettings());
        this.httpClient = httpClient;
        clusterSettings.addSettingsUpdateConsumer(SETTING_DEFAULT_ACCOUNT, s -> {});
        clusterSettings.addAffixUpdateConsumer(SETTING_DEFAULTS, (s, o) -> {}, (s, o) -> {});
        this.reload(settings);
    }

    @Override
    protected PagerDutyAccount createAccount(String name, Settings accountSettings) {
        return new PagerDutyAccount(name, accountSettings, this.httpClient);
    }

    private static List<Setting<?>> getDynamicSettings() {
        return Arrays.asList(SETTING_DEFAULTS, SETTING_DEFAULT_ACCOUNT);
    }

    private static List<Setting<?>> getSecureSettings() {
        return Arrays.asList(SETTING_SECURE_SERVICE_API_KEY);
    }

    public static List<Setting<?>> getSettings() {
        ArrayList allSettings = new ArrayList(PagerDutyService.getDynamicSettings());
        allSettings.addAll(PagerDutyService.getSecureSettings());
        return allSettings;
    }
}

