/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.notification.email.attachment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.watcher.notification.email.attachment.EmailAttachmentParser;
import org.elasticsearch.xpack.watcher.notification.email.attachment.EmailAttachments;

public class EmailAttachmentsParser {
    private final Map<String, EmailAttachmentParser> parsers;

    public EmailAttachmentsParser(Map<String, EmailAttachmentParser> parsers) {
        this.parsers = Collections.unmodifiableMap(parsers);
    }

    public EmailAttachments parse(XContentParser parser) throws IOException {
        XContentParser.Token token;
        ArrayList<EmailAttachmentParser.EmailAttachment> attachments = new ArrayList<EmailAttachmentParser.EmailAttachment>();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token != XContentParser.Token.START_OBJECT || currentFieldName == null) continue;
            String currentAttachmentType = null;
            if (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
                currentAttachmentType = parser.currentName();
            }
            parser.nextToken();
            EmailAttachmentParser emailAttachmentParser = this.parsers.get(currentAttachmentType);
            if (emailAttachmentParser == null) {
                throw new ElasticsearchParseException("Cannot parse attachment of type [{}]", new Object[]{currentAttachmentType});
            }
            Object emailAttachment = emailAttachmentParser.parse(currentFieldName, parser);
            attachments.add((EmailAttachmentParser.EmailAttachment)emailAttachment);
            parser.nextToken();
        }
        return new EmailAttachments(attachments);
    }

    public Map<String, EmailAttachmentParser> getParsers() {
        return this.parsers;
    }
}

