/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.history;

import java.io.IOException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.watcher.history.HistoryStoreField;
import org.elasticsearch.xpack.core.watcher.history.WatchRecord;
import org.elasticsearch.xpack.core.watcher.support.Exceptions;
import org.elasticsearch.xpack.core.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.watcher.watch.WatchStoreUtils;

public class HistoryStore {
    private static final Logger logger = LogManager.getLogger(HistoryStore.class);
    private final BulkProcessor bulkProcessor;

    public HistoryStore(BulkProcessor bulkProcessor) {
        this.bulkProcessor = bulkProcessor;
    }

    public void put(WatchRecord watchRecord) throws Exception {
        String index = HistoryStoreField.getHistoryIndexNameForTime((ZonedDateTime)watchRecord.triggerEvent().triggeredTime());
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            watchRecord.toXContent(builder, (ToXContent.Params)WatcherParams.HIDE_SECRETS);
            IndexRequest request = new IndexRequest(index).id(watchRecord.id().value()).source(builder);
            request.opType(DocWriteRequest.OpType.CREATE);
            this.bulkProcessor.add(request);
        }
        catch (IOException ioe) {
            throw Exceptions.ioException((String)"failed to persist watch record [{}]", (Throwable)ioe, (Object[])new Object[]{watchRecord});
        }
    }

    public void forcePut(WatchRecord watchRecord) {
        String index = HistoryStoreField.getHistoryIndexNameForTime((ZonedDateTime)watchRecord.triggerEvent().triggeredTime());
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            watchRecord.toXContent(builder, (ToXContent.Params)WatcherParams.HIDE_SECRETS);
            IndexRequest request = new IndexRequest(index).id(watchRecord.id().value()).source(builder);
            this.bulkProcessor.add(request);
        }
        catch (IOException ioe) {
            WatchRecord wr = watchRecord;
            logger.error(() -> new ParameterizedMessage("failed to persist watch record [{}]", (Object)wr), (Throwable)ioe);
        }
    }

    public static boolean validate(ClusterState state) {
        String currentIndex = HistoryStoreField.getHistoryIndexNameForTime((ZonedDateTime)ZonedDateTime.now(ZoneOffset.UTC));
        IndexMetaData indexMetaData = WatchStoreUtils.getConcreteIndex(currentIndex, state.metaData());
        return indexMetaData == null || indexMetaData.getState() == IndexMetaData.State.OPEN && state.routingTable().index(indexMetaData.getIndex()).allPrimaryShardsActive();
    }
}

