/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.votingonly.VotingOnlyNodeFeatureSetUsage;

public class VotingOnlyNodeFeatureSet
implements XPackFeatureSet {
    private final XPackLicenseState licenseState;

    @Inject
    public VotingOnlyNodeFeatureSet(@Nullable XPackLicenseState licenseState) {
        this.licenseState = licenseState;
    }

    public String name() {
        return "voting_only";
    }

    public boolean available() {
        return this.licenseState != null && this.licenseState.isVotingOnlyAllowed();
    }

    public boolean enabled() {
        return true;
    }

    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        listener.onResponse((Object)new VotingOnlyNodeFeatureSetUsage(this.licenseState.isVotingOnlyAllowed()));
    }
}

