/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.TemporalAccessor;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateFormatters;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Foldables;
import org.elasticsearch.xpack.sql.parser.ParsingException;
import org.elasticsearch.xpack.sql.proto.StringUtils;

public final class DateUtils {
    public static final ZoneId UTC = ZoneId.of("Z");
    public static final String DATE_PARSE_FORMAT = "epoch_millis";
    public static final LocalDate EPOCH = LocalDate.of(1970, 1, 1);
    public static final long DAY_IN_MILLIS = 86400000L;
    private static final DateTimeFormatter DATE_TIME_ESCAPED_LITERAL_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(" ").append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter().withZone(UTC);
    private static final DateFormatter UTC_DATE_TIME_FORMATTER = DateFormatter.forPattern((String)"date_optional_time").withZone(UTC);
    private static final int DEFAULT_PRECISION_FOR_CURRENT_FUNCTIONS = 3;

    private DateUtils() {
    }

    public static ZonedDateTime asDateOnly(long millis) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), UTC).toLocalDate().atStartOfDay(UTC);
    }

    public static OffsetTime asTimeOnly(long millis) {
        return OffsetTime.ofInstant(Instant.ofEpochMilli(millis % 86400000L), UTC);
    }

    public static OffsetTime asTimeOnly(long millis, ZoneId zoneId) {
        return OffsetTime.ofInstant(Instant.ofEpochMilli(millis % 86400000L), zoneId);
    }

    public static OffsetTime asTimeAtZone(OffsetTime time, ZoneId zonedId) {
        return time.atDate(EPOCH).atZoneSameInstant(zonedId).toOffsetDateTime().toOffsetTime();
    }

    public static ZonedDateTime asDateTime(long millis) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), UTC);
    }

    public static ZonedDateTime asDateTime(long millis, ZoneId id) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), id);
    }

    public static ZonedDateTime asDateOnly(String dateFormat) {
        return LocalDate.parse(dateFormat, DateTimeFormatter.ISO_LOCAL_DATE).atStartOfDay(UTC);
    }

    public static ZonedDateTime asDateOnly(ZonedDateTime zdt) {
        return zdt.toLocalDate().atStartOfDay(zdt.getZone());
    }

    public static OffsetTime asTimeOnly(String timeFormat) {
        return DateFormatters.from((TemporalAccessor)DateTimeFormatter.ISO_TIME.parse(timeFormat)).toOffsetDateTime().toOffsetTime();
    }

    public static ZonedDateTime asDateTime(String dateFormat) {
        return DateFormatters.from((TemporalAccessor)UTC_DATE_TIME_FORMATTER.parse(dateFormat)).withZoneSameInstant(UTC);
    }

    public static ZonedDateTime ofEscapedLiteral(String dateFormat) {
        return ZonedDateTime.parse(dateFormat, DATE_TIME_ESCAPED_LITERAL_FORMATTER.withZone(UTC));
    }

    public static String toString(ZonedDateTime dateTime) {
        return StringUtils.toString((Object)dateTime);
    }

    public static String toDateString(ZonedDateTime date) {
        return date.format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static String toTimeString(OffsetTime time) {
        return StringUtils.toString((Object)time);
    }

    public static long minDayInterval(long l) {
        if (l < 86400000L) {
            return 86400000L;
        }
        return l - l % 86400000L;
    }

    public static int getNanoPrecision(Expression precisionExpression, int nano) {
        int precision = 3;
        if (precisionExpression != null) {
            try {
                precision = Foldables.intValueOf(precisionExpression);
            }
            catch (Exception e) {
                throw new ParsingException(precisionExpression.source(), "invalid precision; " + e.getMessage(), new Object[0]);
            }
        }
        if (precision < 0 || precision > 9) {
            throw new ParsingException(precisionExpression.source(), "precision needs to be between [0-9], received [{}]", precisionExpression.sourceText());
        }
        nano -= nano % (int)Math.pow(10.0, 9 - precision);
        return nano;
    }
}

