/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.tree;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.elasticsearch.xpack.sql.tree.Node;
import org.elasticsearch.xpack.sql.tree.Source;

public abstract class NodeInfo<T extends Node<?>> {
    protected final T node;

    private NodeInfo(T node) {
        this.node = node;
    }

    public final List<Object> properties() {
        return Collections.unmodifiableList(this.innerProperties());
    }

    protected abstract List<Object> innerProperties();

    final <E> T transform(Function<? super E, ? extends E> rule, Class<E> typeToken) {
        List children = ((Node)this.node).children();
        Function<Object, Object> realRule = p -> {
            if (p != children && !children.contains(p) && (p == null || typeToken.isInstance(p))) {
                return rule.apply((Object)typeToken.cast(p));
            }
            return p;
        };
        return this.innerTransform(realRule);
    }

    protected abstract T innerTransform(Function<Object, Object> var1);

    public static <T extends Node<?>> NodeInfo<T> create(T n) {
        return new NodeInfo<T>(n){

            @Override
            protected List<Object> innerProperties() {
                return Collections.emptyList();
            }

            @Override
            protected T innerTransform(Function<Object, Object> rule) {
                return this.node;
            }
        };
    }

    public static <T extends Node<?>, P1> NodeInfo<T> create(T n, final BiFunction<Source, P1, T> ctor, final P1 p1) {
        return new NodeInfo<T>(n){

            @Override
            protected List<Object> innerProperties() {
                return Arrays.asList(p1);
            }

            @Override
            protected T innerTransform(Function<Object, Object> rule) {
                boolean same = true;
                Object newP1 = rule.apply(p1);
                return (same &= Objects.equals(p1, newP1)) ? this.node : (Node)ctor.apply(this.node.source(), newP1);
            }
        };
    }

    public static <T extends Node<?>, P1, P2> NodeInfo<T> create(T n, final NodeCtor2<P1, P2, T> ctor, final P1 p1, final P2 p2) {
        return new NodeInfo<T>(n){

            @Override
            protected List<Object> innerProperties() {
                return Arrays.asList(p1, p2);
            }

            @Override
            protected T innerTransform(Function<Object, Object> rule) {
                boolean same = true;
                Object newP1 = rule.apply(p1);
                same &= Objects.equals(p1, newP1);
                Object newP2 = rule.apply(p2);
                return (same &= Objects.equals(p2, newP2)) ? this.node : (Node)ctor.apply(this.node.source(), newP1, newP2);
            }
        };
    }

    public static <T extends Node<?>, P1, P2, P3> NodeInfo<T> create(T n, final NodeCtor3<P1, P2, P3, T> ctor, final P1 p1, final P2 p2, final P3 p3) {
        return new NodeInfo<T>(n){

            @Override
            protected List<Object> innerProperties() {
                return Arrays.asList(p1, p2, p3);
            }

            @Override
            protected T innerTransform(Function<Object, Object> rule) {
                boolean same = true;
                Object newP1 = rule.apply(p1);
                same &= Objects.equals(p1, newP1);
                Object newP2 = rule.apply(p2);
                same &= Objects.equals(p2, newP2);
                Object newP3 = rule.apply(p3);
                return (same &= Objects.equals(p3, newP3)) ? this.node : (Node)ctor.apply(this.node.source(), newP1, newP2, newP3);
            }
        };
    }

    public static <T extends Node<?>, P1, P2, P3, P4> NodeInfo<T> create(T n, final NodeCtor4<P1, P2, P3, P4, T> ctor, final P1 p1, final P2 p2, final P3 p3, final P4 p4) {
        return new NodeInfo<T>(n){

            @Override
            protected List<Object> innerProperties() {
                return Arrays.asList(p1, p2, p3, p4);
            }

            @Override
            protected T innerTransform(Function<Object, Object> rule) {
                boolean same = true;
                Object newP1 = rule.apply(p1);
                same &= Objects.equals(p1, newP1);
                Object newP2 = rule.apply(p2);
                same &= Objects.equals(p2, newP2);
                Object newP3 = rule.apply(p3);
                same &= Objects.equals(p3, newP3);
                Object newP4 = rule.apply(p4);
                return (same &= Objects.equals(p4, newP4)) ? this.node : (Node)ctor.apply(this.node.source(), newP1, newP2, newP3, newP4);
            }
        };
    }

    public static <T extends Node<?>, P1, P2, P3, P4, P5> NodeInfo<T> create(T n, final NodeCtor5<P1, P2, P3, P4, P5, T> ctor, final P1 p1, final P2 p2, final P3 p3, final P4 p4, final P5 p5) {
        return new NodeInfo<T>(n){

            @Override
            protected List<Object> innerProperties() {
                return Arrays.asList(p1, p2, p3, p4, p5);
            }

            @Override
            protected T innerTransform(Function<Object, Object> rule) {
                boolean same = true;
                Object newP1 = rule.apply(p1);
                same &= Objects.equals(p1, newP1);
                Object newP2 = rule.apply(p2);
                same &= Objects.equals(p2, newP2);
                Object newP3 = rule.apply(p3);
                same &= Objects.equals(p3, newP3);
                Object newP4 = rule.apply(p4);
                same &= Objects.equals(p4, newP4);
                Object newP5 = rule.apply(p5);
                return (same &= Objects.equals(p5, newP5)) ? this.node : (Node)ctor.apply(this.node.source(), newP1, newP2, newP3, newP4, newP5);
            }
        };
    }

    public static <T extends Node<?>, P1, P2, P3, P4, P5, P6> NodeInfo<T> create(T n, final NodeCtor6<P1, P2, P3, P4, P5, P6, T> ctor, final P1 p1, final P2 p2, final P3 p3, final P4 p4, final P5 p5, final P6 p6) {
        return new NodeInfo<T>(n){

            @Override
            protected List<Object> innerProperties() {
                return Arrays.asList(p1, p2, p3, p4, p5, p6);
            }

            @Override
            protected T innerTransform(Function<Object, Object> rule) {
                boolean same = true;
                Object newP1 = rule.apply(p1);
                same &= Objects.equals(p1, newP1);
                Object newP2 = rule.apply(p2);
                same &= Objects.equals(p2, newP2);
                Object newP3 = rule.apply(p3);
                same &= Objects.equals(p3, newP3);
                Object newP4 = rule.apply(p4);
                same &= Objects.equals(p4, newP4);
                Object newP5 = rule.apply(p5);
                same &= Objects.equals(p5, newP5);
                Object newP6 = rule.apply(p6);
                return (same &= Objects.equals(p6, newP6)) ? this.node : (Node)ctor.apply(this.node.source(), newP1, newP2, newP3, newP4, newP5, newP6);
            }
        };
    }

    public static <T extends Node<?>, P1, P2, P3, P4, P5, P6, P7> NodeInfo<T> create(T n, final NodeCtor7<P1, P2, P3, P4, P5, P6, P7, T> ctor, final P1 p1, final P2 p2, final P3 p3, final P4 p4, final P5 p5, final P6 p6, final P7 p7) {
        return new NodeInfo<T>(n){

            @Override
            protected List<Object> innerProperties() {
                return Arrays.asList(p1, p2, p3, p4, p5, p6, p7);
            }

            @Override
            protected T innerTransform(Function<Object, Object> rule) {
                boolean same = true;
                Object newP1 = rule.apply(p1);
                same &= Objects.equals(p1, newP1);
                Object newP2 = rule.apply(p2);
                same &= Objects.equals(p2, newP2);
                Object newP3 = rule.apply(p3);
                same &= Objects.equals(p3, newP3);
                Object newP4 = rule.apply(p4);
                same &= Objects.equals(p4, newP4);
                Object newP5 = rule.apply(p5);
                same &= Objects.equals(p5, newP5);
                Object newP6 = rule.apply(p6);
                same &= Objects.equals(p6, newP6);
                Object newP7 = rule.apply(p7);
                return (same &= Objects.equals(p7, newP7)) ? this.node : (Node)ctor.apply(this.node.source(), newP1, newP2, newP3, newP4, newP5, newP6, newP7);
            }
        };
    }

    public static <T extends Node<?>, P1, P2, P3, P4, P5, P6, P7, P8> NodeInfo<T> create(T n, final NodeCtor8<P1, P2, P3, P4, P5, P6, P7, P8, T> ctor, final P1 p1, final P2 p2, final P3 p3, final P4 p4, final P5 p5, final P6 p6, final P7 p7, final P8 p8) {
        return new NodeInfo<T>(n){

            @Override
            protected List<Object> innerProperties() {
                return Arrays.asList(p1, p2, p3, p4, p5, p6, p7, p8);
            }

            @Override
            protected T innerTransform(Function<Object, Object> rule) {
                boolean same = true;
                Object newP1 = rule.apply(p1);
                same &= Objects.equals(p1, newP1);
                Object newP2 = rule.apply(p2);
                same &= Objects.equals(p2, newP2);
                Object newP3 = rule.apply(p3);
                same &= Objects.equals(p3, newP3);
                Object newP4 = rule.apply(p4);
                same &= Objects.equals(p4, newP4);
                Object newP5 = rule.apply(p5);
                same &= Objects.equals(p5, newP5);
                Object newP6 = rule.apply(p6);
                same &= Objects.equals(p6, newP6);
                Object newP7 = rule.apply(p7);
                same &= Objects.equals(p7, newP7);
                Object newP8 = rule.apply(p8);
                return (same &= Objects.equals(p8, newP8)) ? this.node : (Node)ctor.apply(this.node.source(), newP1, newP2, newP3, newP4, newP5, newP6, newP7, newP8);
            }
        };
    }

    public static <T extends Node<?>, P1, P2, P3, P4, P5, P6, P7, P8, P9> NodeInfo<T> create(T n, final NodeCtor9<P1, P2, P3, P4, P5, P6, P7, P8, P9, T> ctor, final P1 p1, final P2 p2, final P3 p3, final P4 p4, final P5 p5, final P6 p6, final P7 p7, final P8 p8, final P9 p9) {
        return new NodeInfo<T>(n){

            @Override
            protected List<Object> innerProperties() {
                return Arrays.asList(p1, p2, p3, p4, p5, p6, p7, p8, p9);
            }

            @Override
            protected T innerTransform(Function<Object, Object> rule) {
                boolean same = true;
                Object newP1 = rule.apply(p1);
                same &= Objects.equals(p1, newP1);
                Object newP2 = rule.apply(p2);
                same &= Objects.equals(p2, newP2);
                Object newP3 = rule.apply(p3);
                same &= Objects.equals(p3, newP3);
                Object newP4 = rule.apply(p4);
                same &= Objects.equals(p4, newP4);
                Object newP5 = rule.apply(p5);
                same &= Objects.equals(p5, newP5);
                Object newP6 = rule.apply(p6);
                same &= Objects.equals(p6, newP6);
                Object newP7 = rule.apply(p7);
                same &= Objects.equals(p7, newP7);
                Object newP8 = rule.apply(p8);
                same &= Objects.equals(p8, newP8);
                Object newP9 = rule.apply(p9);
                return (same &= Objects.equals(p9, newP9)) ? this.node : (Node)ctor.apply(this.node.source(), newP1, newP2, newP3, newP4, newP5, newP6, newP7, newP8, newP9);
            }
        };
    }

    public static <T extends Node<?>, P1, P2, P3, P4, P5, P6, P7, P8, P9, P10> NodeInfo<T> create(T n, final NodeCtor10<P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, T> ctor, final P1 p1, final P2 p2, final P3 p3, final P4 p4, final P5 p5, final P6 p6, final P7 p7, final P8 p8, final P9 p9, final P10 p10) {
        return new NodeInfo<T>(n){

            @Override
            protected List<Object> innerProperties() {
                return Arrays.asList(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10);
            }

            @Override
            protected T innerTransform(Function<Object, Object> rule) {
                boolean same = true;
                Object newP1 = rule.apply(p1);
                same &= Objects.equals(p1, newP1);
                Object newP2 = rule.apply(p2);
                same &= Objects.equals(p2, newP2);
                Object newP3 = rule.apply(p3);
                same &= Objects.equals(p3, newP3);
                Object newP4 = rule.apply(p4);
                same &= Objects.equals(p4, newP4);
                Object newP5 = rule.apply(p5);
                same &= Objects.equals(p5, newP5);
                Object newP6 = rule.apply(p6);
                same &= Objects.equals(p6, newP6);
                Object newP7 = rule.apply(p7);
                same &= Objects.equals(p7, newP7);
                Object newP8 = rule.apply(p8);
                same &= Objects.equals(p8, newP8);
                Object newP9 = rule.apply(p9);
                same &= Objects.equals(p9, newP9);
                Object newP10 = rule.apply(p10);
                return (same &= Objects.equals(p10, newP10)) ? this.node : (Node)ctor.apply(this.node.source(), newP1, newP2, newP3, newP4, newP5, newP6, newP7, newP8, newP9, newP10);
            }
        };
    }

    /* synthetic */ NodeInfo(Node x0, 1 x1) {
        this(x0);
    }

    public static interface NodeCtor10<P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, T> {
        public T apply(Source var1, P1 var2, P2 var3, P3 var4, P4 var5, P5 var6, P6 var7, P7 var8, P8 var9, P9 var10, P10 var11);
    }

    public static interface NodeCtor9<P1, P2, P3, P4, P5, P6, P7, P8, P9, T> {
        public T apply(Source var1, P1 var2, P2 var3, P3 var4, P4 var5, P5 var6, P6 var7, P7 var8, P8 var9, P9 var10);
    }

    public static interface NodeCtor8<P1, P2, P3, P4, P5, P6, P7, P8, T> {
        public T apply(Source var1, P1 var2, P2 var3, P3 var4, P4 var5, P5 var6, P6 var7, P7 var8, P8 var9);
    }

    public static interface NodeCtor7<P1, P2, P3, P4, P5, P6, P7, T> {
        public T apply(Source var1, P1 var2, P2 var3, P3 var4, P4 var5, P5 var6, P6 var7, P7 var8);
    }

    public static interface NodeCtor6<P1, P2, P3, P4, P5, P6, T> {
        public T apply(Source var1, P1 var2, P2 var3, P3 var4, P4 var5, P5 var6, P6 var7);
    }

    public static interface NodeCtor5<P1, P2, P3, P4, P5, T> {
        public T apply(Source var1, P1 var2, P2 var3, P3 var4, P4 var5, P5 var6);
    }

    public static interface NodeCtor4<P1, P2, P3, P4, T> {
        public T apply(Source var1, P1 var2, P2 var3, P3 var4, P4 var5);
    }

    public static interface NodeCtor3<P1, P2, P3, T> {
        public T apply(Source var1, P1 var2, P2 var3, P3 var4);
    }

    public static interface NodeCtor2<P1, P2, T> {
        public T apply(Source var1, P1 var2, P2 var3);
    }
}

