/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.container;

import org.elasticsearch.xpack.sql.execution.search.SqlSourceBuilder;
import org.elasticsearch.xpack.sql.querydsl.container.FieldReference;
import org.elasticsearch.xpack.sql.type.DataType;

public class SearchHitFieldRef
extends FieldReference {
    private final String name;
    private final String fullFieldName;
    private final DataType dataType;
    private final boolean docValue;
    private final String hitName;

    public SearchHitFieldRef(String name, String fullFieldName, DataType dataType, boolean useDocValueInsteadOfSource, boolean isAlias) {
        this(name, fullFieldName, dataType, useDocValueInsteadOfSource, isAlias, null);
    }

    public SearchHitFieldRef(String name, String fullFieldName, DataType dataType, boolean useDocValueInsteadOfSource, boolean isAlias, String hitName) {
        this.name = name;
        this.fullFieldName = fullFieldName;
        this.dataType = dataType;
        this.docValue = isAlias ? useDocValueInsteadOfSource : (dataType.isFromDocValuesOnly() ? useDocValueInsteadOfSource : false);
        this.hitName = hitName;
    }

    public String hitName() {
        return this.hitName;
    }

    @Override
    public String name() {
        return this.name;
    }

    public String fullFieldName() {
        return this.fullFieldName;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public boolean useDocValue() {
        return this.docValue;
    }

    @Override
    public void collectFields(SqlSourceBuilder sourceBuilder) {
        if (this.hitName != null) {
            return;
        }
        if (this.docValue) {
            sourceBuilder.addDocField(this.name, this.dataType.format());
        } else {
            sourceBuilder.addSourceField(this.name);
        }
    }

    public String toString() {
        return this.name;
    }
}

