/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.agg;

import java.time.ZoneId;
import java.util.Objects;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.DateHistogramValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.querydsl.agg.GroupByKey;
import org.elasticsearch.xpack.sql.querydsl.container.Sort;

public class GroupByDateHistogram
extends GroupByKey {
    private final long fixedInterval;
    private final String calendarInterval;
    private final ZoneId zoneId;

    public GroupByDateHistogram(String id, String fieldName, long fixedInterval, ZoneId zoneId) {
        this(id, fieldName, null, null, fixedInterval, null, zoneId);
    }

    public GroupByDateHistogram(String id, ScriptTemplate script, long fixedInterval, ZoneId zoneId) {
        this(id, null, script, null, fixedInterval, null, zoneId);
    }

    public GroupByDateHistogram(String id, String fieldName, String calendarInterval, ZoneId zoneId) {
        this(id, fieldName, null, null, -1L, calendarInterval, zoneId);
    }

    public GroupByDateHistogram(String id, ScriptTemplate script, String calendarInterval, ZoneId zoneId) {
        this(id, null, script, null, -1L, calendarInterval, zoneId);
    }

    private GroupByDateHistogram(String id, String fieldName, ScriptTemplate script, Sort.Direction direction, long fixedInterval, String calendarInterval, ZoneId zoneId) {
        super(id, fieldName, script, direction);
        if (fixedInterval <= 0L && (calendarInterval == null || calendarInterval.trim().isEmpty())) {
            throw new SqlIllegalArgumentException("Either fixed interval or calendar interval needs to be specified");
        }
        this.fixedInterval = fixedInterval;
        this.calendarInterval = calendarInterval;
        this.zoneId = zoneId;
    }

    public long fixedInterval() {
        return this.fixedInterval;
    }

    @Override
    protected CompositeValuesSourceBuilder<?> createSourceBuilder() {
        DateHistogramValuesSourceBuilder builder = new DateHistogramValuesSourceBuilder(this.id()).timeZone(this.zoneId);
        return this.calendarInterval != null ? builder.calendarInterval(new DateHistogramInterval(this.calendarInterval)) : builder.fixedInterval(new DateHistogramInterval(this.fixedInterval + "ms"));
    }

    @Override
    protected GroupByKey copy(String id, String fieldName, ScriptTemplate script, Sort.Direction direction) {
        return new GroupByDateHistogram(id, fieldName, script, direction, this.fixedInterval, this.calendarInterval, this.zoneId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fixedInterval, this.calendarInterval, this.zoneId);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            GroupByDateHistogram other = (GroupByDateHistogram)obj;
            return Objects.equals(this.fixedInterval, other.fixedInterval) && Objects.equals(this.calendarInterval, other.calendarInterval) && Objects.equals(this.zoneId, other.zoneId);
        }
        return false;
    }
}

