/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.planner;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.sql.expression.function.aggregate.InnerAggregate;
import org.elasticsearch.xpack.sql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.sql.plan.physical.PivotExec;
import org.elasticsearch.xpack.sql.plan.physical.Unexecutable;
import org.elasticsearch.xpack.sql.plan.physical.UnplannedExec;
import org.elasticsearch.xpack.sql.tree.Node;

abstract class Verifier {
    Verifier() {
    }

    private static Failure fail(Node<?> source, String message, Object ... args) {
        return new Failure(source, LoggerMessageFormat.format(null, (String)message, (Object[])args));
    }

    static List<Failure> verifyMappingPlan(PhysicalPlan plan) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        plan.forEachUp(p -> {
            if (p instanceof UnplannedExec) {
                failures.add(Verifier.fail(p, "Unplanned item", new Object[0]));
            }
            p.forEachExpressionsUp(e -> {
                if (e.childrenResolved() && !e.resolved()) {
                    failures.add(Verifier.fail(e, "Unresolved expression", new Object[0]));
                }
            });
        });
        Verifier.checkInnerAggsPivot(plan, failures);
        return failures;
    }

    private static void checkInnerAggsPivot(PhysicalPlan plan, List<Failure> failures) {
        plan.forEachDown(p -> p.pivot().aggregates().forEach(agg -> agg.forEachDown(e -> {
            if (e instanceof InnerAggregate) {
                failures.add(Verifier.fail(e, "Aggregation [{}] not supported (yet) by PIVOT", e.sourceText()));
            }
        })), PivotExec.class);
    }

    static List<Failure> verifyExecutingPlan(PhysicalPlan plan) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        plan.forEachUp(p -> {
            if (p instanceof Unexecutable) {
                failures.add(Verifier.fail(p, "Unexecutable item", new Object[0]));
            }
            p.forEachExpressionsUp(e -> {
                if (e.childrenResolved() && !e.resolved()) {
                    failures.add(Verifier.fail(e, "Unresolved expression", new Object[0]));
                }
            });
        });
        return failures;
    }

    static class Failure {
        private final Node<?> source;
        private final String message;

        Failure(Node<?> source, String message) {
            this.source = source;
            this.message = message;
        }

        Node<?> source() {
            return this.source;
        }

        String message() {
            return this.message;
        }

        public int hashCode() {
            return this.source.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Failure other = (Failure)obj;
            return Objects.equals(this.source, other.source);
        }
    }
}

