/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.physical;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.plan.logical.Pivot;
import org.elasticsearch.xpack.sql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.sql.plan.physical.UnaryExec;
import org.elasticsearch.xpack.sql.plan.physical.Unexecutable;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;

public class PivotExec
extends UnaryExec
implements Unexecutable {
    private final Pivot pivot;

    public PivotExec(Source source, PhysicalPlan child, Pivot pivot) {
        super(source, child);
        this.pivot = pivot;
    }

    @Override
    protected NodeInfo<PivotExec> info() {
        return NodeInfo.create(this, PivotExec::new, this.child(), this.pivot);
    }

    @Override
    protected PivotExec replaceChild(PhysicalPlan newChild) {
        return new PivotExec(this.source(), newChild, this.pivot);
    }

    @Override
    public List<Attribute> output() {
        return this.pivot.output();
    }

    public Pivot pivot() {
        return this.pivot;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.pivot, this.child());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PivotExec other = (PivotExec)obj;
        return Objects.equals(this.pivot, other.pivot) && Objects.equals(this.child(), other.child());
    }
}

