/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.logical.command.sys;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.plan.logical.command.Command;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.SqlSession;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DataTypes;

public class SysTypes
extends Command {
    private final Integer type;

    public SysTypes(Source source, int type) {
        super(source);
        this.type = type;
    }

    @Override
    protected NodeInfo<SysTypes> info() {
        return NodeInfo.create(this, SysTypes::new, this.type);
    }

    @Override
    public List<Attribute> output() {
        return Arrays.asList(this.keyword("TYPE_NAME"), this.field("DATA_TYPE", DataType.INTEGER), this.field("PRECISION", DataType.INTEGER), this.keyword("LITERAL_PREFIX"), this.keyword("LITERAL_SUFFIX"), this.keyword("CREATE_PARAMS"), this.field("NULLABLE", DataType.SHORT), this.field("CASE_SENSITIVE", DataType.BOOLEAN), this.field("SEARCHABLE", DataType.SHORT), this.field("UNSIGNED_ATTRIBUTE", DataType.BOOLEAN), this.field("FIXED_PREC_SCALE", DataType.BOOLEAN), this.field("AUTO_INCREMENT", DataType.BOOLEAN), this.keyword("LOCAL_TYPE_NAME"), this.field("MINIMUM_SCALE", DataType.SHORT), this.field("MAXIMUM_SCALE", DataType.SHORT), this.field("SQL_DATA_TYPE", DataType.INTEGER), this.field("SQL_DATETIME_SUB", DataType.INTEGER), this.field("NUM_PREC_RADIX", DataType.INTEGER), this.field("INTERVAL_PRECISION", DataType.INTEGER));
    }

    @Override
    public final void execute(SqlSession session, ActionListener<Cursor.Page> listener) {
        Stream<DataType> values = Stream.of(DataType.values());
        if (this.type != 0) {
            values = values.filter(t -> this.type.equals(t.sqlType.getVendorTypeNumber()));
        }
        List<List<?>> rows = values.sorted(Comparator.comparing(t -> t.sqlType.getVendorTypeNumber()).thenComparing(DataType::sqlName)).map(t -> Arrays.asList(t.toString(), t.sqlType.getVendorTypeNumber(), DataTypes.precision(t), "'", "'", null, 2, t.isString(), 3, !t.isSigned(), Boolean.FALSE, Boolean.FALSE, null, DataTypes.metaSqlMinimumScale(t), DataTypes.metaSqlMaximumScale(t), DataTypes.metaSqlDataType(t), DataTypes.metaSqlDateTimeSub(t), DataTypes.metaSqlRadix(t), null)).collect(Collectors.toList());
        listener.onResponse((Object)this.of(session, rows));
    }

    @Override
    public int hashCode() {
        return this.type.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.type.equals(((SysTypes)obj).type);
    }
}

