/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.logical.command.sys;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.lucene.util.Counter;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.sql.analysis.index.EsIndex;
import org.elasticsearch.xpack.sql.analysis.index.IndexResolution;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.predicate.regex.LikePattern;
import org.elasticsearch.xpack.sql.plan.logical.command.Command;
import org.elasticsearch.xpack.sql.proto.Mode;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.Rows;
import org.elasticsearch.xpack.sql.session.SqlSession;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DataTypes;
import org.elasticsearch.xpack.sql.type.EsField;
import org.elasticsearch.xpack.sql.util.StringUtils;

public class SysColumns
extends Command {
    private final String catalog;
    private final String index;
    private final LikePattern pattern;
    private final LikePattern columnPattern;

    public SysColumns(Source source, String catalog, String index, LikePattern pattern, LikePattern columnPattern) {
        super(source);
        this.catalog = catalog;
        this.index = index;
        this.pattern = pattern;
        this.columnPattern = columnPattern;
    }

    @Override
    protected NodeInfo<SysColumns> info() {
        return NodeInfo.create(this, SysColumns::new, this.catalog, this.index, this.pattern, this.columnPattern);
    }

    @Override
    public List<Attribute> output() {
        return this.output(false);
    }

    private List<Attribute> output(boolean odbcCompatible) {
        DataType clientBasedType = odbcCompatible ? DataType.SHORT : DataType.INTEGER;
        return Arrays.asList(this.keyword("TABLE_CAT"), this.keyword("TABLE_SCHEM"), this.keyword("TABLE_NAME"), this.keyword("COLUMN_NAME"), this.field("DATA_TYPE", clientBasedType), this.keyword("TYPE_NAME"), this.field("COLUMN_SIZE", DataType.INTEGER), this.field("BUFFER_LENGTH", DataType.INTEGER), this.field("DECIMAL_DIGITS", clientBasedType), this.field("NUM_PREC_RADIX", clientBasedType), this.field("NULLABLE", clientBasedType), this.keyword("REMARKS"), this.keyword("COLUMN_DEF"), this.field("SQL_DATA_TYPE", clientBasedType), this.field("SQL_DATETIME_SUB", clientBasedType), this.field("CHAR_OCTET_LENGTH", DataType.INTEGER), this.field("ORDINAL_POSITION", DataType.INTEGER), this.keyword("IS_NULLABLE"), this.keyword("SCOPE_CATALOG"), this.keyword("SCOPE_SCHEMA"), this.keyword("SCOPE_TABLE"), this.field("SOURCE_DATA_TYPE", DataType.SHORT), this.keyword("IS_AUTOINCREMENT"), this.keyword("IS_GENERATEDCOLUMN"));
    }

    @Override
    public void execute(SqlSession session, ActionListener<Cursor.Page> listener) {
        String indexName;
        Mode mode = session.configuration().mode();
        List<Attribute> output = this.output(mode == Mode.ODBC);
        String cluster = session.indexResolver().clusterName();
        if (Strings.hasText((String)this.catalog) && !cluster.equals(this.catalog)) {
            listener.onResponse((Object)Cursor.Page.last(Rows.empty(output)));
            return;
        }
        String string = this.index != null ? this.index : (indexName = this.pattern != null ? StringUtils.likeToUnescaped(this.pattern.pattern(), this.pattern.escape()) : "");
        String idx = this.index != null ? this.index : (this.pattern != null ? this.pattern.asIndexNameWildcard() : "*");
        String regex = this.pattern != null ? this.pattern.asJavaRegex() : null;
        Pattern columnMatcher = this.columnPattern != null ? Pattern.compile(this.columnPattern.asJavaRegex()) : null;
        boolean includeFrozen = session.configuration().includeFrozen();
        if ("*".equals(idx)) {
            session.indexResolver().resolveAsSeparateMappings(idx, regex, includeFrozen, (ActionListener<List<EsIndex>>)ActionListener.wrap(esIndices -> {
                ArrayList rows = new ArrayList();
                for (EsIndex esIndex : esIndices) {
                    SysColumns.fillInRows(cluster, esIndex.name(), esIndex.mapping(), null, rows, columnMatcher, mode);
                }
                listener.onResponse((Object)this.of(session, rows));
            }, arg_0 -> listener.onFailure(arg_0)));
        } else {
            session.indexResolver().resolveAsMergedMapping(idx, regex, includeFrozen, (ActionListener<IndexResolution>)ActionListener.wrap(r -> {
                ArrayList rows = new ArrayList();
                if (r.isValid()) {
                    EsIndex esIndex = r.get();
                    SysColumns.fillInRows(cluster, indexName, esIndex.mapping(), null, rows, columnMatcher, mode);
                }
                listener.onResponse((Object)this.of(session, rows));
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }

    static void fillInRows(String clusterName, String indexName, Map<String, EsField> mapping, String prefix, List<List<?>> rows, Pattern columnMatcher, Mode mode) {
        SysColumns.fillInRows(clusterName, indexName, mapping, prefix, rows, columnMatcher, Counter.newCounter(), mode);
    }

    private static void fillInRows(String clusterName, String indexName, Map<String, EsField> mapping, String prefix, List<List<?>> rows, Pattern columnMatcher, Counter position, Mode mode) {
        boolean isOdbcClient = mode == Mode.ODBC;
        for (Map.Entry<String, EsField> entry : mapping.entrySet()) {
            position.addAndGet(1L);
            String name = entry.getKey();
            name = prefix != null ? prefix + "." + name : name;
            EsField field = entry.getValue();
            DataType type = field.getDataType();
            if (type.isPrimitive() && (columnMatcher == null || columnMatcher.matcher(name).matches())) {
                rows.add(Arrays.asList(clusterName, null, indexName, name, SysColumns.odbcCompatible(type.sqlType.getVendorTypeNumber(), isOdbcClient), type.toString(), type.displaySize, type.size, null, SysColumns.odbcCompatible(DataTypes.metaSqlRadix(type), isOdbcClient), SysColumns.odbcCompatible(1, isOdbcClient), null, null, SysColumns.odbcCompatible(DataTypes.metaSqlDataType(type), isOdbcClient), SysColumns.odbcCompatible(DataTypes.metaSqlDateTimeSub(type), isOdbcClient), type.isString() || type == DataType.BINARY ? Integer.valueOf(type.size) : null, (int)position.get(), "YES", null, null, null, null, "NO", "NO"));
            }
            if (field.getProperties() == null || type == DataType.NESTED) continue;
            SysColumns.fillInRows(clusterName, indexName, field.getProperties(), name, rows, columnMatcher, position, mode);
        }
    }

    private static Object odbcCompatible(Integer value, boolean isOdbcClient) {
        if (isOdbcClient && value != null) {
            return value.shortValue();
        }
        return value;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.catalog, this.index, this.pattern, this.columnPattern);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SysColumns other = (SysColumns)obj;
        return Objects.equals(this.catalog, other.catalog) && Objects.equals(this.index, other.index) && Objects.equals(this.pattern, other.pattern) && Objects.equals(this.columnPattern, other.columnPattern);
    }
}

