/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.logical;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.capabilities.Unresolvable;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.plan.TableIdentifier;
import org.elasticsearch.xpack.sql.plan.logical.LeafPlan;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;

public class UnresolvedRelation
extends LeafPlan
implements Unresolvable {
    private final TableIdentifier table;
    private final boolean frozen;
    private final String alias;
    private final String unresolvedMsg;

    public UnresolvedRelation(Source source, TableIdentifier table, String alias, boolean frozen) {
        this(source, table, alias, frozen, null);
    }

    public UnresolvedRelation(Source source, TableIdentifier table, String alias, boolean frozen, String unresolvedMessage) {
        super(source);
        this.table = table;
        this.alias = alias;
        this.frozen = frozen;
        this.unresolvedMsg = unresolvedMessage == null ? "Unknown index [" + table.index() + "]" : unresolvedMessage;
    }

    @Override
    protected NodeInfo<UnresolvedRelation> info() {
        return NodeInfo.create(this, UnresolvedRelation::new, this.table, this.alias, this.frozen, this.unresolvedMsg);
    }

    public TableIdentifier table() {
        return this.table;
    }

    public String alias() {
        return this.alias;
    }

    public boolean frozen() {
        return this.frozen;
    }

    @Override
    public boolean resolved() {
        return false;
    }

    @Override
    public boolean expressionsResolved() {
        return false;
    }

    @Override
    public List<Attribute> output() {
        return Collections.emptyList();
    }

    @Override
    public String unresolvedMessage() {
        return this.unresolvedMsg;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.source(), this.table, this.alias, this.unresolvedMsg);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UnresolvedRelation other = (UnresolvedRelation)obj;
        return this.source().equals(other.source()) && this.table.equals(other.table) && Objects.equals(this.alias, other.alias) && Objects.equals(this.frozen, other.frozen) && this.unresolvedMsg.equals(other.unresolvedMsg);
    }

    @Override
    public List<Object> nodeProperties() {
        return Collections.singletonList(this.table);
    }

    @Override
    public String toString() {
        return "?" + this.table.index();
    }
}

