/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.logical;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.xpack.sql.capabilities.Resolvables;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.AttributeSet;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.ExpressionId;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.NamedExpression;
import org.elasticsearch.xpack.sql.expression.function.Function;
import org.elasticsearch.xpack.sql.plan.logical.EsRelation;
import org.elasticsearch.xpack.sql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.sql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;

public class Pivot
extends UnaryPlan {
    private final Expression column;
    private final List<NamedExpression> values;
    private final List<NamedExpression> aggregates;
    private AttributeSet groupingSet;
    private AttributeSet valueOutput;
    private List<Attribute> output;

    public Pivot(Source source, LogicalPlan child, Expression column, List<NamedExpression> values, List<NamedExpression> aggregates) {
        super(source, child);
        this.column = column;
        this.values = values;
        this.aggregates = aggregates;
    }

    private static Expression withQualifierNull(Expression e) {
        if (e instanceof Attribute) {
            Attribute fa = (Attribute)e;
            return fa.withQualifier(null);
        }
        return e;
    }

    @Override
    protected NodeInfo<Pivot> info() {
        return NodeInfo.create(this, Pivot::new, this.child(), this.column, this.values, this.aggregates);
    }

    @Override
    protected Pivot replaceChild(LogicalPlan newChild) {
        Expression newColumn = this.column;
        List<NamedExpression> newAggregates = this.aggregates;
        if (newChild instanceof EsRelation) {
            newColumn = this.column.transformUp(Pivot::withQualifierNull);
            newAggregates = this.aggregates.stream().map(aggregate -> (NamedExpression)aggregate.transformUp(Pivot::withQualifierNull)).collect(Collectors.toList());
        }
        return new Pivot(this.source(), newChild, newColumn, this.values, newAggregates);
    }

    public Expression column() {
        return this.column;
    }

    public List<NamedExpression> values() {
        return this.values;
    }

    public List<NamedExpression> aggregates() {
        return this.aggregates;
    }

    public AttributeSet groupingSet() {
        if (this.groupingSet == null) {
            AttributeSet columnSet = Expressions.references(Collections.singletonList(this.column));
            this.groupingSet = new AttributeSet(Expressions.onlyPrimitiveFieldAttributes(this.child().output())).subtract(columnSet).subtract(Expressions.references(this.aggregates)).combine(columnSet);
        }
        return this.groupingSet;
    }

    public AttributeSet valuesOutput() {
        if (this.valueOutput == null) {
            ArrayList<Attribute> out = new ArrayList<Attribute>(this.aggregates.size() * this.values.size());
            if (this.aggregates.size() == 1) {
                NamedExpression agg = this.aggregates.get(0);
                for (NamedExpression value : this.values) {
                    ExpressionId id = value.id();
                    out.add(value.toAttribute().withDataType(agg.dataType()).withId(id));
                }
            } else {
                for (NamedExpression agg : this.aggregates) {
                    String name = agg instanceof Function ? ((Function)agg).functionName() : agg.name();
                    for (NamedExpression value : this.values) {
                        ExpressionId id = value.id();
                        out.add(value.toAttribute().withName(value.name() + "_" + name).withDataType(agg.dataType()).withId(id));
                    }
                }
            }
            this.valueOutput = new AttributeSet(out);
        }
        return this.valueOutput;
    }

    @Override
    public List<Attribute> output() {
        if (this.output == null) {
            this.output = new ArrayList<Attribute>(this.groupingSet().subtract(Expressions.references(Collections.singletonList(this.column))).combine(this.valuesOutput()));
        }
        return this.output;
    }

    @Override
    public boolean expressionsResolved() {
        return this.column.resolved() && Resolvables.resolved(this.values) && Resolvables.resolved(this.aggregates);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.column, this.values, this.aggregates, this.child());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Pivot other = (Pivot)obj;
        return Objects.equals(this.column, other.column) && Objects.equals(this.values, other.values) && Objects.equals(this.aggregates, other.aggregates) && Objects.equals(this.child(), other.child());
    }
}

