/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.parser;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.xpack.sql.analysis.index.IndexResolver;
import org.elasticsearch.xpack.sql.expression.Literal;
import org.elasticsearch.xpack.sql.parser.LogicalPlanBuilder;
import org.elasticsearch.xpack.sql.parser.ParsingException;
import org.elasticsearch.xpack.sql.parser.SqlBaseParser;
import org.elasticsearch.xpack.sql.plan.TableIdentifier;
import org.elasticsearch.xpack.sql.plan.logical.command.Command;
import org.elasticsearch.xpack.sql.plan.logical.command.Debug;
import org.elasticsearch.xpack.sql.plan.logical.command.Explain;
import org.elasticsearch.xpack.sql.plan.logical.command.ShowColumns;
import org.elasticsearch.xpack.sql.plan.logical.command.ShowFunctions;
import org.elasticsearch.xpack.sql.plan.logical.command.ShowSchemas;
import org.elasticsearch.xpack.sql.plan.logical.command.ShowTables;
import org.elasticsearch.xpack.sql.plan.logical.command.sys.SysColumns;
import org.elasticsearch.xpack.sql.plan.logical.command.sys.SysTables;
import org.elasticsearch.xpack.sql.plan.logical.command.sys.SysTypes;
import org.elasticsearch.xpack.sql.proto.SqlTypedParamValue;
import org.elasticsearch.xpack.sql.tree.Source;

abstract class CommandBuilder
extends LogicalPlanBuilder {
    protected CommandBuilder(Map<Token, SqlTypedParamValue> params) {
        super(params);
    }

    @Override
    public Command visitDebug(SqlBaseParser.DebugContext ctx) {
        Source source = CommandBuilder.source(ctx);
        if (ctx.FORMAT().size() > 1) {
            throw new ParsingException(source, "Debug FORMAT should be specified at most once", new Object[0]);
        }
        if (ctx.PLAN().size() > 1) {
            throw new ParsingException(source, "Debug PLAN should be specified at most once", new Object[0]);
        }
        Debug.Type type = null;
        if (ctx.type != null) {
            type = ctx.type.getType() == 7 ? Debug.Type.ANALYZED : Debug.Type.OPTIMIZED;
        }
        boolean graphViz = ctx.format != null && ctx.format.getType() == 44;
        Debug.Format format = graphViz ? Debug.Format.GRAPHVIZ : Debug.Format.TEXT;
        return new Debug(source, this.plan((ParseTree)ctx.statement()), type, format);
    }

    @Override
    public Command visitExplain(SqlBaseParser.ExplainContext ctx) {
        Source source = CommandBuilder.source(ctx);
        if (ctx.PLAN().size() > 1) {
            throw new ParsingException(source, "Explain TYPE should be specified at most once", new Object[0]);
        }
        if (ctx.FORMAT().size() > 1) {
            throw new ParsingException(source, "Explain FORMAT should be specified at most once", new Object[0]);
        }
        if (ctx.VERIFY().size() > 1) {
            throw new ParsingException(source, "Explain VERIFY should be specified at most once", new Object[0]);
        }
        Explain.Type type = null;
        if (ctx.type != null) {
            switch (ctx.type.getType()) {
                case 74: {
                    type = Explain.Type.PARSED;
                    break;
                }
                case 7: {
                    type = Explain.Type.ANALYZED;
                    break;
                }
                case 70: {
                    type = Explain.Type.OPTIMIZED;
                    break;
                }
                case 59: {
                    type = Explain.Type.MAPPED;
                    break;
                }
                case 32: {
                    type = Explain.Type.EXECUTABLE;
                    break;
                }
                default: {
                    type = Explain.Type.ALL;
                }
            }
        }
        boolean graphViz = ctx.format != null && ctx.format.getType() == 44;
        Explain.Format format = graphViz ? Explain.Format.GRAPHVIZ : Explain.Format.TEXT;
        boolean verify = ctx.verify != null ? Booleans.parseBoolean((String)ctx.verify.getText().toLowerCase(Locale.ROOT), (boolean)true) : true;
        return new Explain(source, this.plan((ParseTree)ctx.statement()), type, format, verify);
    }

    @Override
    public Object visitShowFunctions(SqlBaseParser.ShowFunctionsContext ctx) {
        return new ShowFunctions(CommandBuilder.source(ctx), this.visitLikePattern(ctx.likePattern()));
    }

    @Override
    public Object visitShowTables(SqlBaseParser.ShowTablesContext ctx) {
        TableIdentifier ti = this.visitTableIdentifier(ctx.tableIdent);
        String index = ti != null ? ti.qualifiedIndex() : null;
        return new ShowTables(CommandBuilder.source(ctx), index, this.visitLikePattern(ctx.likePattern()), ctx.FROZEN() != null);
    }

    @Override
    public Object visitShowSchemas(SqlBaseParser.ShowSchemasContext ctx) {
        return new ShowSchemas(CommandBuilder.source(ctx));
    }

    @Override
    public Object visitShowColumns(SqlBaseParser.ShowColumnsContext ctx) {
        TableIdentifier ti = this.visitTableIdentifier(ctx.tableIdent);
        String index = ti != null ? ti.qualifiedIndex() : null;
        return new ShowColumns(CommandBuilder.source(ctx), index, this.visitLikePattern(ctx.likePattern()), ctx.FROZEN() != null);
    }

    @Override
    public SysTables visitSysTables(SqlBaseParser.SysTablesContext ctx) {
        ArrayList<IndexResolver.IndexType> types = new ArrayList<IndexResolver.IndexType>();
        boolean legacyTableType = false;
        block10: for (SqlBaseParser.StringContext string : ctx.string()) {
            String value = this.string(string);
            if (value == null || value.isEmpty() || value.equals("%") && ctx.string().size() == 1) continue;
            switch (value.toUpperCase(Locale.ROOT)) {
                case "TABLE": {
                    legacyTableType = true;
                    types.add(IndexResolver.IndexType.STANDARD_INDEX);
                    continue block10;
                }
                case "BASE TABLE": {
                    types.add(IndexResolver.IndexType.STANDARD_INDEX);
                    continue block10;
                }
                case "VIEW": {
                    types.add(IndexResolver.IndexType.ALIAS);
                    continue block10;
                }
            }
            types.add(IndexResolver.IndexType.UNKNOWN);
        }
        EnumSet<IndexResolver.IndexType> set = types.isEmpty() ? null : EnumSet.copyOf(types);
        TableIdentifier ti = this.visitTableIdentifier(ctx.tableIdent);
        String index = ti != null ? ti.qualifiedIndex() : null;
        return new SysTables(CommandBuilder.source(ctx), this.visitLikePattern(ctx.clusterLike), index, this.visitLikePattern(ctx.tableLike), set, legacyTableType);
    }

    @Override
    public Object visitSysColumns(SqlBaseParser.SysColumnsContext ctx) {
        TableIdentifier ti = this.visitTableIdentifier(ctx.tableIdent);
        String index = ti != null ? ti.qualifiedIndex() : null;
        return new SysColumns(CommandBuilder.source(ctx), this.string(ctx.cluster), index, this.visitLikePattern(ctx.tableLike), this.visitLikePattern(ctx.columnPattern));
    }

    @Override
    public SysTypes visitSysTypes(SqlBaseParser.SysTypesContext ctx) {
        int type = 0;
        if (ctx.type != null) {
            Literal value = (Literal)this.visit((ParseTree)ctx.type);
            type = ((Number)value.fold()).intValue();
        }
        return new SysTypes(CommandBuilder.source(ctx), type);
    }
}

