/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.optimizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.analysis.analyzer.Analyzer;
import org.elasticsearch.xpack.sql.expression.Alias;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.AttributeMap;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.ExpressionSet;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.expression.Literal;
import org.elasticsearch.xpack.sql.expression.NamedExpression;
import org.elasticsearch.xpack.sql.expression.Nullability;
import org.elasticsearch.xpack.sql.expression.Order;
import org.elasticsearch.xpack.sql.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.sql.expression.function.Function;
import org.elasticsearch.xpack.sql.expression.function.FunctionAttribute;
import org.elasticsearch.xpack.sql.expression.function.Functions;
import org.elasticsearch.xpack.sql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.sql.expression.function.aggregate.AggregateFunctionAttribute;
import org.elasticsearch.xpack.sql.expression.function.aggregate.ExtendedStats;
import org.elasticsearch.xpack.sql.expression.function.aggregate.ExtendedStatsEnclosed;
import org.elasticsearch.xpack.sql.expression.function.aggregate.First;
import org.elasticsearch.xpack.sql.expression.function.aggregate.InnerAggregate;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Last;
import org.elasticsearch.xpack.sql.expression.function.aggregate.MatrixStats;
import org.elasticsearch.xpack.sql.expression.function.aggregate.MatrixStatsEnclosed;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Max;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Min;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Percentile;
import org.elasticsearch.xpack.sql.expression.function.aggregate.PercentileRank;
import org.elasticsearch.xpack.sql.expression.function.aggregate.PercentileRanks;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Percentiles;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Stats;
import org.elasticsearch.xpack.sql.expression.function.aggregate.TopHits;
import org.elasticsearch.xpack.sql.expression.function.scalar.Cast;
import org.elasticsearch.xpack.sql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.ScalarFunctionAttribute;
import org.elasticsearch.xpack.sql.expression.predicate.BinaryOperator;
import org.elasticsearch.xpack.sql.expression.predicate.BinaryPredicate;
import org.elasticsearch.xpack.sql.expression.predicate.Negatable;
import org.elasticsearch.xpack.sql.expression.predicate.Predicates;
import org.elasticsearch.xpack.sql.expression.predicate.Range;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.ArbitraryConditionalFunction;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.Case;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.Coalesce;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.IfConditional;
import org.elasticsearch.xpack.sql.expression.predicate.fulltext.FullTextPredicate;
import org.elasticsearch.xpack.sql.expression.predicate.logical.And;
import org.elasticsearch.xpack.sql.expression.predicate.logical.Not;
import org.elasticsearch.xpack.sql.expression.predicate.logical.Or;
import org.elasticsearch.xpack.sql.expression.predicate.nulls.IsNotNull;
import org.elasticsearch.xpack.sql.expression.predicate.nulls.IsNull;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.GreaterThan;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.GreaterThanOrEqual;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.In;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.LessThan;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.LessThanOrEqual;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.NotEquals;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.NullEquals;
import org.elasticsearch.xpack.sql.plan.logical.Aggregate;
import org.elasticsearch.xpack.sql.plan.logical.EsRelation;
import org.elasticsearch.xpack.sql.plan.logical.Filter;
import org.elasticsearch.xpack.sql.plan.logical.Limit;
import org.elasticsearch.xpack.sql.plan.logical.LocalRelation;
import org.elasticsearch.xpack.sql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.sql.plan.logical.OrderBy;
import org.elasticsearch.xpack.sql.plan.logical.Pivot;
import org.elasticsearch.xpack.sql.plan.logical.Project;
import org.elasticsearch.xpack.sql.plan.logical.SubQueryAlias;
import org.elasticsearch.xpack.sql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.sql.rule.Rule;
import org.elasticsearch.xpack.sql.rule.RuleExecutor;
import org.elasticsearch.xpack.sql.session.EmptyExecutable;
import org.elasticsearch.xpack.sql.session.SingletonExecutable;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.util.CollectionUtils;
import org.elasticsearch.xpack.sql.util.Holder;

public class Optimizer
extends RuleExecutor<LogicalPlan> {
    public RuleExecutor.ExecutionInfo debugOptimize(LogicalPlan verified) {
        return verified.optimized() ? null : this.executeWithInfo(verified);
    }

    public LogicalPlan optimize(LogicalPlan verified) {
        return verified.optimized() ? verified : this.execute(verified);
    }

    @Override
    protected Iterable<RuleExecutor.Batch> batches() {
        RuleExecutor.Batch pivot = new RuleExecutor.Batch((RuleExecutor)this, "Pivot Rewrite", RuleExecutor.Limiter.ONCE, new RewritePivot());
        RuleExecutor.Batch operators = new RuleExecutor.Batch((RuleExecutor)this, "Operator Optimization", new PruneDuplicatesInGroupBy(), new CombineProjections(), new ReplaceFoldableAttributes(), new FoldNull(), new ConstantFolding(), new SimplifyConditional(), new SimplifyCase(), new BooleanSimplification(), new BooleanLiteralsOnTheRight(), new BinaryComparisonSimplification(), new PropagateEquals(), new CombineBinaryComparisons(), new PruneFilters(), new PruneOrderBy(), new PruneOrderByNestedFields(), new PruneCast(), new SortAggregateOnOrderBy());
        RuleExecutor.Batch aggregate = new RuleExecutor.Batch((RuleExecutor)this, "Aggregation Rewrite", new ReplaceMinMaxWithTopHits(), new ReplaceAggsWithMatrixStats(), new ReplaceAggsWithExtendedStats(), new ReplaceAggsWithStats(), new PromoteStatsToExtendedStats(), new ReplaceAggsWithPercentiles(), new ReplaceAggsWithPercentileRanks());
        RuleExecutor.Batch local = new RuleExecutor.Batch((RuleExecutor)this, "Skip Elasticsearch", new SkipQueryOnLimitZero(), new SkipQueryIfFoldingProjection());
        RuleExecutor.Batch label = new RuleExecutor.Batch((RuleExecutor)this, "Set as Optimized", RuleExecutor.Limiter.ONCE, Analyzer.CleanAliases.INSTANCE, new SetAsOptimized());
        return Arrays.asList(pivot, operators, aggregate, local, label);
    }

    static enum TransformDirection {
        UP,
        DOWN;

    }

    static abstract class OptimizerExpressionRule
    extends Rule<LogicalPlan, LogicalPlan> {
        private final TransformDirection direction;

        OptimizerExpressionRule(TransformDirection direction) {
            this.direction = direction;
        }

        @Override
        public final LogicalPlan apply(LogicalPlan plan) {
            return this.direction == TransformDirection.DOWN ? (LogicalPlan)plan.transformExpressionsDown(this::rule) : (LogicalPlan)plan.transformExpressionsUp(this::rule);
        }

        @Override
        protected LogicalPlan rule(LogicalPlan plan) {
            return plan;
        }

        @Override
        protected abstract Expression rule(Expression var1);
    }

    static abstract class OptimizerRule<SubPlan extends LogicalPlan>
    extends Rule<SubPlan, LogicalPlan> {
        private final TransformDirection direction;

        OptimizerRule() {
            this(TransformDirection.DOWN);
        }

        protected OptimizerRule(TransformDirection direction) {
            this.direction = direction;
        }

        @Override
        public final LogicalPlan apply(LogicalPlan plan) {
            return this.direction == TransformDirection.DOWN ? plan.transformDown(this::rule, this.typeToken()) : plan.transformUp(this::rule, this.typeToken());
        }

        @Override
        protected abstract LogicalPlan rule(SubPlan var1);
    }

    static class SetAsOptimized
    extends Rule<LogicalPlan, LogicalPlan> {
        SetAsOptimized() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan plan) {
            plan.forEachUp(this::rule);
            return plan;
        }

        @Override
        protected LogicalPlan rule(LogicalPlan plan) {
            if (!plan.optimized()) {
                plan.setOptimized();
            }
            return plan;
        }
    }

    static class SkipQueryIfFoldingProjection
    extends OptimizerRule<LogicalPlan> {
        SkipQueryIfFoldingProjection() {
        }

        @Override
        protected LogicalPlan rule(LogicalPlan plan) {
            Holder optimizedPlan = new Holder();
            plan.forEachDown(p -> {
                List<Object> values = this.extractConstants(p.projections());
                if (values.size() == p.projections().size() && !(p.child() instanceof EsRelation) && SkipQueryIfFoldingProjection.isNotQueryWithFromClauseAndFilterFoldedToFalse(p)) {
                    optimizedPlan.set(new LocalRelation(p.source(), new SingletonExecutable(p.output(), values.toArray())));
                }
            }, Project.class);
            if (optimizedPlan.get() != null) {
                return (LogicalPlan)optimizedPlan.get();
            }
            plan.forEachDown(a -> {
                List<Object> values = this.extractConstants(a.aggregates());
                if (values.size() == a.aggregates().size() && SkipQueryIfFoldingProjection.isNotQueryWithFromClauseAndFilterFoldedToFalse(a)) {
                    optimizedPlan.set(new LocalRelation(a.source(), new SingletonExecutable(a.output(), values.toArray())));
                }
            }, Aggregate.class);
            if (optimizedPlan.get() != null) {
                return (LogicalPlan)optimizedPlan.get();
            }
            return plan;
        }

        private List<Object> extractConstants(List<? extends NamedExpression> named) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (NamedExpression namedExpression : named) {
                if (namedExpression instanceof Alias) {
                    Alias a = (Alias)namedExpression;
                    if (a.child().foldable()) {
                        values.add(a.child().fold());
                        continue;
                    }
                    return values;
                }
                if (namedExpression.foldable()) {
                    values.add(namedExpression.fold());
                    continue;
                }
                return values;
            }
            return values;
        }

        private static boolean isNotQueryWithFromClauseAndFilterFoldedToFalse(UnaryPlan plan) {
            return !(plan.child() instanceof LocalRelation) || plan.child() instanceof LocalRelation && !(((LocalRelation)plan.child()).executable() instanceof EmptyExecutable);
        }
    }

    static class SkipQueryOnLimitZero
    extends OptimizerRule<Limit> {
        SkipQueryOnLimitZero() {
        }

        @Override
        protected LogicalPlan rule(Limit limit) {
            if (limit.limit() instanceof Literal && Integer.valueOf(0).equals(limit.limit().fold())) {
                return new LocalRelation(limit.source(), new EmptyExecutable(limit.output()));
            }
            return limit;
        }
    }

    static class CombineBinaryComparisons
    extends OptimizerExpressionRule {
        CombineBinaryComparisons() {
            super(TransformDirection.DOWN);
        }

        @Override
        protected Expression rule(Expression e) {
            if (e instanceof And) {
                return this.combine((And)e);
            }
            if (e instanceof Or) {
                return this.combine((Or)e);
            }
            return e;
        }

        private Expression combine(And and) {
            ArrayList<Range> ranges = new ArrayList<Range>();
            ArrayList<BinaryComparison> bcs = new ArrayList<BinaryComparison>();
            ArrayList<Expression> exps = new ArrayList<Expression>();
            boolean changed = false;
            for (Expression ex : Predicates.splitAnd(and)) {
                if (ex instanceof Range) {
                    Range r = (Range)ex;
                    if (CombineBinaryComparisons.findExistingRange(r, ranges, true)) {
                        changed = true;
                        continue;
                    }
                    ranges.add(r);
                    continue;
                }
                if (ex instanceof BinaryComparison && !(ex instanceof Equals)) {
                    BinaryComparison bc = (BinaryComparison)ex;
                    if (bc.right().foldable() && (this.findConjunctiveComparisonInRange(bc, ranges) || CombineBinaryComparisons.findExistingComparison(bc, bcs, true))) {
                        changed = true;
                        continue;
                    }
                    bcs.add(bc);
                    continue;
                }
                exps.add(ex);
            }
            for (int i = 0; i < bcs.size() - 1; ++i) {
                BinaryComparison main = (BinaryComparison)bcs.get(i);
                for (int j = i + 1; j < bcs.size(); ++j) {
                    BinaryComparison other = (BinaryComparison)bcs.get(j);
                    if (!main.left().semanticEquals(other.left())) continue;
                    if ((main instanceof GreaterThan || main instanceof GreaterThanOrEqual) && (other instanceof LessThan || other instanceof LessThanOrEqual)) {
                        bcs.remove(j);
                        bcs.remove(i);
                        ranges.add(new Range(and.source(), main.left(), main.right(), main instanceof GreaterThanOrEqual, other.right(), other instanceof LessThanOrEqual));
                        changed = true;
                        continue;
                    }
                    if (!(other instanceof GreaterThan) && !(other instanceof GreaterThanOrEqual) || !(main instanceof LessThan) && !(main instanceof LessThanOrEqual)) continue;
                    bcs.remove(j);
                    bcs.remove(i);
                    ranges.add(new Range(and.source(), main.left(), other.right(), other instanceof GreaterThanOrEqual, main.right(), main instanceof LessThanOrEqual));
                    changed = true;
                }
            }
            return changed ? Predicates.combineAnd(CollectionUtils.combine(new Collection[]{exps, bcs, ranges})) : and;
        }

        private Expression combine(Or or) {
            ArrayList<BinaryComparison> bcs = new ArrayList<BinaryComparison>();
            ArrayList<Range> ranges = new ArrayList<Range>();
            ArrayList<Expression> exps = new ArrayList<Expression>();
            boolean changed = false;
            for (Expression ex : Predicates.splitOr(or)) {
                if (ex instanceof Range) {
                    Range r = (Range)ex;
                    if (CombineBinaryComparisons.findExistingRange(r, ranges, false)) {
                        changed = true;
                        continue;
                    }
                    ranges.add(r);
                    continue;
                }
                if (ex instanceof BinaryComparison) {
                    BinaryComparison bc = (BinaryComparison)ex;
                    if (bc.right().foldable() && CombineBinaryComparisons.findExistingComparison(bc, bcs, false)) {
                        changed = true;
                        continue;
                    }
                    bcs.add(bc);
                    continue;
                }
                exps.add(ex);
            }
            return changed ? Predicates.combineOr(CollectionUtils.combine(new Collection[]{exps, bcs, ranges})) : or;
        }

        private static boolean findExistingRange(Range main, List<Range> ranges, boolean conjunctive) {
            if (!main.lower().foldable() && !main.upper().foldable()) {
                return false;
            }
            for (int i = 0; i < ranges.size(); ++i) {
                Integer comp;
                Range other = ranges.get(i);
                if (!main.value().semanticEquals(other.value())) continue;
                boolean compared = false;
                boolean lower = false;
                boolean upper = false;
                boolean lowerEq = false;
                boolean upperEq = false;
                if (main.lower().foldable() && other.lower().foldable()) {
                    compared = true;
                    comp = BinaryComparison.compare(main.lower().fold(), other.lower().fold());
                    if (comp != null) {
                        boolean bl = lowerEq = comp == 0 && main.includeLower() == other.includeLower();
                        if (conjunctive) {
                            lower = comp > 0 || comp == 0 && !main.includeLower() && other.includeLower();
                        } else {
                            boolean bl2 = lower = comp < 0 || comp == 0 && main.includeLower() && !other.includeLower() || lowerEq;
                        }
                    }
                }
                if (main.upper().foldable() && other.upper().foldable()) {
                    compared = true;
                    comp = BinaryComparison.compare(main.upper().fold(), other.upper().fold());
                    if (comp != null) {
                        boolean bl = upperEq = comp == 0 && main.includeUpper() == other.includeUpper();
                        if (conjunctive) {
                            upper = comp < 0 || comp == 0 && !main.includeUpper() && other.includeUpper();
                        } else {
                            boolean bl3 = upper = comp > 0 || comp == 0 && main.includeUpper() && !other.includeUpper() || upperEq;
                        }
                    }
                }
                if (conjunctive) {
                    if (lower || upper) {
                        ranges.remove(i);
                        ranges.add(i, new Range(main.source(), main.value(), lower ? main.lower() : other.lower(), lower ? main.includeLower() : other.includeLower(), upper ? main.upper() : other.upper(), upper ? main.includeUpper() : other.includeUpper()));
                    }
                    return compared;
                }
                if (lower && upper) {
                    ranges.remove(i);
                    ranges.add(i, new Range(main.source(), main.value(), lower ? main.lower() : other.lower(), lower ? main.includeLower() : other.includeLower(), upper ? main.upper() : other.upper(), upper ? main.includeUpper() : other.includeUpper()));
                    return true;
                }
                return !(!compared || lower && !lowerEq || upper && !upperEq);
            }
            return false;
        }

        private boolean findConjunctiveComparisonInRange(BinaryComparison main, List<Range> ranges) {
            Object value = main.right().fold();
            for (int i = 0; i < ranges.size(); ++i) {
                Integer comp;
                Range other = ranges.get(i);
                if (!main.left().semanticEquals(other.value())) continue;
                if (main instanceof GreaterThan || main instanceof GreaterThanOrEqual) {
                    Integer comp2;
                    if (other.lower().foldable() && (comp2 = BinaryComparison.compare(value, other.lower().fold())) != null) {
                        boolean lower;
                        boolean lowerEq = comp2 == 0 && other.includeLower() && main instanceof GreaterThan;
                        boolean bl = lower = comp2 > 0 || lowerEq;
                        if (lower) {
                            ranges.remove(i);
                            ranges.add(i, new Range(other.source(), other.value(), main.right(), lowerEq ? true : other.includeLower(), other.upper(), other.includeUpper()));
                        }
                        return true;
                    }
                } else if ((main instanceof LessThan || main instanceof LessThanOrEqual) && other.lower().foldable() && (comp = BinaryComparison.compare(value, other.lower().fold())) != null) {
                    boolean upper;
                    boolean upperEq = comp == 0 && other.includeUpper() && main instanceof LessThan;
                    boolean bl = upper = comp > 0 || upperEq;
                    if (upper) {
                        ranges.remove(i);
                        ranges.add(i, new Range(other.source(), other.value(), other.lower(), other.includeLower(), main.right(), upperEq ? true : other.includeUpper()));
                    }
                    return true;
                }
                return false;
            }
            return false;
        }

        private static boolean findExistingComparison(BinaryComparison main, List<BinaryComparison> bcs, boolean conjunctive) {
            Object value = main.right().fold();
            for (int i = 0; i < bcs.size(); ++i) {
                BinaryComparison other = bcs.get(i);
                if (!other.right().foldable()) continue;
                if ((other instanceof GreaterThan || other instanceof GreaterThanOrEqual) && (main instanceof GreaterThan || main instanceof GreaterThanOrEqual)) {
                    if (!main.left().semanticEquals(other.left())) continue;
                    Integer compare = BinaryComparison.compare(value, other.right().fold());
                    if (compare != null) {
                        if (conjunctive && (compare > 0 || compare == 0 && main instanceof GreaterThan && other instanceof GreaterThanOrEqual) || !conjunctive && (compare < 0 || compare == 0 && main instanceof GreaterThanOrEqual && other instanceof GreaterThan)) {
                            bcs.remove(i);
                            bcs.add(i, main);
                        }
                        return true;
                    }
                    return false;
                }
                if (!(other instanceof LessThan) && !(other instanceof LessThanOrEqual) || !(main instanceof LessThan) && !(main instanceof LessThanOrEqual) || !main.left().semanticEquals(other.left())) continue;
                Integer compare = BinaryComparison.compare(value, other.right().fold());
                if (compare != null) {
                    if (conjunctive && (compare < 0 || compare == 0 && main instanceof LessThan && other instanceof LessThanOrEqual) || !conjunctive && (compare > 0 || compare == 0 && main instanceof LessThanOrEqual && other instanceof LessThan)) {
                        bcs.remove(i);
                        bcs.add(i, main);
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
    }

    static class PropagateEquals
    extends OptimizerExpressionRule {
        PropagateEquals() {
            super(TransformDirection.DOWN);
        }

        @Override
        protected Expression rule(Expression e) {
            if (e instanceof And) {
                return this.propagate((And)e);
            }
            return e;
        }

        private Expression propagate(And and) {
            ArrayList<Range> ranges = new ArrayList<Range>();
            ArrayList<BinaryComparison> equals = new ArrayList<BinaryComparison>();
            ArrayList<Expression> exps = new ArrayList<Expression>();
            boolean changed = false;
            for (Expression ex : Predicates.splitAnd(and)) {
                if (ex instanceof Range) {
                    ranges.add((Range)ex);
                    continue;
                }
                if (ex instanceof Equals || ex instanceof NullEquals) {
                    BinaryComparison otherEq = (BinaryComparison)ex;
                    if (otherEq.right().foldable()) {
                        for (BinaryComparison eq : equals) {
                            Integer comp;
                            if (!eq.right().foldable() || !otherEq.left().semanticEquals(eq.left()) || !eq.right().foldable() || !otherEq.right().foldable() || (comp = BinaryComparison.compare(eq.right().fold(), otherEq.right().fold())) == null || comp == 0) continue;
                            return Literal.FALSE;
                        }
                    }
                    equals.add(otherEq);
                    continue;
                }
                exps.add(ex);
            }
            for (BinaryComparison eq : equals) {
                if (!eq.right().foldable()) continue;
                Object eqValue = eq.right().fold();
                for (int i = 0; i < ranges.size(); ++i) {
                    Integer compare;
                    Range range = (Range)ranges.get(i);
                    if (!range.value().semanticEquals(eq.left())) continue;
                    if (range.lower().foldable() && (compare = BinaryComparison.compare(range.lower().fold(), eqValue)) != null && (compare > 0 || compare == 0 && !range.includeLower())) {
                        return Literal.FALSE;
                    }
                    if (range.upper().foldable() && (compare = BinaryComparison.compare(range.upper().fold(), eqValue)) != null && (compare < 0 || compare == 0 && !range.includeUpper())) {
                        return Literal.FALSE;
                    }
                    ranges.remove(i);
                    changed = true;
                }
            }
            return changed ? Predicates.combineAnd(CollectionUtils.combine(new Collection[]{exps, equals, ranges})) : and;
        }
    }

    static class BooleanLiteralsOnTheRight
    extends OptimizerExpressionRule {
        BooleanLiteralsOnTheRight() {
            super(TransformDirection.UP);
        }

        @Override
        protected Expression rule(Expression e) {
            return e instanceof BinaryOperator ? this.literalToTheRight((BinaryOperator)e) : e;
        }

        private Expression literalToTheRight(BinaryOperator<?, ?, ?, ?> be) {
            return be.left() instanceof Literal && !(be.right() instanceof Literal) ? be.swapLeftAndRight() : be;
        }
    }

    static class BinaryComparisonSimplification
    extends OptimizerExpressionRule {
        BinaryComparisonSimplification() {
            super(TransformDirection.DOWN);
        }

        @Override
        protected Expression rule(Expression e) {
            return e instanceof BinaryComparison ? this.simplify((BinaryComparison)e) : e;
        }

        private Expression simplify(BinaryComparison bc) {
            Expression l = bc.left();
            Expression r = bc.right();
            if ((bc instanceof Equals || bc instanceof GreaterThanOrEqual || bc instanceof LessThanOrEqual) && l.nullable() == Nullability.FALSE && r.nullable() == Nullability.FALSE && l.semanticEquals(r)) {
                return Literal.TRUE;
            }
            if (bc instanceof NullEquals) {
                if (l.semanticEquals(r)) {
                    return Literal.TRUE;
                }
                if (Expressions.isNull(r)) {
                    return new IsNull(bc.source(), l);
                }
            }
            if ((bc instanceof NotEquals || bc instanceof GreaterThan || bc instanceof LessThan) && l.nullable() == Nullability.FALSE && r.nullable() == Nullability.FALSE && l.semanticEquals(r)) {
                return Literal.FALSE;
            }
            return bc;
        }
    }

    static class BooleanSimplification
    extends OptimizerExpressionRule {
        BooleanSimplification() {
            super(TransformDirection.UP);
        }

        @Override
        protected Expression rule(Expression e) {
            if (e instanceof And || e instanceof Or) {
                return this.simplifyAndOr((BinaryPredicate)e);
            }
            if (e instanceof Not) {
                return this.simplifyNot((Not)e);
            }
            return e;
        }

        private Expression simplifyAndOr(BinaryPredicate<?, ?, ?, ?> bc) {
            Expression l = bc.left();
            Expression r = bc.right();
            if (bc instanceof And) {
                List<Expression> rightSplit;
                if (Literal.TRUE.equals(l)) {
                    return r;
                }
                if (Literal.TRUE.equals(r)) {
                    return l;
                }
                if (Literal.FALSE.equals(l) || Literal.FALSE.equals(r)) {
                    return Literal.FALSE;
                }
                if (l.semanticEquals(r)) {
                    return l;
                }
                List<Expression> leftSplit = Predicates.splitOr(l);
                List<Expression> common = Predicates.inCommon(leftSplit, rightSplit = Predicates.splitOr(r));
                if (common.isEmpty()) {
                    return bc;
                }
                List<Expression> lDiff = Predicates.subtract(leftSplit, common);
                List<Expression> rDiff = Predicates.subtract(rightSplit, common);
                if (lDiff.isEmpty() || rDiff.isEmpty()) {
                    return Predicates.combineOr(common);
                }
                Expression combineLeft = Predicates.combineOr(lDiff);
                Expression combineRight = Predicates.combineOr(rDiff);
                return Predicates.combineOr(CollectionUtils.combine(common, new And(combineLeft.source(), combineLeft, combineRight)));
            }
            if (bc instanceof Or) {
                List<Expression> rightSplit;
                if (Literal.TRUE.equals(l) || Literal.TRUE.equals(r)) {
                    return Literal.TRUE;
                }
                if (Literal.FALSE.equals(l)) {
                    return r;
                }
                if (Literal.FALSE.equals(r)) {
                    return l;
                }
                if (l.semanticEquals(r)) {
                    return l;
                }
                List<Expression> leftSplit = Predicates.splitAnd(l);
                List<Expression> common = Predicates.inCommon(leftSplit, rightSplit = Predicates.splitAnd(r));
                if (common.isEmpty()) {
                    return bc;
                }
                List<Expression> lDiff = Predicates.subtract(leftSplit, common);
                List<Expression> rDiff = Predicates.subtract(rightSplit, common);
                if (lDiff.isEmpty() || rDiff.isEmpty()) {
                    return Predicates.combineAnd(common);
                }
                Expression combineLeft = Predicates.combineAnd(lDiff);
                Expression combineRight = Predicates.combineAnd(rDiff);
                return Predicates.combineAnd(CollectionUtils.combine(common, new Or(combineLeft.source(), combineLeft, combineRight)));
            }
            return bc;
        }

        private Expression simplifyNot(Not n) {
            Expression c = n.field();
            if (Literal.TRUE.semanticEquals(c)) {
                return Literal.FALSE;
            }
            if (Literal.FALSE.semanticEquals(c)) {
                return Literal.TRUE;
            }
            if (c instanceof Negatable) {
                return ((Negatable)((Object)c)).negate();
            }
            if (c instanceof Not) {
                return ((Not)c).field();
            }
            return n;
        }
    }

    static class SimplifyCase
    extends OptimizerExpressionRule {
        SimplifyCase() {
            super(TransformDirection.DOWN);
        }

        @Override
        protected Expression rule(Expression e) {
            if (e instanceof Case) {
                Case c = (Case)e;
                ArrayList<IfConditional> newConditions = new ArrayList<IfConditional>();
                for (IfConditional conditional : c.conditions()) {
                    if (conditional.condition().foldable()) {
                        Boolean res = (Boolean)conditional.condition().fold();
                        if (res != Boolean.TRUE) continue;
                        newConditions.add(conditional);
                        break;
                    }
                    newConditions.add(conditional);
                }
                if (newConditions.size() < c.children().size()) {
                    return c.replaceChildren((List)CollectionUtils.combine(newConditions, c.elseResult()));
                }
            }
            return e;
        }
    }

    static class SimplifyConditional
    extends OptimizerExpressionRule {
        SimplifyConditional() {
            super(TransformDirection.DOWN);
        }

        @Override
        protected Expression rule(Expression e) {
            if (e instanceof ArbitraryConditionalFunction) {
                ArbitraryConditionalFunction c = (ArbitraryConditionalFunction)e;
                ArrayList<Expression> newChildren = new ArrayList<Expression>();
                for (Expression child : c.children()) {
                    if (Expressions.isNull(child)) continue;
                    newChildren.add(child);
                    if (!(e instanceof Coalesce) || !child.foldable()) continue;
                    break;
                }
                if (newChildren.size() < c.children().size()) {
                    return (Expression)c.replaceChildren(newChildren);
                }
            }
            return e;
        }
    }

    static class ConstantFolding
    extends OptimizerExpressionRule {
        ConstantFolding() {
            super(TransformDirection.DOWN);
        }

        @Override
        protected Expression rule(Expression e) {
            return e.foldable() ? Literal.of(e) : e;
        }
    }

    static class FoldNull
    extends OptimizerExpressionRule {
        FoldNull() {
            super(TransformDirection.UP);
        }

        @Override
        protected Expression rule(Expression e) {
            if (e instanceof IsNotNull) {
                if (((IsNotNull)e).field().nullable() == Nullability.FALSE) {
                    return new Literal(e.source(), Expressions.name(e), Boolean.TRUE, DataType.BOOLEAN);
                }
            } else if (e instanceof IsNull) {
                if (((IsNull)e).field().nullable() == Nullability.FALSE) {
                    return new Literal(e.source(), Expressions.name(e), Boolean.FALSE, DataType.BOOLEAN);
                }
            } else if (e instanceof In) {
                In in = (In)e;
                if (Expressions.isNull(in.value())) {
                    return Literal.of(in, null);
                }
            } else if (!(e instanceof Alias) && e.nullable() == Nullability.TRUE && Expressions.anyMatch(e.children(), Expressions::isNull)) {
                return Literal.of(e, null);
            }
            return e;
        }
    }

    static class ReplaceFoldableAttributes
    extends Rule<LogicalPlan, LogicalPlan> {
        ReplaceFoldableAttributes() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan plan) {
            return this.rule(plan);
        }

        @Override
        protected LogicalPlan rule(LogicalPlan plan) {
            LinkedHashMap aliases = new LinkedHashMap();
            ArrayList attrs = new ArrayList();
            plan.forEachDown(p -> {
                for (NamedExpression namedExpression : p.projections()) {
                    if (!(namedExpression instanceof Alias) || !((Alias)namedExpression).child().foldable()) continue;
                    Attribute attr = namedExpression.toAttribute();
                    attrs.add(attr);
                    aliases.put(attr, (Alias)namedExpression);
                }
            }, Project.class);
            if (attrs.isEmpty()) {
                return plan;
            }
            Holder<Boolean> stop = new Holder<Boolean>(Boolean.FALSE);
            plan = plan.transformUp(p -> {
                if (stop.get() == Boolean.FALSE && this.canPropagateFoldable((LogicalPlan)p)) {
                    return (LogicalPlan)p.transformExpressionsDown(e -> {
                        if (e instanceof Attribute && attrs.contains(e)) {
                            Alias as = (Alias)aliases.get(e);
                            if (as == null) {
                                throw new SqlIllegalArgumentException("unsupported");
                            }
                            return as;
                        }
                        return e;
                    });
                }
                if (p.children().size() > 1) {
                    stop.set(Boolean.TRUE);
                }
                return p;
            });
            return Analyzer.CleanAliases.INSTANCE.apply(plan);
        }

        private boolean canPropagateFoldable(LogicalPlan p) {
            return p instanceof Project || p instanceof Filter || p instanceof SubQueryAlias || p instanceof Aggregate || p instanceof Limit || p instanceof OrderBy;
        }
    }

    static class CombineProjections
    extends OptimizerRule<Project> {
        CombineProjections() {
            super(TransformDirection.UP);
        }

        @Override
        protected LogicalPlan rule(Project project) {
            LogicalPlan child = project.child();
            if (child instanceof Project) {
                Project p = (Project)child;
                return new Project(p.source(), p.child(), this.combineProjections(project.projections(), p.projections()));
            }
            if (child instanceof Aggregate) {
                Aggregate a = (Aggregate)child;
                return new Aggregate(a.source(), a.child(), a.groupings(), this.combineProjections(project.projections(), a.aggregates()));
            }
            if (child instanceof Pivot) {
                Pivot p = (Pivot)child;
                if (project.outputSet().subsetOf(p.groupingSet())) {
                    return new Aggregate(p.source(), p.child(), new ArrayList<Expression>(project.projections()), project.projections());
                }
            }
            return project;
        }

        private List<NamedExpression> combineProjections(List<? extends NamedExpression> upper, List<? extends NamedExpression> lower) {
            LinkedHashMap<Attribute, NamedExpression> map = new LinkedHashMap<Attribute, NamedExpression>();
            for (NamedExpression namedExpression : lower) {
                if (namedExpression instanceof Attribute) continue;
                map.put(namedExpression.toAttribute(), namedExpression);
            }
            AttributeMap aliases = new AttributeMap(map);
            ArrayList<NamedExpression> arrayList = new ArrayList<NamedExpression>();
            for (NamedExpression namedExpression : upper) {
                NamedExpression replacedExp = (NamedExpression)namedExpression.transformUp(a -> {
                    NamedExpression as = (NamedExpression)aliases.get(a);
                    return as != null ? as : a;
                }, Attribute.class);
                arrayList.add((NamedExpression)Analyzer.CleanAliases.trimNonTopLevelAliases(replacedExp));
            }
            return arrayList;
        }
    }

    static class PruneDuplicateFunctions
    extends Rule<LogicalPlan, LogicalPlan> {
        PruneDuplicateFunctions() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan p) {
            ArrayList seen = new ArrayList();
            return (LogicalPlan)p.transformExpressionsUp(e -> this.rule((Expression)e, seen));
        }

        @Override
        protected LogicalPlan rule(LogicalPlan e) {
            return e;
        }

        protected Expression rule(Expression exp, List<Function> seen) {
            Expression e = exp;
            if (e instanceof Function) {
                Function f = (Function)e;
                for (Function seenFunction : seen) {
                    if (seenFunction == f || !f.functionEquals(seenFunction)) continue;
                    return seenFunction;
                }
                seen.add(f);
            }
            return exp;
        }
    }

    static class PruneCast
    extends Rule<LogicalPlan, LogicalPlan> {
        PruneCast() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan plan) {
            return this.rule(plan);
        }

        @Override
        protected LogicalPlan rule(LogicalPlan plan) {
            LinkedHashMap replacedCast = new LinkedHashMap();
            LogicalPlan transformed = (LogicalPlan)plan.transformExpressionsUp(e -> {
                Cast c;
                if (e instanceof Cast && (c = (Cast)e).from() == c.to()) {
                    Expression argument = c.field();
                    Alias as = new Alias(c.source(), c.sourceText(), argument);
                    replacedCast.put(c.toAttribute(), as.toAttribute());
                    return as;
                }
                return e;
            });
            if (!replacedCast.isEmpty()) {
                return transformed.transformUp(p -> {
                    ArrayList<Attribute> newProjections = new ArrayList<Attribute>();
                    boolean changed = false;
                    for (NamedExpression namedExpression : p.projections()) {
                        Attribute found = (Attribute)replacedCast.get(namedExpression.toAttribute());
                        if (found != null) {
                            changed = true;
                            newProjections.add(found);
                            continue;
                        }
                        newProjections.add(namedExpression.toAttribute());
                    }
                    return changed ? new Project(p.source(), p.child(), newProjections) : p;
                }, Project.class);
            }
            return transformed;
        }
    }

    static class CombineLimits
    extends OptimizerRule<Limit> {
        CombineLimits() {
        }

        @Override
        protected LogicalPlan rule(Limit limit) {
            if (limit.child() instanceof Limit) {
                throw new UnsupportedOperationException("not implemented yet");
            }
            throw new UnsupportedOperationException("not implemented yet");
        }
    }

    static class SortAggregateOnOrderBy
    extends OptimizerRule<OrderBy> {
        SortAggregateOnOrderBy() {
        }

        @Override
        protected LogicalPlan rule(OrderBy ob) {
            List<Order> order = ob.order();
            LinkedList<Order> nonConstant = new LinkedList<Order>();
            for (Order o : order) {
                if (o.child().foldable()) continue;
                nonConstant.add(0, o);
            }
            Holder<Boolean> foundAggregate = new Holder<Boolean>(Boolean.FALSE);
            return ob.transformDown(a -> {
                if (foundAggregate.get() == Boolean.TRUE) {
                    return a;
                }
                foundAggregate.set(Boolean.TRUE);
                LinkedList<Expression> groupings = new LinkedList<Expression>(a.groupings());
                for (Order o : nonConstant) {
                    Expression fieldToOrder = o.child();
                    for (Expression group : a.groupings()) {
                        Holder<Boolean> isMatching = new Holder<Boolean>(Boolean.FALSE);
                        if (Expressions.equalsAsAttribute(fieldToOrder, group)) {
                            isMatching.set(Boolean.TRUE);
                        } else {
                            a.aggregates().forEach(alias -> {
                                Expression child;
                                if (alias instanceof Alias && (Expressions.equalsAsAttribute(child = ((Alias)alias).child(), group) && (Expressions.equalsAsAttribute(alias, fieldToOrder) || Expressions.equalsAsAttribute(child, fieldToOrder)) || Expressions.equalsAsAttribute(alias, group) && (Expressions.equalsAsAttribute(alias, fieldToOrder) || Expressions.equalsAsAttribute(child, fieldToOrder)))) {
                                    isMatching.set(Boolean.TRUE);
                                }
                            });
                        }
                        if (!isMatching.get().booleanValue()) continue;
                        groupings.remove(group);
                        groupings.add(0, group);
                    }
                }
                if (!groupings.equals(a.groupings())) {
                    return new Aggregate(a.source(), a.child(), groupings, a.aggregates());
                }
                return a;
            }, Aggregate.class);
        }
    }

    static class PruneOrderBy
    extends OptimizerRule<OrderBy> {
        PruneOrderBy() {
        }

        @Override
        protected LogicalPlan rule(OrderBy ob) {
            Holder<Boolean> foundAggregate = new Holder<Boolean>(Boolean.FALSE);
            Holder<Boolean> foundImplicitGroupBy = new Holder<Boolean>(Boolean.FALSE);
            ob.forEachDown(a -> {
                if (foundAggregate.get() == Boolean.TRUE) {
                    return;
                }
                foundAggregate.set(Boolean.TRUE);
                if (a.groupings().isEmpty()) {
                    foundImplicitGroupBy.set(Boolean.TRUE);
                }
            }, Aggregate.class);
            if (foundImplicitGroupBy.get() == Boolean.TRUE) {
                return ob.child();
            }
            return ob;
        }
    }

    static class PruneOrderByNestedFields
    extends OptimizerRule<Project> {
        PruneOrderByNestedFields() {
        }

        private void findNested(Expression exp, Map<String, Function> functions, Consumer<FieldAttribute> onFind) {
            exp.forEachUp(e -> {
                FieldAttribute fa;
                FunctionAttribute sfa;
                Function f;
                if (e instanceof FunctionAttribute && (f = (Function)functions.get((sfa = (FunctionAttribute)e).functionId())) != null) {
                    this.findNested(f, functions, onFind);
                }
                if (e instanceof FieldAttribute && (fa = (FieldAttribute)e).isNested()) {
                    onFind.accept(fa);
                }
            });
        }

        @Override
        protected LogicalPlan rule(Project project) {
            if (project.child() instanceof OrderBy) {
                OrderBy ob = (OrderBy)project.child();
                Map<String, Function> functions = Functions.collectFunctions(project);
                LinkedHashMap nestedOrders = new LinkedHashMap();
                for (Order order : ob.order()) {
                    this.findNested(order.child(), functions, fa -> nestedOrders.put(fa.nestedParent().name(), order));
                }
                if (nestedOrders.isEmpty()) {
                    return project;
                }
                ArrayList nestedTopFields = new ArrayList();
                for (NamedExpression namedExpression : project.projections()) {
                    this.findNested(namedExpression, functions, fa -> nestedTopFields.add(fa.nestedParent().name()));
                }
                ArrayList<Order> arrayList = new ArrayList<Order>(ob.order());
                if (nestedTopFields.isEmpty()) {
                    arrayList.removeAll(nestedOrders.values());
                } else {
                    for (Map.Entry entry : nestedOrders.entrySet()) {
                        String parent = (String)entry.getKey();
                        boolean shouldKeep = false;
                        for (String topParent : nestedTopFields) {
                            if (!topParent.startsWith(parent)) continue;
                            shouldKeep = true;
                            break;
                        }
                        if (shouldKeep) continue;
                        arrayList.remove(entry.getValue());
                    }
                }
                if (arrayList.isEmpty()) {
                    return new Project(project.source(), ob.child(), project.projections());
                }
                if (arrayList.size() != ob.order().size()) {
                    OrderBy orderBy = new OrderBy(ob.source(), ob.child(), arrayList);
                    return new Project(project.source(), orderBy, project.projections());
                }
            }
            return project;
        }
    }

    static class ReplaceAliasesInHaving
    extends OptimizerRule<Filter> {
        ReplaceAliasesInHaving() {
        }

        @Override
        protected LogicalPlan rule(Filter filter) {
            Expression cond;
            Expression newCondition;
            if (filter.child() instanceof Aggregate && (newCondition = (cond = filter.condition()).transformDown(a -> a, AggregateFunctionAttribute.class)) != cond) {
                return new Filter(filter.source(), filter.child(), newCondition);
            }
            return filter;
        }
    }

    static class PruneFilters
    extends OptimizerRule<Filter> {
        PruneFilters() {
        }

        @Override
        protected LogicalPlan rule(Filter filter) {
            Expression condition = filter.condition().transformUp(PruneFilters::foldBinaryLogic);
            if (condition instanceof Literal) {
                if (Literal.TRUE.equals(condition)) {
                    return filter.child();
                }
                if (Literal.FALSE.equals(condition) || Expressions.isNull(condition)) {
                    return new LocalRelation(filter.source(), new EmptyExecutable(filter.output()));
                }
            }
            if (!condition.equals(filter.condition())) {
                return new Filter(filter.source(), filter.child(), condition);
            }
            return filter;
        }

        private static Expression foldBinaryLogic(Expression expression) {
            And and;
            if (expression instanceof Or) {
                Or or = (Or)expression;
                boolean nullLeft = Expressions.isNull(or.left());
                boolean nullRight = Expressions.isNull(or.right());
                if (nullLeft && nullRight) {
                    return Literal.NULL;
                }
                if (nullLeft) {
                    return or.right();
                }
                if (nullRight) {
                    return or.left();
                }
            }
            if (expression instanceof And && (Expressions.isNull((and = (And)expression).left()) || Expressions.isNull(and.right()))) {
                return Literal.NULL;
            }
            return expression;
        }
    }

    static class ReplaceMinMaxWithTopHits
    extends OptimizerRule<LogicalPlan> {
        ReplaceMinMaxWithTopHits() {
        }

        @Override
        protected LogicalPlan rule(LogicalPlan plan) {
            HashMap seen = new HashMap();
            return (LogicalPlan)plan.transformExpressionsDown(e -> {
                Max max;
                Min min;
                if (e instanceof Min && (min = (Min)e).field().dataType().isString()) {
                    TopHits topHits = (TopHits)seen.get(min.id());
                    if (topHits != null) {
                        return topHits;
                    }
                    topHits = new First(min.source(), min.field(), null);
                    seen.put(min.id(), topHits);
                    return topHits;
                }
                if (e instanceof Max && (max = (Max)e).field().dataType().isString()) {
                    TopHits topHits = (TopHits)seen.get(max.id());
                    if (topHits != null) {
                        return topHits;
                    }
                    topHits = new Last(max.source(), max.field(), null);
                    seen.put(max.id(), topHits);
                    return topHits;
                }
                return e;
            });
        }
    }

    static class ReplaceAggsWithPercentileRanks
    extends Rule<LogicalPlan, LogicalPlan> {
        ReplaceAggsWithPercentileRanks() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan p) {
            LinkedHashMap<Expression, Set> valuesPerField = new LinkedHashMap<Expression, Set>();
            p.forEachExpressionsUp(e -> this.count((Expression)e, (Map<Expression, Set<Expression>>)valuesPerField));
            LinkedHashMap ranksPerField = new LinkedHashMap();
            valuesPerField.forEach((k, v) -> ranksPerField.put(k, new PercentileRanks(((Expression)v.iterator().next()).source(), (Expression)k, (List<Expression>)new ArrayList<Expression>((Collection<Expression>)v))));
            LinkedHashMap promotedFunctionIds = new LinkedHashMap();
            p = (LogicalPlan)p.transformExpressionsUp(e -> this.rule((Expression)e, ranksPerField, promotedFunctionIds));
            return (LogicalPlan)p.transformExpressionsDown(e -> ReplaceAggsWithStats.updateAggFunctionAttrs(e, promotedFunctionIds));
        }

        private void count(Expression e, Map<Expression, Set<Expression>> ranksPerField) {
            if (e instanceof PercentileRank) {
                PercentileRank p = (PercentileRank)e;
                Expression field = p.field();
                Set<Expression> percentiles = ranksPerField.get(field);
                if (percentiles == null) {
                    percentiles = new LinkedHashSet<Expression>();
                    ranksPerField.put(field, percentiles);
                }
                percentiles.add(p.value());
            }
        }

        protected Expression rule(Expression e, Map<Expression, PercentileRanks> ranksPerField, Map<String, AggregateFunctionAttribute> promotedIds) {
            if (e instanceof PercentileRank) {
                PercentileRank p = (PercentileRank)e;
                PercentileRanks ranks = ranksPerField.get(p.field());
                InnerAggregate ia = new InnerAggregate(p, ranks);
                promotedIds.putIfAbsent(p.functionId(), ia.toAttribute());
                return ia;
            }
            return e;
        }

        @Override
        protected LogicalPlan rule(LogicalPlan e) {
            return e;
        }
    }

    static class ReplaceAggsWithPercentiles
    extends Rule<LogicalPlan, LogicalPlan> {
        ReplaceAggsWithPercentiles() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan p) {
            LinkedHashMap<Expression, Set> percentsPerField = new LinkedHashMap<Expression, Set>();
            p.forEachExpressionsUp(e -> this.count((Expression)e, (Map<Expression, Set<Expression>>)percentsPerField));
            LinkedHashMap percentilesPerField = new LinkedHashMap();
            percentsPerField.forEach((k, v) -> percentilesPerField.put(k, new Percentiles(((Expression)v.iterator().next()).source(), (Expression)k, (List<Expression>)new ArrayList<Expression>((Collection<Expression>)v))));
            LinkedHashMap promotedFunctionIds = new LinkedHashMap();
            p = (LogicalPlan)p.transformExpressionsUp(e -> this.rule((Expression)e, percentilesPerField, promotedFunctionIds));
            return (LogicalPlan)p.transformExpressionsDown(e -> ReplaceAggsWithStats.updateAggFunctionAttrs(e, promotedFunctionIds));
        }

        private void count(Expression e, Map<Expression, Set<Expression>> percentsPerField) {
            if (e instanceof Percentile) {
                Percentile p = (Percentile)e;
                Expression field = p.field();
                Set<Expression> percentiles = percentsPerField.get(field);
                if (percentiles == null) {
                    percentiles = new LinkedHashSet<Expression>();
                    percentsPerField.put(field, percentiles);
                }
                percentiles.add(p.percent());
            }
        }

        protected Expression rule(Expression e, Map<Expression, Percentiles> percentilesPerField, Map<String, AggregateFunctionAttribute> promotedIds) {
            if (e instanceof Percentile) {
                Percentile p = (Percentile)e;
                Percentiles percentiles = percentilesPerField.get(p.field());
                InnerAggregate ia = new InnerAggregate(p, percentiles);
                promotedIds.putIfAbsent(p.functionId(), ia.toAttribute());
                return ia;
            }
            return e;
        }

        @Override
        protected LogicalPlan rule(LogicalPlan e) {
            return e;
        }
    }

    static class PromoteStatsToExtendedStats
    extends Rule<LogicalPlan, LogicalPlan> {
        PromoteStatsToExtendedStats() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan p) {
            LinkedHashMap seen = new LinkedHashMap();
            p.forEachExpressionsUp(e -> this.count((Expression)e, seen));
            return (LogicalPlan)p.transformExpressionsUp(e -> this.promote((Expression)e, seen));
        }

        @Override
        protected LogicalPlan rule(LogicalPlan e) {
            return e;
        }

        private void count(Expression e, Map<Expression, ExtendedStats> seen) {
            InnerAggregate ia;
            if (e instanceof InnerAggregate && (ia = (InnerAggregate)e).outer() instanceof ExtendedStats) {
                ExtendedStats extStats = (ExtendedStats)ia.outer();
                seen.putIfAbsent(extStats.field(), extStats);
            }
        }

        protected Expression promote(Expression e, Map<Expression, ExtendedStats> seen) {
            Stats stats;
            ExtendedStats ext;
            InnerAggregate ia;
            if (e instanceof InnerAggregate && (ia = (InnerAggregate)e).outer() instanceof Stats && (ext = seen.get((stats = (Stats)ia.outer()).field())) != null && stats.field().equals(ext.field())) {
                return new InnerAggregate(ia.inner(), ext);
            }
            return e;
        }
    }

    static class ReplaceAggsWithStats
    extends Rule<LogicalPlan, LogicalPlan> {
        ReplaceAggsWithStats() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan p) {
            LinkedHashMap potentialPromotions = new LinkedHashMap();
            p.forEachExpressionsUp(e -> this.collect((Expression)e, potentialPromotions));
            if (potentialPromotions.isEmpty()) {
                return p;
            }
            LinkedHashMap<String, AggregateFunctionAttribute> promotedFunctionIds = new LinkedHashMap<String, AggregateFunctionAttribute>();
            p = (LogicalPlan)p.transformExpressionsUp(e -> ReplaceAggsWithStats.promote(e, potentialPromotions, promotedFunctionIds));
            return ReplaceAggsWithStats.updateAggAttributes(p, promotedFunctionIds);
        }

        @Override
        protected LogicalPlan rule(LogicalPlan e) {
            return e;
        }

        private Expression collect(Expression e, Map<Expression, Match> seen) {
            if (Stats.isTypeCompatible(e)) {
                AggregateFunction f = (AggregateFunction)e;
                Expression argument = f.field();
                Match match = seen.get(argument);
                if (match == null) {
                    match = new Match(new Stats(new Source(f.sourceLocation(), "STATS(" + Expressions.name(argument) + ")"), argument));
                    seen.put(argument, match);
                }
                match.add(f.getClass());
            }
            return e;
        }

        private static Expression promote(Expression e, Map<Expression, Match> seen, Map<String, AggregateFunctionAttribute> attrs) {
            AggregateFunction f;
            Expression argument;
            Match match;
            if (Stats.isTypeCompatible(e) && (match = seen.get(argument = (f = (AggregateFunction)e).field())) != null) {
                AggregateFunction inner = match.maybePromote(f);
                if (inner != f) {
                    attrs.putIfAbsent(f.functionId(), inner.toAttribute());
                }
                return inner;
            }
            return e;
        }

        static LogicalPlan updateAggAttributes(LogicalPlan p, Map<String, AggregateFunctionAttribute> promotedFunctionIds) {
            p = (LogicalPlan)p.transformExpressionsUp(e -> ReplaceAggsWithStats.updateAggFunctionAttrs(e, promotedFunctionIds));
            LinkedHashSet<String> newAggIds = new LinkedHashSet<String>(promotedFunctionIds.size());
            for (AggregateFunctionAttribute afa : promotedFunctionIds.values()) {
                newAggIds.add(afa.functionId());
            }
            LinkedHashMap updatedScalarAttrs = new LinkedHashMap();
            LinkedHashMap updatedScalarAliases = new LinkedHashMap();
            p = (LogicalPlan)p.transformExpressionsUp(e -> {
                if (e instanceof ScalarFunctionAttribute) {
                    ScalarFunctionAttribute sfa = (ScalarFunctionAttribute)e;
                    sfa = updatedScalarAttrs.getOrDefault(sfa.functionId(), sfa);
                    sfa = updatedScalarAliases.getOrDefault(sfa.id(), sfa);
                    return sfa;
                }
                if (e instanceof Alias) {
                    ScalarFunctionAttribute sfa;
                    Attribute att = Expressions.attribute(e);
                    if (att instanceof ScalarFunctionAttribute && updatedScalarAttrs.containsKey((sfa = (ScalarFunctionAttribute)att).functionId())) {
                        updatedScalarAliases.put(sfa.id(), sfa);
                    }
                } else if (e instanceof ScalarFunction && !Expressions.anyMatch(e.children(), c -> c instanceof FullTextPredicate)) {
                    ScalarFunction sf = (ScalarFunction)e;
                    if (!newAggIds.isEmpty() && !updatedScalarAttrs.containsKey(sf.functionId()) && e.anyMatch(c -> {
                        Attribute a = Expressions.attribute(c);
                        if (a instanceof FunctionAttribute) {
                            return newAggIds.contains(((FunctionAttribute)a).functionId());
                        }
                        return false;
                    })) {
                        updatedScalarAttrs.put(sf.functionId(), sf.toAttribute());
                    }
                }
                return e;
            });
            return p;
        }

        private static Expression updateAggFunctionAttrs(Expression e, Map<String, AggregateFunctionAttribute> promotedIds) {
            AggregateFunctionAttribute ae;
            AggregateFunctionAttribute promoted;
            if (e instanceof AggregateFunctionAttribute && (promoted = promotedIds.get((ae = (AggregateFunctionAttribute)e).functionId())) != null) {
                return ae.withFunctionId(promoted.functionId(), promoted.propertyPath());
            }
            return e;
        }

        private static class Match {
            final Stats stats;
            private final Set<Class<? extends AggregateFunction>> functionTypes = new LinkedHashSet<Class<? extends AggregateFunction>>();
            private Map<Class<? extends AggregateFunction>, InnerAggregate> innerAggs = null;

            Match(Stats stats) {
                this.stats = stats;
            }

            public String toString() {
                return this.stats.toString();
            }

            public void add(Class<? extends AggregateFunction> aggType) {
                this.functionTypes.add(aggType);
            }

            public AggregateFunction maybePromote(AggregateFunction agg) {
                if (this.functionTypes.size() > 1) {
                    if (this.innerAggs == null) {
                        this.innerAggs = new LinkedHashMap<Class<? extends AggregateFunction>, InnerAggregate>();
                    }
                    return this.innerAggs.computeIfAbsent(agg.getClass(), k -> new InnerAggregate(agg, this.stats));
                }
                return agg;
            }
        }
    }

    static class ReplaceAggsWithExtendedStats
    extends Rule<LogicalPlan, LogicalPlan> {
        ReplaceAggsWithExtendedStats() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan p) {
            LinkedHashMap<String, AggregateFunctionAttribute> promotedFunctionIds = new LinkedHashMap<String, AggregateFunctionAttribute>();
            LinkedHashMap seen = new LinkedHashMap();
            p = (LogicalPlan)p.transformExpressionsUp(e -> this.rule((Expression)e, seen, (Map<String, AggregateFunctionAttribute>)promotedFunctionIds));
            if (seen.isEmpty()) {
                return p;
            }
            return ReplaceAggsWithStats.updateAggAttributes(p, promotedFunctionIds);
        }

        @Override
        protected LogicalPlan rule(LogicalPlan e) {
            return e;
        }

        protected Expression rule(Expression e, Map<Expression, ExtendedStats> seen, Map<String, AggregateFunctionAttribute> promotedIds) {
            if (e instanceof ExtendedStatsEnclosed) {
                AggregateFunction f = (AggregateFunction)e;
                Expression argument = f.field();
                ExtendedStats extendedStats = seen.get(argument);
                if (extendedStats == null) {
                    extendedStats = new ExtendedStats(f.source(), argument);
                    seen.put(argument, extendedStats);
                }
                InnerAggregate ia = new InnerAggregate(f, extendedStats);
                promotedIds.putIfAbsent(f.functionId(), ia.toAttribute());
                return ia;
            }
            return e;
        }
    }

    static class ReplaceAggsWithMatrixStats
    extends Rule<LogicalPlan, LogicalPlan> {
        ReplaceAggsWithMatrixStats() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan p) {
            LinkedHashMap seen = new LinkedHashMap();
            LinkedHashMap<String, AggregateFunctionAttribute> promotedFunctionIds = new LinkedHashMap<String, AggregateFunctionAttribute>();
            p = (LogicalPlan)p.transformExpressionsUp(e -> this.rule((Expression)e, seen, (Map<String, AggregateFunctionAttribute>)promotedFunctionIds));
            if (seen.isEmpty()) {
                return p;
            }
            return ReplaceAggsWithStats.updateAggAttributes(p, promotedFunctionIds);
        }

        @Override
        protected LogicalPlan rule(LogicalPlan e) {
            return e;
        }

        protected Expression rule(Expression e, Map<Expression, MatrixStats> seen, Map<String, AggregateFunctionAttribute> promotedIds) {
            if (e instanceof MatrixStatsEnclosed) {
                AggregateFunction f = (AggregateFunction)e;
                Expression argument = f.field();
                MatrixStats matrixStats = seen.get(argument);
                if (matrixStats == null) {
                    matrixStats = new MatrixStats(f.source(), argument);
                    seen.put(argument, matrixStats);
                }
                InnerAggregate ia = new InnerAggregate(f.source(), f, matrixStats, argument);
                promotedIds.putIfAbsent(f.functionId(), ia.toAttribute());
                return ia;
            }
            return e;
        }
    }

    static class ReplaceDuplicateAggsWithReferences
    extends OptimizerRule<Aggregate> {
        ReplaceDuplicateAggsWithReferences() {
        }

        @Override
        protected LogicalPlan rule(Aggregate agg) {
            List<? extends NamedExpression> aggs = agg.aggregates();
            HashMap<Expression, NamedExpression> unique = new HashMap<Expression, NamedExpression>();
            HashMap<NamedExpression, Expression> reverse = new HashMap<NamedExpression, Expression>();
            for (NamedExpression namedExpression : aggs) {
                if (namedExpression instanceof Alias) {
                    Alias alias = (Alias)namedExpression;
                    unique.putIfAbsent(alias.child(), alias);
                    reverse.putIfAbsent(namedExpression, alias.child());
                    continue;
                }
                unique.putIfAbsent(namedExpression.canonical(), namedExpression);
                reverse.putIfAbsent(namedExpression, namedExpression.canonical());
            }
            if (unique.size() != aggs.size()) {
                ArrayList<NamedExpression> newAggs = new ArrayList<NamedExpression>(aggs.size());
                for (NamedExpression namedExpression : aggs) {
                    newAggs.add((NamedExpression)unique.get(reverse.get(namedExpression)));
                }
                return new Aggregate(agg.source(), agg.child(), agg.groupings(), newAggs);
            }
            return agg;
        }
    }

    static class PruneDuplicatesInGroupBy
    extends OptimizerRule<Aggregate> {
        PruneDuplicatesInGroupBy() {
        }

        @Override
        protected LogicalPlan rule(Aggregate agg) {
            List<Expression> groupings = agg.groupings();
            if (groupings.isEmpty()) {
                return agg;
            }
            ExpressionSet<Expression> unique = new ExpressionSet<Expression>(groupings);
            if (unique.size() != groupings.size()) {
                return new Aggregate(agg.source(), agg.child(), new ArrayList<Expression>(unique), agg.aggregates());
            }
            return agg;
        }
    }

    static class RewritePivot
    extends OptimizerRule<Pivot> {
        RewritePivot() {
        }

        @Override
        protected LogicalPlan rule(Pivot plan) {
            ArrayList<Expression> rawValues = new ArrayList<Expression>(plan.values().size());
            for (NamedExpression namedExpression : plan.values()) {
                if (namedExpression instanceof Alias) {
                    rawValues.add(((Alias)namedExpression).child());
                    continue;
                }
                if (namedExpression instanceof Literal) {
                    rawValues.add(namedExpression);
                    continue;
                }
                if (namedExpression.foldable()) {
                    rawValues.add(Literal.of(namedExpression.name(), namedExpression));
                    continue;
                }
                UnresolvedAttribute attr = new UnresolvedAttribute(namedExpression.source(), namedExpression.name(), null, "Unexpected alias");
                return new Pivot(plan.source(), plan.child(), plan.column(), Collections.singletonList(attr), plan.aggregates());
            }
            Filter filter = new Filter(plan.source(), plan.child(), new In(plan.source(), plan.column(), rawValues));
            return new Pivot(plan.source(), filter, plan.column(), plan.values(), plan.aggregates());
        }
    }
}

