/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.operator.comparison;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.Foldables;
import org.elasticsearch.xpack.sql.expression.Nullability;
import org.elasticsearch.xpack.sql.expression.TypeResolutions;
import org.elasticsearch.xpack.sql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.InPipe;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.InProcessor;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DataTypes;
import org.elasticsearch.xpack.sql.util.CollectionUtils;
import org.elasticsearch.xpack.sql.util.StringUtils;

public class In
extends ScalarFunction {
    private final Expression value;
    private final List<Expression> list;

    public In(Source source, Expression value, List<Expression> list) {
        super(source, CollectionUtils.combine(list, value));
        this.value = value;
        this.list = new ArrayList<Expression>(new LinkedHashSet<Expression>(list));
    }

    @Override
    protected NodeInfo<In> info() {
        return NodeInfo.create(this, In::new, this.value, this.list);
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() < 2) {
            throw new IllegalArgumentException("expected at least [2] children but received [" + newChildren.size() + "]");
        }
        return new In(this.source(), newChildren.get(newChildren.size() - 1), newChildren.subList(0, newChildren.size() - 1));
    }

    public Expression value() {
        return this.value;
    }

    public List<Expression> list() {
        return this.list;
    }

    @Override
    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    @Override
    public Nullability nullable() {
        return Nullability.UNKNOWN;
    }

    @Override
    public boolean foldable() {
        return Expressions.foldable(this.children()) || Expressions.foldable(this.list) && this.list().stream().allMatch(e -> e.dataType() == DataType.NULL);
    }

    @Override
    public Boolean fold() {
        if (this.value.dataType() == DataType.NULL || this.list.size() == 1 && this.list.get(0).dataType() == DataType.NULL) {
            return null;
        }
        return InProcessor.apply(this.value.fold(), Foldables.valuesOf(this.list, this.value.dataType()));
    }

    @Override
    public ScriptTemplate asScript() {
        ScriptTemplate leftScript = this.asScript(this.value);
        ArrayList values = new ArrayList(new LinkedHashSet(Foldables.valuesOf(this.list, this.value.dataType())));
        return new ScriptTemplate(this.formatTemplate(LoggerMessageFormat.format((String)"{sql}.", (String)"in({}, {})", (Object[])new Object[]{leftScript.template()})), ParamsBuilder.paramsBuilder().script(leftScript.params()).variable(values).build(), this.dataType());
    }

    @Override
    protected Pipe makePipe() {
        return new InPipe(this.source(), this, this.children().stream().map(Expressions::pipe).collect(Collectors.toList()));
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        Expression.TypeResolution resolution = TypeResolutions.isExact(this.value, this.functionName(), Expressions.ParamOrdinal.DEFAULT);
        if (resolution.unresolved()) {
            return resolution;
        }
        for (Expression ex : this.list) {
            if (ex.foldable()) continue;
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"Comparisons against variables are not (currently) supported; offender [{}] in [{}]", (Object[])new Object[]{Expressions.name(ex), this.name()}));
        }
        DataType dt = this.value.dataType();
        for (int i = 0; i < this.list.size(); ++i) {
            Expression listValue = this.list.get(i);
            if (DataTypes.areTypesCompatible(dt, listValue.dataType())) continue;
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"{} argument of [{}] must be [{}], found value [{}] type [{}]", (Object[])new Object[]{StringUtils.ordinal(i + 1), this.sourceText(), dt.typeName, Expressions.name(listValue), listValue.dataType().typeName}));
        }
        return super.resolveType();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.list);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        In other = (In)obj;
        return Objects.equals(this.value, other.value) && Objects.equals(this.list, other.list);
    }
}

