/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic;

import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.BinaryArithmeticProcessor;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.DateTimeArithmeticOperation;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;

public class Sub
extends DateTimeArithmeticOperation {
    public Sub(Source source, Expression left, Expression right) {
        super(source, left, right, BinaryArithmeticProcessor.BinaryArithmeticOperation.SUB);
    }

    @Override
    protected NodeInfo<Sub> info() {
        return NodeInfo.create(this, Sub::new, this.left(), this.right());
    }

    @Override
    protected Sub replaceChildren(Expression newLeft, Expression newRight) {
        return new Sub(this.source(), newLeft, newRight);
    }

    @Override
    protected Expression.TypeResolution resolveWithIntervals() {
        Expression.TypeResolution resolution = super.resolveWithIntervals();
        if (resolution.unresolved()) {
            return resolution;
        }
        if (this.right().dataType().isDateOrTimeBased() && this.left().dataType().isInterval()) {
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"Cannot subtract a {}[{}] from an interval[{}]; do you mean the reverse?", (Object[])new Object[]{this.right().dataType().typeName, this.right().source().text(), this.left().source().text()}));
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }
}

