/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic;

import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.ArithmeticOperation;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.BinaryArithmeticProcessor;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DataTypeConversion;

abstract class DateTimeArithmeticOperation
extends ArithmeticOperation {
    DateTimeArithmeticOperation(Source source, Expression left, Expression right, BinaryArithmeticProcessor.BinaryArithmeticOperation operation) {
        super(source, left, right, operation);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        DataType l = this.left().dataType();
        DataType r = this.right().dataType();
        if (l.isNumeric() && r.isNumeric()) {
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        if (l.isInterval() || r.isInterval()) {
            if (DataTypeConversion.commonType(l, r) == null) {
                return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"[{}] has arguments with incompatible types [{}] and [{}]", (Object[])new Object[]{this.symbol(), l, r}));
            }
            return this.resolveWithIntervals();
        }
        return super.resolveType();
    }

    protected Expression.TypeResolution resolveWithIntervals() {
        DataType l = this.left().dataType();
        DataType r = this.right().dataType();
        if (!r.isDateOrTimeBased() && !r.isInterval() || !l.isDateOrTimeBased() && !l.isInterval()) {
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"[{}] has arguments with incompatible types [{}] and [{}]", (Object[])new Object[]{this.symbol(), l, r}));
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }
}

