/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic;

import java.io.IOException;
import java.time.Duration;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.function.BiFunction;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.script.JodaCompatibleZonedDateTime;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.gen.processor.FunctionalBinaryProcessor;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.expression.literal.Interval;
import org.elasticsearch.xpack.sql.expression.literal.IntervalDayTime;
import org.elasticsearch.xpack.sql.expression.literal.IntervalYearMonth;
import org.elasticsearch.xpack.sql.expression.predicate.PredicateBiFunction;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.Arithmetics;

public class BinaryArithmeticProcessor
extends FunctionalBinaryProcessor<Object, Object, Object, BinaryArithmeticOperation> {
    public static final String NAME = "abn";

    public BinaryArithmeticProcessor(Processor left, Processor right, BinaryArithmeticOperation operation) {
        super(left, right, operation);
    }

    public BinaryArithmeticProcessor(StreamInput in) throws IOException {
        super(in, i -> (BinaryArithmeticOperation)i.readEnum(BinaryArithmeticOperation.class));
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Object doProcess(Object left, Object right) {
        BinaryArithmeticOperation f = (BinaryArithmeticOperation)this.function();
        if (left == null || right == null) {
            return null;
        }
        if (f == BinaryArithmeticOperation.DIV || f == BinaryArithmeticOperation.MOD) {
            if (!(left instanceof Number)) {
                throw new SqlIllegalArgumentException("A number is required; received {}", left);
            }
            if (!(right instanceof Number)) {
                throw new SqlIllegalArgumentException("A number is required; received {}", right);
            }
            return f.apply(left, right);
        }
        if (f == BinaryArithmeticOperation.ADD || f == BinaryArithmeticOperation.SUB || f == BinaryArithmeticOperation.MUL) {
            return f.apply(left, right);
        }
        throw new SqlIllegalArgumentException("Cannot perform arithmetic operation due to arguments");
    }

    public static enum BinaryArithmeticOperation implements PredicateBiFunction<Object, Object, Object>
    {
        ADD((l, r) -> {
            if (l instanceof Number) {
                return Arithmetics.add((Number)l, (Number)r);
            }
            if (l instanceof IntervalYearMonth && r instanceof IntervalYearMonth) {
                return ((IntervalYearMonth)l).add((Interval)((IntervalYearMonth)r));
            }
            if (l instanceof IntervalDayTime && r instanceof IntervalDayTime) {
                return ((IntervalDayTime)l).add((Interval)((IntervalDayTime)r));
            }
            l = BinaryArithmeticOperation.unwrapJodaTime(l);
            r = BinaryArithmeticOperation.unwrapJodaTime(r);
            if ((l instanceof ZonedDateTime || l instanceof OffsetTime) && r instanceof IntervalYearMonth) {
                return Arithmetics.add((Temporal)l, (Period)((IntervalYearMonth)r).interval());
            }
            if ((l instanceof ZonedDateTime || l instanceof OffsetTime) && r instanceof IntervalDayTime) {
                return Arithmetics.add((Temporal)l, (Duration)((IntervalDayTime)r).interval());
            }
            if ((r instanceof ZonedDateTime || r instanceof OffsetTime) && l instanceof IntervalYearMonth) {
                return Arithmetics.add((Temporal)r, (Period)((IntervalYearMonth)l).interval());
            }
            if ((r instanceof ZonedDateTime || r instanceof OffsetTime) && l instanceof IntervalDayTime) {
                return Arithmetics.add((Temporal)r, (Duration)((IntervalDayTime)l).interval());
            }
            throw new SqlIllegalArgumentException("Cannot compute [+] between [{}] [{}]", l.getClass().getSimpleName(), r.getClass().getSimpleName());
        }, "+"),
        SUB((l, r) -> {
            if (l instanceof Number) {
                return Arithmetics.sub((Number)l, (Number)r);
            }
            if (l instanceof IntervalYearMonth && r instanceof IntervalYearMonth) {
                return ((IntervalYearMonth)l).sub((Interval)((IntervalYearMonth)r));
            }
            if (l instanceof IntervalDayTime && r instanceof IntervalDayTime) {
                return ((IntervalDayTime)l).sub((Interval)((IntervalDayTime)r));
            }
            l = BinaryArithmeticOperation.unwrapJodaTime(l);
            r = BinaryArithmeticOperation.unwrapJodaTime(r);
            if ((l instanceof ZonedDateTime || l instanceof OffsetTime) && r instanceof IntervalYearMonth) {
                return Arithmetics.sub((Temporal)l, (Period)((IntervalYearMonth)r).interval());
            }
            if ((l instanceof ZonedDateTime || l instanceof OffsetTime) && r instanceof IntervalDayTime) {
                return Arithmetics.sub((Temporal)l, (Duration)((IntervalDayTime)r).interval());
            }
            if ((r instanceof ZonedDateTime || r instanceof OffsetTime) && l instanceof Interval) {
                throw new SqlIllegalArgumentException("Cannot subtract a date from an interval; do you mean the reverse?");
            }
            throw new SqlIllegalArgumentException("Cannot compute [-] between [{}] [{}]", l.getClass().getSimpleName(), r.getClass().getSimpleName());
        }, "-"),
        MUL((l, r) -> {
            if (l instanceof Number && r instanceof Number) {
                return Arithmetics.mul((Number)l, (Number)r);
            }
            l = BinaryArithmeticOperation.unwrapJodaTime(l);
            r = BinaryArithmeticOperation.unwrapJodaTime(r);
            if (l instanceof Number && r instanceof IntervalYearMonth) {
                return ((IntervalYearMonth)r).mul(((Number)l).intValue());
            }
            if (r instanceof Number && l instanceof IntervalYearMonth) {
                return ((IntervalYearMonth)l).mul(((Number)r).intValue());
            }
            if (l instanceof Number && r instanceof IntervalDayTime) {
                return ((IntervalDayTime)r).mul(((Number)l).longValue());
            }
            if (r instanceof Number && l instanceof IntervalDayTime) {
                return ((IntervalDayTime)l).mul(((Number)r).longValue());
            }
            throw new SqlIllegalArgumentException("Cannot compute [*] between [{}] [{}]", l.getClass().getSimpleName(), r.getClass().getSimpleName());
        }, "*"),
        DIV(Arithmetics::div, "/"),
        MOD(Arithmetics::mod, "%");

        private final BiFunction<Object, Object, Object> process;
        private final String symbol;

        private BinaryArithmeticOperation(BiFunction<Object, Object, Object> process, String symbol) {
            this.process = process;
            this.symbol = symbol;
        }

        private BinaryArithmeticOperation(NumericArithmetic process, String symbol) {
            this(process::wrap, symbol);
        }

        @Override
        public String symbol() {
            return this.symbol;
        }

        @Override
        public final Object doApply(Object left, Object right) {
            return this.process.apply(left, right);
        }

        public String toString() {
            return this.symbol;
        }

        private static Object unwrapJodaTime(Object o) {
            return o instanceof JodaCompatibleZonedDateTime ? ((JodaCompatibleZonedDateTime)o).getZonedDateTime() : o;
        }
    }

    private static interface NumericArithmetic
    extends BiFunction<Number, Number, Number> {
        default public Object wrap(Object l, Object r) {
            return this.apply((Number)l, (Number)r);
        }
    }
}

