/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.conditional;

import java.util.Arrays;
import java.util.List;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.ConditionalFunction;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.NullIfPipe;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.NullIfProcessor;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;

public class NullIf
extends ConditionalFunction {
    public NullIf(Source source, Expression left, Expression right) {
        super(source, Arrays.asList(left, right));
    }

    @Override
    protected NodeInfo<? extends NullIf> info() {
        return NodeInfo.create(this, NullIf::new, (Expression)this.children().get(0), (Expression)this.children().get(1));
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new NullIf(this.source(), newChildren.get(0), newChildren.get(1));
    }

    @Override
    public Object fold() {
        return NullIfProcessor.apply(((Expression)this.children().get(0)).fold(), ((Expression)this.children().get(1)).fold());
    }

    @Override
    public ScriptTemplate asScript() {
        ScriptTemplate left = this.asScript((Expression)this.children().get(0));
        ScriptTemplate right = this.asScript((Expression)this.children().get(1));
        String template = "{sql}.nullif(" + left.template() + "," + right.template() + ")";
        ParamsBuilder params = ParamsBuilder.paramsBuilder();
        params.script(left.params());
        params.script(right.params());
        return new ScriptTemplate(this.formatTemplate(template), params.build(), this.dataType);
    }

    @Override
    protected Pipe makePipe() {
        return new NullIfPipe(this.source(), this, Expressions.pipe((Expression)this.children().get(0)), Expressions.pipe((Expression)this.children().get(1)));
    }
}

