/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.conditional;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;

public class CaseProcessor
implements Processor {
    public static final String NAME = "case";
    private final List<Processor> processors;

    public CaseProcessor(List<Processor> processors) {
        this.processors = processors;
    }

    public CaseProcessor(StreamInput in) throws IOException {
        this.processors = in.readNamedWriteableList(Processor.class);
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteableList(this.processors);
    }

    @Override
    public Object process(Object input) {
        ArrayList<Object> objects = new ArrayList<Object>(this.processors.size());
        for (Processor processor : this.processors) {
            objects.add(processor.process(input));
        }
        return CaseProcessor.apply(objects);
    }

    public static Object apply(List<Object> objects) {
        for (int i = 0; i < objects.size() - 2; i += 2) {
            if (objects.get(i) != Boolean.TRUE) continue;
            return objects.get(i + 1);
        }
        return objects.get(objects.size() - 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CaseProcessor that = (CaseProcessor)o;
        return Objects.equals(this.processors, that.processors);
    }

    public int hashCode() {
        return Objects.hash(this.processors);
    }
}

