/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.ZoneId;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.BaseDateTimeFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.QuarterProcessor;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;

public class Quarter
extends BaseDateTimeFunction {
    public Quarter(Source source, Expression field, ZoneId zoneId) {
        super(source, field, zoneId);
    }

    @Override
    public ScriptTemplate asScript() {
        ScriptTemplate script = super.asScript();
        String template = this.formatTemplate("{sql}.quarter(" + script.template() + ", {})");
        ParamsBuilder params = ParamsBuilder.paramsBuilder().script(script.params()).variable(this.zoneId().getId());
        return new ScriptTemplate(template, params.build(), this.dataType());
    }

    @Override
    protected NodeInfo.NodeCtor2<Expression, ZoneId, BaseDateTimeFunction> ctorForInfo() {
        return Quarter::new;
    }

    @Override
    protected Quarter replaceChild(Expression newChild) {
        return new Quarter(this.source(), newChild, this.zoneId());
    }

    @Override
    protected Processor makeProcessor() {
        return new QuarterProcessor(this.zoneId());
    }

    @Override
    public DataType dataType() {
        return DataType.INTEGER;
    }
}

