/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.ZoneId;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.BaseDateTimeFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.NamedDateTimeProcessor;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.util.StringUtils;

abstract class NamedDateTimeFunction
extends BaseDateTimeFunction {
    private final NamedDateTimeProcessor.NameExtractor nameExtractor;

    NamedDateTimeFunction(Source source, Expression field, ZoneId zoneId, NamedDateTimeProcessor.NameExtractor nameExtractor) {
        super(source, field, zoneId);
        this.nameExtractor = nameExtractor;
    }

    @Override
    public ScriptTemplate asScript() {
        ScriptTemplate script = super.asScript();
        String template = this.formatTemplate("{sql}." + StringUtils.underscoreToLowerCamelCase(this.nameExtractor.name()) + "(" + script.template() + ", {})");
        ParamsBuilder params = ParamsBuilder.paramsBuilder().script(script.params()).variable(this.zoneId().getId());
        return new ScriptTemplate(template, params.build(), this.dataType());
    }

    @Override
    protected Processor makeProcessor() {
        return new NamedDateTimeProcessor(this.nameExtractor, this.zoneId());
    }

    @Override
    public DataType dataType() {
        return DataType.KEYWORD;
    }
}

