/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.BinaryDateTimeProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTrunc;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;

public class DateTruncProcessor
extends BinaryDateTimeProcessor {
    public static final String NAME = "dtrunc";

    public DateTruncProcessor(Processor source1, Processor source2, ZoneId zoneId) {
        super(source1, source2, zoneId);
    }

    public DateTruncProcessor(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Object doProcess(Object truncateTo, Object timestamp) {
        return DateTruncProcessor.process(truncateTo, timestamp, this.zoneId());
    }

    public static Object process(Object truncateTo, Object timestamp, ZoneId zoneId) {
        if (truncateTo == null || timestamp == null) {
            return null;
        }
        if (!(truncateTo instanceof String)) {
            throw new SqlIllegalArgumentException("A string is required; received [{}]", truncateTo);
        }
        DateTrunc.Part truncateDateField = DateTrunc.Part.resolve((String)truncateTo);
        if (truncateDateField == null) {
            List<String> similar = DateTrunc.Part.findSimilar((String)truncateTo);
            if (similar.isEmpty()) {
                throw new SqlIllegalArgumentException("A value of {} or their aliases is required; received [{}]", DateTrunc.Part.values(), truncateTo);
            }
            throw new SqlIllegalArgumentException("Received value [{}] is not valid date part for truncation; did you mean {}?", truncateTo, similar);
        }
        if (!(timestamp instanceof ZonedDateTime)) {
            throw new SqlIllegalArgumentException("A date/datetime is required; received [{}]", timestamp);
        }
        return truncateDateField.truncate(((ZonedDateTime)timestamp).withZoneSameInstant(zoneId));
    }
}

