/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.function.scalar.BinaryScalarFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.BinaryDateTimeFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeField;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTruncPipe;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTruncProcessor;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;

public class DateTrunc
extends BinaryDateTimeFunction {
    public DateTrunc(Source source, Expression truncateTo, Expression timestamp, ZoneId zoneId) {
        super(source, truncateTo, timestamp, zoneId);
    }

    @Override
    public DataType dataType() {
        return DataType.DATETIME;
    }

    @Override
    protected BinaryScalarFunction replaceChildren(Expression newTruncateTo, Expression newTimestamp) {
        return new DateTrunc(this.source(), newTruncateTo, newTimestamp, this.zoneId());
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, DateTrunc::new, this.left(), this.right(), this.zoneId());
    }

    @Override
    protected String scriptMethodName() {
        return "dateTrunc";
    }

    @Override
    public Object fold() {
        return DateTruncProcessor.process(this.left().fold(), this.right().fold(), this.zoneId());
    }

    @Override
    protected Pipe createPipe(Pipe truncateTo, Pipe timestamp, ZoneId zoneId) {
        return new DateTruncPipe(this.source(), this, truncateTo, timestamp, zoneId);
    }

    @Override
    protected boolean resolveDateTimeField(String dateTimeField) {
        return Part.resolve(dateTimeField) != null;
    }

    @Override
    protected List<String> findSimilarDateTimeFields(String dateTimeField) {
        return Part.findSimilar(dateTimeField);
    }

    @Override
    protected List<String> validDateTimeFieldValues() {
        return Part.VALID_VALUES;
    }

    public static enum Part implements DateTimeField
    {
        MILLENNIUM(dt -> {
            int year = dt.getYear();
            int firstYearOfMillenium = year - year % 1000;
            return dt.with(ChronoField.YEAR, firstYearOfMillenium).with(ChronoField.MONTH_OF_YEAR, 1L).with(ChronoField.DAY_OF_MONTH, 1L).toLocalDate().atStartOfDay(dt.getZone());
        }, "millennia"),
        CENTURY(dt -> {
            int year = dt.getYear();
            int firstYearOfCentury = year - year % 100;
            return dt.with(ChronoField.YEAR, firstYearOfCentury).with(ChronoField.MONTH_OF_YEAR, 1L).with(ChronoField.DAY_OF_MONTH, 1L).toLocalDate().atStartOfDay(dt.getZone());
        }, "centuries"),
        DECADE(dt -> {
            int year = dt.getYear();
            int firstYearOfDecade = year - year % 10;
            return dt.with(ChronoField.YEAR, firstYearOfDecade).with(ChronoField.MONTH_OF_YEAR, 1L).with(ChronoField.DAY_OF_MONTH, 1L).toLocalDate().atStartOfDay(dt.getZone());
        }, "decades"),
        YEAR(dt -> dt.with(ChronoField.MONTH_OF_YEAR, 1L).with(ChronoField.DAY_OF_MONTH, 1L).toLocalDate().atStartOfDay(dt.getZone()), "years", "yy", "yyyy"),
        QUARTER(dt -> {
            int month = dt.getMonthValue();
            int firstMonthOfQuarter = (month - 1) / 3 * 3 + 1;
            return dt.with(ChronoField.MONTH_OF_YEAR, firstMonthOfQuarter).with(ChronoField.DAY_OF_MONTH, 1L).toLocalDate().atStartOfDay(dt.getZone());
        }, "quarters", "qq", "q"),
        MONTH(dt -> dt.with(ChronoField.DAY_OF_MONTH, 1L).toLocalDate().atStartOfDay(dt.getZone()), "months", "mm", "m"),
        WEEK(dt -> dt.with(ChronoField.DAY_OF_WEEK, 1L).toLocalDate().atStartOfDay(dt.getZone()), "weeks", "wk", "ww"),
        DAY(dt -> dt.toLocalDate().atStartOfDay(dt.getZone()), "days", "dd", "d"),
        HOUR(dt -> {
            int hour = dt.getHour();
            return dt.toLocalDate().atStartOfDay(dt.getZone()).with(ChronoField.HOUR_OF_DAY, hour);
        }, "hours", "hh"),
        MINUTE(dt -> {
            int hour = dt.getHour();
            int minute = dt.getMinute();
            return dt.toLocalDate().atStartOfDay(dt.getZone()).with(ChronoField.HOUR_OF_DAY, hour).with(ChronoField.MINUTE_OF_HOUR, minute);
        }, "minutes", "mi", "n"),
        SECOND(dt -> dt.with(ChronoField.NANO_OF_SECOND, 0L), "seconds", "ss", "s"),
        MILLISECOND(dt -> {
            int micros = dt.get(ChronoField.MICRO_OF_SECOND);
            return dt.with(ChronoField.MILLI_OF_SECOND, micros / 1000);
        }, "milliseconds", "ms"),
        MICROSECOND(dt -> {
            int nanos = dt.getNano();
            return dt.with(ChronoField.MICRO_OF_SECOND, nanos / 1000);
        }, "microseconds", "mcs"),
        NANOSECOND(dt -> dt, "nanoseconds", "ns");

        private static final Map<String, Part> NAME_TO_PART;
        private static final List<String> VALID_VALUES;
        private UnaryOperator<ZonedDateTime> truncateFunction;
        private Set<String> aliases;

        private Part(UnaryOperator<ZonedDateTime> truncateFunction, String ... aliases) {
            this.truncateFunction = truncateFunction;
            this.aliases = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(aliases)));
        }

        @Override
        public Iterable<String> aliases() {
            return this.aliases;
        }

        public static List<String> findSimilar(String match) {
            return DateTimeField.findSimilar(NAME_TO_PART.keySet(), match);
        }

        public static Part resolve(String truncateTo) {
            return DateTimeField.resolveMatch(NAME_TO_PART, truncateTo);
        }

        public ZonedDateTime truncate(ZonedDateTime dateTime) {
            return (ZonedDateTime)this.truncateFunction.apply(dateTime);
        }

        static {
            NAME_TO_PART = DateTimeField.initializeResolutionMap((DateTimeField[])Part.values());
            VALID_VALUES = DateTimeField.initializeValidValues((DateTimeField[])Part.values());
        }
    }
}

