/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.BinaryDateTimeProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DatePart;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;

public class DatePartProcessor
extends BinaryDateTimeProcessor {
    public static final String NAME = "dtpart";

    public DatePartProcessor(Processor source1, Processor source2, ZoneId zoneId) {
        super(source1, source2, zoneId);
    }

    public DatePartProcessor(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Object doProcess(Object part, Object timestamp) {
        return DatePartProcessor.process(part, timestamp, this.zoneId());
    }

    public static Object process(Object part, Object timestamp, ZoneId zoneId) {
        if (part == null || timestamp == null) {
            return null;
        }
        if (!(part instanceof String)) {
            throw new SqlIllegalArgumentException("A string is required; received [{}]", part);
        }
        DatePart.Part datePartField = DatePart.Part.resolve((String)part);
        if (datePartField == null) {
            List<String> similar = DatePart.Part.findSimilar((String)part);
            if (similar.isEmpty()) {
                throw new SqlIllegalArgumentException("A value of {} or their aliases is required; received [{}]", DatePart.Part.values(), part);
            }
            throw new SqlIllegalArgumentException("Received value [{}] is not valid date part for extraction; did you mean {}?", part, similar);
        }
        if (!(timestamp instanceof ZonedDateTime)) {
            throw new SqlIllegalArgumentException("A date/datetime is required; received [{}]", timestamp);
        }
        return datePartField.extract(((ZonedDateTime)timestamp).withZoneSameInstant(zoneId));
    }
}

