/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateAdd;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.ThreeArgsDateTimeProcessor;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;

public class DateAddProcessor
extends ThreeArgsDateTimeProcessor {
    public static final String NAME = "dtadd";

    public DateAddProcessor(Processor unit, Processor numberOfUnits, Processor timestamp, ZoneId zoneId) {
        super(unit, numberOfUnits, timestamp, zoneId);
    }

    public DateAddProcessor(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public Object doProcess(Object unit, Object numberOfUnits, Object timestamp, ZoneId zoneId) {
        return DateAddProcessor.process(unit, numberOfUnits, timestamp, zoneId);
    }

    public static Object process(Object unit, Object numberOfUnits, Object timestamp, ZoneId zoneId) {
        if (unit == null || numberOfUnits == null || timestamp == null) {
            return null;
        }
        if (!(unit instanceof String)) {
            throw new SqlIllegalArgumentException("A string is required; received [{}]", unit);
        }
        DateAdd.Part datePartField = DateAdd.Part.resolve((String)unit);
        if (datePartField == null) {
            List<String> similar = DateAdd.Part.findSimilar((String)unit);
            if (similar.isEmpty()) {
                throw new SqlIllegalArgumentException("A value of {} or their aliases is required; received [{}]", DateAdd.Part.values(), unit);
            }
            throw new SqlIllegalArgumentException("Received value [{}] is not valid date part to add; did you mean {}?", unit, similar);
        }
        if (!(numberOfUnits instanceof Number)) {
            throw new SqlIllegalArgumentException("A number is required; received [{}]", numberOfUnits);
        }
        if (!(timestamp instanceof ZonedDateTime)) {
            throw new SqlIllegalArgumentException("A date/datetime is required; received [{}]", timestamp);
        }
        return datePartField.add(((ZonedDateTime)timestamp).withZoneSameInstant(zoneId), ((Number)numberOfUnits).intValue());
    }
}

