/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.TypeResolutions;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateAddPipe;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateAddProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeField;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.ThreeArgsDateTimeFunction;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;

public class DateAdd
extends ThreeArgsDateTimeFunction {
    public DateAdd(Source source, Expression unit, Expression numberOfUnits, Expression timestamp, ZoneId zoneId) {
        super(source, unit, numberOfUnits, timestamp, zoneId);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        String datePartValue;
        Expression.TypeResolution resolution = TypeResolutions.isString(this.first(), this.sourceText(), Expressions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        if (this.first().foldable() && (datePartValue = (String)this.first().fold()) != null && !this.resolveDateTimeField(datePartValue)) {
            List<String> similar = this.findSimilarDateTimeFields(datePartValue);
            if (similar.isEmpty()) {
                return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"first argument of [{}] must be one of {} or their aliases; found value [{}]", (Object[])new Object[]{this.sourceText(), this.validDateTimeFieldValues(), Expressions.name(this.first())}));
            }
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"Unknown value [{}] for first argument of [{}]; did you mean {}?", (Object[])new Object[]{Expressions.name(this.first()), this.sourceText(), similar}));
        }
        resolution = TypeResolutions.isInteger(this.second(), this.sourceText(), Expressions.ParamOrdinal.SECOND);
        if (resolution.unresolved()) {
            return resolution;
        }
        resolution = TypeResolutions.isDate(this.third(), this.sourceText(), Expressions.ParamOrdinal.THIRD);
        if (resolution.unresolved()) {
            return resolution;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    @Override
    public DataType dataType() {
        return DataType.DATETIME;
    }

    @Override
    protected ThreeArgsDateTimeFunction replaceChildren(Expression newFirst, Expression newSecond, Expression newThird) {
        return new DateAdd(this.source(), newFirst, newSecond, newThird, this.zoneId());
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, DateAdd::new, this.first(), this.second(), this.third(), this.zoneId());
    }

    @Override
    protected Pipe createPipe(Pipe unit, Pipe numberOfUnits, Pipe timestamp, ZoneId zoneId) {
        return new DateAddPipe(this.source(), this, unit, numberOfUnits, timestamp, zoneId);
    }

    @Override
    protected String scriptMethodName() {
        return "dateAdd";
    }

    @Override
    public Object fold() {
        return DateAddProcessor.process(this.first().fold(), this.second().fold(), this.third().fold(), this.zoneId());
    }

    @Override
    protected boolean resolveDateTimeField(String dateTimeField) {
        return Part.resolve(dateTimeField) != null;
    }

    @Override
    protected List<String> findSimilarDateTimeFields(String dateTimeField) {
        return Part.findSimilar(dateTimeField);
    }

    @Override
    protected List<String> validDateTimeFieldValues() {
        return Part.VALID_VALUES;
    }

    public static enum Part implements DateTimeField
    {
        YEAR((dt, i) -> dt.plus(i.intValue(), ChronoUnit.YEARS), "years", "yyyy", "yy"),
        QUARTER((dt, i) -> dt.plus(i * 3, ChronoUnit.MONTHS), "quarters", "qq", "q"),
        MONTH((dt, i) -> dt.plus(i.intValue(), ChronoUnit.MONTHS), "months", "mm", "m"),
        DAYOFYEAR((dt, i) -> dt.plus(i.intValue(), ChronoUnit.DAYS), "dy", "y"),
        DAY((dt, i) -> dt.plus(i.intValue(), ChronoUnit.DAYS), "days", "dd", "d"),
        WEEK((dt, i) -> dt.plus(i.intValue(), ChronoUnit.WEEKS), "weeks", "wk", "ww"),
        WEEKDAY((dt, i) -> dt.plus(i.intValue(), ChronoUnit.DAYS), "weekdays", "dw"),
        HOUR((dt, i) -> dt.plus(i.intValue(), ChronoUnit.HOURS), "hours", "hh"),
        MINUTE((dt, i) -> dt.plus(i.intValue(), ChronoUnit.MINUTES), "minutes", "mi", "n"),
        SECOND((dt, i) -> dt.plus(i.intValue(), ChronoUnit.SECONDS), "seconds", "ss", "s"),
        MILLISECOND((dt, i) -> dt.plus(i.intValue(), ChronoUnit.MILLIS), "milliseconds", "ms"),
        MICROSECOND((dt, i) -> dt.plus(i.intValue(), ChronoUnit.MICROS), "microseconds", "mcs"),
        NANOSECOND((dt, i) -> dt.plus(i.intValue(), ChronoUnit.NANOS), "nanoseconds", "ns");

        private static final Map<String, Part> NAME_TO_PART;
        private static final List<String> VALID_VALUES;
        private BiFunction<ZonedDateTime, Integer, ZonedDateTime> addFunction;
        private Set<String> aliases;

        private Part(BiFunction<ZonedDateTime, Integer, ZonedDateTime> addFunction, String ... aliases) {
            this.addFunction = addFunction;
            this.aliases = new HashSet<String>(Arrays.asList(aliases));
        }

        @Override
        public Iterable<String> aliases() {
            return this.aliases;
        }

        public static List<String> findSimilar(String match) {
            return DateTimeField.findSimilar(NAME_TO_PART.keySet(), match);
        }

        public static Part resolve(String dateTimeUnit) {
            return DateTimeField.resolveMatch(NAME_TO_PART, dateTimeUnit);
        }

        public ZonedDateTime add(ZonedDateTime dateTime, Integer numberOfUnits) {
            return this.addFunction.apply(dateTime, numberOfUnits);
        }

        static {
            NAME_TO_PART = DateTimeField.initializeResolutionMap((DateTimeField[])Part.values());
            VALID_VALUES = DateTimeField.initializeValidValues((DateTimeField[])Part.values());
        }
    }
}

