/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.OffsetTime;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.CurrentFunction;
import org.elasticsearch.xpack.sql.session.Configuration;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.util.DateUtils;

public class CurrentTime
extends CurrentFunction<OffsetTime> {
    private final Expression precision;

    public CurrentTime(Source source, Expression precision, Configuration configuration) {
        super(source, configuration, CurrentTime.nanoPrecision(configuration.now().toOffsetDateTime().toOffsetTime(), precision), DataType.TIME);
        this.precision = precision;
    }

    Expression precision() {
        return this.precision;
    }

    @Override
    protected NodeInfo<CurrentTime> info() {
        return NodeInfo.create(this, CurrentTime::new, this.precision, this.configuration());
    }

    static OffsetTime nanoPrecision(OffsetTime ot, Expression precisionExpression) {
        return ot.withNano(DateUtils.getNanoPrecision(precisionExpression, ot.getNano()));
    }
}

