/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.common.io.SqlStreamInput;
import org.elasticsearch.xpack.sql.expression.gen.processor.BinaryProcessor;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;

public abstract class BinaryDateTimeProcessor
extends BinaryProcessor {
    private final ZoneId zoneId;

    public BinaryDateTimeProcessor(Processor source1, Processor source2, ZoneId zoneId) {
        super(source1, source2);
        this.zoneId = zoneId;
    }

    public BinaryDateTimeProcessor(StreamInput in) throws IOException {
        super(in);
        this.zoneId = SqlStreamInput.asSqlStream(in).zoneId();
    }

    @Override
    protected void doWrite(StreamOutput out) {
    }

    ZoneId zoneId() {
        return this.zoneId;
    }

    @Override
    protected abstract Object doProcess(Object var1, Object var2);

    public int hashCode() {
        return Objects.hash(this.left(), this.right(), this.zoneId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryDateTimeProcessor other = (BinaryDateTimeProcessor)obj;
        return Objects.equals(this.left(), other.left()) && Objects.equals(this.right(), other.right()) && Objects.equals(this.zoneId(), other.zoneId());
    }
}

