/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.ZoneId;
import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.BinaryPipe;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.tree.Source;

public abstract class BinaryDateTimePipe
extends BinaryPipe {
    private final ZoneId zoneId;

    public BinaryDateTimePipe(Source source, Expression expression, Pipe left, Pipe right, ZoneId zoneId) {
        super(source, expression, left, right);
        this.zoneId = zoneId;
    }

    ZoneId zoneId() {
        return this.zoneId;
    }

    @Override
    public Processor asProcessor() {
        return this.makeProcessor(this.left().asProcessor(), this.right().asProcessor(), this.zoneId);
    }

    protected abstract Processor makeProcessor(Processor var1, Processor var2, ZoneId var3);

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.zoneId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BinaryDateTimePipe that = (BinaryDateTimePipe)o;
        return Objects.equals(this.zoneId, that.zoneId);
    }
}

