/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.ZoneId;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.TypeResolutions;
import org.elasticsearch.xpack.sql.expression.function.scalar.BinaryScalarFunction;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.Source;

public abstract class BinaryDateTimeFunction
extends BinaryScalarFunction {
    private final ZoneId zoneId;

    public BinaryDateTimeFunction(Source source, Expression datePart, Expression timestamp, ZoneId zoneId) {
        super(source, datePart, timestamp);
        this.zoneId = zoneId;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        String datePartValue;
        Expression.TypeResolution resolution = TypeResolutions.isString(this.left(), this.sourceText(), Expressions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        if (this.left().foldable() && (datePartValue = (String)this.left().fold()) != null && !this.resolveDateTimeField(datePartValue)) {
            List<String> similar = this.findSimilarDateTimeFields(datePartValue);
            if (similar.isEmpty()) {
                return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"first argument of [{}] must be one of {} or their aliases; found value [{}]", (Object[])new Object[]{this.sourceText(), this.validDateTimeFieldValues(), Expressions.name(this.left())}));
            }
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"Unknown value [{}] for first argument of [{}]; did you mean {}?", (Object[])new Object[]{Expressions.name(this.left()), this.sourceText(), similar}));
        }
        resolution = TypeResolutions.isDate(this.right(), this.sourceText(), Expressions.ParamOrdinal.SECOND);
        if (resolution.unresolved()) {
            return resolution;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    protected abstract boolean resolveDateTimeField(String var1);

    protected abstract List<String> findSimilarDateTimeFields(String var1);

    protected abstract List<String> validDateTimeFieldValues();

    @Override
    protected Pipe makePipe() {
        return this.createPipe(Expressions.pipe(this.left()), Expressions.pipe(this.right()), this.zoneId);
    }

    protected abstract Pipe createPipe(Pipe var1, Pipe var2, ZoneId var3);

    @Override
    protected ScriptTemplate asScriptFrom(ScriptTemplate leftScript, ScriptTemplate rightScript) {
        return new ScriptTemplate(this.formatTemplate("{sql}." + this.scriptMethodName() + "(" + leftScript.template() + "," + rightScript.template() + ",{})"), ParamsBuilder.paramsBuilder().script(leftScript.params()).script(rightScript.params()).variable(this.zoneId.getId()).build(), this.dataType());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.zoneId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BinaryDateTimeFunction that = (BinaryDateTimeFunction)o;
        return this.zoneId.equals(that.zoneId);
    }
}

