/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.grouping;

import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.Literal;
import org.elasticsearch.xpack.sql.expression.TypeResolutions;
import org.elasticsearch.xpack.sql.expression.function.grouping.GroupingFunction;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;

public class Histogram
extends GroupingFunction {
    private final Literal interval;
    private final ZoneId zoneId;

    public Histogram(Source source, Expression field, Expression interval, ZoneId zoneId) {
        super(source, field, Collections.singletonList(interval));
        this.interval = Literal.of(interval);
        this.zoneId = zoneId;
    }

    public Literal interval() {
        return this.interval;
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        Expression.TypeResolution resolution = TypeResolutions.isNumericOrDate(this.field(), "HISTOGRAM", Expressions.ParamOrdinal.FIRST);
        if (resolution == Expression.TypeResolution.TYPE_RESOLVED) {
            resolution = this.field().dataType().isDateBased() ? TypeResolutions.isType(this.interval, DataType::isInterval, "(Date) HISTOGRAM", Expressions.ParamOrdinal.SECOND, "interval") : TypeResolutions.isNumeric(this.interval, "(Numeric) HISTOGRAM", Expressions.ParamOrdinal.SECOND);
        }
        return resolution;
    }

    @Override
    public final GroupingFunction replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 2) {
            throw new IllegalArgumentException("expected [2] children but received [" + newChildren.size() + "]");
        }
        return new Histogram(this.source(), newChildren.get(0), newChildren.get(1), this.zoneId);
    }

    @Override
    public DataType dataType() {
        return this.field().dataType();
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, Histogram::new, this.field(), this.interval, this.zoneId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field(), this.interval, this.zoneId);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            Histogram other = (Histogram)obj;
            return Objects.equals(this.interval, other.interval) && Objects.equals(this.zoneId, other.zoneId);
        }
        return false;
    }
}

