/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.aggregate;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Literal;
import org.elasticsearch.xpack.sql.expression.NamedExpression;
import org.elasticsearch.xpack.sql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.sql.expression.function.aggregate.AggregateFunctionAttribute;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;

public class Count
extends AggregateFunction {
    private final boolean distinct;

    public Count(Source source, Expression field, boolean distinct) {
        super(source, field);
        this.distinct = distinct;
    }

    @Override
    protected NodeInfo<Count> info() {
        return NodeInfo.create(this, Count::new, this.field(), this.distinct);
    }

    @Override
    public Count replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 1) {
            throw new IllegalArgumentException("expected [1] child but received [" + newChildren.size() + "]");
        }
        return new Count(this.source(), newChildren.get(0), this.distinct);
    }

    public boolean distinct() {
        return this.distinct;
    }

    @Override
    public DataType dataType() {
        return DataType.LONG;
    }

    @Override
    public String functionId() {
        String functionId = this.id().toString();
        if (!this.distinct() && this.field() instanceof NamedExpression) {
            functionId = ((NamedExpression)this.field()).id().toString();
        }
        return functionId;
    }

    @Override
    public AggregateFunctionAttribute toAttribute() {
        if (this.field() instanceof Literal) {
            return new AggregateFunctionAttribute(this.source(), this.name(), this.dataType(), this.id(), this.functionId(), this.id(), "_count");
        }
        if (!this.distinct()) {
            return new AggregateFunctionAttribute(this.source(), this.name(), this.dataType(), this.id(), this.functionId(), this.id(), this.functionId() + "._count");
        }
        return super.toAttribute();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Count other = (Count)obj;
        return Objects.equals(other.distinct(), this.distinct()) && Objects.equals(this.field(), other.field());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.distinct());
    }
}

