/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.aggregate;

import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.ExpressionId;
import org.elasticsearch.xpack.sql.expression.Nullability;
import org.elasticsearch.xpack.sql.expression.function.FunctionAttribute;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;

public class AggregateFunctionAttribute
extends FunctionAttribute {
    private final ExpressionId innerId;
    private final String propertyPath;

    AggregateFunctionAttribute(Source source, String name, DataType dataType, ExpressionId id, String functionId) {
        this(source, name, dataType, null, Nullability.FALSE, id, false, functionId, null, null);
    }

    AggregateFunctionAttribute(Source source, String name, DataType dataType, ExpressionId id, String functionId, ExpressionId innerId, String propertyPath) {
        this(source, name, dataType, null, Nullability.FALSE, id, false, functionId, innerId, propertyPath);
    }

    public AggregateFunctionAttribute(Source source, String name, DataType dataType, String qualifier, Nullability nullability, ExpressionId id, boolean synthetic, String functionId, ExpressionId innerId, String propertyPath) {
        super(source, name, dataType, qualifier, nullability, id, synthetic, functionId);
        this.innerId = innerId;
        this.propertyPath = propertyPath;
    }

    @Override
    protected NodeInfo<AggregateFunctionAttribute> info() {
        return NodeInfo.create(this, AggregateFunctionAttribute::new, this.name(), this.dataType(), this.qualifier(), this.nullable(), this.id(), this.synthetic(), this.functionId(), this.innerId, this.propertyPath);
    }

    public ExpressionId innerId() {
        return this.innerId != null ? this.innerId : this.id();
    }

    public String propertyPath() {
        return this.propertyPath;
    }

    @Override
    protected Expression canonicalize() {
        return new AggregateFunctionAttribute(this.source(), "<none>", this.dataType(), null, Nullability.TRUE, this.id(), false, "<none>", null, null);
    }

    @Override
    protected Attribute clone(Source source, String name, DataType dataType, String qualifier, Nullability nullability, ExpressionId id, boolean synthetic) {
        return new AggregateFunctionAttribute(source, name, dataType, qualifier, nullability, id, synthetic, this.functionId(), this.innerId, this.propertyPath);
    }

    public AggregateFunctionAttribute withFunctionId(String functionId, String propertyPath) {
        return new AggregateFunctionAttribute(this.source(), this.name(), this.dataType(), this.qualifier(), this.nullable(), this.id(), this.synthetic(), functionId, this.innerId, propertyPath);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.propertyPath);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            AggregateFunctionAttribute other = (AggregateFunctionAttribute)obj;
            return Objects.equals(this.propertyPath, other.propertyPath);
        }
        return false;
    }

    @Override
    protected String label() {
        return "a->" + this.innerId();
    }
}

