/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.aggregate;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.TypeResolutions;
import org.elasticsearch.xpack.sql.expression.function.Function;
import org.elasticsearch.xpack.sql.expression.function.aggregate.AggregateFunctionAttribute;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.AggNameInput;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.util.CollectionUtils;

public abstract class AggregateFunction
extends Function {
    private final Expression field;
    private final List<? extends Expression> parameters;
    private AggregateFunctionAttribute lazyAttribute;

    protected AggregateFunction(Source source, Expression field) {
        this(source, field, Collections.emptyList());
    }

    protected AggregateFunction(Source source, Expression field, List<? extends Expression> parameters) {
        super(source, CollectionUtils.combine(Collections.singletonList(field), parameters));
        this.field = field;
        this.parameters = parameters;
    }

    public Expression field() {
        return this.field;
    }

    public List<? extends Expression> parameters() {
        return this.parameters;
    }

    @Override
    public AggregateFunctionAttribute toAttribute() {
        if (this.lazyAttribute == null) {
            this.lazyAttribute = new AggregateFunctionAttribute(this.source(), this.name(), this.dataType(), this.id(), this.functionId());
        }
        return this.lazyAttribute;
    }

    @Override
    protected Pipe makePipe() {
        return new AggNameInput(this.source(), (Expression)this, this.name());
    }

    @Override
    public ScriptTemplate asScript() {
        throw new SqlIllegalArgumentException("Aggregate functions cannot be scripted");
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        AggregateFunction other = (AggregateFunction)obj;
        return Objects.equals(other.field(), this.field()) && Objects.equals(other.parameters(), this.parameters());
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isExact(this.field, this.sourceText(), Expressions.ParamOrdinal.DEFAULT);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field(), this.parameters());
    }
}

