/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function;

import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.function.Function;
import org.elasticsearch.xpack.sql.expression.function.FunctionDefinition;
import org.elasticsearch.xpack.sql.expression.function.Score;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Avg;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.sql.expression.function.aggregate.First;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Kurtosis;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Last;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Max;
import org.elasticsearch.xpack.sql.expression.function.aggregate.MedianAbsoluteDeviation;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Min;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Percentile;
import org.elasticsearch.xpack.sql.expression.function.aggregate.PercentileRank;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Skewness;
import org.elasticsearch.xpack.sql.expression.function.aggregate.StddevPop;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Sum;
import org.elasticsearch.xpack.sql.expression.function.aggregate.SumOfSquares;
import org.elasticsearch.xpack.sql.expression.function.aggregate.TopHits;
import org.elasticsearch.xpack.sql.expression.function.aggregate.VarPop;
import org.elasticsearch.xpack.sql.expression.function.grouping.Histogram;
import org.elasticsearch.xpack.sql.expression.function.scalar.Cast;
import org.elasticsearch.xpack.sql.expression.function.scalar.Database;
import org.elasticsearch.xpack.sql.expression.function.scalar.User;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.CurrentDate;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.CurrentDateTime;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.CurrentTime;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateAdd;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateDiff;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DatePart;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTrunc;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DayName;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DayOfMonth;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DayOfWeek;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DayOfYear;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.HourOfDay;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.IsoDayOfWeek;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.IsoWeekOfYear;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.MinuteOfDay;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.MinuteOfHour;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.MonthName;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.MonthOfYear;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.Quarter;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.SecondOfMinute;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.WeekOfYear;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.Year;
import org.elasticsearch.xpack.sql.expression.function.scalar.geo.StAswkt;
import org.elasticsearch.xpack.sql.expression.function.scalar.geo.StDistance;
import org.elasticsearch.xpack.sql.expression.function.scalar.geo.StGeometryType;
import org.elasticsearch.xpack.sql.expression.function.scalar.geo.StWkttosql;
import org.elasticsearch.xpack.sql.expression.function.scalar.geo.StX;
import org.elasticsearch.xpack.sql.expression.function.scalar.geo.StY;
import org.elasticsearch.xpack.sql.expression.function.scalar.geo.StZ;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.ACos;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.ASin;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.ATan;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.ATan2;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Abs;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Cbrt;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Ceil;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Cos;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Cosh;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Cot;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Degrees;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.E;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Exp;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Expm1;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Floor;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Log;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Log10;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Pi;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Power;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Radians;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Random;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Round;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Sign;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Sin;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Sinh;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Sqrt;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Tan;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Truncate;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.Ascii;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.BitLength;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.Char;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.CharLength;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.Concat;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.Insert;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.LCase;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.LTrim;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.Left;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.Length;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.Locate;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.OctetLength;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.Position;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.RTrim;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.Repeat;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.Replace;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.Right;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.Space;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.Substring;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.UCase;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.Case;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.Coalesce;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.Greatest;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.IfNull;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.Iif;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.Least;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.NullIf;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.Mod;
import org.elasticsearch.xpack.sql.parser.ParsingException;
import org.elasticsearch.xpack.sql.session.Configuration;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.util.Check;

public class FunctionRegistry {
    private final Map<String, FunctionDefinition> defs = new LinkedHashMap<String, FunctionDefinition>();
    private final Map<String, String> aliases = new HashMap<String, String>();

    public FunctionRegistry() {
        this.defineDefaultFunctions();
    }

    FunctionRegistry(FunctionDefinition ... functions) {
        this.addToMap(functions);
    }

    private void defineDefaultFunctions() {
        this.addToMap(FunctionRegistry.def(Avg.class, Avg::new, "AVG"), FunctionRegistry.def(Count.class, Count::new, "COUNT"), FunctionRegistry.def(First.class, First::new, "FIRST", "FIRST_VALUE"), FunctionRegistry.def(Last.class, Last::new, "LAST", "LAST_VALUE"), FunctionRegistry.def(Max.class, Max::new, "MAX"), FunctionRegistry.def(Min.class, Min::new, "MIN"), FunctionRegistry.def(Sum.class, Sum::new, "SUM"));
        this.addToMap(FunctionRegistry.def(Kurtosis.class, Kurtosis::new, "KURTOSIS"), FunctionRegistry.def(MedianAbsoluteDeviation.class, MedianAbsoluteDeviation::new, "MAD"), FunctionRegistry.def(Percentile.class, Percentile::new, "PERCENTILE"), FunctionRegistry.def(PercentileRank.class, PercentileRank::new, "PERCENTILE_RANK"), FunctionRegistry.def(Skewness.class, Skewness::new, "SKEWNESS"), FunctionRegistry.def(StddevPop.class, StddevPop::new, "STDDEV_POP"), FunctionRegistry.def(SumOfSquares.class, SumOfSquares::new, "SUM_OF_SQUARES"), FunctionRegistry.def(VarPop.class, VarPop::new, "VAR_POP"));
        this.addToMap(FunctionRegistry.def(Histogram.class, Histogram::new, "HISTOGRAM"));
        this.addToMap(FunctionRegistry.def(Case.class, Case::new, "CASE"), FunctionRegistry.def(Coalesce.class, Coalesce::new, "COALESCE"), FunctionRegistry.def(Iif.class, Iif::new, "IIF"), FunctionRegistry.def(IfNull.class, IfNull::new, "IFNULL", "ISNULL", "NVL"), FunctionRegistry.def(NullIf.class, NullIf::new, "NULLIF"), FunctionRegistry.def(Greatest.class, Greatest::new, "GREATEST"), FunctionRegistry.def(Least.class, Least::new, "LEAST"));
        this.addToMap(FunctionRegistry.def(CurrentDate.class, CurrentDate::new, "CURRENT_DATE", "CURDATE", "TODAY"), FunctionRegistry.def(CurrentTime.class, CurrentTime::new, "CURRENT_TIME", "CURTIME"), FunctionRegistry.def(CurrentDateTime.class, CurrentDateTime::new, "CURRENT_TIMESTAMP", "NOW"), FunctionRegistry.def(DayName.class, DayName::new, "DAY_NAME", "DAYNAME"), FunctionRegistry.def(DayOfMonth.class, DayOfMonth::new, "DAY_OF_MONTH", "DAYOFMONTH", "DAY", "DOM"), FunctionRegistry.def(DayOfWeek.class, DayOfWeek::new, "DAY_OF_WEEK", "DAYOFWEEK", "DOW"), FunctionRegistry.def(DayOfYear.class, DayOfYear::new, "DAY_OF_YEAR", "DAYOFYEAR", "DOY"), FunctionRegistry.def(DateAdd.class, DateAdd::new, "DATEADD", "DATE_ADD", "TIMESTAMPADD", "TIMESTAMP_ADD"), FunctionRegistry.def(DateDiff.class, DateDiff::new, "DATEDIFF", "DATE_DIFF", "TIMESTAMPDIFF", "TIMESTAMP_DIFF"), FunctionRegistry.def(DatePart.class, DatePart::new, "DATEPART", "DATE_PART"), FunctionRegistry.def(DateTrunc.class, DateTrunc::new, "DATETRUNC", "DATE_TRUNC"), FunctionRegistry.def(HourOfDay.class, HourOfDay::new, "HOUR_OF_DAY", "HOUR"), FunctionRegistry.def(IsoDayOfWeek.class, IsoDayOfWeek::new, "ISO_DAY_OF_WEEK", "ISODAYOFWEEK", "ISODOW", "IDOW"), FunctionRegistry.def(IsoWeekOfYear.class, IsoWeekOfYear::new, "ISO_WEEK_OF_YEAR", "ISOWEEKOFYEAR", "ISOWEEK", "IWOY", "IW"), FunctionRegistry.def(MinuteOfDay.class, MinuteOfDay::new, "MINUTE_OF_DAY"), FunctionRegistry.def(MinuteOfHour.class, MinuteOfHour::new, "MINUTE_OF_HOUR", "MINUTE"), FunctionRegistry.def(MonthName.class, MonthName::new, "MONTH_NAME", "MONTHNAME"), FunctionRegistry.def(MonthOfYear.class, MonthOfYear::new, "MONTH_OF_YEAR", "MONTH"), FunctionRegistry.def(SecondOfMinute.class, SecondOfMinute::new, "SECOND_OF_MINUTE", "SECOND"), FunctionRegistry.def(Quarter.class, Quarter::new, "QUARTER"), FunctionRegistry.def(Year.class, Year::new, "YEAR"), FunctionRegistry.def(WeekOfYear.class, WeekOfYear::new, "WEEK_OF_YEAR", "WEEK"));
        this.addToMap(FunctionRegistry.def(Abs.class, Abs::new, "ABS"), FunctionRegistry.def(ACos.class, ACos::new, "ACOS"), FunctionRegistry.def(ASin.class, ASin::new, "ASIN"), FunctionRegistry.def(ATan.class, ATan::new, "ATAN"), FunctionRegistry.def(ATan2.class, ATan2::new, "ATAN2"), FunctionRegistry.def(Cbrt.class, Cbrt::new, "CBRT"), FunctionRegistry.def(Ceil.class, Ceil::new, "CEIL", "CEILING"), FunctionRegistry.def(Cos.class, Cos::new, "COS"), FunctionRegistry.def(Cosh.class, Cosh::new, "COSH"), FunctionRegistry.def(Cot.class, Cot::new, "COT"), FunctionRegistry.def(Degrees.class, Degrees::new, "DEGREES"), FunctionRegistry.def(E.class, E::new, "E"), FunctionRegistry.def(Exp.class, Exp::new, "EXP"), FunctionRegistry.def(Expm1.class, Expm1::new, "EXPM1"), FunctionRegistry.def(Floor.class, Floor::new, "FLOOR"), FunctionRegistry.def(Log.class, Log::new, "LOG"), FunctionRegistry.def(Log10.class, Log10::new, "LOG10"), FunctionRegistry.def(Mod.class, Mod::new, "MOD"), FunctionRegistry.def(Pi.class, Pi::new, "PI"), FunctionRegistry.def(Power.class, Power::new, "POWER"), FunctionRegistry.def(Radians.class, Radians::new, "RADIANS"), FunctionRegistry.def(Random.class, Random::new, "RANDOM", "RAND"), FunctionRegistry.def(Round.class, Round::new, "ROUND"), FunctionRegistry.def(Sign.class, Sign::new, "SIGN", "SIGNUM"), FunctionRegistry.def(Sin.class, Sin::new, "SIN"), FunctionRegistry.def(Sinh.class, Sinh::new, "SINH"), FunctionRegistry.def(Sqrt.class, Sqrt::new, "SQRT"), FunctionRegistry.def(Tan.class, Tan::new, "TAN"), FunctionRegistry.def(Truncate.class, Truncate::new, "TRUNCATE"));
        this.addToMap(FunctionRegistry.def(Ascii.class, Ascii::new, "ASCII"), FunctionRegistry.def(BitLength.class, BitLength::new, "BIT_LENGTH"), FunctionRegistry.def(Char.class, Char::new, "CHAR"), FunctionRegistry.def(CharLength.class, CharLength::new, "CHAR_LENGTH", "CHARACTER_LENGTH"), FunctionRegistry.def(Concat.class, Concat::new, "CONCAT"), FunctionRegistry.def(Insert.class, Insert::new, "INSERT"), FunctionRegistry.def(LCase.class, LCase::new, "LCASE"), FunctionRegistry.def(Left.class, Left::new, "LEFT"), FunctionRegistry.def(Length.class, Length::new, "LENGTH"), FunctionRegistry.def(Locate.class, Locate::new, "LOCATE"), FunctionRegistry.def(LTrim.class, LTrim::new, "LTRIM"), FunctionRegistry.def(OctetLength.class, OctetLength::new, "OCTET_LENGTH"), FunctionRegistry.def(Position.class, Position::new, "POSITION"), FunctionRegistry.def(Repeat.class, Repeat::new, "REPEAT"), FunctionRegistry.def(Replace.class, Replace::new, "REPLACE"), FunctionRegistry.def(Right.class, Right::new, "RIGHT"), FunctionRegistry.def(RTrim.class, RTrim::new, "RTRIM"), FunctionRegistry.def(Space.class, Space::new, "SPACE"), FunctionRegistry.def(Substring.class, Substring::new, "SUBSTRING"), FunctionRegistry.def(UCase.class, UCase::new, "UCASE"));
        this.addToMap(FunctionRegistry.def(Cast.class, Cast::new, "CAST", "CONVERT"));
        this.addToMap(FunctionRegistry.def(Database.class, Database::new, "DATABASE"), FunctionRegistry.def(User.class, User::new, "USER"));
        this.addToMap(FunctionRegistry.def(StAswkt.class, StAswkt::new, "ST_ASWKT", "ST_ASTEXT"), FunctionRegistry.def(StDistance.class, StDistance::new, "ST_DISTANCE"), FunctionRegistry.def(StWkttosql.class, StWkttosql::new, "ST_WKTTOSQL", "ST_GEOMFROMTEXT"), FunctionRegistry.def(StGeometryType.class, StGeometryType::new, "ST_GEOMETRYTYPE"), FunctionRegistry.def(StX.class, StX::new, "ST_X"), FunctionRegistry.def(StY.class, StY::new, "ST_Y"), FunctionRegistry.def(StZ.class, StZ::new, "ST_Z"));
        this.addToMap(FunctionRegistry.def(Score.class, Score::new, "SCORE"));
    }

    void addToMap(FunctionDefinition ... functions) {
        HashMap<String, FunctionDefinition> batchMap = new HashMap<String, FunctionDefinition>();
        for (FunctionDefinition f : functions) {
            batchMap.put(f.name(), f);
            for (String alias : f.aliases()) {
                FunctionDefinition old = batchMap.put(alias, f);
                if (old != null || this.defs.containsKey(alias)) {
                    throw new SqlIllegalArgumentException("alias [" + alias + "] is used by [" + (old != null ? old : this.defs.get(alias).name()) + "] and [" + f.name() + "]");
                }
                this.aliases.put(alias, f.name());
            }
        }
        this.defs.putAll(batchMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new)));
    }

    public FunctionDefinition resolveFunction(String functionName) {
        FunctionDefinition def = this.defs.get(functionName);
        if (def == null) {
            throw new SqlIllegalArgumentException("Cannot find function {}; this should have been caught during analysis", functionName);
        }
        return def;
    }

    public String resolveAlias(String alias) {
        String upperCase = alias.toUpperCase(Locale.ROOT);
        return this.aliases.getOrDefault(upperCase, upperCase);
    }

    public boolean functionExists(String functionName) {
        return this.defs.containsKey(functionName);
    }

    public Collection<FunctionDefinition> listFunctions() {
        return this.defs.entrySet().stream().map(e -> new FunctionDefinition((String)e.getKey(), Collections.emptyList(), ((FunctionDefinition)e.getValue()).clazz(), ((FunctionDefinition)e.getValue()).extractViable(), ((FunctionDefinition)e.getValue()).builder())).collect(Collectors.toList());
    }

    public Collection<FunctionDefinition> listFunctions(String pattern) {
        Pattern p = Strings.hasText((String)pattern) ? Pattern.compile(pattern.toUpperCase(Locale.ROOT)) : null;
        return this.defs.entrySet().stream().filter(e -> p == null || p.matcher((CharSequence)e.getKey()).matches()).map(e -> new FunctionDefinition((String)e.getKey(), Collections.emptyList(), ((FunctionDefinition)e.getValue()).clazz(), ((FunctionDefinition)e.getValue()).extractViable(), ((FunctionDefinition)e.getValue()).builder())).collect(Collectors.toList());
    }

    static <T extends Function> FunctionDefinition def(Class<T> function, java.util.function.Function<Source, T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, distinct, cfg) -> {
            if (!children.isEmpty()) {
                throw new SqlIllegalArgumentException("expects no arguments");
            }
            if (distinct) {
                throw new SqlIllegalArgumentException("does not support DISTINCT yet it was specified");
            }
            return (Function)ctorRef.apply(source);
        };
        return FunctionRegistry.def(function, builder, false, names);
    }

    static <T extends Function> FunctionDefinition def(Class<T> function, ConfigurationAwareFunctionBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, distinct, cfg) -> {
            if (!children.isEmpty()) {
                throw new SqlIllegalArgumentException("expects no arguments");
            }
            if (distinct) {
                throw new SqlIllegalArgumentException("does not support DISTINCT yet it was specified");
            }
            return (Function)ctorRef.build(source, cfg);
        };
        return FunctionRegistry.def(function, builder, false, names);
    }

    static <T extends Function> FunctionDefinition def(Class<T> function, UnaryConfigurationAwareFunctionBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, distinct, cfg) -> {
            if (children.size() > 1) {
                throw new SqlIllegalArgumentException("expects exactly one argument");
            }
            if (distinct) {
                throw new SqlIllegalArgumentException("does not support DISTINCT yet it was specified");
            }
            Expression ex = children.size() == 1 ? (Expression)children.get(0) : null;
            return (Function)ctorRef.build(source, ex, cfg);
        };
        return FunctionRegistry.def(function, builder, false, names);
    }

    static <T extends Function> FunctionDefinition def(Class<T> function, BiFunction<Source, Expression, T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, distinct, cfg) -> {
            if (children.size() != 1) {
                throw new SqlIllegalArgumentException("expects exactly one argument");
            }
            if (distinct) {
                throw new SqlIllegalArgumentException("does not support DISTINCT yet it was specified");
            }
            return (Function)ctorRef.apply(source, (Expression)children.get(0));
        };
        return FunctionRegistry.def(function, builder, false, names);
    }

    static <T extends Function> FunctionDefinition def(Class<T> function, MultiFunctionBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, distinct, cfg) -> {
            if (distinct) {
                throw new SqlIllegalArgumentException("does not support DISTINCT yet it was specified");
            }
            return (Function)ctorRef.build(source, children);
        };
        return FunctionRegistry.def(function, builder, false, names);
    }

    static <T extends Function> FunctionDefinition def(Class<T> function, DistinctAwareUnaryFunctionBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, distinct, cfg) -> {
            if (children.size() != 1) {
                throw new SqlIllegalArgumentException("expects exactly one argument");
            }
            return (Function)ctorRef.build(source, (Expression)children.get(0), distinct);
        };
        return FunctionRegistry.def(function, builder, false, names);
    }

    static <T extends Function> FunctionDefinition def(Class<T> function, DatetimeUnaryFunctionBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, distinct, cfg) -> {
            if (children.size() != 1) {
                throw new SqlIllegalArgumentException("expects exactly one argument");
            }
            if (distinct) {
                throw new SqlIllegalArgumentException("does not support DISTINCT yet it was specified");
            }
            return (Function)ctorRef.build(source, (Expression)children.get(0), cfg.zoneId());
        };
        return FunctionRegistry.def(function, builder, true, names);
    }

    static <T extends Function> FunctionDefinition def(Class<T> function, DatetimeBinaryFunctionBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, distinct, cfg) -> {
            if (children.size() != 2) {
                throw new SqlIllegalArgumentException("expects exactly two arguments");
            }
            if (distinct) {
                throw new SqlIllegalArgumentException("does not support DISTINCT yet it was specified");
            }
            return (Function)ctorRef.build(source, (Expression)children.get(0), (Expression)children.get(1), cfg.zoneId());
        };
        return FunctionRegistry.def(function, builder, false, names);
    }

    static <T extends Function> FunctionDefinition def(Class<T> function, DatetimeThreeArgsFunctionBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, distinct, cfg) -> {
            if (children.size() != 3) {
                throw new SqlIllegalArgumentException("expects three arguments");
            }
            if (distinct) {
                throw new SqlIllegalArgumentException("does not support DISTINCT yet it was specified");
            }
            return (Function)ctorRef.build(source, (Expression)children.get(0), (Expression)children.get(1), (Expression)children.get(2), cfg.zoneId());
        };
        return FunctionRegistry.def(function, builder, false, names);
    }

    static <T extends Function> FunctionDefinition def(Class<T> function, BinaryFunctionBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, distinct, cfg) -> {
            boolean isBinaryOptionalParamFunction;
            boolean bl = isBinaryOptionalParamFunction = function.isAssignableFrom(Round.class) || function.isAssignableFrom(Truncate.class) || TopHits.class.isAssignableFrom(function);
            if (isBinaryOptionalParamFunction && (children.size() > 2 || children.size() < 1)) {
                throw new SqlIllegalArgumentException("expects one or two arguments");
            }
            if (!isBinaryOptionalParamFunction && children.size() != 2) {
                throw new SqlIllegalArgumentException("expects exactly two arguments");
            }
            if (distinct) {
                throw new SqlIllegalArgumentException("does not support DISTINCT yet it was specified");
            }
            return (Function)ctorRef.build(source, (Expression)children.get(0), children.size() == 2 ? (Expression)children.get(1) : null);
        };
        return FunctionRegistry.def(function, builder, false, names);
    }

    private static FunctionDefinition def(Class<? extends Function> function, FunctionBuilder builder, boolean datetime, String ... names) {
        Check.isTrue(names.length > 0, "At least one name must be provided for the function");
        String primaryName = names[0];
        List<String> aliases = Arrays.asList(names).subList(1, names.length);
        FunctionDefinition.Builder realBuilder = (uf, distinct, cfg) -> {
            try {
                return builder.build(uf.source(), uf.children(), distinct, cfg);
            }
            catch (SqlIllegalArgumentException e) {
                throw new ParsingException(uf.source(), "error building [" + primaryName + "]: " + e.getMessage(), new Object[]{e});
            }
        };
        return new FunctionDefinition(primaryName, Collections.unmodifiableList(aliases), function, datetime, realBuilder);
    }

    static <T extends Function> FunctionDefinition def(Class<T> function, ThreeParametersFunctionBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, distinct, cfg) -> {
            boolean hasMinimumTwo;
            boolean bl = hasMinimumTwo = function.isAssignableFrom(Locate.class) || function.isAssignableFrom(Iif.class);
            if (hasMinimumTwo && (children.size() > 3 || children.size() < 2)) {
                throw new SqlIllegalArgumentException("expects two or three arguments");
            }
            if (!hasMinimumTwo && children.size() != 3) {
                throw new SqlIllegalArgumentException("expects exactly three arguments");
            }
            if (distinct) {
                throw new SqlIllegalArgumentException("does not support DISTINCT yet it was specified");
            }
            return (Function)ctorRef.build(source, (Expression)children.get(0), (Expression)children.get(1), children.size() == 3 ? (Expression)children.get(2) : null);
        };
        return FunctionRegistry.def(function, builder, false, names);
    }

    static <T extends Function> FunctionDefinition def(Class<T> function, FourParametersFunctionBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, distinct, cfg) -> {
            if (children.size() != 4) {
                throw new SqlIllegalArgumentException("expects exactly four arguments");
            }
            if (distinct) {
                throw new SqlIllegalArgumentException("does not support DISTINCT yet it was specified");
            }
            return (Function)ctorRef.build(source, (Expression)children.get(0), (Expression)children.get(1), (Expression)children.get(2), (Expression)children.get(3));
        };
        return FunctionRegistry.def(function, builder, false, names);
    }

    private static <T extends Function> FunctionDefinition def(Class<T> function, CastFunctionBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, distinct, cfg) -> (Function)ctorRef.build(source, (Expression)children.get(0), ((Expression)children.get(0)).dataType());
        return FunctionRegistry.def(function, builder, false, names);
    }

    private static interface CastFunctionBuilder<T> {
        public T build(Source var1, Expression var2, DataType var3);
    }

    static interface FourParametersFunctionBuilder<T> {
        public T build(Source var1, Expression var2, Expression var3, Expression var4, Expression var5);
    }

    static interface ThreeParametersFunctionBuilder<T> {
        public T build(Source var1, Expression var2, Expression var3, Expression var4);
    }

    private static interface FunctionBuilder {
        public Function build(Source var1, List<Expression> var2, boolean var3, Configuration var4);
    }

    static interface BinaryFunctionBuilder<T> {
        public T build(Source var1, Expression var2, Expression var3);
    }

    static interface DatetimeThreeArgsFunctionBuilder<T> {
        public T build(Source var1, Expression var2, Expression var3, Expression var4, ZoneId var5);
    }

    static interface DatetimeBinaryFunctionBuilder<T> {
        public T build(Source var1, Expression var2, Expression var3, ZoneId var4);
    }

    static interface DatetimeUnaryFunctionBuilder<T> {
        public T build(Source var1, Expression var2, ZoneId var3);
    }

    static interface DistinctAwareUnaryFunctionBuilder<T> {
        public T build(Source var1, Expression var2, boolean var3);
    }

    static interface MultiFunctionBuilder<T> {
        public T build(Source var1, List<Expression> var2);
    }

    static interface UnaryConfigurationAwareFunctionBuilder<T> {
        public T build(Source var1, Expression var2, Configuration var3);
    }

    static interface ConfigurationAwareFunctionBuilder<T> {
        public T build(Source var1, Configuration var2);
    }
}

